package com.appzilo.sdk.video;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.TaskStackBuilder;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import android.view.ContextThemeWrapper;
import android.view.View;

import com.appzilo.sdk.video.backend.GigsApi;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.EmbedGigsResponse;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.BackgroundWorker;
import com.appzilo.sdk.video.core.Error;


import com.appzilo.sdk.video.core.Result;
import com.appzilo.sdk.video.player.VideoPlayer;
import com.appzilo.sdk.video.player.VideoPlayerView;
import com.appzilo.sdk.video.player.listeners.VideoPlayerInitListener;
import com.appzilo.sdk.video.utils.SharedPreferencesUtil;
import com.appzilo.sdk.video.utils.Utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class EmbedVideoActivity extends AppCompatActivity implements
        VideoPlayerInitListener,
        CustomVideoUIController.Listener,
        BackgroundWorker.Callbacks {

    private static final String TASK_GET_YT = "youtube_task_init";
    private static final String TASK_VERIFY_YT = "youtube_task_verify";
    private static final String TASK_GET_POLICE = "youtube_task_get_police";
    private static final String TASK_REPORT_YOUTUBE = "youtube_task_report";
    private static final String OBJ_GIGS_BACKEND = "gigs_backend.youtube";
    private static final String TASK_REQUEST_NOTICE = "task_request_notice";
    private static final String OBJ_NOTICE_API = "obj_notice_api";
    private static final String QUERY_PARAMS = "query_params";

    public static boolean sIsOpened = false;

    private View mCustomPlayerUI;
    private BackgroundWorker mWorker;
    private GigsApi mGigsApi;
    private CustomVideoUIController mCustomPlayerUIController;
    private AlertDialog mNoVideoDialog;
    private ArrayList<EmbedGigsResponse> mPoliceVideoResponse;
    private boolean mIsPolice;
    private VideoPlayerView mYouTubePlayerView;
    private NoticeResponse mNoticeResponse;
    private EmbedGigsResponse mVideoGigsResponse;
    private boolean mBackStackLost = false;
    private String mGigsUrl;
    private boolean mIsInPictureMode;
    private boolean mPiPClosed;
    private String mQuery;
    private Bundle mQueryBundle;
    private NoticeApi mNoticeApi;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
        setContentView(R.layout.activity_embed_video);
        mYouTubePlayerView = findViewById(R.id.player);
        getLifecycle().addObserver(mYouTubePlayerView);
        mCustomPlayerUI = mYouTubePlayerView.inflateCustomPlayerUI(R.layout.custom_video_ui);
        mWorker = new BackgroundWorker(this);
        mGigsApi = (GigsApi) mWorker.get(OBJ_GIGS_BACKEND);
        if (mGigsApi == null) {
            mGigsApi = new GigsApi(this); // , mType);
            mWorker.put(OBJ_GIGS_BACKEND, mGigsApi);
        }
        mNoticeResponse = NoticeApi.getNoticeResponse(getApplicationContext());
        if (mNoticeApi == null) {
            mNoticeApi = new NoticeApi(getApplicationContext());
            mWorker.put(OBJ_NOTICE_API, mNoticeApi);
        }
        mQuery = getIntent().getStringExtra(AppziloVideo.PARAMS);
        if (mQuery != null && !mQuery.isEmpty()) {
            mQueryBundle = new Bundle();
            mQueryBundle.putString(QUERY_PARAMS, mQuery);
            mWorker.executeTask(TASK_REQUEST_NOTICE, mQueryBundle, this);
        }
    }

    @Override
    public void onPictureInPictureModeChanged(final boolean isInPictureInPictureMode, Configuration newConfig) {
        super.onPictureInPictureModeChanged(isInPictureInPictureMode, newConfig);
        final Handler handler = new Handler();
        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                if(mCustomPlayerUIController != null) mCustomPlayerUIController.setPipMode(isInPictureInPictureMode);
                if(!isInPictureInPictureMode) mBackStackLost = true;
                mIsInPictureMode = isInPictureInPictureMode;
            }
        }, 300);

    }

    @Override
    protected void onResume() {
        super.onResume();
        if(mPiPClosed){
            this.recreate();
            mPiPClosed = false;
            return;
        }

        if (mCustomPlayerUIController != null) {
            mCustomPlayerUIController.onResume();
        }

        sIsOpened = true;
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (mCustomPlayerUIController != null) {
            mCustomPlayerUIController.onPause();
        }
    }

    @Override
    protected void onStop() {
        super.onStop();
        sIsOpened = false;
        if(mIsInPictureMode){
            finish();
            overridePendingTransition(0, 0);
            mPiPClosed = true;
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (mCustomPlayerUIController != null) {
            mCustomPlayerUIController.onDestroy();
        }
    }

    @Override
    public void finish() {
        super.finish();
        overridePendingTransition(0, 0);
        this.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
    }

    @Override
    public void onInitSuccess(@NonNull final VideoPlayer youTubePlayer) {
        if(mCustomPlayerUIController == null){
            mCustomPlayerUIController = new CustomVideoUIController(this, this, mCustomPlayerUI, youTubePlayer, mYouTubePlayerView, (mNoticeResponse!=null)?mNoticeResponse.passive_video_interval * 1000:0, mIsPolice);
            youTubePlayer.addListener(mCustomPlayerUIController);
        }
    }

    @Override
    public Result executeTaskInBackground(String id, Bundle args) {
        if(args == null){
            args = new Bundle();
        }
        args.putBoolean(GigsApi.IS_FEATURED, (getIntent().getBooleanExtra(GigsApi.IS_FEATURED, false)));
        args.putInt(GigsApi.VIDEO_CATEGORY, (getIntent().getIntExtra(GigsApi.VIDEO_CATEGORY, 0)));
        switch (id) {
            case TASK_GET_YT:
                return mGigsApi.getYtVideo(args);
            case TASK_VERIFY_YT:
                return mGigsApi.verifyWatchedYtVideo(args);
            case TASK_GET_POLICE:
                return mGigsApi.getPoliceVideo();
            case TASK_REPORT_YOUTUBE:
                return mGigsApi.reportYoutube(args);
            case GigsApi.TASK_SKIP_VIDEO:
                return mGigsApi.skipVideo(args);
            case TASK_REQUEST_NOTICE:
                String query = args.getString(QUERY_PARAMS);
                if (query != null) {
                    HashMap<String, String> queryParams = Utils.queryToHashMap(query);
                    if ((queryParams.containsKey(AppziloVideo.APP_KEY) && !queryParams.get(AppziloVideo.APP_KEY).isEmpty()) && (queryParams.containsKey(AppziloVideo.USER_ID) && !queryParams.get(AppziloVideo.USER_ID).isEmpty())) {
                        return mNoticeApi.request(queryParams);
                    }
                }
                return new Result(Error.EMPTY);
        }
        return null;
    }

    @Override
    public void onBackgroundTaskCompleted(String id, Result result) {
        switch (id) {
            case TASK_REQUEST_NOTICE:
                if (result != null && result.isSuccess()) {
                    mNoticeResponse = (NoticeResponse) result.getResult();
                    mIsPolice = (mNoticeResponse != null) && mNoticeResponse.is_police;
                    mYouTubePlayerView.initialize(this, true);
                    if(!mIsPolice && mNoticeResponse != null && mNoticeResponse.credential.success) {
                        mWorker.executeTask(TASK_GET_YT, null, EmbedVideoActivity.this);
                        return;
                    }
                }
                videoNotAvailable();
                break;
            case TASK_GET_YT:
                if (result.isSuccess()) {
                    mVideoGigsResponse = (EmbedGigsResponse) result.getResult();
                    mCustomPlayerUIController.initializeYtVideoInfo(mVideoGigsResponse);
                    return;
                }
                break;
            case TASK_VERIFY_YT:
            case TASK_REPORT_YOUTUBE:
            case GigsApi.TASK_SKIP_VIDEO:
                if (result.isSuccess()) {
                    mVideoGigsResponse = (EmbedGigsResponse) result.getResult();
                    mCustomPlayerUIController.verifiedYtVideo(mVideoGigsResponse);
                    Intent gigsIntent = new Intent("gigs_force_refresh_receiver");
                    LocalBroadcastManager.getInstance(this).sendBroadcast(gigsIntent);
                    return;
                }
                break;
            case TASK_GET_POLICE:
                if (result.isSuccess()) {
                    EmbedGigsResponse[] response = (EmbedGigsResponse[]) result.getResult();
                    if(response.length > 0 ){
                        mPoliceVideoResponse = new ArrayList<>(Arrays.asList(response));
                        mCustomPlayerUIController.initializeYtVideoInfo(mPoliceVideoResponse.get(mPoliceVideoResponse.size()-1));
                        mPoliceVideoResponse.remove(mPoliceVideoResponse.size()-1);
                    }
                    return;
                }
                break;
        }

        videoNotAvailable();
    }

    @Override
    public void videoReachEndpoint(String id, int timestamp) {
        if(!mIsPolice){
            Bundle bundle = new Bundle();
            bundle.putString(GigsApi.YOUTUBE_GIGS_ID, id);
            bundle.putInt(GigsApi.YOUTUBE_TIMSTAMP, timestamp);
            mWorker.executeTask(TASK_VERIFY_YT, bundle, EmbedVideoActivity.this);
        }
        else if(mPoliceVideoResponse.size() > 0){
            mCustomPlayerUIController.verifiedYtVideo(mPoliceVideoResponse.get(mPoliceVideoResponse.size()-1));
            mPoliceVideoResponse.remove(mPoliceVideoResponse.size()-1);
        }
        else{
            videoNotAvailable();
        }
    }

    @Override
    public void videoNotAvailable() {
        if (!isFinishing()) {
            if ((mNoVideoDialog == null || !mNoVideoDialog.isShowing() && !isFinishing())) {
                mNoVideoDialog = new AlertDialog.Builder(new ContextThemeWrapper(this, R.style.AlertDialog))
                        .setCancelable(false)
                        .setMessage(R.string.no_video_retry)
                        .setPositiveButton(android.R.string.ok, new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                finish();
                            }
                        })
                        .show();
            }
        }
    }

    @Override
    public void forceStopVideo() {
        if (!isFinishing()) {
            finish();
        }
    }

    @Override
    public void youtubePlayableError(String id, String error) {
        Bundle bundle = new Bundle();
        bundle.putString(GigsApi.YOUTUBE_GIGS_ID, id);
        bundle.putString(GigsApi.YOUTUBE_ERROR, error);
        mWorker.executeTask(TASK_REPORT_YOUTUBE, bundle, EmbedVideoActivity.this);
    }

    @TargetApi(Build.VERSION_CODES.N)
    @Override
    public void enablePictureInPicture() {
        enterPictureInPictureMode();
    }

    @Override
    public void skipVideo(String gid) {
        if (mNoticeResponse != null && !mNoticeResponse.is_police) {
            Bundle bundle = new Bundle();
            bundle.putString(GigsApi.YOUTUBE_GIGS_ID, gid);
            mWorker.executeTask(GigsApi.TASK_SKIP_VIDEO, bundle, this);
        } else {
            videoNotAvailable();
        }
    }

    @Override
    public void applyOverrideConfiguration(Configuration overrideConfiguration) {
        if (Build.VERSION.SDK_INT >= 21 && Build.VERSION.SDK_INT <= 25) {
            return;
        }
        super.applyOverrideConfiguration(overrideConfiguration);
    }
}
