/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.player;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.webkit.JavascriptInterface;
import androidx.annotation.NonNull;
import com.appzilo.sdk.video.player.PlayerConstants;
import com.appzilo.sdk.video.player.listeners.VideoPlayerListener;
import java.util.Collection;
import java.util.Iterator;

public class VideoPlayerBridge {
    private static final String STATE_UNSTARTED = "UNSTARTED";
    private static final String STATE_ENDED = "ENDED";
    private static final String STATE_PLAYING = "PLAYING";
    private static final String STATE_PAUSED = "PAUSED";
    private static final String STATE_BUFFERING = "BUFFERING";
    private static final String STATE_CUED = "CUED";
    private static final String STATE_ONLINE = "ONLINE";
    private static final String STATE_OFFLINE = "OFFLINE";
    private static final String STATE_VIDEOSTART = "VIDEOSTART";
    private static final String QUALITY_SMALL = "small";
    private static final String QUALITY_MEDIUM = "medium";
    private static final String QUALITY_LARGE = "large";
    private static final String QUALITY_HD720 = "hd720";
    private static final String QUALITY_HD1080 = "hd1080";
    private static final String QUALITY_HIGH_RES = "highres";
    private static final String QUALITY_DEFAULT = "default";
    private static final String RATE_0_25 = "0.25";
    private static final String RATE_0_5 = "0.5";
    private static final String RATE_1 = "1";
    private static final String RATE_1_5 = "1.5";
    private static final String RATE_2 = "2";
    private static final String ERROR_INVALID_PARAMETER_IN_REQUEST = "2";
    private static final String ERROR_HTML_5_PLAYER = "5";
    private static final String ERROR_VIDEO_NOT_FOUND = "100";
    private static final String ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER1 = "101";
    private static final String ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER2 = "150";
    @NonNull
    private final YouTubePlayerBridgeCallbacks youTubePlayer;
    @NonNull
    private final Handler mainThreadHandler;

    public VideoPlayerBridge(@NonNull YouTubePlayerBridgeCallbacks youTubePlayerBridgeCallbacks) {
        VideoPlayerBridge videoPlayerBridge = this;
        videoPlayerBridge.youTubePlayer = youTubePlayerBridgeCallbacks;
        videoPlayerBridge.mainThreadHandler = new Handler(Looper.getMainLooper());
    }

    @NonNull
    private PlayerConstants.PlayerState parsePlayerState(String string2) {
        return string2.equalsIgnoreCase(STATE_UNSTARTED) ? PlayerConstants.PlayerState.UNSTARTED : (string2.equalsIgnoreCase(STATE_VIDEOSTART) ? PlayerConstants.PlayerState.VIDEOSTART : (string2.equalsIgnoreCase(STATE_ENDED) ? PlayerConstants.PlayerState.ENDED : (string2.equalsIgnoreCase(STATE_PLAYING) ? PlayerConstants.PlayerState.PLAYING : (string2.equalsIgnoreCase(STATE_PAUSED) ? PlayerConstants.PlayerState.PAUSED : (string2.equalsIgnoreCase(STATE_BUFFERING) ? PlayerConstants.PlayerState.BUFFERING : (string2.equalsIgnoreCase(STATE_CUED) ? PlayerConstants.PlayerState.VIDEO_CUED : (string2.equals(STATE_OFFLINE) ? PlayerConstants.PlayerState.OFFLINE : (string2.equals(STATE_ONLINE) ? PlayerConstants.PlayerState.ONLINE : PlayerConstants.PlayerState.UNKNOWN))))))));
    }

    @NonNull
    private PlayerConstants.PlaybackQuality parsePlaybackQuality(String string2) {
        return string2.equalsIgnoreCase(QUALITY_SMALL) ? PlayerConstants.PlaybackQuality.SMALL : (string2.equalsIgnoreCase(QUALITY_MEDIUM) ? PlayerConstants.PlaybackQuality.MEDIUM : (string2.equalsIgnoreCase(QUALITY_LARGE) ? PlayerConstants.PlaybackQuality.LARGE : (string2.equalsIgnoreCase(QUALITY_HD720) ? PlayerConstants.PlaybackQuality.HD720 : (string2.equalsIgnoreCase(QUALITY_HD1080) ? PlayerConstants.PlaybackQuality.HD1080 : (string2.equalsIgnoreCase(QUALITY_HIGH_RES) ? PlayerConstants.PlaybackQuality.HIGH_RES : (string2.equalsIgnoreCase(QUALITY_DEFAULT) ? PlayerConstants.PlaybackQuality.DEFAULT : PlayerConstants.PlaybackQuality.UNKNOWN))))));
    }

    @NonNull
    private PlayerConstants.PlaybackRate parsePlaybackRate(String string2) {
        return string2.equalsIgnoreCase(RATE_0_25) ? PlayerConstants.PlaybackRate.RATE_0_25 : (string2.equalsIgnoreCase(RATE_0_5) ? PlayerConstants.PlaybackRate.RATE_0_5 : (string2.equalsIgnoreCase(RATE_1) ? PlayerConstants.PlaybackRate.RATE_1 : (string2.equalsIgnoreCase(RATE_1_5) ? PlayerConstants.PlaybackRate.RATE_1_5 : (string2.equalsIgnoreCase("2") ? PlayerConstants.PlaybackRate.RATE_2 : PlayerConstants.PlaybackRate.UNKNOWN))));
    }

    @NonNull
    private PlayerConstants.PlayerError parsePlayerError(String string2) {
        return string2.equalsIgnoreCase("2") ? PlayerConstants.PlayerError.INVALID_PARAMETER_IN_REQUEST : (string2.equalsIgnoreCase(ERROR_HTML_5_PLAYER) ? PlayerConstants.PlayerError.HTML_5_PLAYER : (string2.equalsIgnoreCase(ERROR_VIDEO_NOT_FOUND) ? PlayerConstants.PlayerError.VIDEO_NOT_FOUND : (string2.equalsIgnoreCase(ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER1) ? PlayerConstants.PlayerError.VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER : (string2.equalsIgnoreCase(ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER2) ? PlayerConstants.PlayerError.VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER : PlayerConstants.PlayerError.UNKNOWN))));
    }

    @JavascriptInterface
    public void sendYouTubeIframeAPIReady() {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                VideoPlayerBridge.this.youTubePlayer.onYouTubeIframeAPIReady();
            }
        });
    }

    @JavascriptInterface
    public void isMute(final boolean bl) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                Iterator<VideoPlayerListener> iterator = VideoPlayerBridge.this.youTubePlayer.getListeners().iterator();
                while (iterator.hasNext()) {
                    iterator.next().isMute(bl);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendReady() {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                Iterator<VideoPlayerListener> iterator = iterator.VideoPlayerBridge.this.youTubePlayer.getListeners().iterator();
                while (iterator.hasNext()) {
                    ((VideoPlayerListener)iterator.next()).onReady();
                }
            }
        });
    }

    @JavascriptInterface
    public void sendStateChange(String object) {
        VideoPlayerBridge videoPlayerBridge = this;
        object = videoPlayerBridge.parsePlayerState((String)object);
        videoPlayerBridge.mainThreadHandler.post(new Runnable((PlayerConstants.PlayerState)((Object)object)){
            final /* synthetic */ PlayerConstants.PlayerState val$playerState;
            {
                this.val$playerState = playerState;
            }

            @Override
            public void run() {
                Iterator<VideoPlayerListener> iterator = VideoPlayerBridge.this.youTubePlayer.getListeners().iterator();
                while (iterator.hasNext()) {
                    iterator.next().onStateChange(this.val$playerState);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendPlaybackQualityChange(String object) {
        VideoPlayerBridge videoPlayerBridge = this;
        object = videoPlayerBridge.parsePlaybackQuality((String)object);
        videoPlayerBridge.mainThreadHandler.post(new Runnable((PlayerConstants.PlaybackQuality)((Object)object)){
            final /* synthetic */ PlayerConstants.PlaybackQuality val$playbackQuality;
            {
                this.val$playbackQuality = playbackQuality;
            }

            @Override
            public void run() {
                Iterator<VideoPlayerListener> iterator = VideoPlayerBridge.this.youTubePlayer.getListeners().iterator();
                while (iterator.hasNext()) {
                    iterator.next().onPlaybackQualityChange(this.val$playbackQuality);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendPlaybackRateChange(String object) {
        VideoPlayerBridge videoPlayerBridge = this;
        object = videoPlayerBridge.parsePlaybackRate((String)object);
        videoPlayerBridge.mainThreadHandler.post(new Runnable((PlayerConstants.PlaybackRate)((Object)object)){
            final /* synthetic */ PlayerConstants.PlaybackRate val$playbackRate;
            {
                this.val$playbackRate = playbackRate;
            }

            @Override
            public void run() {
                Iterator<VideoPlayerListener> iterator = VideoPlayerBridge.this.youTubePlayer.getListeners().iterator();
                while (iterator.hasNext()) {
                    iterator.next().onPlaybackRateChange(this.val$playbackRate);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendError(String object) {
        VideoPlayerBridge videoPlayerBridge = this;
        object = videoPlayerBridge.parsePlayerError((String)object);
        videoPlayerBridge.mainThreadHandler.post(new Runnable((PlayerConstants.PlayerError)((Object)object)){
            final /* synthetic */ PlayerConstants.PlayerError val$playerError;
            {
                this.val$playerError = playerError;
            }

            @Override
            public void run() {
                Iterator<VideoPlayerListener> iterator = VideoPlayerBridge.this.youTubePlayer.getListeners().iterator();
                while (iterator.hasNext()) {
                    iterator.next().onError(this.val$playerError);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendApiChange() {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                Iterator<VideoPlayerListener> iterator = iterator.VideoPlayerBridge.this.youTubePlayer.getListeners().iterator();
                while (iterator.hasNext()) {
                    ((VideoPlayerListener)iterator.next()).onApiChange();
                }
            }
        });
    }

    @JavascriptInterface
    public void sendVideoCurrentTime(String string2) {
        try {
            final float f = Float.parseFloat(string2);
            this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    Iterator<VideoPlayerListener> iterator = VideoPlayerBridge.this.youTubePlayer.getListeners().iterator();
                    while (iterator.hasNext()) {
                        iterator.next().onCurrentSecond(f);
                    }
                }
            });
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return;
        }
    }

    @JavascriptInterface
    public void sendVideoDuration(String string2) {
        block3: {
            try {
                if (!TextUtils.isEmpty((CharSequence)string2)) break block3;
                string2 = "0";
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                return;
            }
        }
        final float f = Float.parseFloat(string2);
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                Iterator<VideoPlayerListener> iterator = VideoPlayerBridge.this.youTubePlayer.getListeners().iterator();
                while (iterator.hasNext()) {
                    iterator.next().onVideoDuration(f);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendVideoLoadedFraction(String string2) {
        try {
            final float f = Float.parseFloat(string2);
            this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    Iterator<VideoPlayerListener> iterator = VideoPlayerBridge.this.youTubePlayer.getListeners().iterator();
                    while (iterator.hasNext()) {
                        iterator.next().onVideoLoadedFraction(f);
                    }
                }
            });
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return;
        }
    }

    @JavascriptInterface
    public void sendVideoId(final String string2) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                Iterator<VideoPlayerListener> iterator = VideoPlayerBridge.this.youTubePlayer.getListeners().iterator();
                while (iterator.hasNext()) {
                    iterator.next().onVideoId(string2);
                }
            }
        });
    }

    public static interface YouTubePlayerBridgeCallbacks {
        public void onYouTubeIframeAPIReady();

        public Collection<VideoPlayerListener> getListeners();
    }
}

