/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.core;

import android.content.Context;
import android.os.Build;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.Error;
import com.appzilo.sdk.video.core.Logger;
import com.appzilo.sdk.video.core.Result;
import com.appzilo.sdk.video.core.SyncCookieHandler;
import com.appzilo.sdk.video.utils.SharedPreferencesUtil;
import com.appzilo.sdk.video.utils.Utils;
import com.franmontiel.persistentcookiejar.PersistentCookieJar;
import com.franmontiel.persistentcookiejar.cache.CookieCache;
import com.franmontiel.persistentcookiejar.cache.SetCookieCache;
import com.franmontiel.persistentcookiejar.persistence.CookiePersistor;
import com.franmontiel.persistentcookiejar.persistence.SharedPrefsCookiePersistor;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.CipherSuite;
import okhttp3.ConnectionSpec;
import okhttp3.CookieJar;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.TlsVersion;

public class Http {
    private static final String COOKIES = "set-cookie";
    private static OkHttpClient sClient;
    private static PersistentCookieJar mCookieJar;
    private static String mAppKey;
    private static String sUserAgent;
    private static SharedPreferencesUtil mPrefUtil;
    private static ConnectionSpec spec;

    public static void init(Context context) {
        mPrefUtil = new SharedPreferencesUtil(context);
    }

    public static Request request(Context context, String string2) {
        mAppKey = string2;
        return Http.request(context);
    }

    public static Request request(Context context) {
        if (sClient == null) {
            mCookieJar = new PersistentCookieJar((CookieCache)new SetCookieCache(), (CookiePersistor)new SharedPrefsCookiePersistor(context));
            TimeUnit timeUnit = TimeUnit.SECONDS;
            OkHttpClient.Builder builder = new OkHttpClient.Builder().connectionSpecs(Collections.singletonList(spec)).connectTimeout(20L, timeUnit);
            timeUnit = TimeUnit.SECONDS;
            OkHttpClient.Builder builder2 = builder.readTimeout(20L, timeUnit);
            timeUnit = TimeUnit.SECONDS;
            sClient = builder2.writeTimeout(20L, timeUnit).cookieJar((CookieJar)new SyncCookieHandler()).build();
        }
        return new Request(context);
    }

    public static void destroy() {
        sClient = null;
    }

    /*
     * Loose catch block
     */
    public static String getDefaultAgent(Context context) {
        Object object2 = sUserAgent;
        if (object2 == null || ((String)object2).isEmpty()) {
            if (Build.VERSION.SDK_INT >= 17) {
                sUserAgent = WebSettings.getDefaultUserAgent((Context)context);
            } else {
                Class<WebSettings> clazz = WebSettings.class;
                Class[] classArray = new Class[2];
                classArray[0] = Context.class;
                classArray[1] = WebView.class;
                Constructor constructor = clazz.getDeclaredConstructor(classArray);
                Constructor constructor2 = constructor;
                Constructor constructor3 = constructor;
                Object object2 = object2 = constructor;
                constructor2.setAccessible(true);
                Object[] objectArray = new Object[2];
                objectArray[0] = context;
                objectArray[1] = null;
                sUserAgent = ((WebSettings)constructor3.newInstance(objectArray)).getUserAgentString();
                ((Constructor)object2).setAccessible(false);
                catch (Throwable throwable) {
                    try {
                        ((Constructor)object2).setAccessible(false);
                        throw throwable;
                    }
                    catch (Exception exception) {
                        sUserAgent = System.getProperty("http.agent");
                    }
                }
            }
        }
        return sUserAgent;
    }

    static {
        spec = new ConnectionSpec.Builder(ConnectionSpec.COMPATIBLE_TLS).supportsTlsExtensions(true).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2, TlsVersion.TLS_1_1, TlsVersion.TLS_1_0}).cipherSuites(new CipherSuite[]{CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_ECDHE_ECDSA_WITH_RC4_128_SHA, CipherSuite.TLS_ECDHE_RSA_WITH_RC4_128_SHA, CipherSuite.TLS_DHE_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_DHE_DSS_WITH_AES_128_CBC_SHA, CipherSuite.TLS_DHE_RSA_WITH_AES_256_CBC_SHA}).build();
    }

    public static class Request {
        private Request.Builder mBuilder;
        private List<String> mLog = new ArrayList<String>();
        private Context mContext;
        private SharedPreferencesUtil mPrefUtil;
        private String mUrl;

        Request(Context context) {
            this.mBuilder = new Request.Builder();
            this.mPrefUtil = new SharedPreferencesUtil(context);
            Object object = NoticeApi.getNoticeResponse(context);
            if (object != null && (object = ((NoticeResponse)object).credential.app_key) != null) {
                mAppKey = (String)object;
            }
            Request request = this;
            request.mBuilder.addHeader("App-Key", mAppKey);
            request.mLog.add("App-Key: " + mAppKey);
            object = Http.getDefaultAgent(context);
            if (object != null) {
                Request request2 = this;
                request2.mBuilder.addHeader("User-Agent", (String)object);
                request2.mLog.add("User Agent: " + (String)object);
            }
            this.mContext = context;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void updateCookies(Response object) {
            StringBuilder stringBuilder;
            List list = object.headers("Set-Cookie");
            object = stringBuilder;
            stringBuilder = new StringBuilder();
            boolean bl = true;
            Iterator iterator = list.iterator();
            block2: while (true) {
                if (!iterator.hasNext()) {
                    this.mLog.add("Update-Cookie: " + ((StringBuilder)object).toString());
                    return;
                }
                try {
                    Iterator<HttpCookie> iterator2 = HttpCookie.parse((String)iterator.next()).iterator();
                    while (true) {
                        if (!iterator2.hasNext()) continue block2;
                        HttpCookie httpCookie = iterator2.next();
                        String string2 = httpCookie.getName();
                        httpCookie.getValue();
                        if (bl) {
                            bl = false;
                        } else {
                            ((StringBuilder)object).append("; ");
                        }
                        ((StringBuilder)object).append(string2).append("=").append(httpCookie.getValue());
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                break;
            }
        }

        public Request url(String string2) {
            Request request = this;
            request.mUrl = string2;
            request.mBuilder.url(string2);
            request.mLog.add(0, "URL: " + string2);
            return request;
        }

        public Request tag(String string2) {
            Request request = this;
            request.mBuilder.tag((Object)string2);
            return request;
        }

        public Request post(Map<String, String> map) {
            if (map != null) {
                FormBody.Builder builder;
                FormBody.Builder builder2 = builder;
                builder = new FormBody.Builder();
                if (!this.mPrefUtil.getStringValue("dbm", "").isEmpty()) {
                    map.put("dbm", this.mPrefUtil.getStringValue("dbm", ""));
                }
                if (this.mUrl.contains("appzilo.com") && !this.mPrefUtil.getStringValue("az_dbm", "").isEmpty()) {
                    map.put("dbm_key", this.mPrefUtil.getStringValue("az_dbm", ""));
                }
                if (this.mUrl.contains("getmoocash.com") && !this.mPrefUtil.getStringValue("moo_dbm", "").isEmpty()) {
                    map.put("dbm_key", this.mPrefUtil.getStringValue("moo_dbm", ""));
                }
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string2 = entry.getValue();
                    if (string2 == null) {
                        string2 = "";
                    }
                    builder2.add(entry.getKey(), string2);
                }
                Request request = this;
                request.mLog.add("PARAM: " + map.toString());
                request.mBuilder.post((RequestBody)builder2.build());
            }
            return this;
        }

        public Result send() {
            Object object;
            Result result;
            block11: {
                Result result2;
                block9: {
                    block8: {
                        if (!Utils.isOnline(this.mContext) || sClient == null) break block9;
                        result = null;
                        Response response = object = sClient.newCall(this.mBuilder.build()).execute();
                        List<String> list = this.mLog;
                        StringBuilder stringBuilder = new StringBuilder();
                        StringBuilder stringBuilder2 = stringBuilder.append("Code: ").append(object.code());
                        list.add(stringBuilder2.append(" ").append(object.message()).toString());
                        if (!response.isSuccessful()) break block8;
                        try {
                            this.updateCookies((Response)object);
                            object = object.body().string();
                        }
                        catch (IOException iOException) {
                            this.mLog.add("Error: " + iOException.getMessage());
                            object = result;
                        }
                    }
                    object = result;
                    if (object != null) {
                        Result result3;
                        this.mLog.add("Response: " + (String)object);
                        result = result3;
                        result3 = new Result(null, object);
                    } else {
                        Result result4;
                        result = result4;
                        result4 = new Result(Error.NETWORK);
                    }
                    break block11;
                }
                result = result2;
                result2 = new Result(Error.OFFLINE);
            }
            object = this.mLog.iterator();
            while (object.hasNext()) {
                Logger.d("HTTP[" + Integer.toHexString(this.hashCode()) + "] " + (String)object.next());
            }
            return result;
        }

        public Call call() {
            return sClient.newCall(this.mBuilder.build());
        }
    }
}

