/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.backend;

import android.content.Context;
import android.os.Bundle;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.AutoRedirectGigsResponse;
import com.appzilo.sdk.video.backend.model.EmbedGigsResponse;
import com.appzilo.sdk.video.core.App;
import com.appzilo.sdk.video.core.Error;
import com.appzilo.sdk.video.core.Http;
import com.appzilo.sdk.video.core.Result;
import com.appzilo.sdk.video.utils.SharedPreferencesUtil;
import com.appzilo.sdk.video.utils.Utils;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class GigsApi {
    public static final String VIDEO_CATEGORY = "video_category";
    public static final String YOUTUBE_GIGS_ID = "tid";
    public static final String YOUTUBE_TIMSTAMP = "ts";
    public static final String YOUTUBE_ERROR = "sid";
    public static final String IS_FEATURED = "is_featured";
    public static final String VIDEO_EXCLUDE = "exclude_gid";
    public static final String AUTO_REDIRECT = "ard";
    public static final String VIDEO_WEBVIEW_CONTROL = "video_webview_control";
    public static final String VIDEO_COUNT = "video_count";
    public static final String VIDEO_RESPOSNE = "video_response";
    public static final String VIDEO_TYPE_SUPPORT = "ty";
    public static final String TASK_GET_YOUTUBE = "GigsBackend.getYoutube";
    public static final String TASK_LOAD_URL = "GigsBackend.loadUrl";
    public static final String TASK_SKIP_VIDEO = "GigsBackend.skipVideo";
    private final String TASK_GET_TASKS;
    private final String TASK_VERIFY_YOUTUBE;
    private final String TASK_VERIFY_REDIRECT_PAGE;
    private final String TASK_GET_REDIRECT_PAGE;
    private final String TASK_REPORT_YOUTUBE;
    private final String TASK_GET_POLICE_VIDEO;
    private final String GIGS_TASK_URL;
    private final SharedPreferencesUtil mSharedPref;
    private String mAppKey;
    private Context mContext;

    public GigsApi(Context context) {
        this.TASK_GET_TASKS = "GigsBackend.getTasks";
        this.TASK_VERIFY_YOUTUBE = "GigsBackend.verifiyYoutube";
        this.TASK_VERIFY_REDIRECT_PAGE = "GigsBackend.verifyRedirectPage";
        this.TASK_GET_REDIRECT_PAGE = "GigsBackend.getRedirectPage";
        this.TASK_REPORT_YOUTUBE = "GigsBackend.reportYoutube";
        this.TASK_GET_POLICE_VIDEO = "GigsBackend.getPoliceVideo";
        String string2 = App.getIsLive() ? "https://app.getmoocash.com/task/?" : "https://www.uploadhub.com/getmoocash/task/?";
        this.GIGS_TASK_URL = string2;
        this.mContext = context;
        this.getAppKey(context);
        this.mSharedPref = new SharedPreferencesUtil(context);
    }

    private void getAppKey(Context object) {
        if ((object = NoticeApi.getNoticeResponse(object)) != null) {
            this.mAppKey = object.credential.app_key;
        }
    }

    public String getDomain() {
        return this.GIGS_TASK_URL;
    }

    public Result loadUrl(String string2) {
        Object object = Http.request(((GigsApi)object).mContext).url(string2).tag(TASK_LOAD_URL).send();
        if (((Result)object).isSuccess() && (object = (String)((Result)object).getResult()) != null && !((String)object).isEmpty()) {
            return new Result(null, object);
        }
        return new Result(Error.NETWORK);
    }

    public Result getYtVideo(Bundle bundle) {
        Object var2_2 = null;
        if (!Utils.isOnline(((GigsApi)object).mContext)) {
            return new Result(Error.OFFLINE);
        }
        Object object = Http.request(((GigsApi)object).mContext).url(((GigsApi)object).GIGS_TASK_URL).post(((GigsApi)object).getParams(TASK_GET_YOUTUBE, bundle)).tag(TASK_GET_YOUTUBE).send();
        if (((Result)object).isSuccess() && (object = (String)((Result)object).getResult()) != null) {
            try {
                object = (EmbedGigsResponse)App.gson().fromJson((String)object, EmbedGigsResponse.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                jsonSyntaxException.printStackTrace();
                object = var2_2;
            }
            if (object != null) {
                return new Result(null, object);
            }
            return new Result(Error.DATA);
        }
        return new Result(Error.NETWORK);
    }

    public Result reportYoutube(Bundle bundle) {
        Object var2_2 = null;
        if (!Utils.isOnline(((GigsApi)object).mContext)) {
            return new Result(Error.OFFLINE);
        }
        GigsApi gigsApi = object;
        gigsApi.getAppKey(gigsApi.mContext);
        Object object = Http.request(gigsApi.mContext).url(((GigsApi)object).GIGS_TASK_URL).post(((GigsApi)object).getParams("GigsBackend.reportYoutube", bundle)).tag("GigsBackend.reportYoutube").send();
        if (((Result)object).isSuccess() && (object = (String)((Result)object).getResult()) != null) {
            try {
                object = (EmbedGigsResponse)App.gson().fromJson((String)object, EmbedGigsResponse.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                object = var2_2;
            }
            if (object != null) {
                return new Result(null, object);
            }
            return new Result(Error.DATA);
        }
        return new Result(Error.NETWORK);
    }

    public Result verifyWatchedYtVideo(Bundle bundle) {
        Object var2_2 = null;
        if (!Utils.isOnline(((GigsApi)object).mContext)) {
            return new Result(Error.OFFLINE);
        }
        Object object = Http.request(((GigsApi)object).mContext).url(((GigsApi)object).GIGS_TASK_URL).post(((GigsApi)object).getParams("GigsBackend.verifiyYoutube", bundle)).tag("GigsBackend.verifiyYoutube").send();
        if (((Result)object).isSuccess() && (object = (String)((Result)object).getResult()) != null) {
            try {
                object = (EmbedGigsResponse)App.gson().fromJson((String)object, EmbedGigsResponse.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                jsonSyntaxException.printStackTrace();
                object = var2_2;
            }
            if (object != null) {
                return new Result(null, object);
            }
            return new Result(Error.DATA);
        }
        return new Result(Error.NETWORK);
    }

    public Result getRedirectPage(Bundle bundle) {
        Object var2_2 = null;
        if (!Utils.isOnline(((GigsApi)object).mContext)) {
            return new Result(Error.OFFLINE);
        }
        Object object = Http.request(((GigsApi)object).mContext).url(((GigsApi)object).GIGS_TASK_URL).post(((GigsApi)object).getParams("GigsBackend.getRedirectPage", bundle)).tag("GigsBackend.getRedirectPage").send();
        if (((Result)object).isSuccess() && (object = (String)((Result)object).getResult()) != null) {
            try {
                object = (AutoRedirectGigsResponse)App.gson().fromJson((String)object, AutoRedirectGigsResponse.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                object = var2_2;
            }
            if (object != null) {
                return new Result(null, object);
            }
            return new Result(Error.DATA);
        }
        return new Result(Error.NETWORK);
    }

    public Result verifyRedirectPage(Bundle bundle) {
        Object var2_2 = null;
        if (!Utils.isOnline(((GigsApi)object).mContext)) {
            return new Result(Error.OFFLINE);
        }
        Object object = Http.request(((GigsApi)object).mContext).url(((GigsApi)object).GIGS_TASK_URL).post(((GigsApi)object).getParams("GigsBackend.verifyRedirectPage", bundle)).tag("GigsBackend.verifyRedirectPage").send();
        if (((Result)object).isSuccess() && (object = (String)((Result)object).getResult()) != null) {
            try {
                object = (AutoRedirectGigsResponse)App.gson().fromJson((String)object, AutoRedirectGigsResponse.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                object = var2_2;
            }
            if (object != null) {
                return new Result(null, object);
            }
            return new Result(Error.DATA);
        }
        return new Result(Error.NETWORK);
    }

    public Result skipVideo(Bundle bundle) {
        Object var2_2 = null;
        if (!Utils.isOnline(((GigsApi)object).mContext)) {
            return new Result(Error.OFFLINE);
        }
        Object object = Http.request(((GigsApi)object).mContext).url(((GigsApi)object).GIGS_TASK_URL).post(((GigsApi)object).getParams(TASK_SKIP_VIDEO, bundle)).tag(TASK_SKIP_VIDEO).send();
        if (((Result)object).isSuccess() && (object = (String)((Result)object).getResult()) != null) {
            try {
                object = (EmbedGigsResponse)App.gson().fromJson((String)object, EmbedGigsResponse.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                object = var2_2;
            }
            if (object != null) {
                return new Result(null, object);
            }
            return new Result(Error.DATA);
        }
        return new Result(Error.NETWORK);
    }

    public Result getPoliceVideo() {
        Object var1_1 = null;
        if (!Utils.isOnline(object.mContext)) {
            return new Result(Error.OFFLINE);
        }
        Object object = Http.request(object.mContext).url("https://www.dropbox.com/s/d1iv1prpdf76shg/youtube_task.txt?dl=1").tag("GigsBackend.getPoliceVideo").send();
        if (object.isSuccess() && (object = (String)object.getResult()) != null) {
            try {
                object = (EmbedGigsResponse[])App.gson().fromJson((String)object, EmbedGigsResponse[].class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                object = var1_1;
            }
            if (object != null) {
                return new Result(null, object);
            }
            return new Result(Error.DATA);
        }
        return new Result(Error.NETWORK);
    }

    public HashMap<String, String> getParams(String string2, Bundle bundle) {
        Object object;
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2 = hashMap;
        hashMap = new HashMap<String, String>();
        if (bundle.getBoolean(VIDEO_WEBVIEW_CONTROL, false)) {
            hashMap2.put("view", "web");
        } else {
            hashMap2.put("view", "json");
        }
        if (bundle.containsKey("check") && bundle.getInt("check") == 1) {
            hashMap2.put("check", "1");
        }
        if (bundle.containsKey(IS_FEATURED) && bundle.getBoolean(IS_FEATURED, false)) {
            hashMap2.put("ft", "1");
        }
        if (bundle.containsKey(VIDEO_CATEGORY) && bundle.getInt(VIDEO_CATEGORY, 0) > 0) {
            hashMap2.put("cid", String.valueOf(bundle.getInt(VIDEO_CATEGORY, 0)));
        }
        if (bundle.containsKey(VIDEO_EXCLUDE) && bundle.getSerializable(VIDEO_EXCLUDE) != null && (object = (ArrayList)bundle.getSerializable(VIDEO_EXCLUDE)) != null) {
            int n = 0;
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                hashMap2.put("exclude_gid[" + n + "]", (String)iterator.next());
                ++n;
            }
        }
        if (bundle.containsKey(VIDEO_TYPE_SUPPORT) && bundle.getString(VIDEO_TYPE_SUPPORT, null) != null) {
            hashMap2.put(VIDEO_TYPE_SUPPORT, bundle.getString(VIDEO_TYPE_SUPPORT, null));
        }
        if ((object3 = ((GigsApi)object3).mSharedPref) != null) {
            Object object2 = object3;
            Object object3 = AUTO_REDIRECT;
            object = ((SharedPreferencesUtil)object2).getBooleanValue("yt_is_auto_skip", false) ? "1" : "0";
            hashMap2.put((String)object3, (String)object);
        }
        hashMap2.put("v", "3");
        int n = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 1972155541: {
                if (!string2.equals(TASK_GET_YOUTUBE)) break;
                n = 1;
                break;
            }
            case 1914803532: {
                if (!string2.equals("GigsBackend.verifyRedirectPage")) break;
                n = 4;
                break;
            }
            case 337120857: {
                if (!string2.equals("GigsBackend.getRedirectPage")) break;
                n = 2;
                break;
            }
            case 115425659: {
                if (!string2.equals("GigsBackend.verifiyYoutube")) break;
                n = 3;
                break;
            }
            case 48487591: {
                if (!string2.equals("GigsBackend.reportYoutube")) break;
                n = 5;
                break;
            }
            case -345689196: {
                if (!string2.equals(TASK_SKIP_VIDEO)) break;
                n = 6;
                break;
            }
            case -1299072640: {
                if (!string2.equals("GigsBackend.getTasks")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                hashMap2.put("op", "skip");
                hashMap2.put(YOUTUBE_GIGS_ID, bundle.getString(YOUTUBE_GIGS_ID));
                break;
            }
            case 5: {
                hashMap2.put("op", "report_prob");
                if (bundle.containsKey(YOUTUBE_ERROR)) {
                    hashMap2.put(YOUTUBE_ERROR, bundle.getString(YOUTUBE_ERROR));
                }
                hashMap2.put(YOUTUBE_GIGS_ID, bundle.getString(YOUTUBE_GIGS_ID));
                break;
            }
            case 3: 
            case 4: {
                hashMap2.put("op", "watched");
                if (bundle.containsKey(YOUTUBE_GIGS_ID)) {
                    HashMap<String, String> hashMap3 = hashMap2;
                    hashMap3.put(YOUTUBE_GIGS_ID, bundle.getString(YOUTUBE_GIGS_ID));
                    hashMap3.put("hsh", Utils.javaEncrypt(bundle.getString(YOUTUBE_GIGS_ID) + "," + bundle.getInt(YOUTUBE_TIMSTAMP)));
                }
                if (string2.equals("GigsBackend.verifiyYoutube")) {
                    hashMap2.remove("dbg");
                }
                return hashMap2;
            }
            case 2: {
                HashMap<String, String> hashMap4 = hashMap2;
                hashMap4.put("op", "get_page");
                return hashMap4;
            }
            case 1: {
                HashMap<String, String> hashMap5 = hashMap2;
                hashMap5.put("op", "get_video");
                return hashMap5;
            }
            case 0: {
                return hashMap2;
            }
        }
        return hashMap2;
    }
}

