/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.appzilo.sdk.video.R;
import com.appzilo.sdk.video.backend.GigsApi;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.EmbedGigsResponse;
import com.appzilo.sdk.video.backend.model.NoticeCredential;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.App;
import com.appzilo.sdk.video.core.BackgroundWorker;
import com.appzilo.sdk.video.core.Result;
import com.appzilo.sdk.video.utils.SharedPreferencesUtil;
import java.util.HashMap;
import java.util.Map;

public class WebviewFragment
extends Fragment
implements SwipeRefreshLayout.OnRefreshListener,
BackgroundWorker.Callbacks {
    public static final String URL = "url";
    private static final String OBJ_GIGS_BACKEND = "gigs_backend.video";
    private static final String TASK_REQUEST_URL = "task_request_url";
    private WebView mWebView;
    private String mUrl;
    private Toolbar mToolbar;
    private View mView;
    private boolean hideActionBar;
    private SwipeRefreshLayout mRefresh;
    private Handler mainThreadHandler;
    private SharedPreferencesUtil mPref;
    private BackgroundWorker mWorker;
    private GigsApi mGigsBackend;

    public static WebviewFragment newInstance(Bundle bundle) {
        WebviewFragment webviewFragment;
        WebviewFragment webviewFragment2 = webviewFragment;
        webviewFragment = new WebviewFragment();
        if (bundle == null) {
            Bundle bundle2;
            bundle = bundle2;
            bundle2 = new Bundle();
        }
        WebviewFragment webviewFragment3 = webviewFragment2;
        webviewFragment3.setArguments(bundle);
        return webviewFragment3;
    }

    private Map<String, String> getCustomHeaders() {
        HashMap<String, String> hashMap;
        WebviewFragment webviewFragment = hashMap2;
        HashMap<String, String> hashMap2 = hashMap;
        new HashMap<String, String>().put("X-Requested-With", "com.android.browser");
        Object object = NoticeApi.getNoticeResponse(webviewFragment.getContext());
        if (object != null && (object = ((NoticeResponse)object).credential) != null && (object = ((NoticeCredential)object).app_key) != null) {
            hashMap2.put("App-Key", (String)object);
        }
        return hashMap2;
    }

    public void onCreate(@Nullable Bundle bundle) {
        WebviewFragment webviewFragment = this;
        super.onCreate(bundle);
        bundle = webviewFragment.getArguments();
        if (bundle != null) {
            this.mUrl = bundle.getString(URL);
        }
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
        if (this.getActivity() != null) {
            WebviewFragment webviewFragment2 = this;
            webviewFragment2.mPref = new SharedPreferencesUtil((Context)this.getActivity());
            webviewFragment2.mWorker = new BackgroundWorker(this.getActivity());
            webviewFragment2.mGigsBackend = (GigsApi)webviewFragment2.mWorker.get(OBJ_GIGS_BACKEND);
            if (webviewFragment2.mGigsBackend == null) {
                this.mGigsBackend = new GigsApi(this.getContext());
                this.mWorker.put(OBJ_GIGS_BACKEND, this.mGigsBackend);
            }
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        WebviewFragment webviewFragment = this;
        webviewFragment.mView = layoutInflater.inflate(R.layout.fragment_webview, viewGroup, false);
        webviewFragment.mRefresh = (SwipeRefreshLayout)webviewFragment.mView.findViewById(R.id.swipeContainer);
        webviewFragment.mRefresh.setEnabled(false);
        webviewFragment.mRefresh.setColorSchemeResources(new int[]{R.color.primary});
        webviewFragment.mWebView = (WebView)webviewFragment.mView.findViewById(R.id.web);
        return webviewFragment.mView;
    }

    public void onViewCreated(View object, @Nullable Bundle bundle) {
        WebviewFragment webviewFragment = this;
        super.onViewCreated((View)object, bundle);
        object = webviewFragment.mWebView.getSettings();
        if (Build.VERSION.SDK_INT >= 17) {
            object.setMediaPlaybackRequiresUserGesture(false);
        } else {
            object.setPluginState(WebSettings.PluginState.ON);
        }
        View view = object;
        view.setJavaScriptEnabled(true);
        view.setDomStorageEnabled(true);
        view.setAllowFileAccess(true);
        object = this.mPref.getStringValue("moo_dbm", null);
        if (object != null && !((String)object).isEmpty()) {
            this.mUrl = this.mUrl + "&dbm=" + this.mPref.getStringValue("dbm", null) + "&dbm_key=" + (String)object;
        }
        WebviewFragment webviewFragment2 = this;
        webviewFragment2.mWorker.executeTask(TASK_REQUEST_URL, null, this);
        webviewFragment2.mWebView.addJavascriptInterface((Object)new OtherWebViewJavascriptInterface(), "PlayerBridge");
        webviewFragment2.mWebView.setWebViewClient((WebViewClient)new OtherWebViewClient());
        webviewFragment2.mWebView.setWebChromeClient(new WebChromeClient());
    }

    public void onResume() {
        WebviewFragment webviewFragment = this;
        super.onResume();
        webviewFragment.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebviewFragment.this.mWebView.loadUrl("javascript:playVideo()");
            }
        });
    }

    public void onPause() {
        WebviewFragment webviewFragment = this;
        super.onPause();
        webviewFragment.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebviewFragment.this.mWebView.loadUrl("javascript:pauseVideo()");
            }
        });
    }

    public void onDestroy() {
        WebviewFragment webviewFragment = this;
        webviewFragment.mainThreadHandler.removeCallbacksAndMessages(null);
        super.onDestroy();
    }

    public void onRefresh() {
        this.mWebView.reload();
    }

    @Override
    public Result executeTaskInBackground(String string2, Bundle bundle) {
        if (TASK_REQUEST_URL.equals(string2)) {
            return this.mGigsBackend.loadUrl(this.mUrl);
        }
        return null;
    }

    @Override
    public void onBackgroundTaskCompleted(String string2, Result result) {
        if (TASK_REQUEST_URL.equals(string2) && result.isSuccess()) {
            WebviewFragment webviewFragment = embedGigsResponse;
            EmbedGigsResponse embedGigsResponse = (EmbedGigsResponse)App.gson().fromJson((String)result.getResult(), EmbedGigsResponse.class);
            webviewFragment.mWebView.loadDataWithBaseURL(embedGigsResponse.video_info.url, embedGigsResponse.video_html, "text/html", "utf-8", null);
        }
    }

    public class OtherWebViewJavascriptInterface {
        @JavascriptInterface
        public void onFinish() {
            if (WebviewFragment.this.getActivity() != null) {
                WebviewFragment.this.getActivity().finish();
            }
        }
    }

    private class OtherWebViewClient
    extends WebViewClient {
        private OtherWebViewClient() {
        }

        @TargetApi(value=21)
        public boolean shouldOverrideUrlLoading(WebView webView, WebResourceRequest webResourceRequest) {
            webView.loadUrl(webResourceRequest.getUrl().toString(), WebviewFragment.this.getCustomHeaders());
            return true;
        }

        public boolean shouldOverrideUrlLoading(WebView webView, String string2) {
            webView.loadUrl(string2, WebviewFragment.this.getCustomHeaders());
            return true;
        }

        public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
            OtherWebViewClient otherWebViewClient = this;
            super.onPageStarted(webView, string2, bitmap);
            otherWebViewClient.WebviewFragment.this.mRefresh.setRefreshing(true);
        }

        public void onPageFinished(WebView webView, String string2) {
            OtherWebViewClient otherWebViewClient = this;
            super.onPageFinished(webView, string2);
            otherWebViewClient.WebviewFragment.this.mRefresh.setRefreshing(false);
            webView.setVisibility(0);
        }
    }
}

