package com.appzilo.sdk.video.utils;


import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.appzilo.sdk.video.player.PlayerConstants;
import com.appzilo.sdk.video.player.listeners.AbstractVideoPlayerListener;

/**
 * Utility class responsible for tracking the state of YouTubePlayer.
 * This is a YouTubePlayerListener, therefore is responsibility of the user to add and remove it as a listener on the YouTubePlayer object.
 */
public class VideoPlayerTracker extends AbstractVideoPlayerListener {
    private PlayerConstants.PlayerState currentState = PlayerConstants.PlayerState.UNKNOWN;
    private float currentSecond;
    private float videoDuration;
    private String videoId;

    @Override
    public void onStateChange(@NonNull PlayerConstants.PlayerState state) {
        this.currentState = state;
    }

    @Override
    public void onCurrentSecond(float second) {
        currentSecond = second;
    }

    @Override
    public void onVideoDuration(float duration) {
        videoDuration = duration;
    }

    @Override
    public void onVideoId(@NonNull String videoId) {
        this.videoId = videoId;
    }

    @Override
    public void isMute(@NonNull boolean mute) {

    }

    /**
     * @return the player state. A value from {@link PlayerConstants.PlayerState}
     */
    public PlayerConstants.PlayerState getState() {
        return currentState;
    }

    public float getCurrentSecond() {
        return currentSecond;
    }

    public float getVideoDuration() {
        return videoDuration;
    }

    public @Nullable
    String getVideoId() {
        return videoId;
    }
}
