/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.ui.menu.defaultMenu;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.PopupWindow;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.appzilo.sdk.video.R;
import com.appzilo.sdk.video.ui.menu.MenuItem;
import com.appzilo.sdk.video.ui.menu.YouTubePlayerMenu;
import com.appzilo.sdk.video.ui.menu.defaultMenu.MenuAdapter;
import java.util.ArrayList;
import java.util.List;

public class DefaultYouTubePlayerMenu
implements YouTubePlayerMenu {
    private final Context context;
    private final List<MenuItem> menuItems;
    @Nullable
    private PopupWindow popupWindow;

    public DefaultYouTubePlayerMenu(@NonNull Context context) {
        DefaultYouTubePlayerMenu defaultYouTubePlayerMenu = this;
        defaultYouTubePlayerMenu.context = context;
        defaultYouTubePlayerMenu.menuItems = new ArrayList<MenuItem>();
    }

    @NonNull
    private PopupWindow createPopupWindow() {
        LayoutInflater layoutInflater = (LayoutInflater)defaultYouTubePlayerMenu2.context.getSystemService("layout_inflater");
        if (layoutInflater != null) {
            DefaultYouTubePlayerMenu defaultYouTubePlayerMenu = defaultYouTubePlayerMenu2;
            DefaultYouTubePlayerMenu defaultYouTubePlayerMenu2 = layoutInflater.inflate(R.layout.player_menu, null);
            defaultYouTubePlayerMenu.setUpRecyclerView((RecyclerView)defaultYouTubePlayerMenu2.findViewById(R.id.recycler_view));
            PopupWindow popupWindow = new PopupWindow((View)defaultYouTubePlayerMenu2, -2, -2);
            popupWindow.setFocusable(true);
            popupWindow.setWidth(-2);
            popupWindow.setHeight(-2);
            popupWindow.setContentView((View)defaultYouTubePlayerMenu2);
            return popupWindow;
        }
        throw new RuntimeException("can't access LAYOUT_INFLATER_SERVICE");
    }

    private void setUpRecyclerView(RecyclerView recyclerView) {
        RecyclerView recyclerView2 = recyclerView;
        recyclerView2.setHasFixedSize(true);
        recyclerView2.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.context));
        recyclerView2.setAdapter((RecyclerView.Adapter)new MenuAdapter(this.context, this.menuItems));
    }

    @Override
    public void show(View view) {
        DefaultYouTubePlayerMenu defaultYouTubePlayerMenu = this;
        defaultYouTubePlayerMenu.popupWindow = defaultYouTubePlayerMenu.createPopupWindow();
        defaultYouTubePlayerMenu.popupWindow.showAsDropDown(view, 0, -this.context.getResources().getDimensionPixelSize(R.dimen._8dp) * 4);
        if (defaultYouTubePlayerMenu.menuItems.size() == 0) {
            Log.e((String)YouTubePlayerMenu.class.getName(), (String)"The menu is empty");
        }
    }

    @Override
    public void dismiss() {
        DefaultYouTubePlayerMenu defaultYouTubePlayerMenu = defaultYouTubePlayerMenu.popupWindow;
        if (defaultYouTubePlayerMenu != null) {
            defaultYouTubePlayerMenu.dismiss();
        }
    }

    @Override
    public void addItem(MenuItem menuItem) {
        this.menuItems.add(menuItem);
    }

    @Override
    public void removeItem(int n) {
        this.menuItems.remove(n);
    }

    @Override
    public int getItemCount() {
        return this.menuItems.size();
    }
}

