/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.ui;

import android.animation.Animator;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.appzilo.sdk.video.R;
import com.appzilo.sdk.video.player.PlayerConstants;
import com.appzilo.sdk.video.player.VideoPlayer;
import com.appzilo.sdk.video.player.VideoPlayerView;
import com.appzilo.sdk.video.player.listeners.VideoPlayerFullScreenListener;
import com.appzilo.sdk.video.player.listeners.VideoPlayerListener;
import com.appzilo.sdk.video.ui.PlayerUIController;
import com.appzilo.sdk.video.ui.menu.YouTubePlayerMenu;
import com.appzilo.sdk.video.ui.menu.defaultMenu.DefaultYouTubePlayerMenu;
import com.appzilo.sdk.video.utils.Utils;

public class DefaultPlayerUIController
implements PlayerUIController,
VideoPlayerListener,
VideoPlayerFullScreenListener,
View.OnClickListener,
SeekBar.OnSeekBarChangeListener {
    @NonNull
    private final VideoPlayerView videoPlayerView;
    @NonNull
    private final VideoPlayer videoPlayer;
    private final Handler handler = new Handler(Looper.getMainLooper());
    @NonNull
    private YouTubePlayerMenu youTubePlayerMenu;
    private View panel;
    private View controlsRoot;
    private LinearLayout extraViewsContainer;
    private TextView videoTitle;
    private TextView videoCurrentTime;
    private TextView videoDuration;
    private TextView liveVideoIndicator;
    private ProgressBar progressBar;
    private ImageView menuButton;
    private ImageView playPauseButton;
    private ImageView youTubeButton;
    private ImageView fullScreenButton;
    private ImageView customActionLeft;
    private ImageView customActionRight;
    private SeekBar seekBar;
    @Nullable
    private View.OnClickListener onFullScreenButtonListener;
    @Nullable
    private View.OnClickListener onMenuButtonClickListener;
    private boolean isPlaying = false;
    private boolean isVisible = true;
    private boolean canFadeControls = false;
    private boolean showUI = true;
    private final Runnable fadeOutRunnable = new Runnable(){

        @Override
        public void run() {
            DefaultPlayerUIController.this.fadeControls(0.0f);
        }
    };
    private boolean showPlayPauseButton = true;
    private boolean showBufferingProgress = true;
    private boolean showCustomActionLeft = false;
    private boolean showCustomActionRight = false;
    private boolean seekBarTouchStarted = false;
    private int newSeekBarProgress = -1;

    public DefaultPlayerUIController(@NonNull VideoPlayerView videoPlayerView, @NonNull VideoPlayer videoPlayer) {
        this.videoPlayerView = videoPlayerView;
        this.videoPlayer = videoPlayer;
        this.initViews(View.inflate((Context)videoPlayerView.getContext(), (int)R.layout.default_player_ui, (ViewGroup)videoPlayerView));
        this.youTubePlayerMenu = new DefaultYouTubePlayerMenu(videoPlayerView.getContext());
    }

    private void initViews(View view) {
        DefaultPlayerUIController defaultPlayerUIController = this;
        this.panel = view.findViewById(R.id.panel);
        this.controlsRoot = view.findViewById(R.id.controls_root);
        this.extraViewsContainer = (LinearLayout)view.findViewById(R.id.extra_views_container);
        this.videoTitle = (TextView)view.findViewById(R.id.video_title);
        this.videoCurrentTime = (TextView)view.findViewById(R.id.video_current_time);
        this.videoDuration = (TextView)view.findViewById(R.id.video_duration);
        this.liveVideoIndicator = (TextView)view.findViewById(R.id.live_video_indicator);
        this.progressBar = (ProgressBar)view.findViewById(R.id.progress);
        this.menuButton = (ImageView)view.findViewById(R.id.menu_button);
        this.playPauseButton = (ImageView)view.findViewById(R.id.play_pause_button);
        this.youTubeButton = (ImageView)view.findViewById(R.id.youtube_button);
        this.fullScreenButton = (ImageView)view.findViewById(R.id.fullscreen_button);
        this.customActionLeft = (ImageView)view.findViewById(R.id.custom_action_left_button);
        this.customActionRight = (ImageView)view.findViewById(R.id.custom_action_right_button);
        defaultPlayerUIController.seekBar = (SeekBar)view.findViewById(R.id.seek_bar);
        defaultPlayerUIController.seekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        defaultPlayerUIController.panel.setOnClickListener((View.OnClickListener)this);
        defaultPlayerUIController.playPauseButton.setOnClickListener((View.OnClickListener)this);
        defaultPlayerUIController.menuButton.setOnClickListener((View.OnClickListener)this);
        defaultPlayerUIController.fullScreenButton.setOnClickListener((View.OnClickListener)this);
    }

    private void onMenuButtonPressed() {
        View.OnClickListener onClickListener = this.onMenuButtonClickListener;
        if (onClickListener == null) {
            this.youTubePlayerMenu.show((View)this.menuButton);
        } else {
            onClickListener.onClick((View)this.menuButton);
        }
    }

    private void onFullScreenButtonPressed() {
        View.OnClickListener onClickListener = this.onFullScreenButtonListener;
        if (onClickListener == null) {
            this.videoPlayerView.toggleFullScreen();
        } else {
            onClickListener.onClick((View)this.fullScreenButton);
        }
    }

    private void onPlayButtonPressed() {
        if (this.isPlaying) {
            this.videoPlayer.pause();
        } else {
            this.videoPlayer.play();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updatePlayPauseButtonIcon(boolean bl) {
        void var1_4;
        if (bl) {
            int n = R.drawable.ic_pause_36dp;
        } else {
            int n = R.drawable.ic_play_36dp;
        }
        this.playPauseButton.setImageResource((int)var1_4);
    }

    private void toggleControlsVisibility() {
        float f = this.isVisible ? 0.0f : 1.0f;
        this.fadeControls(f);
    }

    private void fadeControls(final float f) {
        if (this.canFadeControls && this.showUI) {
            boolean bl = f != 0.0f;
            this.isVisible = bl;
            if (f == 1.0f && this.isPlaying) {
                this.startFadeOutViewTimer();
            } else {
                this.handler.removeCallbacks(this.fadeOutRunnable);
            }
            this.controlsRoot.animate().alpha(f).setDuration(300L).setListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animator) {
                    if (f == 1.0f) {
                        DefaultPlayerUIController.this.controlsRoot.setVisibility(0);
                    }
                }

                public void onAnimationEnd(Animator animator) {
                    if (f == 0.0f) {
                        DefaultPlayerUIController.this.controlsRoot.setVisibility(8);
                    }
                }

                public void onAnimationCancel(Animator animator) {
                }

                public void onAnimationRepeat(Animator animator) {
                }
            }).start();
            return;
        }
    }

    private void startFadeOutViewTimer() {
        this.handler.postDelayed(this.fadeOutRunnable, 3000L);
    }

    private void updateControlsState(PlayerConstants.PlayerState playerState) {
        switch (5.$SwitchMap$com$appzilo$sdk$video$player$PlayerConstants$PlayerState[playerState.ordinal()]) {
            default: {
                break;
            }
            case 4: {
                this.resetUI();
                break;
            }
            case 3: {
                this.isPlaying = true;
                break;
            }
            case 2: {
                this.isPlaying = false;
                break;
            }
            case 1: {
                this.isPlaying = false;
            }
        }
        DefaultPlayerUIController defaultPlayerUIController = this;
        defaultPlayerUIController.updatePlayPauseButtonIcon(defaultPlayerUIController.isPlaying ^ true);
    }

    private void resetUI() {
        DefaultPlayerUIController defaultPlayerUIController = this;
        defaultPlayerUIController.seekBar.setProgress(0);
        defaultPlayerUIController.seekBar.setMax(0);
        defaultPlayerUIController.videoDuration.post(new Runnable(){

            @Override
            public void run() {
                DefaultPlayerUIController.this.videoDuration.setText((CharSequence)"");
            }
        });
    }

    @Override
    public void showVideoTitle(boolean n) {
        n = n != 0 ? 0 : 8;
        this.videoTitle.setVisibility(n);
    }

    @Override
    public void setVideoTitle(@NonNull String string2) {
        this.videoTitle.setText((CharSequence)string2);
    }

    @Override
    public void showUI(boolean bl) {
        int n = bl ? 0 : 4;
        this.controlsRoot.setVisibility(n);
        this.showUI = bl;
    }

    @Override
    public void showPlayPauseButton(boolean bl) {
        int n = bl ? 0 : 8;
        this.playPauseButton.setVisibility(n);
        this.showPlayPauseButton = bl;
    }

    @Override
    public void enableLiveVideoUI(boolean bl) {
        if (bl) {
            DefaultPlayerUIController defaultPlayerUIController = this;
            defaultPlayerUIController.videoDuration.setVisibility(4);
            defaultPlayerUIController.seekBar.setVisibility(4);
            defaultPlayerUIController.videoCurrentTime.setVisibility(4);
            defaultPlayerUIController.liveVideoIndicator.setVisibility(0);
        } else {
            DefaultPlayerUIController defaultPlayerUIController = this;
            defaultPlayerUIController.videoDuration.setVisibility(0);
            defaultPlayerUIController.seekBar.setVisibility(0);
            defaultPlayerUIController.videoCurrentTime.setVisibility(0);
            defaultPlayerUIController.liveVideoIndicator.setVisibility(8);
        }
    }

    @Override
    public void setCustomAction1(@NonNull Drawable drawable2, View.OnClickListener onClickListener) {
        DefaultPlayerUIController defaultPlayerUIController = this;
        defaultPlayerUIController.customActionLeft.setImageDrawable(drawable2);
        defaultPlayerUIController.customActionLeft.setOnClickListener(onClickListener);
        defaultPlayerUIController.showCustomAction1(true);
    }

    @Override
    public void setCustomAction2(@NonNull Drawable drawable2, View.OnClickListener onClickListener) {
        DefaultPlayerUIController defaultPlayerUIController = this;
        defaultPlayerUIController.customActionRight.setImageDrawable(drawable2);
        defaultPlayerUIController.customActionRight.setOnClickListener(onClickListener);
        defaultPlayerUIController.showCustomAction2(true);
    }

    @Override
    public void showCustomAction1(boolean n) {
        this.showCustomActionLeft = n;
        n = n != 0 ? 0 : 8;
        this.customActionLeft.setVisibility(n);
    }

    @Override
    public void showCustomAction2(boolean n) {
        this.showCustomActionRight = n;
        n = n != 0 ? 0 : 8;
        this.customActionRight.setVisibility(n);
    }

    @Override
    public void showMenuButton(boolean n) {
        n = n != 0 ? 0 : 8;
        this.menuButton.setVisibility(n);
    }

    @Override
    public void setMenuButtonClickListener(@NonNull View.OnClickListener onClickListener) {
        this.onMenuButtonClickListener = onClickListener;
    }

    @Override
    public void showCurrentTime(boolean n) {
        n = n != 0 ? 0 : 8;
        this.videoCurrentTime.setVisibility(n);
    }

    @Override
    public void showDuration(boolean n) {
        n = n != 0 ? 0 : 8;
        this.videoDuration.setVisibility(n);
    }

    @Override
    public void showSeekBar(boolean n) {
        n = n != 0 ? 0 : 4;
        this.seekBar.setVisibility(n);
    }

    @Override
    public void showBufferingProgress(boolean bl) {
        this.showBufferingProgress = bl;
    }

    @Override
    public void showYouTubeButton(boolean n) {
        n = n != 0 ? 0 : 8;
        this.youTubeButton.setVisibility(n);
    }

    @Override
    public void addView(@NonNull View view) {
        this.extraViewsContainer.addView(view, 0);
    }

    @Override
    public void removeView(@NonNull View view) {
        this.extraViewsContainer.removeView(view);
    }

    @Override
    @NonNull
    public YouTubePlayerMenu getMenu() {
        return this.youTubePlayerMenu;
    }

    @Override
    public void setMenu(@NonNull YouTubePlayerMenu youTubePlayerMenu) {
        this.youTubePlayerMenu = youTubePlayerMenu;
    }

    @Override
    public void showFullscreenButton(boolean n) {
        n = n != 0 ? 0 : 8;
        this.fullScreenButton.setVisibility(n);
    }

    @Override
    public void setFullScreenButtonClickListener(@NonNull View.OnClickListener onClickListener) {
        this.onFullScreenButtonListener = onClickListener;
    }

    public void onClick(View view) {
        if (view == this.panel) {
            this.toggleControlsVisibility();
        } else if (view == this.playPauseButton) {
            this.onPlayButtonPressed();
        } else if (view == this.fullScreenButton) {
            this.onFullScreenButtonPressed();
        } else if (view == this.menuButton) {
            this.onMenuButtonPressed();
        }
    }

    @Override
    public void onYouTubePlayerEnterFullScreen() {
        this.fullScreenButton.setImageResource(R.drawable.ic_fullscreen_exit_24dp);
    }

    @Override
    public void onYouTubePlayerExitFullScreen() {
        this.fullScreenButton.setImageResource(R.drawable.ic_fullscreen_24dp);
    }

    @Override
    public void onStateChange(@NonNull PlayerConstants.PlayerState playerState) {
        this.newSeekBarProgress = -1;
        this.updateControlsState(playerState);
        if (playerState != PlayerConstants.PlayerState.PLAYING && playerState != PlayerConstants.PlayerState.PAUSED && playerState != PlayerConstants.PlayerState.VIDEO_CUED) {
            DefaultPlayerUIController defaultPlayerUIController = this;
            defaultPlayerUIController.updatePlayPauseButtonIcon(false);
            defaultPlayerUIController.fadeControls(1.0f);
            if (playerState == PlayerConstants.PlayerState.BUFFERING) {
                DefaultPlayerUIController defaultPlayerUIController2 = this;
                defaultPlayerUIController2.panel.setBackgroundColor(ContextCompat.getColor((Context)this.videoPlayerView.getContext(), (int)17170445));
                if (defaultPlayerUIController2.showPlayPauseButton) {
                    this.playPauseButton.setVisibility(4);
                }
                DefaultPlayerUIController defaultPlayerUIController3 = this;
                defaultPlayerUIController3.customActionLeft.setVisibility(8);
                defaultPlayerUIController3.customActionRight.setVisibility(8);
                defaultPlayerUIController3.canFadeControls = false;
            }
            if (playerState == PlayerConstants.PlayerState.UNSTARTED) {
                DefaultPlayerUIController defaultPlayerUIController4 = this;
                defaultPlayerUIController4.canFadeControls = false;
                defaultPlayerUIController4.progressBar.setVisibility(8);
                if (defaultPlayerUIController4.showPlayPauseButton) {
                    this.playPauseButton.setVisibility(0);
                }
            }
        } else {
            DefaultPlayerUIController defaultPlayerUIController = this;
            defaultPlayerUIController.panel.setBackgroundColor(ContextCompat.getColor((Context)this.videoPlayerView.getContext(), (int)17170445));
            defaultPlayerUIController.progressBar.setVisibility(8);
            if (defaultPlayerUIController.showPlayPauseButton) {
                this.playPauseButton.setVisibility(0);
            }
            if (this.showCustomActionLeft) {
                this.customActionLeft.setVisibility(0);
            }
            if (this.showCustomActionRight) {
                this.customActionRight.setVisibility(0);
            }
            this.canFadeControls = true;
            boolean bl = playerState == PlayerConstants.PlayerState.PLAYING;
            this.updatePlayPauseButtonIcon(bl);
            if (bl) {
                this.startFadeOutViewTimer();
            } else {
                this.handler.removeCallbacks(this.fadeOutRunnable);
            }
        }
    }

    @Override
    public void onCurrentSecond(float f) {
        if (this.seekBarTouchStarted) {
            return;
        }
        if (this.newSeekBarProgress > 0 && !Utils.formatTime(f).equals(Utils.formatTime(this.newSeekBarProgress))) {
            return;
        }
        this.newSeekBarProgress = -1;
        this.seekBar.setProgress((int)f);
    }

    @Override
    public void onVideoDuration(float f) {
        DefaultPlayerUIController defaultPlayerUIController = this;
        defaultPlayerUIController.videoDuration.setText((CharSequence)Utils.formatTime(f));
        defaultPlayerUIController.seekBar.setMax((int)f);
    }

    @Override
    public void onVideoLoadedFraction(float f) {
        if (this.showBufferingProgress) {
            SeekBar seekBar = this.seekBar;
            seekBar.setSecondaryProgress((int)(f * (float)seekBar.getMax()));
        } else {
            this.seekBar.setSecondaryProgress(0);
        }
    }

    @Override
    public void onVideoId(final @NonNull String string2) {
        this.youTubeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent;
                view = intent;
                intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("http://www.youtube.com/watch?v=" + string2 + "#t=" + DefaultPlayerUIController.this.seekBar.getProgress())));
                DefaultPlayerUIController.this.controlsRoot.getContext().startActivity((Intent)view);
            }
        });
    }

    @Override
    public void isMute(@NonNull boolean bl) {
    }

    @Override
    public void onReady() {
    }

    @Override
    public void onPlaybackQualityChange(@NonNull PlayerConstants.PlaybackQuality playbackQuality) {
    }

    @Override
    public void onPlaybackRateChange(@NonNull PlayerConstants.PlaybackRate playbackRate) {
    }

    @Override
    public void onError(@NonNull PlayerConstants.PlayerError playerError) {
    }

    @Override
    public void onApiChange() {
    }

    public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
        this.videoCurrentTime.setText((CharSequence)Utils.formatTime(n));
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        this.seekBarTouchStarted = true;
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        if (this.isPlaying) {
            this.newSeekBarProgress = seekBar.getProgress();
        }
        this.videoPlayer.seekTo(seekBar.getProgress());
        this.seekBarTouchStarted = false;
    }
}

