/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.player;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.appzilo.sdk.video.R;
import com.appzilo.sdk.video.player.IFramePlayerOptions;
import com.appzilo.sdk.video.player.VideoPlayer;
import com.appzilo.sdk.video.player.WebViewVideoPlayer;
import com.appzilo.sdk.video.player.listeners.AbstractVideoPlayerListener;
import com.appzilo.sdk.video.player.listeners.VideoPlayerFullScreenListener;
import com.appzilo.sdk.video.player.listeners.VideoPlayerInitListener;
import com.appzilo.sdk.video.player.playerUtils.FullScreenHelper;
import com.appzilo.sdk.video.player.playerUtils.PlaybackResumer;
import com.appzilo.sdk.video.ui.DefaultPlayerUIController;
import com.appzilo.sdk.video.ui.PlayerUIController;
import com.appzilo.sdk.video.utils.Callable;
import com.appzilo.sdk.video.utils.NetworkReceiver;
import com.appzilo.sdk.video.utils.ResourcesUtil;
import com.appzilo.sdk.video.utils.ScreenSizeUtil;
import com.appzilo.sdk.video.utils.Utils;

public class VideoPlayerView
extends FrameLayout
implements NetworkReceiver.NetworkListener,
LifecycleObserver {
    public static final String PLAYER_TYPE = "player_type";
    public static final int TYPE_YOUTUBE = 0;
    public static final int TYPE_TWITCH = 1;
    public static final int TYPE_MIXER = 2;
    @NonNull
    private final WebViewVideoPlayer youTubePlayer;
    @Nullable
    private DefaultPlayerUIController defaultPlayerUIController;
    @NonNull
    private final NetworkReceiver networkReceiver;
    @NonNull
    private final PlaybackResumer playbackResumer;
    @NonNull
    private final FullScreenHelper fullScreenHelper;
    @Nullable
    private Callable asyncInitialization;
    private String mTag;

    public VideoPlayerView(Context context) {
        this(context, null);
    }

    public VideoPlayerView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public VideoPlayerView(Context context, AttributeSet attributeSet, int n) {
        FrameLayout.LayoutParams layoutParams;
        VideoPlayerView videoPlayerView = this;
        Context context2 = context;
        super(context, attributeSet, n);
        ScreenSizeUtil.init(context2);
        ResourcesUtil.init(context2);
        videoPlayerView.youTubePlayer = new WebViewVideoPlayer(context);
        context = layoutParams;
        layoutParams = new FrameLayout.LayoutParams(-1, -1);
        videoPlayerView.youTubePlayer.setBackgroundColor(ResourcesUtil.getColor(R.color.black));
        videoPlayerView.addView((View)videoPlayerView.youTubePlayer, (ViewGroup.LayoutParams)context);
        VideoPlayerView videoPlayerView2 = this;
        videoPlayerView.defaultPlayerUIController = new DefaultPlayerUIController(videoPlayerView2, videoPlayerView2.youTubePlayer);
        videoPlayerView.playbackResumer = new PlaybackResumer();
        videoPlayerView.networkReceiver = new NetworkReceiver(this);
        videoPlayerView.fullScreenHelper = new FullScreenHelper();
        videoPlayerView.fullScreenHelper.addFullScreenListener(this.defaultPlayerUIController);
        videoPlayerView.addYouTubePlayerListeners(videoPlayerView.youTubePlayer);
    }

    private void addYouTubePlayerListeners(VideoPlayer videoPlayer) {
        DefaultPlayerUIController defaultPlayerUIController = this.defaultPlayerUIController;
        if (defaultPlayerUIController != null) {
            videoPlayer.addListener(defaultPlayerUIController);
        }
        VideoPlayer videoPlayer2 = videoPlayer;
        videoPlayer2.addListener(this.playbackResumer);
        videoPlayer2.addListener(new AbstractVideoPlayerListener(){

            @Override
            public void onReady() {
                VideoPlayerView.access$102(VideoPlayerView.this, null);
            }
        });
    }

    static /* synthetic */ Callable access$102(VideoPlayerView videoPlayerView, Callable callable) {
        videoPlayerView.asyncInitialization = callable;
        return callable;
    }

    public void initPlayer(String string2, String string3) {
        this.youTubePlayer.initWebView(string2, string3);
    }

    public void refreshPlayer() {
        this.youTubePlayer.refresh();
    }

    public void setTag(String string2) {
        this.youTubePlayer.setTag(string2);
    }

    protected void onMeasure(int n, int n2) {
        if (this.getLayoutParams().height == -2) {
            int n3 = n;
            super.onMeasure(n3, View.MeasureSpec.makeMeasureSpec((int)(View.MeasureSpec.getSize((int)n3) * 9 / 16), (int)0x40000000));
        } else {
            super.onMeasure(n, n2);
        }
    }

    public void initialize(@NonNull VideoPlayerInitListener videoPlayerInitListener, boolean bl) {
        this.initialize(videoPlayerInitListener, bl, null);
    }

    public void initialize(final @NonNull VideoPlayerInitListener videoPlayerInitListener, boolean bl, final @Nullable IFramePlayerOptions iFramePlayerOptions) {
        if (bl) {
            this.getContext().registerReceiver((BroadcastReceiver)this.networkReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        this.asyncInitialization = new Callable(){

            @Override
            public void call() {
                VideoPlayerView.this.youTubePlayer.initialize(new VideoPlayerInitListener(){

                    @Override
                    public void onInitSuccess(@NonNull VideoPlayer videoPlayer) {
                        videoPlayerInitListener.onInitSuccess(videoPlayer);
                    }
                }, iFramePlayerOptions);
            }
        };
        if (Utils.isOnline(this.getContext())) {
            this.asyncInitialization.call();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void release() {
        VideoPlayerView videoPlayerView = this;
        videoPlayerView.removeView((View)videoPlayerView.youTubePlayer);
        videoPlayerView.youTubePlayer.removeAllViews();
        videoPlayerView.youTubePlayer.destroy();
        try {
            videoPlayerView.getContext().unregisterReceiver((BroadcastReceiver)this.networkReceiver);
        }
        catch (Exception exception) {}
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    void onStop() {
        this.youTubePlayer.pause();
    }

    @Override
    public void onNetworkAvailable() {
        Callable callable = this.asyncInitialization;
        if (callable != null) {
            callable.call();
        } else {
            this.playbackResumer.resume(this.youTubePlayer);
        }
    }

    @Override
    public void onNetworkUnavailable() {
    }

    public void enableBackgroundPlayback(boolean bl) {
        this.youTubePlayer.backgroundPlaybackEnabled = bl;
    }

    @NonNull
    public PlayerUIController getPlayerUIController() {
        DefaultPlayerUIController defaultPlayerUIController = ((VideoPlayerView)((Object)defaultPlayerUIController)).defaultPlayerUIController;
        if (defaultPlayerUIController != null) {
            return defaultPlayerUIController;
        }
        throw new RuntimeException("You have inflated a custom player UI. You must manage it with your own controller.");
    }

    public View inflateCustomPlayerUI(@LayoutRes int n) {
        VideoPlayerView videoPlayerView = this;
        videoPlayerView.removeViews(1, videoPlayerView.getChildCount() - 1);
        DefaultPlayerUIController defaultPlayerUIController = videoPlayerView.defaultPlayerUIController;
        if (defaultPlayerUIController != null) {
            VideoPlayerView videoPlayerView2 = this;
            videoPlayerView2.youTubePlayer.removeListener(defaultPlayerUIController);
            videoPlayerView2.fullScreenHelper.removeFullScreenListener(this.defaultPlayerUIController);
        }
        this.defaultPlayerUIController = null;
        return View.inflate((Context)this.getContext(), (int)n, (ViewGroup)this);
    }

    public void enterFullScreen() {
        this.fullScreenHelper.enterFullScreen((View)this);
    }

    public void exitFullScreen() {
        this.fullScreenHelper.exitFullScreen((View)this);
    }

    public boolean isFullScreen() {
        return this.fullScreenHelper.isFullScreen();
    }

    public void toggleFullScreen() {
        this.fullScreenHelper.toggleFullScreen((View)this);
    }

    public boolean addFullScreenListener(@NonNull VideoPlayerFullScreenListener videoPlayerFullScreenListener) {
        return this.fullScreenHelper.addFullScreenListener(videoPlayerFullScreenListener);
    }

    public boolean removeFullScreenListener(@NonNull VideoPlayerFullScreenListener videoPlayerFullScreenListener) {
        return this.fullScreenHelper.removeFullScreenListener(videoPlayerFullScreenListener);
    }
}

