/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.player;

import androidx.annotation.NonNull;
import org.json.JSONException;
import org.json.JSONObject;

public class IFramePlayerOptions {
    private final JSONObject playerOptions;

    private IFramePlayerOptions(JSONObject jSONObject) {
        this.playerOptions = jSONObject;
    }

    public static IFramePlayerOptions getDefault() {
        return new Builder().build();
    }

    public String toString() {
        return this.playerOptions.toString();
    }

    public static class Builder {
        private static final String AUTOPLAY = "autoplay";
        private static final String CONTROLS = "controls";
        private static final String ENABLE_JS_API = "enablejsapi";
        private static final String FS = "fs";
        private static final String ORIGIN = "origin";
        private static final String REL = "rel";
        private static final String SHOW_INFO = "showinfo";
        private static final String IV_LOAD_POLICY = "iv_load_policy";
        private static final String MODEST_BRANDING = "modestbranding";
        private final JSONObject builderOptions;

        public Builder() {
            Builder builder = this;
            builder.builderOptions = new JSONObject();
            builder.addInt(AUTOPLAY, 0);
            builder.addInt(CONTROLS, 0);
            builder.addInt(ENABLE_JS_API, 1);
            builder.addInt(FS, 0);
            builder.addString(ORIGIN, "https://www.youtube.com");
            builder.addInt(REL, 0);
            builder.addInt(SHOW_INFO, 0);
            builder.addInt(IV_LOAD_POLICY, 3);
            builder.addInt(MODEST_BRANDING, 1);
        }

        private void addString(@NonNull String string2, @NonNull String string3) {
            try {
                this.builderOptions.put(string2, (Object)string3);
                return;
            }
            catch (JSONException jSONException) {
                throw new RuntimeException("Illegal JSON value " + string2 + ": " + string3);
            }
        }

        private void addInt(@NonNull String string2, int n) {
            try {
                this.builderOptions.put(string2, n);
                return;
            }
            catch (JSONException jSONException) {
                throw new RuntimeException("Illegal JSON value " + string2 + ": " + n);
            }
        }

        public Builder autoplay(int n) {
            Builder builder = this;
            builder.addInt(AUTOPLAY, n);
            return builder;
        }

        public Builder controls(int n) {
            Builder builder = this;
            builder.addInt(CONTROLS, n);
            return builder;
        }

        public Builder origin(@NonNull String string2) {
            Builder builder = this;
            builder.addString(ORIGIN, string2);
            return builder;
        }

        public Builder rel(int n) {
            Builder builder = this;
            builder.addInt(REL, n);
            return builder;
        }

        public Builder showInfo(int n) {
            Builder builder = this;
            builder.addInt(SHOW_INFO, n);
            return builder;
        }

        public Builder ivLoadPolicy(int n) {
            Builder builder = this;
            builder.addInt(IV_LOAD_POLICY, n);
            return builder;
        }

        public Builder modestBranding(int n) {
            Builder builder = this;
            builder.addInt(MODEST_BRANDING, n);
            return builder;
        }

        public IFramePlayerOptions build() {
            return new IFramePlayerOptions(this.builderOptions);
        }
    }
}

