/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.core;

import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.appzilo.sdk.video.core.Result;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class BackgroundWorker {
    private static final int CPU_COUNT = 8;
    private static final int CORE_POOL_SIZE = 9;
    private static final int MAXIMUM_POOL_SIZE = 17;
    private static final int KEEP_ALIVE = 1;
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "BackgroundWorker #" + this.mCount.getAndIncrement());
        }
    };
    private static final BlockingQueue<Runnable> sPoolWorkQueue = new LinkedBlockingQueue<Runnable>(128);
    private static final Executor THREAD_POOL_EXECUTOR;
    private HeadlessFragment mFragment;

    public BackgroundWorker(FragmentActivity fragmentActivity) {
        String string2 = fragmentActivity.getClass().getName() + "_appzilo";
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        HeadlessFragment headlessFragment = (HeadlessFragment)fragmentManager.findFragmentByTag(string2);
        if (headlessFragment == null && !fragmentActivity.isFinishing()) {
            HeadlessFragment headlessFragment2;
            headlessFragment = headlessFragment2;
            headlessFragment2 = new HeadlessFragment();
            try {
                fragmentManager.beginTransaction().add((Fragment)headlessFragment, string2).commit();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        this.mFragment = headlessFragment;
    }

    static {
        TimeUnit timeUnit = TimeUnit.SECONDS;
        BlockingQueue<Runnable> blockingQueue = sPoolWorkQueue;
        ThreadFactory threadFactory = sThreadFactory;
        THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(9, 17, 1L, timeUnit, blockingQueue, threadFactory);
    }

    public void executeTask(String string2, Bundle bundle, Callbacks callbacks) {
        this.mFragment.executeTask(string2, bundle, callbacks);
    }

    public void executeNewTask(String string2, Bundle bundle, Callbacks callbacks) {
        this.mFragment.executeNewTask(string2, bundle, callbacks);
    }

    public void put(String string2, Object object) {
        this.mFragment.put(string2, object);
    }

    public void remove(String string2) {
        this.mFragment.remove(string2);
    }

    public Object get(String string2) {
        Object object = object.mFragment;
        if (object != null) {
            return ((HeadlessFragment)((Object)object)).get(string2);
        }
        return null;
    }

    public static class HeadlessFragment
    extends Fragment {
        private Map<String, Object> mObjects = new HashMap<String, Object>();
        private Map<String, BackgroundTask> mTasks = new HashMap<String, BackgroundTask>();

        public void onCreate(Bundle bundle) {
            HeadlessFragment headlessFragment = this;
            super.onCreate(bundle);
            headlessFragment.setRetainInstance(true);
        }

        public void onDestroy() {
            HeadlessFragment headlessFragment = this;
            super.onDestroy();
            Iterator<Map.Entry<String, BackgroundTask>> iterator = headlessFragment.mTasks.entrySet().iterator();
            while (iterator.hasNext()) {
                iterator.next().getValue().cancel(true);
            }
            HeadlessFragment headlessFragment2 = this;
            headlessFragment2.mTasks.clear();
            headlessFragment2.mObjects.clear();
        }

        public void put(String string2, Object object) {
            this.mObjects.put(string2, object);
        }

        public void remove(String string2) {
            this.mObjects.remove(string2);
        }

        public Object get(String string2) {
            return this.mObjects.get(string2);
        }

        public void executeTask(String string2, Bundle bundle, Callbacks callbacks) {
            BackgroundTask backgroundTask;
            BackgroundTask backgroundTask2 = this.mTasks.get(string2);
            if (backgroundTask2 != null) {
                backgroundTask2.update(bundle, callbacks);
                return;
            }
            backgroundTask2 = backgroundTask;
            backgroundTask = new BackgroundTask(this, string2, bundle, callbacks);
            this.mTasks.put(string2, backgroundTask2);
            if (Build.VERSION.SDK_INT > 10) {
                backgroundTask2.executeOnExecutor(THREAD_POOL_EXECUTOR, new Void[0]);
            } else {
                backgroundTask2.execute(new Void[0]);
            }
        }

        public void executeNewTask(String string2, Bundle bundle, Callbacks callbacks) {
            BackgroundTask backgroundTask = this.mTasks.remove(string2);
            if (backgroundTask != null) {
                backgroundTask.cancel(true);
            }
            this.executeTask(string2, bundle, callbacks);
        }

        public void taskCompleted(String string2) {
            this.mTasks.remove(string2);
        }
    }

    public static class BackgroundTask
    extends AsyncTask<Void, Void, Result> {
        private HeadlessFragment mFragment;
        private String mId;
        private Bundle mArgs;
        private Callbacks mCallbacks;

        public BackgroundTask(HeadlessFragment headlessFragment, String string2, Bundle bundle, Callbacks callbacks) {
            this.mFragment = headlessFragment;
            this.mId = string2;
            this.mArgs = bundle;
            this.mCallbacks = callbacks;
        }

        private void release() {
            this.mFragment.taskCompleted(this.mId);
            this.mFragment = null;
            this.mCallbacks = null;
        }

        protected Result doInBackground(Void ... voidArray) {
            return this.mCallbacks.executeTaskInBackground(this.mId, this.mArgs);
        }

        protected void onPostExecute(Result result) {
            Callbacks callbacks = this.mCallbacks;
            if (callbacks != null) {
                callbacks.onBackgroundTaskCompleted(this.mId, result);
            }
            this.release();
        }

        protected void onCancelled() {
            this.release();
        }

        public void update(Bundle bundle, Callbacks callbacks) {
            this.mArgs = bundle;
            this.mCallbacks = callbacks;
        }
    }

    public static interface Callbacks {
        public Result executeTaskInBackground(String var1, Bundle var2);

        public void onBackgroundTaskCompleted(String var1, Result var2);
    }
}

