/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.appzilo.sdk.video.CustomVideoUIController;
import com.appzilo.sdk.video.EmbedDoubleVideoActivity;
import com.appzilo.sdk.video.R;
import com.appzilo.sdk.video.backend.GigsApi;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.EmbedGigsResponse;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.App;
import com.appzilo.sdk.video.core.BackgroundWorker;
import com.appzilo.sdk.video.core.Result;
import com.appzilo.sdk.video.player.VideoPlayer;
import com.appzilo.sdk.video.player.VideoPlayerView;
import com.appzilo.sdk.video.player.listeners.VideoPlayerInitListener;
import java.util.ArrayList;

public class EmbedVideoFragment
extends Fragment
implements BackgroundWorker.Callbacks,
VideoPlayerInitListener,
CustomVideoUIController.Listener {
    public static final String EMBED_PAGE = "page";
    private String TASK_GET_VIDEO = "video_task_init";
    private String TASK_GET_SAME_VIDEO = "video_task_same_init";
    private String TASK_VERIFY_VIDEO = "video_task_verify";
    private String TASK_REPORT_VIDEO = "video_task_report";
    private String TASK_SKIP_VIDEO = "video_task_skip";
    private String OBJ_GIGS_BACKEND = "gigs_backend.video";
    private VideoPlayerView mYouTubePlayerView;
    private CustomVideoUIController mCustomPlayerUIController;
    private View mCustomPlayerUI;
    private BackgroundWorker mWorker;
    private GigsApi mGigsBackend;
    private NoticeResponse mNoticeResponse;
    private EmbedGigsResponse mVideoGigsResponse;
    private int mPage;
    private EmbedVideoInterface mListener;

    public static EmbedVideoFragment newInstance(Bundle bundle) {
        if (bundle == null) {
            Bundle bundle2;
            bundle = bundle2;
            bundle2 = new Bundle();
        }
        EmbedVideoFragment embedVideoFragment = new EmbedVideoFragment();
        embedVideoFragment.setArguments(bundle);
        return embedVideoFragment;
    }

    public void onCreate(@Nullable Bundle object) {
        EmbedVideoFragment embedVideoFragment = this;
        super.onCreate(object);
        if (embedVideoFragment.getActivity() != null) {
            EmbedVideoFragment embedVideoFragment2 = this;
            embedVideoFragment2.mWorker = new BackgroundWorker(this.getActivity());
            embedVideoFragment2.mGigsBackend = (GigsApi)embedVideoFragment2.mWorker.get(this.OBJ_GIGS_BACKEND);
            if (embedVideoFragment2.mGigsBackend == null) {
                this.mGigsBackend = new GigsApi(this.getContext());
                this.mWorker.put(this.OBJ_GIGS_BACKEND, this.mGigsBackend);
            }
            EmbedVideoFragment embedVideoFragment3 = this;
            embedVideoFragment3.mNoticeResponse = NoticeApi.getNoticeResponse(embedVideoFragment3.getContext());
            object = null;
            if (embedVideoFragment3.getArguments() != null) {
                EmbedVideoFragment embedVideoFragment4 = this;
                object = embedVideoFragment4.getArguments().getString("video_response", null);
                embedVideoFragment4.mPage = embedVideoFragment4.getArguments().getInt(EMBED_PAGE);
                embedVideoFragment4.TASK_GET_VIDEO = this.TASK_GET_VIDEO + this.mPage;
                embedVideoFragment4.TASK_VERIFY_VIDEO = this.TASK_VERIFY_VIDEO + this.mPage;
                embedVideoFragment4.TASK_REPORT_VIDEO = this.TASK_REPORT_VIDEO + this.mPage;
                embedVideoFragment4.TASK_SKIP_VIDEO = this.TASK_SKIP_VIDEO + this.mPage;
                embedVideoFragment4.TASK_GET_SAME_VIDEO = this.TASK_GET_SAME_VIDEO + this.mPage;
            }
            if (object != null) {
                this.mVideoGigsResponse = (EmbedGigsResponse)App.gson().fromJson(this.getArguments().getString("video_response"), EmbedGigsResponse.class);
            }
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        EmbedVideoFragment embedVideoFragment = this;
        layoutInflater = layoutInflater.inflate(R.layout.fragment_embed_video, viewGroup, false);
        embedVideoFragment.mYouTubePlayerView = (VideoPlayerView)layoutInflater.findViewById(R.id.player);
        embedVideoFragment.mCustomPlayerUI = embedVideoFragment.mYouTubePlayerView.inflateCustomPlayerUI(R.layout.custom_video_ui);
        embedVideoFragment.mYouTubePlayerView.initialize(this, true);
        if (embedVideoFragment.getActivity() != null) {
            ((EmbedDoubleVideoActivity)this.getActivity()).addLifecycleObserver(this.mYouTubePlayerView);
        }
        return layoutInflater;
    }

    public void onResume() {
        EmbedVideoFragment embedVideoFragment = this;
        super.onResume();
        if (embedVideoFragment.getView() != null) {
            this.getView().clearFocus();
        }
        if ((this = ((EmbedVideoFragment)this).mCustomPlayerUIController) != null) {
            ((CustomVideoUIController)this).onResume();
        }
    }

    public void onPause() {
        EmbedVideoFragment embedVideoFragment = customVideoUIController;
        super.onPause();
        CustomVideoUIController customVideoUIController = embedVideoFragment.mCustomPlayerUIController;
        if (customVideoUIController != null) {
            customVideoUIController.onPause();
        }
    }

    public void onDestroy() {
        EmbedVideoFragment embedVideoFragment = customVideoUIController;
        super.onDestroy();
        CustomVideoUIController customVideoUIController = embedVideoFragment.mCustomPlayerUIController;
        if (customVideoUIController != null) {
            customVideoUIController.onDestroy();
        }
    }

    @Override
    public Result executeTaskInBackground(String string2, Bundle bundle) {
        if (bundle == null) {
            Bundle bundle2;
            bundle = bundle2;
            bundle2 = new Bundle();
        }
        if (this.getActivity() != null && this.getActivity() instanceof EmbedDoubleVideoActivity) {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList;
            if (new ArrayList<String>(((EmbedDoubleVideoActivity)this.getActivity()).getCurrentPlayingGid()).size() > 0) {
                arrayList2.remove(this.mVideoGigsResponse.gid);
                bundle.putSerializable("exclude_gid", arrayList2);
            }
        }
        if (this.getArguments() != null) {
            bundle.putBoolean("is_featured", this.getArguments().getBoolean("is_featured", false));
            bundle.putInt("video_category", this.getArguments().getInt("video_category", 0));
        }
        if (!string2.equals(this.TASK_GET_VIDEO) && !string2.equals(this.TASK_GET_SAME_VIDEO)) {
            if (string2.equals(this.TASK_VERIFY_VIDEO)) {
                return this.mGigsBackend.verifyWatchedYtVideo(bundle);
            }
            if (string2.equals(this.TASK_REPORT_VIDEO)) {
                return this.mGigsBackend.reportYoutube(bundle);
            }
            if (string2.equals(this.TASK_SKIP_VIDEO)) {
                return this.mGigsBackend.skipVideo(bundle);
            }
            return null;
        }
        return this.mGigsBackend.getYtVideo(bundle);
    }

    @Override
    public void onBackgroundTaskCompleted(String object, Result result) {
        if (((String)object).equals(this.TASK_GET_VIDEO)) {
            this.mVideoGigsResponse = (EmbedGigsResponse)result.getResult();
            this.mCustomPlayerUIController.initializeYtVideoInfo(this.mVideoGigsResponse);
            return;
        }
        if ((((String)object).equals(this.TASK_VERIFY_VIDEO) || ((String)object).equals(this.TASK_REPORT_VIDEO) || ((String)object).equals(this.TASK_SKIP_VIDEO) || ((String)object).equals(this.TASK_GET_SAME_VIDEO)) && result.isSuccess()) {
            Intent intent;
            object = (EmbedGigsResponse)result.getResult();
            if (object != null && ((EmbedGigsResponse)object).gid != null && this.getActivity() != null) {
                if (this.getActivity() != null && ((EmbedDoubleVideoActivity)this.getActivity()).isVideoIdExist(((EmbedGigsResponse)object).gid) && !((EmbedGigsResponse)object).gid.equals(this.mCustomPlayerUIController.getPlayingVideoId())) {
                    this.mWorker.executeTask(this.TASK_GET_SAME_VIDEO, null, this);
                    return;
                }
                this.mVideoGigsResponse = object;
                ((EmbedDoubleVideoActivity)this.getActivity()).addPlayingGid(((EmbedGigsResponse)object).gid);
            }
            EmbedVideoFragment embedVideoFragment = this;
            embedVideoFragment.mCustomPlayerUIController.verifiedYtVideo((EmbedGigsResponse)object);
            object = intent;
            intent = new Intent("gigs_force_refresh_receiver");
            if (embedVideoFragment.getContext() != null) {
                LocalBroadcastManager.getInstance((Context)this.getContext()).sendBroadcast((Intent)object);
            }
            return;
        }
        this.videoNotAvailable();
    }

    public String getCurrentPlayingVideoId() {
        return this.mCustomPlayerUIController.getPlayingVideoId();
    }

    @Override
    public void videoReachEndpoint(String string2, int n) {
        NoticeResponse noticeResponse = this.mNoticeResponse;
        if (noticeResponse != null && !noticeResponse.is_police) {
            Bundle bundle;
            noticeResponse = bundle;
            new Bundle().putString("tid", string2);
            noticeResponse.putInt("ts", n);
            this.mWorker.executeTask(this.TASK_VERIFY_VIDEO, (Bundle)noticeResponse, this);
        } else {
            this.videoNotAvailable();
        }
    }

    @Override
    public void skipVideo(String string2) {
        NoticeResponse noticeResponse = this.mNoticeResponse;
        if (noticeResponse != null && !noticeResponse.is_police) {
            Bundle bundle;
            noticeResponse = bundle;
            new Bundle().putString("tid", string2);
            this.mWorker.executeTask(this.TASK_SKIP_VIDEO, (Bundle)noticeResponse, this);
        } else {
            this.videoNotAvailable();
        }
    }

    @Override
    public void videoNotAvailable() {
        EmbedVideoInterface embedVideoInterface;
        if (this.getActivity() != null && !this.getActivity().isFinishing() && (embedVideoInterface = this.mListener) != null) {
            embedVideoInterface.videoNotAvailable(this.mPage);
        }
    }

    @Override
    public void forceStopVideo() {
        if (this.getActivity() != null && !this.getActivity().isFinishing()) {
            this.getActivity().finish();
        }
    }

    @Override
    public void youtubePlayableError(String string2, String string3) {
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putString("tid", string2);
        bundle2.putString("sid", string3);
        this.mWorker.executeTask(this.TASK_REPORT_VIDEO, bundle2, this);
    }

    @Override
    public void enablePictureInPicture() {
    }

    public void setListener(EmbedVideoInterface embedVideoInterface) {
        this.mListener = embedVideoInterface;
    }

    public void setMute(boolean bl) {
        CustomVideoUIController customVideoUIController = ((EmbedVideoFragment)((Object)customVideoUIController)).mCustomPlayerUIController;
        if (customVideoUIController != null) {
            customVideoUIController.setMute(bl);
        }
    }

    public void setVolumeControl(boolean bl) {
        CustomVideoUIController customVideoUIController = ((EmbedVideoFragment)((Object)customVideoUIController)).mCustomPlayerUIController;
        if (customVideoUIController != null) {
            customVideoUIController.setVolumeControl(bl);
        }
    }

    public void reload() {
        CustomVideoUIController customVideoUIController = ((EmbedVideoFragment)((Object)customVideoUIController)).mCustomPlayerUIController;
        if (customVideoUIController != null) {
            customVideoUIController.reload();
        }
    }

    @Override
    public void onInitSuccess(@NonNull VideoPlayer videoPlayer) {
        if (this.mCustomPlayerUIController == null) {
            CustomVideoUIController customVideoUIController;
            EmbedVideoFragment embedVideoFragment = this;
            FragmentActivity fragmentActivity = embedVideoFragment.getActivity();
            int n = embedVideoFragment.mPage;
            View view = embedVideoFragment.mCustomPlayerUI;
            VideoPlayerView videoPlayerView = embedVideoFragment.mYouTubePlayerView;
            NoticeResponse noticeResponse = embedVideoFragment.mNoticeResponse;
            int n2 = noticeResponse != null ? noticeResponse.passive_video_interval * 1000 : 0;
            NoticeResponse noticeResponse2 = this.mNoticeResponse;
            boolean bl = noticeResponse2 != null && noticeResponse2.is_police;
            CustomVideoUIController customVideoUIController2 = customVideoUIController;
            customVideoUIController2((Activity)fragmentActivity, this, n, view, videoPlayer, videoPlayerView, n2, bl);
            this.mCustomPlayerUIController = customVideoUIController2;
            videoPlayer.addListener(this.mCustomPlayerUIController);
            this.mCustomPlayerUIController.initializeYtVideoInfo(this.mVideoGigsResponse);
        }
    }

    public static interface EmbedVideoInterface {
        public void videoNotAvailable(int var1);
    }
}

