/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.SystemClock;
import android.view.ContextThemeWrapper;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleObserver;
import com.appzilo.sdk.video.EmbedVideoFragment;
import com.appzilo.sdk.video.R;
import com.appzilo.sdk.video.WebviewFragment;
import com.appzilo.sdk.video.backend.GigsApi;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.EmbedGigsResponse;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.App;
import com.appzilo.sdk.video.core.BackgroundWorker;
import com.appzilo.sdk.video.core.Error;
import com.appzilo.sdk.video.core.Logger;
import com.appzilo.sdk.video.core.Result;
import com.appzilo.sdk.video.player.VideoPlayerView;
import com.appzilo.sdk.video.utils.NetworkUtil;
import com.appzilo.sdk.video.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class EmbedDoubleVideoActivity
extends AppCompatActivity
implements BackgroundWorker.Callbacks,
EmbedVideoFragment.EmbedVideoInterface {
    private static final String OBJ_NOTICE_API = "obj_notice_api";
    private static final String TASK_GET_VIDEO = "video_task_init";
    private static final String TASK_GET_VIDEO_2 = "video_task_init_2";
    private static final String EMBED_FRAGMENT_TAG = "embed_video_";
    private static final String OBJ_GIGS_BACKEND = "gigs_backend.video";
    private static final String TASK_REQUEST_NOTICE = "task_request_notice";
    private static final String QUERY_PARAMS = "query_params";
    private LinearLayout mRootView;
    private BackgroundWorker mWorker;
    private NoticeResponse mNoticeResponse;
    private NoticeApi mNoticeApi;
    private AlertDialog mNoVideoDialog;
    private GigsApi mGigsBackend;
    private EmbedGigsResponse mVideoGigsResponse;
    private int mUnmuteVideoPlayer;
    private ArrayList<String> mPlayingGidList;
    private boolean mIsReady;
    private boolean mFragmentNotAdded;
    private boolean mViewPlaying = false;
    private final Object mSync = new Object();
    private long mLastClickTime = 0L;
    private String mQuery;
    private Bundle mQueryBundle;
    private boolean mIsPolice;
    int page = 1;
    private boolean mIsSkipClicked;

    private boolean isEnableDoubleVideo(boolean bl) {
        return bl && Utils.getCurrentWebViewPackageInfo() && NetworkUtil.isConnectedFast(this.getApplicationContext());
    }

    static /* synthetic */ boolean access$102(EmbedDoubleVideoActivity embedDoubleVideoActivity, boolean bl) {
        embedDoubleVideoActivity.mIsSkipClicked = bl;
        return bl;
    }

    protected void onCreate(@Nullable Bundle object) {
        EmbedDoubleVideoActivity embedDoubleVideoActivity = this;
        super.onCreate((Bundle)object);
        embedDoubleVideoActivity.setRequestedOrientation(0);
        embedDoubleVideoActivity.setContentView(R.layout.activity_embed_video_2);
        embedDoubleVideoActivity.mRootView = (LinearLayout)embedDoubleVideoActivity.findViewById(R.id.embed_video_root);
        embedDoubleVideoActivity.mWorker = new BackgroundWorker((FragmentActivity)this);
        embedDoubleVideoActivity.mNoticeResponse = NoticeApi.getNoticeResponse(embedDoubleVideoActivity.getApplicationContext());
        if (embedDoubleVideoActivity.mNoticeApi == null) {
            this.mNoticeApi = new NoticeApi(this.getApplicationContext());
            this.mWorker.put(OBJ_NOTICE_API, this.mNoticeApi);
        }
        EmbedDoubleVideoActivity embedDoubleVideoActivity2 = this;
        embedDoubleVideoActivity2.mGigsBackend = (GigsApi)embedDoubleVideoActivity2.mWorker.get(OBJ_GIGS_BACKEND);
        if (embedDoubleVideoActivity2.mGigsBackend == null) {
            this.mGigsBackend = new GigsApi((Context)this);
            this.mWorker.put(OBJ_GIGS_BACKEND, this.mGigsBackend);
        }
        EmbedDoubleVideoActivity embedDoubleVideoActivity3 = this;
        embedDoubleVideoActivity3.mPlayingGidList = new ArrayList();
        embedDoubleVideoActivity3.mQuery = embedDoubleVideoActivity3.getIntent().getStringExtra("video_params");
        object = embedDoubleVideoActivity3.mQuery;
        if (object != null && !((String)object).isEmpty()) {
            EmbedDoubleVideoActivity embedDoubleVideoActivity4 = this;
            embedDoubleVideoActivity4.mQueryBundle = new Bundle();
            embedDoubleVideoActivity4.mQueryBundle.putString(QUERY_PARAMS, this.mQuery);
            embedDoubleVideoActivity4.mWorker.executeTask(TASK_REQUEST_NOTICE, this.mQueryBundle, this);
        }
    }

    protected void onResume() {
        EmbedDoubleVideoActivity embedDoubleVideoActivity = this;
        super.onResume();
        embedDoubleVideoActivity.mIsReady = true;
        if (embedDoubleVideoActivity.page == 1 && this.mFragmentNotAdded) {
            this.mWorker.executeTask(TASK_GET_VIDEO, null, this);
            this.mFragmentNotAdded = false;
        }
    }

    protected void onPause() {
        super.onPause();
        this.mIsReady = false;
    }

    public void finish() {
        EmbedDoubleVideoActivity embedDoubleVideoActivity = this;
        super.finish();
        embedDoubleVideoActivity.setRequestedOrientation(1);
    }

    @Override
    public Result executeTaskInBackground(String arrayList, Bundle bundle) {
        if (bundle == null) {
            Bundle bundle2;
            bundle = bundle2;
            bundle2 = new Bundle();
        }
        int n = -1;
        int n2 = ((String)((Object)arrayList)).hashCode();
        if (n2 != -2071100218) {
            if (n2 != -1757448455) {
                if (n2 == 449466498 && ((String)((Object)arrayList)).equals(TASK_REQUEST_NOTICE)) {
                    n = 2;
                }
            } else if (((String)((Object)arrayList)).equals(TASK_GET_VIDEO_2)) {
                n = 1;
            }
        } else if (((String)((Object)arrayList)).equals(TASK_GET_VIDEO)) {
            n = 0;
        }
        if (n != 0 && n != 1) {
            if (n != 2) {
                return null;
            }
            arrayList = bundle.getString(QUERY_PARAMS);
            if (arrayList != null && ((HashMap)((Object)(arrayList = Utils.queryToHashMap((String)((Object)arrayList))))).containsKey("app_key") && !((HashMap)((Object)arrayList)).get("app_key").isEmpty() && ((HashMap)((Object)arrayList)).containsKey("sub_pubid") && !((HashMap)((Object)arrayList)).get("sub_pubid").isEmpty()) {
                return this.mNoticeApi.request((HashMap<String, String>)((Object)arrayList));
            }
            return new Result(Error.EMPTY);
        }
        arrayList = this.mPlayingGidList;
        if (arrayList != null && arrayList.size() > 0) {
            bundle.putSerializable("exclude_gid", this.mPlayingGidList);
        }
        bundle.putBoolean("is_featured", this.getIntent().getBooleanExtra("is_featured", false));
        bundle.putInt("video_category", this.getIntent().getIntExtra("video_category", 0));
        return this.mGigsBackend.getYtVideo(bundle);
    }

    @Override
    public void onBackgroundTaskCompleted(String object, Result result) {
        int n = -1;
        int n2 = ((String)object).hashCode();
        if (n2 != -2071100218) {
            if (n2 != -1757448455) {
                if (n2 == 449466498 && ((String)object).equals(TASK_REQUEST_NOTICE)) {
                    n = 0;
                }
            } else if (((String)object).equals(TASK_GET_VIDEO_2)) {
                n = 2;
            }
        } else if (((String)object).equals(TASK_GET_VIDEO)) {
            n = 1;
        }
        if (n != 0) {
            if (n == 1 || n == 2) {
                if (result.isSuccess() && this.mIsReady) {
                    this.mVideoGigsResponse = (EmbedGigsResponse)result.getResult();
                    if (this.mVideoGigsResponse.success) {
                        EmbedDoubleVideoActivity embedDoubleVideoActivity = this;
                        embedDoubleVideoActivity.getIntent().putExtra("video_response", App.gson().toJson((Object)this.mVideoGigsResponse));
                        embedDoubleVideoActivity.getIntent().putExtra("page", this.page);
                        embedDoubleVideoActivity.addPlayingGid(embedDoubleVideoActivity.mVideoGigsResponse.gid);
                        object = EmbedVideoFragment.newInstance(embedDoubleVideoActivity.getIntent().getExtras());
                        ((EmbedVideoFragment)object).setListener(this);
                        embedDoubleVideoActivity.getSupportFragmentManager().beginTransaction().add(R.id.embed_video_root, (Fragment)object, EMBED_FRAGMENT_TAG + this.page).commit();
                        if (embedDoubleVideoActivity.isEnableDoubleVideo(embedDoubleVideoActivity.mNoticeResponse.double_video) && this.page < 2) {
                            new Handler().postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    EmbedDoubleVideoActivity embedDoubleVideoActivity = embedDoubleVideoActivity.EmbedDoubleVideoActivity.this;
                                    embedDoubleVideoActivity.EmbedDoubleVideoActivity.this.mWorker.executeTask(EmbedDoubleVideoActivity.TASK_GET_VIDEO_2, null, embedDoubleVideoActivity);
                                }
                            }, 1000L);
                        }
                        ++this.page;
                        return;
                    }
                } else if (!this.mIsReady) {
                    this.mFragmentNotAdded = true;
                }
                if (((String)object).equalsIgnoreCase(TASK_GET_VIDEO)) {
                    this.videoNotAvailable();
                }
            }
        } else {
            if (result != null && result.isSuccess()) {
                Object object2;
                this.mNoticeResponse = (NoticeResponse)result.getResult();
                object = this.mNoticeResponse;
                boolean bl = object != null && ((NoticeResponse)object).is_police;
                this.mIsPolice = bl;
                if (!this.mIsPolice && (object2 = this.mNoticeResponse) != null && ((NoticeResponse)object2).credential.success) {
                    if (((NoticeResponse)object2).video_webview_control) {
                        Bundle bundle;
                        Bundle bundle2;
                        EmbedDoubleVideoActivity embedDoubleVideoActivity = this;
                        object2 = bundle2;
                        object2();
                        object2.putBoolean("is_featured", this.getIntent().getBooleanExtra("is_featured", false));
                        bundle2.putInt("video_category", this.getIntent().getIntExtra("video_category", 0));
                        bundle2.putBoolean("video_webview_control", true);
                        object2 = this.mGigsBackend.getDomain() + Utils.hashMapToQuery(this.mGigsBackend.getParams("GigsBackend.getYoutube", (Bundle)object2));
                        if (embedDoubleVideoActivity.isEnableDoubleVideo(embedDoubleVideoActivity.mNoticeResponse.double_video)) {
                            object2 = (String)object2 + "&vc=2";
                        }
                        result = bundle;
                        new Bundle().putString("url", (String)object2);
                        this.getSupportFragmentManager().beginTransaction().add(R.id.embed_video_root, (Fragment)WebviewFragment.newInstance((Bundle)result), EMBED_FRAGMENT_TAG + this.page).commit();
                    } else {
                        this.mWorker.executeTask(TASK_GET_VIDEO, null, this);
                    }
                    return;
                }
            }
            this.videoNotAvailable();
        }
    }

    public void videoNotAvailable() {
        Object object;
        if (!(this.isFinishing() || (object = this.mNoVideoDialog) != null && (object.isShowing() || this.isFinishing()))) {
            DialogInterface.OnClickListener onClickListener;
            object = onClickListener;
            onClickListener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    EmbedDoubleVideoActivity.this.finish();
                }
            };
            this.mNoVideoDialog = new AlertDialog.Builder((Context)new ContextThemeWrapper((Context)this, R.style.AlertDialog)).setCancelable(false).setMessage(R.string.no_video_retry).setPositiveButton(17039370, (DialogInterface.OnClickListener)object).show();
        }
    }

    public void addLifecycleObserver(VideoPlayerView videoPlayerView) {
        this.getLifecycle().addObserver((LifecycleObserver)videoPlayerView);
    }

    public void muteAllHtmlEmbedPlayer(int n) {
        this.mViewPlaying = true;
        for (int i = 1; i <= 2; ++i) {
            Fragment fragment = this.getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG + i);
            if (fragment == null || !(fragment instanceof EmbedVideoFragment)) continue;
            if (i != n) {
                if (this.mUnmuteVideoPlayer <= 0) continue;
                this.mUnmuteVideoPlayer = i;
                ((EmbedVideoFragment)fragment).setMute(false);
                continue;
            }
            ((EmbedVideoFragment)fragment).setVolumeControl(false);
        }
    }

    public void testSkipAd(String string2, int n) {
        for (int i = 1; i <= 2; ++i) {
            Fragment fragment = this.getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG + i);
            if (fragment == null || !(fragment instanceof EmbedVideoFragment)) continue;
            if (i == 1) {
                ((EmbedVideoFragment)fragment).videoReachEndpoint(string2, n);
                continue;
            }
            EmbedVideoFragment embedVideoFragment = (EmbedVideoFragment)fragment;
            embedVideoFragment.videoReachEndpoint(embedVideoFragment.getCurrentPlayingVideoId(), n);
        }
    }

    public void setViewPlaying(boolean bl) {
        this.mViewPlaying = bl;
    }

    public void unmuteSkipVideoPlayer(int n) {
        int n2 = 0;
        if (n == this.mUnmuteVideoPlayer) {
            for (int i = 1; i <= 2; ++i) {
                Fragment fragment = this.getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG + i);
                if (fragment == null || !(fragment instanceof EmbedVideoFragment)) continue;
                ((EmbedVideoFragment)fragment).setMute(true);
                if (n == i) continue;
                n2 = i;
            }
            if (n2 > 0) {
                Fragment fragment = this.getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG + n2);
                if (fragment != null && fragment instanceof EmbedVideoFragment) {
                    ((EmbedVideoFragment)fragment).setMute(false);
                }
                this.mUnmuteVideoPlayer = n2;
            }
        }
    }

    public void unmuteVideoPlayer(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 1; i <= 2; ++i) {
            Fragment fragment = this.getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG + i);
            if (fragment == null || !(fragment instanceof EmbedVideoFragment)) continue;
            ((EmbedVideoFragment)fragment).setMute(true);
            if (n != this.mUnmuteVideoPlayer) {
                n3 = n;
            } else if (n != i) {
                n3 = i;
            }
            ++n4;
        }
        if (n3 != this.mUnmuteVideoPlayer) {
            Fragment fragment;
            Fragment fragment2 = this.getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG + n3);
            if (fragment2 != null && fragment2 instanceof EmbedVideoFragment) {
                ((EmbedVideoFragment)fragment2).setMute(false);
            }
            for (int i = 1; i <= 2; ++i) {
                if (i == n3) continue;
                n2 = i;
            }
            if (n3 > 0 && n4 == 2 && !this.mViewPlaying && (fragment = this.getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG + n2)) != null && fragment instanceof EmbedVideoFragment) {
                ((EmbedVideoFragment)fragment).reload();
            }
        }
        this.mUnmuteVideoPlayer = n3;
    }

    public boolean isUnmuteVideoExist() {
        return this.mUnmuteVideoPlayer > 0;
    }

    public ArrayList<String> getCurrentPlayingGid() {
        if (this.mPlayingGidList.size() > 0) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            Iterator<String> iterator = this.mPlayingGidList.iterator();
            while (iterator.hasNext()) {
                stringBuilder2.append(iterator.next()).append(",");
            }
            Logger.e(stringBuilder2.toString());
            return this.mPlayingGidList;
        }
        return new ArrayList<String>();
    }

    public boolean isVideoIdExist(String string2) {
        return ((ArrayList)(this = ((EmbedDoubleVideoActivity)this).getCurrentPlayingGid())).size() > 0 && ((ArrayList)this).contains(string2);
    }

    public void addPlayingGid(String string2) {
        if (string2 != null) {
            this.mPlayingGidList.add(string2);
        }
    }

    public void removePreviousPlayingId(String string2) {
        if (string2 != null) {
            this.mPlayingGidList.remove(string2);
        }
        this.getCurrentPlayingGid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void videoNotAvailable(final int n) {
        Object object = this.mSync;
        synchronized (object) {
            if (SystemClock.elapsedRealtime() - this.mLastClickTime < 1000L) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        EmbedDoubleVideoActivity.this.videoNotAvailable(n);
                    }
                }, 500L);
                return;
            }
            this.mLastClickTime = SystemClock.elapsedRealtime();
            Fragment fragment = null;
            int n2 = 0;
            for (int i = 1; i <= 2; ++i) {
                Fragment fragment2 = this.getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG + i);
                if (fragment2 != null && fragment2 instanceof EmbedVideoFragment) {
                    if (i != n) {
                        fragment2 = fragment;
                    }
                    ++n2;
                } else {
                    fragment2 = fragment;
                }
                fragment = fragment2;
            }
            if (n2 == 2 && fragment != null) {
                this.getSupportFragmentManager().beginTransaction().remove(fragment).commit();
            } else {
                this.videoNotAvailable();
            }
            return;
        }
    }

    public void updateCurrentPlayingGid(String string2) {
        this.removePreviousPlayingId(string2);
    }

    public boolean isClickedSkipButton() {
        return this.mIsSkipClicked;
    }

    public void setIsSkipClicked() {
        if (!this.mIsSkipClicked) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    EmbedDoubleVideoActivity.access$102(EmbedDoubleVideoActivity.this, false);
                }
            }, 2000L);
            this.mIsSkipClicked = true;
        }
    }

    public void applyOverrideConfiguration(Configuration configuration) {
        int n = Build.VERSION.SDK_INT;
        if (n >= 21 && n <= 25) {
            return;
        }
        super.applyOverrideConfiguration(configuration);
    }
}

