package com.appzilo.sdk.video.utils;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;

import java.lang.reflect.InvocationTargetException;

public class ScreenSizeUtil {

    private static int sWidth;
    private static int sHeight;

    public static void init(Context context) {
        WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
        Display d = wm.getDefaultDisplay();
        DisplayMetrics dm = new DisplayMetrics();
        d.getMetrics(dm);
        int width = dm.widthPixels;
        int height = dm.heightPixels;
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                Point p = new Point();
                Display.class.getMethod("getRealSize", Point.class).invoke(d, p);
                width = p.x;
                height = p.y;
            } catch (IllegalAccessException ignored) {
            } catch (InvocationTargetException ignored) {
            } catch (NoSuchMethodException ignored) {
            }
        } else if (Build.VERSION.SDK_INT >= 14) {
            try {
                width = (int) Display.class.getMethod("getRawWidth").invoke(d);
                height = (int) Display.class.getMethod("getRawHeight").invoke(d);
            } catch (IllegalAccessException ignored) {
            } catch (InvocationTargetException ignored) {
            } catch (NoSuchMethodException ignored) {
            }
        }
        sWidth = width;
        sHeight = height;
    }

    public static int width() {
        return sWidth;
    }

    public static int height() {
        return sHeight;
    }
}
