/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.Activity;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.DecelerateInterpolator;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.SwitchCompat;
import androidx.core.content.ContextCompat;
import com.akexorcist.roundcornerprogressbar.RoundCornerProgressBar;
import com.andexert.library.RippleView;
import com.appzilo.sdk.video.EmbedDoubleVideoActivity;
import com.appzilo.sdk.video.EmbedVideoActivity;
import com.appzilo.sdk.video.R;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.EmbedGigsResponse;
import com.appzilo.sdk.video.backend.model.EmbedVideoInfo;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.player.PlayerConstants;
import com.appzilo.sdk.video.player.VideoPlayer;
import com.appzilo.sdk.video.player.VideoPlayerView;
import com.appzilo.sdk.video.player.listeners.AbstractVideoPlayerListener;
import com.appzilo.sdk.video.utils.ResourcesUtil;
import com.appzilo.sdk.video.utils.SharedPreferencesUtil;
import com.appzilo.sdk.video.utils.Utils;
import com.squareup.picasso.Picasso;
import java.util.Locale;

public class CustomVideoUIController
extends AbstractVideoPlayerListener
implements View.OnClickListener,
CompoundButton.OnCheckedChangeListener {
    public static final String YT_IS_AUTO_SKIP = "yt_is_auto_skip";
    private static final String SKIP_DIALOG_VISIBILITY = "skip_dialog_visiblity";
    private static final String ERROR_INVALID_PARAMETER_IN_REQUEST = "2";
    private static final String ERROR_HTML_5_PLAYER = "5";
    private static final String ERROR_VIDEO_NOT_FOUND = "100";
    private static final String ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER1 = "101";
    private static final String ERROR_VIDEO_LIVE_OFFLINE = "102";
    private static final String ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER2 = "150";
    private SharedPreferencesUtil mPref;
    private int mDefaultInterval = 0;
    private int mDelayInterval = 10000;
    private Activity mActivity;
    private VideoPlayer youTubePlayerCallback;
    private Button mSkipButton;
    private View mLoadingBar;
    private View mPanel;
    private Listener mListener;
    private int mMinWatchTime;
    private String mIdVideoPlaying;
    private boolean mPlayerIsPlaying;
    private EmbedGigsResponse mNextYtInfo;
    private int mTimestamp;
    private boolean mFirstTime;
    private Handler mHandler;
    private SwitchCompat mAutoSkipToggle;
    private View mAutoSkipContainer;
    private Button mStopButton;
    private boolean mIsYtEnded;
    private boolean mIsPolice;
    private final int countdownInterval;
    private CountDownRunnable mCountDownRunnable;
    private boolean mIsOnPause;
    private float mCurrentSeconds;
    private VideoPlayerView mPlayerView;
    private String mVideoUniqueId;
    private View mLiveIndicator;
    private TextView mLiveStatus;
    private boolean mIsInitialize;
    private ErrorCountDownRunnable mErrorCountdown;
    private int mErrorReportMaxTime;
    private boolean mIsVideoHtmlExist;
    private Button mOpenButton;
    private String mVideoUrl;
    private String mVideoType;
    private EmbedGigsResponse mResponse;
    private int mPage;
    private ImageButton mVolume;
    private RippleView mOpenContainer;
    private RippleView mSkipContainer;
    private RippleView mVolumeContainer;
    private RippleView mPipContainer;
    private boolean mFirstOnReady;
    private boolean mIsVideoStart = true;
    private boolean mIsMute;
    private TextView mSkipCoin;
    private RoundCornerProgressBar mSkipProgress;
    private View mSkipRevealView;
    private ImageButton mPipButton;
    private boolean mIsPipMode;
    private ProgressBar mSkipLoading;
    private double mTotalCoinEarned;
    private int mTotalTimeWatched;
    private View mSkipCoinContainer;
    private ImageView mSkipCoinImage;
    private boolean mIsVideoError;
    private ViewDelayRunnable mViewDelayRunnable;
    private DelayRunnable mDelayRunnable;
    private String mCoinImageUrl;
    private String mVirtualCoin;
    private Picasso mPicasso;

    public CustomVideoUIController(Activity activity, Listener listener, View view, VideoPlayer videoPlayer, VideoPlayerView videoPlayerView, int n, boolean bl) {
        this.countdownInterval = 1000;
        this.init(activity, listener, 0, view, videoPlayer, videoPlayerView, n, bl);
    }

    public CustomVideoUIController(Activity activity, Listener listener, int n, View view, VideoPlayer videoPlayer, VideoPlayerView videoPlayerView, int n2, boolean bl) {
        this.countdownInterval = 1000;
        this.init(activity, listener, n, view, videoPlayer, videoPlayerView, n2, bl);
    }

    private void init(Activity activity, Listener object, int n, View view, VideoPlayer videoPlayer, VideoPlayerView videoPlayerView, int n2, boolean bl) {
        this.mActivity = activity;
        this.mListener = object;
        this.mPicasso = new Picasso.Builder(this.mActivity.getApplicationContext()).build();
        object = NoticeApi.getNoticeResponse(this.mActivity.getApplicationContext());
        if (object != null) {
            this.mCoinImageUrl = ((NoticeResponse)object).coin;
            this.mVirtualCoin = ((NoticeResponse)object).vc;
        }
        ResourcesUtil.init((Context)activity);
        this.youTubePlayerCallback = videoPlayer;
        if (n2 > 0) {
            this.mDelayInterval = n2;
        }
        CustomVideoUIController customVideoUIController = this;
        CustomVideoUIController customVideoUIController2 = this;
        this.initViews(view);
        customVideoUIController2.mIsPolice = bl;
        customVideoUIController2.mPref = new SharedPreferencesUtil((Context)activity);
        customVideoUIController.mPlayerView = videoPlayerView;
        customVideoUIController.mHandler = new Handler(Looper.getMainLooper());
        this.mPage = n;
    }

    private void initViews(View view) {
        this.mPanel = view.findViewById(R.id.panel);
        this.mLoadingBar = view.findViewById(R.id.progress_bar);
        this.mAutoSkipContainer = view.findViewById(R.id.yt_auto_skip_container);
        this.mAutoSkipToggle = (SwitchCompat)view.findViewById(R.id.yt_auto_skip);
        this.mStopButton = (Button)view.findViewById(R.id.stop_button);
        this.mAutoSkipToggle.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.mLiveIndicator = view.findViewById(R.id.live_container);
        this.mLiveStatus = (TextView)view.findViewById(R.id.live_status);
        this.mOpenButton = (Button)view.findViewById(R.id.open_button);
        this.mOpenContainer = (RippleView)view.findViewById(R.id.open_container);
        this.mSkipButton = (Button)view.findViewById(R.id.skip_button);
        this.mSkipContainer = (RippleView)view.findViewById(R.id.skip_container);
        this.mVolume = (ImageButton)view.findViewById(R.id.volume_button);
        this.mVolumeContainer = (RippleView)view.findViewById(R.id.volume_container);
        this.mPipButton = (ImageButton)view.findViewById(R.id.pip_button);
        this.mPipContainer = (RippleView)view.findViewById(R.id.pip_container);
        this.mSkipCoinImage = (ImageView)view.findViewById(R.id.skip_coin_image);
        this.mSkipCoin = (TextView)view.findViewById(R.id.skip_coin);
        this.mSkipProgress = (RoundCornerProgressBar)view.findViewById(R.id.skip_progress);
        this.mSkipLoading = (ProgressBar)view.findViewById(R.id.skip_loading);
        this.mSkipCoinContainer = view.findViewById(R.id.skip_coin_container);
        this.mSkipRevealView = view.findViewById(R.id.skip_reveal_view);
        if (this.mIsPolice) {
            this.mSkipContainer.setVisibility(8);
        }
        CustomVideoUIController customVideoUIController = this;
        customVideoUIController.mSkipContainer.setOnRippleCompleteListener(new RippleView.a(){

            @Override
            public void onComplete(RippleView rippleView) {
                if (CustomVideoUIController.this.mSkipButton != null) {
                    CustomVideoUIController customVideoUIController = CustomVideoUIController.this;
                    customVideoUIController.onClick((View)customVideoUIController.mSkipButton);
                }
            }
        });
        customVideoUIController.mOpenContainer.setOnRippleCompleteListener(new RippleView.a(){

            @Override
            public void onComplete(RippleView rippleView) {
                if (CustomVideoUIController.this.mOpenButton != null) {
                    CustomVideoUIController customVideoUIController = CustomVideoUIController.this;
                    customVideoUIController.onClick((View)customVideoUIController.mOpenButton);
                }
            }
        });
        customVideoUIController.mVolumeContainer.setOnRippleCompleteListener(new RippleView.a(){

            @Override
            public void onComplete(RippleView rippleView) {
                if (CustomVideoUIController.this.mVolume != null) {
                    CustomVideoUIController customVideoUIController = CustomVideoUIController.this;
                    customVideoUIController.onClick((View)customVideoUIController.mVolume);
                }
            }
        });
        customVideoUIController.mPipContainer.setOnRippleCompleteListener(new RippleView.a(){

            @Override
            public void onComplete(RippleView rippleView) {
                if (CustomVideoUIController.this.mPipButton != null) {
                    CustomVideoUIController customVideoUIController = CustomVideoUIController.this;
                    customVideoUIController.onClick((View)customVideoUIController.mPipButton);
                }
            }
        });
    }

    private void createErrorReportCountdown() {
        if (this.mErrorReportMaxTime > 0 && this.mIsVideoHtmlExist) {
            ErrorCountDownRunnable errorCountDownRunnable = this.mErrorCountdown;
            if (errorCountDownRunnable != null) {
                this.mHandler.removeCallbacks((Runnable)errorCountDownRunnable);
            }
            this.mErrorCountdown = new ErrorCountDownRunnable();
            this.mHandler.postDelayed((Runnable)this.mErrorCountdown, (long)(this.mErrorReportMaxTime * 1000));
        }
    }

    private void stopErrorReportCountDown() {
        ErrorCountDownRunnable errorCountDownRunnable = this.mErrorCountdown;
        if (errorCountDownRunnable != null) {
            this.mHandler.removeCallbacks((Runnable)errorCountDownRunnable);
            this.mErrorCountdown = null;
        }
    }

    private void initUI() {
        if (!this.mIsPipMode) {
            CustomVideoUIController customVideoUIController = this;
            customVideoUIController.mLoadingBar.setVisibility(0);
            customVideoUIController.mAutoSkipContainer.setVisibility(0);
            customVideoUIController.mStopButton.setVisibility(0);
            customVideoUIController.mAutoSkipToggle.setChecked(this.mPref.getBooleanValue(YT_IS_AUTO_SKIP, false));
            if (!customVideoUIController.mIsPolice) {
                CustomVideoUIController customVideoUIController2 = this;
                customVideoUIController2.mSkipContainer.setVisibility(8);
                customVideoUIController2.mSkipProgress.setProgressColor(ResourcesUtil.getColor(R.color.primary));
            }
        }
        CustomVideoUIController customVideoUIController = this;
        customVideoUIController.mOpenButton.setVisibility(8);
        customVideoUIController.mVolume.setVisibility(8);
        customVideoUIController.mPipButton.setVisibility(8);
    }

    private boolean onCurrentSecond(int n) {
        n = Math.round(n);
        CustomVideoUIController customVideoUIController = this;
        ++customVideoUIController.mTotalTimeWatched;
        if ((n == customVideoUIController.mMinWatchTime || n == 0) && this.mFirstTime) {
            CustomVideoUIController customVideoUIController2 = this;
            customVideoUIController2.mFirstTime = false;
            customVideoUIController2.mListener.videoReachEndpoint(this.mIdVideoPlaying, this.mTimestamp);
            customVideoUIController2.mSkipButton.setVisibility(8);
            customVideoUIController2.mSkipLoading.setVisibility(0);
            return false;
        }
        if (this.mFirstTime && n < this.mMinWatchTime) {
            String string2;
            if (!this.mIsPolice) {
                CustomVideoUIController customVideoUIController3 = this;
                customVideoUIController3.mSkipContainer.setVisibility(0);
                customVideoUIController3.mSkipContainer.setEnabled(false);
                customVideoUIController3.mSkipButton.setVisibility(0);
                customVideoUIController3.mSkipLoading.setVisibility(8);
            }
            n = this.mMinWatchTime - n;
            int n2 = n % 3600 / 60;
            n %= 60;
            if (n2 > 0) {
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                objectArray2[0] = n2;
                objectArray[1] = n;
                string2 = String.format(Locale.US, "%02d:%02d", objectArray2);
            } else {
                Object[] objectArray = new Object[1];
                Object[] objectArray3 = objectArray;
                objectArray[0] = n;
                string2 = String.format(Locale.US, "%ds", objectArray3);
            }
            this.initSkipAdCountDown(String.format(ResourcesUtil.getString(R.string.yt_skip_video_count_down), string2));
            return true;
        }
        return false;
    }

    private void initSkipAdCountDown(String string2) {
        CustomVideoUIController customVideoUIController = this;
        customVideoUIController.removeLoadingUI();
        Button button = customVideoUIController.mSkipButton;
        if (button != null) {
            if (!this.mIsPipMode) {
                int n;
                CustomVideoUIController customVideoUIController2 = this;
                button.setText((CharSequence)string2);
                customVideoUIController2.mSkipButton.setTextSize(12.0f);
                int n2 = n = Utils.dpToPx(8);
                customVideoUIController2.mSkipButton.setPadding(n2, n2, n2, n2);
                customVideoUIController2.mSkipContainer.setEnabled(false);
            }
            CustomVideoUIController customVideoUIController3 = this;
            string2 = customVideoUIController3.mSkipCoinImage.getLayoutParams();
            int n = customVideoUIController3.mIsPipMode ? Utils.dpToPx(16) : Utils.dpToPx(28);
            CustomVideoUIController customVideoUIController4 = this;
            ((ViewGroup.LayoutParams)string2).width = n;
            string2 = customVideoUIController4.mSkipCoinImage.getLayoutParams();
            n = customVideoUIController4.mIsPipMode ? Utils.dpToPx(16) : Utils.dpToPx(28);
            CustomVideoUIController customVideoUIController5 = this;
            ((ViewGroup.LayoutParams)string2).height = n;
            string2 = customVideoUIController5.mSkipContainer.getLayoutParams();
            n = customVideoUIController5.mIsPipMode ? Utils.dpToPx(40) : Utils.dpToPx(60);
            CustomVideoUIController customVideoUIController6 = this;
            ((ViewGroup.LayoutParams)string2).height = n;
            string2 = customVideoUIController6.mSkipButton;
            n = customVideoUIController6.mIsPipMode ? 8 : 0;
            string2.setVisibility(n);
            this.redrawsCountdownBar();
        }
        if (!this.mIsPipMode && (string2 = this.mOpenButton) != null && !this.mIsPolice) {
            if (this.mMinWatchTime <= 300 && this.mTotalTimeWatched <= 300) {
                string2.setEnabled(false);
                this.mOpenButton.setVisibility(8);
            } else {
                CustomVideoUIController customVideoUIController7 = this;
                customVideoUIController7.mOpenButton.setEnabled(true);
                customVideoUIController7.mOpenButton.setText(R.string.skip_video_now);
                customVideoUIController7.mOpenButton.setVisibility(0);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initSkipAd() {
        block7: {
            EmbedGigsResponse embedGigsResponse;
            block8: {
                CustomVideoUIController customVideoUIController = this;
                customVideoUIController.removeLoadingUI();
                embedGigsResponse = customVideoUIController.mNextYtInfo;
                if (embedGigsResponse == null) break block7;
                if (embedGigsResponse.success && embedGigsResponse.video_info != null) break block8;
                embedGigsResponse = this.mNextYtInfo;
                if (embedGigsResponse.success || embedGigsResponse.video_info != null) break block7;
            }
            if ((embedGigsResponse = this.mSkipButton) != null) {
                if (!this.mIsPipMode) {
                    int n;
                    CustomVideoUIController customVideoUIController = this;
                    embedGigsResponse.setVisibility(0);
                    customVideoUIController.mSkipButton.setText(R.string.yt_skip_video);
                    int n2 = n = Utils.dpToPx(8);
                    customVideoUIController.mSkipButton.setPadding(n2, n2, n2, n2);
                    customVideoUIController.mSkipContainer.setEnabled(true);
                    if (!customVideoUIController.mIsPolice) {
                        this.mSkipContainer.setVisibility(0);
                    }
                }
                CustomVideoUIController customVideoUIController = this;
                customVideoUIController.mSkipLoading.setVisibility(8);
                embedGigsResponse = customVideoUIController.mSkipCoinImage.getLayoutParams();
                int n = customVideoUIController.mIsPipMode ? Utils.dpToPx(16) : Utils.dpToPx(28);
                CustomVideoUIController customVideoUIController2 = this;
                ((ViewGroup.LayoutParams)embedGigsResponse).width = n;
                embedGigsResponse = customVideoUIController2.mSkipCoinImage.getLayoutParams();
                n = customVideoUIController2.mIsPipMode ? Utils.dpToPx(16) : Utils.dpToPx(28);
                CustomVideoUIController customVideoUIController3 = this;
                ((ViewGroup.LayoutParams)embedGigsResponse).height = n;
                embedGigsResponse = customVideoUIController3.mSkipContainer.getLayoutParams();
                n = customVideoUIController3.mIsPipMode ? Utils.dpToPx(40) : Utils.dpToPx(60);
                CustomVideoUIController customVideoUIController4 = this;
                ((ViewGroup.LayoutParams)embedGigsResponse).height = n;
                embedGigsResponse = customVideoUIController4.mSkipButton;
                n = customVideoUIController4.mIsPipMode ? 8 : 0;
                CustomVideoUIController customVideoUIController5 = this;
                embedGigsResponse.setVisibility(n);
                customVideoUIController5.redrawsCountdownBar();
                customVideoUIController5.reveal();
            }
            if (this.mIsPipMode) return;
            embedGigsResponse = this.mOpenButton;
            if (embedGigsResponse == null) return;
            if (this.mIsPolice) return;
            if (this.mVideoUrl != null && this.mVideoType != null) {
                CustomVideoUIController customVideoUIController = this;
                embedGigsResponse.setEnabled(true);
                customVideoUIController.mOpenButton.setText((CharSequence)("Watch on " + this.mVideoType.replace("_live", "")));
                customVideoUIController.mOpenButton.setVisibility(0);
                return;
            }
            CustomVideoUIController customVideoUIController = this;
            customVideoUIController.mOpenButton.setEnabled(false);
            customVideoUIController.mOpenButton.setVisibility(8);
            return;
        }
        this.redrawsCountdownBar();
    }

    private void showUiVideo() {
        CustomVideoUIController customVideoUIController = customVideoUIController2;
        customVideoUIController.mFirstTime = true;
        customVideoUIController.mIsYtEnded = false;
        customVideoUIController.removeLoadingUI();
        CustomVideoUIController customVideoUIController2 = customVideoUIController.mPipButton;
        int n = customVideoUIController.isSupportPip() ? 0 : 8;
        customVideoUIController2.setVisibility(n);
    }

    private void removeLoadingUI() {
        CustomVideoUIController customVideoUIController = this;
        customVideoUIController.mLoadingBar.setVisibility(8);
        customVideoUIController.mAutoSkipContainer.setVisibility(8);
        customVideoUIController.mStopButton.setVisibility(8);
    }

    private boolean isSupportPip() {
        return Build.VERSION.SDK_INT >= 26 && this.mActivity instanceof EmbedVideoActivity;
    }

    @NonNull
    private String parsePlayerError(PlayerConstants.PlayerError playerError) {
        return playerError.equals((Object)PlayerConstants.PlayerError.INVALID_PARAMETER_IN_REQUEST) ? ERROR_INVALID_PARAMETER_IN_REQUEST : (playerError.equals((Object)PlayerConstants.PlayerError.HTML_5_PLAYER) ? ERROR_HTML_5_PLAYER : (playerError.equals((Object)PlayerConstants.PlayerError.VIDEO_NOT_FOUND) ? ERROR_VIDEO_NOT_FOUND : (playerError.equals((Object)PlayerConstants.PlayerError.VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER) ? ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER1 : (playerError.equals((Object)PlayerConstants.PlayerError.VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER) ? ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER2 : (playerError.equals((Object)PlayerConstants.PlayerError.ERROR_VIDEO_LIVE_OFFLINE) ? ERROR_VIDEO_LIVE_OFFLINE : "0")))));
    }

    private boolean enabledPictureInPicture() {
        Object object;
        if (Build.VERSION.SDK_INT >= 26 && (object = (AppOpsManager)this.mActivity.getSystemService("appops")) != null) {
            int n = Process.myUid();
            return object.checkOpNoThrow("android:picture_in_picture", n, (String)(object = Utils.getAppId(this.mActivity.getApplicationContext()))) == 0;
        }
        return false;
    }

    private void setMute() {
        Activity activity = this.mActivity;
        if (activity instanceof EmbedDoubleVideoActivity) {
            ((EmbedDoubleVideoActivity)activity).unmuteVideoPlayer(this.mPage);
        }
    }

    private void setInitialMute() {
        Activity activity = this.mActivity;
        if (activity instanceof EmbedDoubleVideoActivity) {
            if (!((EmbedDoubleVideoActivity)activity).isUnmuteVideoExist()) {
                ((EmbedDoubleVideoActivity)this.mActivity).unmuteVideoPlayer(this.mPage);
            } else {
                this.setMute(true);
            }
        }
    }

    private void refreshUI() {
        Handler handler = this.mHandler;
        if (handler != null) {
            handler.removeCallbacksAndMessages(null);
        }
        CustomVideoUIController customVideoUIController = this;
        customVideoUIController.initUI();
        customVideoUIController.mPanel.setBackgroundColor(ContextCompat.getColor((Context)this.mActivity, (int)17170444));
    }

    private void openSkipDialog() {
        if (!this.mPref.getBooleanValue(SKIP_DIALOG_VISIBILITY, false)) {
            View view = LayoutInflater.from((Context)this.mActivity).inflate(R.layout.checkbox, null);
            final CheckBox checkBox = (CheckBox)view.findViewById(R.id.skip);
            new AlertDialog.Builder((Context)new ContextThemeWrapper((Context)this.mActivity, R.style.AlertDialog)).setCancelable(false).setView(view).setTitle((CharSequence)ResourcesUtil.getString(R.string.skip_video_now)).setMessage((CharSequence)ResourcesUtil.getString(R.string.skip_video_no_reward_desc)).setPositiveButton(R.string.skip, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    10 v0 = this;
                    v0.CustomVideoUIController.this.mPref.putBooleanValue(CustomVideoUIController.SKIP_DIALOG_VISIBILITY, checkBox.isChecked());
                    v0.CustomVideoUIController.this.mListener.skipVideo(CustomVideoUIController.this.mIdVideoPlaying);
                    v0.CustomVideoUIController.this.skipEmbedVideo();
                }
            }).setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    dialogInterface.dismiss();
                }
            }).create().show();
        } else {
            CustomVideoUIController customVideoUIController = this;
            customVideoUIController.mListener.skipVideo(this.mIdVideoPlaying);
            customVideoUIController.skipEmbedVideo();
        }
    }

    private void skipEmbedVideo() {
        Activity activity = this.mActivity;
        if (activity instanceof EmbedDoubleVideoActivity) {
            ((EmbedDoubleVideoActivity)activity).unmuteSkipVideoPlayer(this.mPage);
            if (!this.mIsVideoHtmlExist) {
                CustomVideoUIController customVideoUIController = this;
                customVideoUIController.setVolumeControl(true);
                ((EmbedDoubleVideoActivity)customVideoUIController.mActivity).setViewPlaying(false);
            }
        }
        CustomVideoUIController customVideoUIController = this;
        customVideoUIController.youTubePlayerCallback.pause();
        customVideoUIController.mIsYtEnded = true;
        customVideoUIController.mIsOnPause = true;
        customVideoUIController.mPlayerView.refreshPlayer();
        customVideoUIController.removeRunnableHandler();
        customVideoUIController.refreshUI();
    }

    private void reveal() {
        this.mSkipRevealView.setVisibility(0);
        if (Build.VERSION.SDK_INT >= 21) {
            this.mSkipRevealView.post(new Runnable(){

                @Override
                public void run() {
                    11 v0 = this;
                    v0.CustomVideoUIController.this.mSkipRevealView.forceLayout();
                    v0.CustomVideoUIController.this.mSkipRevealView.requestLayout();
                    float f = (float)Math.max(((CustomVideoUIController)v0.CustomVideoUIController.this).mSkipRevealView.getLayoutParams().width, ((CustomVideoUIController)CustomVideoUIController.this).mSkipRevealView.getLayoutParams().height) * 1.2f;
                    Animator animator = null;
                    if (Build.VERSION.SDK_INT >= 21) {
                        animator = ViewAnimationUtils.createCircularReveal((View)CustomVideoUIController.this.mSkipRevealView, (int)0, (int)0, (float)0.0f, (float)f);
                    }
                    CustomVideoUIController.this.mSkipRevealView.setBackgroundColor(ResourcesUtil.getColor(R.color.green));
                    animator.start();
                }
            });
        } else {
            this.mSkipRevealView.setBackgroundColor(ResourcesUtil.getColor(R.color.green));
        }
    }

    private void measureSkipContainerWidth() {
        CustomVideoUIController customVideoUIController = this;
        customVideoUIController.mSkipCoinContainer.measure(0, 0);
        customVideoUIController.mSkipCoin.measure(0, 0);
        customVideoUIController.mSkipCoinContainer.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                12 v0 = this;
                v0.CustomVideoUIController.this.mSkipCoinContainer.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                ((CustomVideoUIController)v0.CustomVideoUIController.this).mSkipProgress.getLayoutParams().width = CustomVideoUIController.this.mSkipCoinContainer.getMeasuredWidth();
                ((CustomVideoUIController)v0.CustomVideoUIController.this).mSkipRevealView.getLayoutParams().width = CustomVideoUIController.this.mSkipCoinContainer.getMeasuredWidth();
                v0.CustomVideoUIController.this.mSkipRevealView.measure(0, 0);
            }
        });
    }

    private void removeRunnableHandler() {
        Object object = this.mHandler;
        if (object != null) {
            ViewDelayRunnable viewDelayRunnable = this.mViewDelayRunnable;
            if (viewDelayRunnable != null) {
                object.removeCallbacks((Runnable)viewDelayRunnable);
            }
            if ((object = this.mDelayRunnable) != null) {
                this.mHandler.removeCallbacks((Runnable)object);
            }
            if ((object = this.mErrorCountdown) != null) {
                this.mHandler.removeCallbacks((Runnable)object);
            }
            if ((object = this.mCountDownRunnable) != null) {
                this.mHandler.removeCallbacks((Runnable)object);
            }
        }
    }

    private void redrawsCountdownBar() {
        CustomVideoUIController customVideoUIController = this;
        customVideoUIController.mSkipLoading.setVisibility(8);
        customVideoUIController.mSkipCoinImage.setVisibility(0);
        Object object = customVideoUIController.mSkipCoinImage;
        String string2 = customVideoUIController.mCoinImageUrl;
        int n = string2 != null && !string2.isEmpty() ? 0 : 8;
        object.setVisibility(n);
        object = this.mCoinImageUrl;
        if (object != null && !((String)object).isEmpty() && (object = this.mPicasso) != null) {
            object.load(this.mCoinImageUrl).into(this.mSkipCoinImage);
        }
        object = this.mResponse != null ? String.format("%." + this.mResponse.coin_dp + "f", this.mTotalCoinEarned) : String.valueOf(this.mTotalCoinEarned);
        Object[] objectArray = this.mCoinImageUrl;
        if (this.mCoinImageUrl == null || objectArray.isEmpty()) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray[0] = object;
            objectArray2[1] = this.mVirtualCoin;
            object = String.format("%s %s", objectArray);
        }
        CustomVideoUIController customVideoUIController2 = this;
        customVideoUIController2.mSkipCoin.setText((CharSequence)object);
        customVideoUIController2.measureSkipContainerWidth();
    }

    static /* synthetic */ boolean access$502(CustomVideoUIController customVideoUIController, boolean bl) {
        customVideoUIController.mIsInitialize = bl;
        return bl;
    }

    static /* synthetic */ int access$702(CustomVideoUIController customVideoUIController, int n) {
        customVideoUIController.mDefaultInterval = n;
        return n;
    }

    static /* synthetic */ boolean access$1402(CustomVideoUIController customVideoUIController, boolean bl) {
        customVideoUIController.mIsVideoStart = bl;
        return bl;
    }

    static /* synthetic */ float access$1208(CustomVideoUIController customVideoUIController) {
        float f = customVideoUIController.mCurrentSeconds;
        customVideoUIController.mCurrentSeconds = f + 1.0f;
        return f;
    }

    public void setPipMode(boolean bl) {
        CustomVideoUIController customVideoUIController = this;
        customVideoUIController.mIsPipMode = bl;
        ImageButton imageButton = customVideoUIController.mPipButton;
        int n = customVideoUIController.mIsPipMode ? 8 : 0;
        imageButton.setVisibility(n);
        if (this.mNextYtInfo != null) {
            this.initSkipAd();
        }
    }

    @Override
    public void onReady() {
        CustomVideoUIController customVideoUIController = this;
        customVideoUIController.removeRunnableHandler();
        if (customVideoUIController.mDefaultInterval > 0 && !this.mFirstOnReady) {
            this.mDefaultInterval = 0;
        }
        CustomVideoUIController customVideoUIController2 = this;
        CustomVideoUIController customVideoUIController3 = this;
        customVideoUIController2.mDelayRunnable = customVideoUIController3.new DelayRunnable(customVideoUIController3.mVideoUniqueId);
        customVideoUIController2.mHandler.postDelayed((Runnable)this.mDelayRunnable, (long)this.mDefaultInterval);
        customVideoUIController2.mDefaultInterval = customVideoUIController2.mDelayInterval;
        customVideoUIController2.mFirstOnReady = false;
    }

    @Override
    public void onStateChange(@NonNull PlayerConstants.PlayerState object) {
        if (object == PlayerConstants.PlayerState.PLAYING) {
            CustomVideoUIController customVideoUIController = this;
            customVideoUIController.stopErrorReportCountDown();
            customVideoUIController.mIsOnPause = false;
            if (customVideoUIController.mIsInitialize) {
                CustomVideoUIController customVideoUIController2 = this;
                customVideoUIController2.mIsInitialize = false;
                customVideoUIController2.mPanel.setBackgroundColor(ContextCompat.getColor((Context)this.mActivity, (int)17170445));
                customVideoUIController2.setMute(customVideoUIController2.mIsMute);
                object = customVideoUIController2.mCountDownRunnable;
                if (object == null) {
                    this.mCountDownRunnable = new CountDownRunnable();
                    this.mPlayerIsPlaying = true;
                    this.mHandler.postDelayed((Runnable)this.mCountDownRunnable, 0L);
                } else {
                    this.mHandler.postDelayed((Runnable)object, 0L);
                }
            }
        } else if (object != PlayerConstants.PlayerState.BUFFERING && object != PlayerConstants.PlayerState.VIDEO_CUED) {
            if (object == PlayerConstants.PlayerState.ENDED) {
                this.mPlayerIsPlaying = false;
                if (this.mVideoType.contains("youtube_live")) {
                    this.onError(PlayerConstants.PlayerError.ERROR_VIDEO_LIVE_OFFLINE);
                } else {
                    object = this.mNextYtInfo;
                    if (object != null) {
                        this.initYtVideoInfo((EmbedGigsResponse)object);
                    }
                }
                this.mIsYtEnded = true;
            } else if (object == PlayerConstants.PlayerState.PAUSED) {
                CustomVideoUIController customVideoUIController = this;
                customVideoUIController.mIsOnPause = true;
                customVideoUIController.mIsInitialize = true;
                customVideoUIController.mFirstTime = true;
            } else if (object == PlayerConstants.PlayerState.OFFLINE) {
                this.mIsInitialize = false;
                this.onError(PlayerConstants.PlayerError.ERROR_VIDEO_LIVE_OFFLINE);
            } else if (object == PlayerConstants.PlayerState.VIDEOSTART) {
                if (this.mIsVideoStart && this.mVideoType.contains("mixer")) {
                    this.setInitialMute();
                    this.mIsVideoStart = false;
                } else {
                    CustomVideoUIController customVideoUIController = this;
                    customVideoUIController.setMute(customVideoUIController.mIsMute);
                }
            }
        } else {
            CustomVideoUIController customVideoUIController = this;
            customVideoUIController.mPanel.setBackgroundColor(ContextCompat.getColor((Context)this.mActivity, (int)17170445));
            customVideoUIController.setMute(customVideoUIController.mIsMute);
        }
    }

    @Override
    public void onCurrentSecond(float f) {
    }

    @Override
    public void onError(@NonNull PlayerConstants.PlayerError playerError) {
        CustomVideoUIController customVideoUIController = this;
        super.onError(playerError);
        customVideoUIController.skipEmbedVideo();
        customVideoUIController.mDefaultInterval = 0;
        customVideoUIController.mPanel.setBackgroundColor(ResourcesUtil.getColor(R.color.black));
        if (!customVideoUIController.mIsPolice) {
            CustomVideoUIController customVideoUIController2 = this;
            customVideoUIController2.mIsVideoError = true;
            customVideoUIController2.mListener.youtubePlayableError(this.mIdVideoPlaying, this.parsePlayerError(playerError));
            customVideoUIController2.initUI();
            return;
        }
        this.mListener.videoNotAvailable();
    }

    public void onClick(View object) {
        int n = object.getId();
        if (n == R.id.skip_button) {
            object = this.mActivity;
            if (object != null && object instanceof EmbedDoubleVideoActivity) {
                if (((EmbedDoubleVideoActivity)object).isClickedSkipButton()) {
                    return;
                }
                ((EmbedDoubleVideoActivity)this.mActivity).setIsSkipClicked();
            }
            CustomVideoUIController customVideoUIController = this;
            customVideoUIController.mPlayerIsPlaying = false;
            customVideoUIController.skipEmbedVideo();
            object = customVideoUIController.mNextYtInfo;
            if (object != null) {
                this.initYtVideoInfo((EmbedGigsResponse)object);
            }
        } else if (n == R.id.stop_button) {
            this.mListener.forceStopVideo();
        } else if (n == R.id.open_button) {
            if (object instanceof Button) {
                if (((Button)object).getText().equals(ResourcesUtil.getString(R.string.skip_video_now))) {
                    this.openSkipDialog();
                } else {
                    Utils.openBrowser((Context)this.mActivity, this.mVideoUrl);
                }
            }
        } else if (n == R.id.volume_button) {
            this.setMute();
        } else if (n == R.id.pip_button && this.isSupportPip()) {
            if (this.enabledPictureInPicture()) {
                CustomVideoUIController customVideoUIController = this;
                customVideoUIController.mListener.enablePictureInPicture();
                customVideoUIController.mPipButton.setVisibility(8);
            } else {
                Intent intent;
                object = intent;
                intent = new Intent("android.settings.PICTURE_IN_PICTURE_SETTINGS", Uri.parse((String)("package" + Utils.getAppId(this.mActivity.getApplicationContext()))));
                this.mActivity.startActivity((Intent)object);
            }
        }
    }

    public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
        if (compoundButton.getId() == R.id.yt_auto_skip) {
            CustomVideoUIController customVideoUIController = this;
            customVideoUIController.mAutoSkipToggle.setChecked(bl);
            customVideoUIController.mPref.putBooleanValue(YT_IS_AUTO_SKIP, bl);
        }
    }

    public void initYtVideoInfo(EmbedGigsResponse embedGigsResponse) {
        Activity activity = this.mActivity;
        if (activity instanceof EmbedDoubleVideoActivity) {
            ((EmbedDoubleVideoActivity)activity).updateCurrentPlayingGid(this.mIdVideoPlaying);
        }
        this.initializeYtVideoInfo(embedGigsResponse);
    }

    public void initializeYtVideoInfo(EmbedGigsResponse embedGigsResponse) {
        if (!this.mPlayerIsPlaying) {
            CustomVideoUIController customVideoUIController = this;
            customVideoUIController.youTubePlayerCallback.pause();
            customVideoUIController.mPlayerView.refreshPlayer();
            customVideoUIController.mPanel.setBackgroundColor(ResourcesUtil.getColor(R.color.black));
            customVideoUIController.initUI();
            if (embedGigsResponse.success && embedGigsResponse.video_info != null) {
                CustomVideoUIController customVideoUIController2 = this;
                this.mCurrentSeconds = 0.0f;
                customVideoUIController2.mResponse = embedGigsResponse;
                Object object = customVideoUIController2.mPanel;
                boolean bl = !customVideoUIController2.mIsPolice && !embedGigsResponse.enable_touch;
                CustomVideoUIController customVideoUIController3 = this;
                object.setClickable(bl);
                object = customVideoUIController3.mPanel;
                bl = !customVideoUIController3.mIsPolice && !embedGigsResponse.enable_touch;
                CustomVideoUIController customVideoUIController4 = this;
                CustomVideoUIController customVideoUIController5 = this;
                CustomVideoUIController customVideoUIController6 = this;
                CustomVideoUIController customVideoUIController7 = this;
                object.setFocusable(bl);
                customVideoUIController7.mCountDownRunnable = null;
                customVideoUIController7.mFirstOnReady = true;
                customVideoUIController7.mIsVideoStart = true;
                customVideoUIController7.mNextYtInfo = null;
                customVideoUIController7.mIsVideoError = false;
                object = embedGigsResponse.video_info;
                customVideoUIController6.mMinWatchTime = ((EmbedVideoInfo)object).min_watch_time;
                customVideoUIController6.mVideoUrl = ((EmbedVideoInfo)object).ourl;
                customVideoUIController5.mVideoType = embedGigsResponse.video_type;
                customVideoUIController5.mVideoUniqueId = ((EmbedVideoInfo)object).id;
                this.mIdVideoPlaying = embedGigsResponse.gid;
                customVideoUIController4.mTimestamp = embedGigsResponse.ts;
                customVideoUIController4.mErrorReportMaxTime = ((EmbedVideoInfo)object).max_error_time;
                object = embedGigsResponse.video_html;
                boolean bl2 = object != null && !((String)object).isEmpty();
                CustomVideoUIController customVideoUIController8 = this;
                customVideoUIController8.mIsVideoHtmlExist = bl2;
                customVideoUIController8.mSkipRevealView.setVisibility(8);
                customVideoUIController8.mTotalCoinEarned = 0.0;
                customVideoUIController8.mTotalTimeWatched = 0;
                customVideoUIController8.redrawsCountdownBar();
                customVideoUIController8.mSkipProgress.setProgress(0.0f);
                customVideoUIController8.mSkipProgress.setMax((float)embedGigsResponse.video_info.min_watch_time);
                customVideoUIController8.mSkipProgress.setProgressColor(ResourcesUtil.getColor(R.color.primary));
                String string2 = embedGigsResponse.video_html;
                if (string2 != null && !string2.isEmpty()) {
                    this.mPlayerView.initPlayer(embedGigsResponse.video_info.url, embedGigsResponse.video_html);
                } else {
                    string2 = this.mActivity;
                    if (string2 instanceof EmbedDoubleVideoActivity) {
                        ((EmbedDoubleVideoActivity)((Object)string2)).muteAllHtmlEmbedPlayer(this.mPage);
                    }
                    this.mViewDelayRunnable = new ViewDelayRunnable(embedGigsResponse);
                    this.mHandler.postDelayed((Runnable)this.mViewDelayRunnable, (long)this.mDefaultInterval);
                }
            } else {
                this.mListener.videoNotAvailable();
            }
        }
    }

    public void onResume() {
        CountDownRunnable countDownRunnable;
        Handler handler;
        if (!this.mIsYtEnded && !this.mPlayerIsPlaying) {
            this.createErrorReportCountdown();
        }
        if (this.mPlayerIsPlaying && this.youTubePlayerCallback != null) {
            if (this.mVideoType.contains("youtube_live")) {
                this.reload();
            } else {
                this.youTubePlayerCallback.play();
            }
        }
        if (!this.mIsVideoHtmlExist && this.mIsOnPause && (handler = this.mHandler) != null && (countDownRunnable = this.mCountDownRunnable) != null) {
            handler.postDelayed((Runnable)countDownRunnable, 1000L);
        }
        this.mIsOnPause = false;
        handler = this.mStopButton;
        if (handler != null) {
            handler.setOnClickListener((View.OnClickListener)this);
        }
        CustomVideoUIController customVideoUIController = this;
        customVideoUIController.mSkipContainer.setOnRippleCompleteListener(new RippleView.a(){

            @Override
            public void onComplete(RippleView rippleView) {
                if (CustomVideoUIController.this.mSkipButton != null) {
                    CustomVideoUIController customVideoUIController = CustomVideoUIController.this;
                    customVideoUIController.onClick((View)customVideoUIController.mSkipButton);
                }
            }
        });
        customVideoUIController.mOpenContainer.setOnRippleCompleteListener(new RippleView.a(){

            @Override
            public void onComplete(RippleView rippleView) {
                if (CustomVideoUIController.this.mOpenButton != null) {
                    CustomVideoUIController customVideoUIController = CustomVideoUIController.this;
                    customVideoUIController.onClick((View)customVideoUIController.mOpenButton);
                }
            }
        });
        customVideoUIController.mVolumeContainer.setOnRippleCompleteListener(new RippleView.a(){

            @Override
            public void onComplete(RippleView rippleView) {
                if (CustomVideoUIController.this.mVolume != null) {
                    CustomVideoUIController customVideoUIController = CustomVideoUIController.this;
                    customVideoUIController.onClick((View)customVideoUIController.mVolume);
                }
            }
        });
        customVideoUIController.mPipContainer.setOnRippleCompleteListener(new RippleView.a(){

            @Override
            public void onComplete(RippleView rippleView) {
                if (CustomVideoUIController.this.mPipButton != null) {
                    CustomVideoUIController customVideoUIController = CustomVideoUIController.this;
                    customVideoUIController.onClick((View)customVideoUIController.mPipButton);
                }
            }
        });
    }

    public void onPause() {
        Object object = this.mActivity;
        if (!(object == null || Build.VERSION.SDK_INT > 24 && object.isInPictureInPictureMode())) {
            object = this.mStopButton;
            if (object != null) {
                object.setOnClickListener(null);
            }
            if ((object = this.youTubePlayerCallback) != null) {
                object.pause();
            }
            CustomVideoUIController customVideoUIController = this;
            customVideoUIController.stopErrorReportCountDown();
            customVideoUIController.mSkipContainer.setOnRippleCompleteListener(null);
            customVideoUIController.mOpenContainer.setOnRippleCompleteListener(null);
            customVideoUIController.mVolumeContainer.setOnRippleCompleteListener(null);
            customVideoUIController.mPipContainer.setOnRippleCompleteListener(null);
        }
    }

    public void onDestroy() {
        CustomVideoUIController customVideoUIController = this;
        customVideoUIController.removeRunnableHandler();
        customVideoUIController.mAutoSkipToggle.setOnCheckedChangeListener(null);
    }

    public void verifiedYtVideo(EmbedGigsResponse embedGigsResponse) {
        EmbedGigsResponse embedGigsResponse2 = this.mResponse;
        if (embedGigsResponse2 != null) {
            this.mTotalCoinEarned += embedGigsResponse2.coins_converted;
        }
        CustomVideoUIController customVideoUIController = this;
        customVideoUIController.mNextYtInfo = embedGigsResponse;
        customVideoUIController.initSkipAd();
        if (!customVideoUIController.mIsVideoError && (embedGigsResponse2 = this.mResponse) != null && embedGigsResponse2.continuous && embedGigsResponse != null && embedGigsResponse.success && embedGigsResponse.video_info == null) {
            CustomVideoUIController customVideoUIController2 = this;
            customVideoUIController2.measureSkipContainerWidth();
            customVideoUIController2.mFirstTime = true;
            customVideoUIController2.mCurrentSeconds = 0.0f;
            customVideoUIController2.mSkipRevealView.setVisibility(8);
            customVideoUIController2.mSkipLoading.setVisibility(0);
            customVideoUIController2.mSkipProgress.setProgress(0.0f);
            customVideoUIController2.mIsInitialize = true;
            customVideoUIController2.mCountDownRunnable = null;
            customVideoUIController2.onStateChange(PlayerConstants.PlayerState.PLAYING);
        } else if (embedGigsResponse != null && this.mResponse != null && (this.mPref.getBooleanValue(YT_IS_AUTO_SKIP, false) || this.mIsYtEnded)) {
            this.mPlayerIsPlaying = false;
            this.initYtVideoInfo(embedGigsResponse);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setMute(boolean bl) {
        CustomVideoUIController customVideoUIController = this;
        customVideoUIController.mIsMute = bl;
        customVideoUIController.youTubePlayerCallback.setMute(bl);
        ImageButton imageButton = customVideoUIController.mVolume;
        if (imageButton != null && this.mActivity instanceof EmbedDoubleVideoActivity) {
            void var1_4;
            imageButton.setVisibility(0);
            if (bl) {
                int n = R.drawable.volume_mute;
            } else {
                int n = R.drawable.volume_up;
            }
            this.mVolume.setImageDrawable(ResourcesUtil.getDrawable((int)var1_4));
        }
    }

    public String getPlayingVideoId() {
        return this.mIdVideoPlaying;
    }

    public void reload() {
        CustomVideoUIController customVideoUIController = this;
        customVideoUIController.refreshUI();
        float f = customVideoUIController.mCurrentSeconds;
        int n = customVideoUIController.mTotalTimeWatched;
        EmbedGigsResponse embedGigsResponse = customVideoUIController.mNextYtInfo;
        CustomVideoUIController customVideoUIController2 = this;
        customVideoUIController2.mPlayerIsPlaying = false;
        customVideoUIController2.mDefaultInterval = 0;
        customVideoUIController2.initializeYtVideoInfo(customVideoUIController2.mResponse);
        this.mTotalTimeWatched = n;
        this.mCurrentSeconds = f;
        this.mTotalCoinEarned = this.mTotalCoinEarned;
        customVideoUIController.mNextYtInfo = embedGigsResponse;
    }

    public void setVolumeControl(boolean n) {
        CustomVideoUIController customVideoUIController = object;
        customVideoUIController.mVolumeContainer.setEnabled(n != 0);
        Object object = customVideoUIController.mVolumeContainer;
        n = n != 0 ? 0 : 8;
        object.setVisibility(n);
    }

    class CountDownRunnable
    implements Runnable {
        CountDownRunnable() {
        }

        @Override
        public void run() {
            if (CustomVideoUIController.this.mIsOnPause) {
                CustomVideoUIController.this.onPause();
                return;
            }
            CountDownRunnable countDownRunnable = this;
            countDownRunnable.CustomVideoUIController.this.mHandler.removeCallbacksAndMessages(null);
            if (countDownRunnable.CustomVideoUIController.this.mMinWatchTime > 0) {
                CustomVideoUIController.access$1208(CustomVideoUIController.this);
            }
            if (CustomVideoUIController.this.mSkipProgress != null) {
                float[] fArray = new float[2];
                float[] fArray2 = fArray;
                fArray2[0] = CustomVideoUIController.this.mSkipProgress.getProgress();
                fArray[1] = CustomVideoUIController.this.mCurrentSeconds;
                ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)CustomVideoUIController.this.mSkipProgress, (String)"progress", (float[])fArray2);
                objectAnimator.setDuration(3000L);
                objectAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                objectAnimator.start();
            }
            CustomVideoUIController customVideoUIController = CustomVideoUIController.this;
            if (customVideoUIController.onCurrentSecond(Math.round(customVideoUIController.mCurrentSeconds))) {
                CustomVideoUIController.this.mHandler.postDelayed((Runnable)CustomVideoUIController.this.mCountDownRunnable, 1000L);
            } else if (CustomVideoUIController.this.mNextYtInfo != null && ((CustomVideoUIController)CustomVideoUIController.this).mNextYtInfo.video_info != null) {
                CustomVideoUIController.this.initSkipAd();
            }
        }
    }

    class ErrorCountDownRunnable
    implements Runnable {
        ErrorCountDownRunnable() {
        }

        @Override
        public void run() {
            CustomVideoUIController.this.onError(PlayerConstants.PlayerError.UNKNOWN);
        }
    }

    class DelayRunnable
    implements Runnable {
        private String mVideoId;

        DelayRunnable(String string2) {
            this.mVideoId = string2;
        }

        @Override
        public void run() {
            DelayRunnable delayRunnable = this;
            delayRunnable.CustomVideoUIController.this.showUiVideo();
            delayRunnable.CustomVideoUIController.this.createErrorReportCountdown();
            CustomVideoUIController.access$502(delayRunnable.CustomVideoUIController.this, true);
            delayRunnable.CustomVideoUIController.this.mPanel.setBackgroundColor(ContextCompat.getColor((Context)CustomVideoUIController.this.mActivity, (int)17170445));
            float f = delayRunnable.CustomVideoUIController.this.mCurrentSeconds;
            if (delayRunnable.CustomVideoUIController.this.mVideoType.contains("live")) {
                f = 0.0f;
            }
            if (CustomVideoUIController.this.mIsVideoStart) {
                DelayRunnable delayRunnable2 = this;
                delayRunnable2.CustomVideoUIController.this.setInitialMute();
                CustomVideoUIController.access$1402(delayRunnable2.CustomVideoUIController.this, false);
            }
            DelayRunnable delayRunnable3 = this;
            delayRunnable3.CustomVideoUIController.this.youTubePlayerCallback.loadVideo(this.mVideoId, f);
            CustomVideoUIController customVideoUIController = delayRunnable3.CustomVideoUIController.this;
            CustomVideoUIController.access$702(customVideoUIController, customVideoUIController.mDelayInterval);
        }
    }

    class ViewDelayRunnable
    implements Runnable {
        private EmbedGigsResponse response;

        ViewDelayRunnable(EmbedGigsResponse embedGigsResponse) {
            this.response = embedGigsResponse;
        }

        @Override
        public void run() {
            ViewDelayRunnable viewDelayRunnable = embedGigsResponse;
            viewDelayRunnable.CustomVideoUIController.this.showUiVideo();
            CustomVideoUIController.access$502(viewDelayRunnable.CustomVideoUIController.this, true);
            EmbedGigsResponse embedGigsResponse = ((ViewDelayRunnable)((Object)embedGigsResponse)).response;
            viewDelayRunnable.CustomVideoUIController.this.mPlayerView.initPlayer(embedGigsResponse.video_info.url, embedGigsResponse.video_html);
            CustomVideoUIController customVideoUIController = viewDelayRunnable.CustomVideoUIController.this;
            CustomVideoUIController.access$702(customVideoUIController, customVideoUIController.mDelayInterval);
        }
    }

    public static interface Listener {
        public void videoReachEndpoint(String var1, int var2);

        public void videoNotAvailable();

        public void forceStopVideo();

        public void youtubePlayableError(String var1, String var2);

        public void enablePictureInPicture();

        public void skipVideo(String var1);
    }
}

