/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.player;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appzilo.sdk.video.player.IFramePlayerOptions;
import com.appzilo.sdk.video.player.PlayerConstants;
import com.appzilo.sdk.video.player.VideoPlayer;
import com.appzilo.sdk.video.player.VideoPlayerBridge;
import com.appzilo.sdk.video.player.listeners.VideoPlayerInitListener;
import com.appzilo.sdk.video.player.listeners.VideoPlayerListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WebViewVideoPlayer
extends WebView
implements VideoPlayer,
VideoPlayerBridge.YouTubePlayerBridgeCallbacks {
    private AudioManager mAudioManager;
    private VideoPlayerInitListener videoPlayerInitListener;
    @NonNull
    private final Set<VideoPlayerListener> videoPlayerListeners;
    @NonNull
    private final Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    private String baseUrl;
    private String playerHtml;
    protected boolean backgroundPlaybackEnabled = false;
    private String mTag;

    public WebViewVideoPlayer(Context context) {
        this(context, null);
    }

    public WebViewVideoPlayer(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public WebViewVideoPlayer(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.videoPlayerListeners = new HashSet<VideoPlayerListener>();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initWebView(IFramePlayerOptions object) {
        object = this.getSettings();
        if (Build.VERSION.SDK_INT >= 17) {
            object.setMediaPlaybackRequiresUserGesture(false);
        } else {
            object.setPluginState(WebSettings.PluginState.ON);
        }
        WebViewVideoPlayer webViewVideoPlayer = this;
        IFramePlayerOptions iFramePlayerOptions = object;
        iFramePlayerOptions.setJavaScriptEnabled(true);
        iFramePlayerOptions.setDomStorageEnabled(true);
        iFramePlayerOptions.setAppCacheEnabled(true);
        iFramePlayerOptions.setAllowFileAccess(true);
        webViewVideoPlayer.setWebViewClient(new CustomWebViewClient());
        webViewVideoPlayer.addJavascriptInterface(new VideoPlayerBridge(this), "PlayerBridge");
        webViewVideoPlayer.setWebChromeClient(new WebChromeClient(){

            public Bitmap getDefaultVideoPoster() {
                if ((this_ = super.getDefaultVideoPoster()) == null) {
                    9 this_ = Bitmap.Config.RGB_565;
                    return Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)this_);
                }
                return this_;
            }
        });
        object = webViewVideoPlayer.getSettings().getUserAgentString();
        object = Build.VERSION.SDK_INT > 19 ? ((String)object).replace("; wv", "").replaceAll("Chrome\\/(\\d+\\.?)+", "Chrome/70.0.3538.80") : ((String)object).replaceAll("(Version\\/\\S+)", "");
        WebViewVideoPlayer webViewVideoPlayer2 = this;
        webViewVideoPlayer2.getSettings().setUserAgentString((String)object);
        object = webViewVideoPlayer2.playerHtml;
        if (object != null && !((String)object).isEmpty()) {
            WebViewVideoPlayer webViewVideoPlayer3 = this;
            webViewVideoPlayer3.loadDataWithBaseURL(webViewVideoPlayer3.baseUrl, this.playerHtml, "text/html", "utf-8", null);
            return;
        }
        object = this.baseUrl;
        if (object != null) {
            this.loadUrl((String)object, this.getCustomHeaders());
        }
        if ((object = this.videoPlayerInitListener) != null) {
            object.onInitSuccess(this);
        }
    }

    private Map<String, String> getCustomHeaders() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("X-Requested-With", "com.android.browser");
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readYouTubePlayerHTMLFromFile() {
        int n = 0;
        try {
            StringBuilder stringBuilder;
            BufferedReader bufferedReader;
            InputStreamReader inputStreamReader;
            InputStream inputStream = this.getResources().openRawResource(n);
            Object object = inputStreamReader;
            inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader2 = bufferedReader;
            bufferedReader = new BufferedReader((Reader)object);
            object = stringBuilder;
            stringBuilder = new StringBuilder();
            while (true) {
                String string2;
                if ((string2 = bufferedReader2.readLine()) == null) {
                    inputStream.close();
                    return ((StringBuilder)object).toString();
                }
                ((StringBuilder)object).append(string2).append("\n");
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Can't parse HTML file containing the player.");
        }
    }

    static /* synthetic */ String access$102(WebViewVideoPlayer webViewVideoPlayer, String string2) {
        webViewVideoPlayer.playerHtml = string2;
        return string2;
    }

    static /* synthetic */ String access$302(WebViewVideoPlayer webViewVideoPlayer, String string2) {
        webViewVideoPlayer.baseUrl = string2;
        return string2;
    }

    public void initialize(@NonNull VideoPlayerInitListener videoPlayerInitListener, @Nullable IFramePlayerOptions iFramePlayerOptions) {
        this.videoPlayerInitListener = videoPlayerInitListener;
        if (iFramePlayerOptions == null) {
            iFramePlayerOptions = IFramePlayerOptions.getDefault();
        }
        this.initWebView(iFramePlayerOptions);
    }

    public void setTag(String string2) {
        this.mTag = string2;
    }

    @Override
    public void onYouTubeIframeAPIReady() {
        VideoPlayerInitListener videoPlayerInitListener = this.videoPlayerInitListener;
        if (videoPlayerInitListener != null) {
            videoPlayerInitListener.onInitSuccess(this);
        }
    }

    @Override
    public void loadVideo(final @NonNull String string2, final float f) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:loadVideo('" + string2 + "', " + f + ")");
            }
        });
    }

    @Override
    public void loadChannel(final @NonNull String string2) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:setChannel('" + string2 + "')");
            }
        });
    }

    @Override
    public void cueVideo(final @NonNull String string2, final float f) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:cueVideo('" + string2 + "', " + f + ")");
            }
        });
    }

    @Override
    public void play() {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:playVideo()");
            }
        });
    }

    @Override
    public void pause() {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:pauseVideo()");
            }
        });
    }

    @Override
    public void setVolume(final int n) {
        if (n >= 0 && n <= 100) {
            this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    WebViewVideoPlayer.this.loadUrl("javascript:setVolume(" + n + ")");
                }
            });
            return;
        }
        throw new IllegalArgumentException("Volume must be between 0 and 100");
    }

    @Override
    public void setMute(final boolean bl) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:setMute(" + bl + ")");
            }
        });
    }

    @Override
    public void seekTo(final float f) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:seekTo(" + f + ")");
            }
        });
    }

    public void destroy() {
        WebViewVideoPlayer webViewVideoPlayer = this;
        webViewVideoPlayer.videoPlayerListeners.clear();
        webViewVideoPlayer.mainThreadHandler.removeCallbacksAndMessages(null);
        super.destroy();
    }

    @Override
    @NonNull
    public Collection<VideoPlayerListener> getListeners() {
        return Collections.unmodifiableCollection(new HashSet<VideoPlayerListener>(this.videoPlayerListeners));
    }

    @Override
    public boolean addListener(@NonNull VideoPlayerListener videoPlayerListener) {
        if (videoPlayerListener == null) {
            Log.e((String)"YouTubePlayer", (String)"null YouTubePlayerListener not allowed.");
            return false;
        }
        return this.videoPlayerListeners.add(videoPlayerListener);
    }

    @Override
    public boolean removeListener(@NonNull VideoPlayerListener videoPlayerListener) {
        return this.videoPlayerListeners.remove(videoPlayerListener);
    }

    public void initWebView(String string2, String string3) {
        this.playerHtml = string3;
        this.baseUrl = string2;
        this.initWebView(IFramePlayerOptions.getDefault());
    }

    public void refresh() {
        WebViewVideoPlayer webViewVideoPlayer = this;
        webViewVideoPlayer.loadUrl("about:blank");
        webViewVideoPlayer.clearView();
    }

    protected void onWindowVisibilityChanged(int n) {
        if (this.backgroundPlaybackEnabled && (n == 8 || n == 4)) {
            return;
        }
        super.onWindowVisibilityChanged(n);
    }

    public class CustomWebViewClient
    extends WebViewClient {
        boolean isError = false;

        @TargetApi(value=21)
        public boolean shouldOverrideUrlLoading(WebView webView, WebResourceRequest webResourceRequest) {
            webView.loadUrl(webResourceRequest.getUrl().toString(), WebViewVideoPlayer.this.getCustomHeaders());
            return true;
        }

        public boolean shouldOverrideUrlLoading(WebView webView, String string2) {
            webView.loadUrl(string2, WebViewVideoPlayer.this.getCustomHeaders());
            return true;
        }

        public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
            super.onPageStarted(webView, string2, bitmap);
            if (!string2.equals("about:blank") && (WebViewVideoPlayer.this.playerHtml == null || WebViewVideoPlayer.this.playerHtml.isEmpty())) {
                this.isError = false;
            }
        }

        public void onPageFinished(WebView webView, String object) {
            super.onPageFinished(webView, (String)object);
            if (!(((String)object).equals("about:blank") || WebViewVideoPlayer.this.playerHtml != null && !WebViewVideoPlayer.this.playerHtml.isEmpty() || this.isError)) {
                if (webView.getProgress() == 100) {
                    object = WebViewVideoPlayer.this.videoPlayerListeners.iterator();
                    while (object.hasNext()) {
                        ((VideoPlayerListener)object.next()).onStateChange(PlayerConstants.PlayerState.PLAYING);
                    }
                }
                if (webView.getProgress() == 100) {
                    CustomWebViewClient customWebViewClient = this;
                    WebViewVideoPlayer.access$102(customWebViewClient.WebViewVideoPlayer.this, null);
                    WebViewVideoPlayer.access$302(customWebViewClient.WebViewVideoPlayer.this, null);
                }
            }
        }
    }
}

