/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Handler;
import android.view.ContextThemeWrapper;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleObserver;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.appzilo.sdk.video.CustomVideoUIController;
import com.appzilo.sdk.video.R;
import com.appzilo.sdk.video.backend.GigsApi;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.EmbedGigsResponse;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.BackgroundWorker;
import com.appzilo.sdk.video.core.Error;
import com.appzilo.sdk.video.core.Result;
import com.appzilo.sdk.video.player.VideoPlayer;
import com.appzilo.sdk.video.player.VideoPlayerView;
import com.appzilo.sdk.video.player.listeners.VideoPlayerInitListener;
import com.appzilo.sdk.video.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class EmbedVideoActivity
extends AppCompatActivity
implements VideoPlayerInitListener,
CustomVideoUIController.Listener,
BackgroundWorker.Callbacks {
    private static final String TASK_GET_YT = "youtube_task_init";
    private static final String TASK_VERIFY_YT = "youtube_task_verify";
    private static final String TASK_GET_POLICE = "youtube_task_get_police";
    private static final String TASK_REPORT_YOUTUBE = "youtube_task_report";
    private static final String OBJ_GIGS_BACKEND = "gigs_backend.youtube";
    private static final String TASK_REQUEST_NOTICE = "task_request_notice";
    private static final String OBJ_NOTICE_API = "obj_notice_api";
    private static final String QUERY_PARAMS = "query_params";
    public static boolean sIsOpened = false;
    private View mCustomPlayerUI;
    private BackgroundWorker mWorker;
    private GigsApi mGigsApi;
    private CustomVideoUIController mCustomPlayerUIController;
    private AlertDialog mNoVideoDialog;
    private ArrayList<EmbedGigsResponse> mPoliceVideoResponse;
    private boolean mIsPolice;
    private VideoPlayerView mYouTubePlayerView;
    private NoticeResponse mNoticeResponse;
    private EmbedGigsResponse mVideoGigsResponse;
    private boolean mBackStackLost = false;
    private String mGigsUrl;
    private boolean mIsInPictureMode;
    private boolean mPiPClosed;
    private String mQuery;
    private Bundle mQueryBundle;
    private NoticeApi mNoticeApi;

    static /* synthetic */ boolean access$102(EmbedVideoActivity embedVideoActivity, boolean bl) {
        embedVideoActivity.mBackStackLost = bl;
        return bl;
    }

    static /* synthetic */ boolean access$202(EmbedVideoActivity embedVideoActivity, boolean bl) {
        embedVideoActivity.mIsInPictureMode = bl;
        return bl;
    }

    protected void onCreate(@Nullable Bundle object) {
        EmbedVideoActivity embedVideoActivity = this;
        super.onCreate((Bundle)object);
        embedVideoActivity.setRequestedOrientation(0);
        embedVideoActivity.setContentView(R.layout.activity_embed_video);
        embedVideoActivity.mYouTubePlayerView = (VideoPlayerView)embedVideoActivity.findViewById(R.id.player);
        embedVideoActivity.getLifecycle().addObserver((LifecycleObserver)this.mYouTubePlayerView);
        embedVideoActivity.mCustomPlayerUI = embedVideoActivity.mYouTubePlayerView.inflateCustomPlayerUI(R.layout.custom_video_ui);
        embedVideoActivity.mWorker = new BackgroundWorker((FragmentActivity)this);
        embedVideoActivity.mGigsApi = (GigsApi)embedVideoActivity.mWorker.get(OBJ_GIGS_BACKEND);
        if (embedVideoActivity.mGigsApi == null) {
            this.mGigsApi = new GigsApi((Context)this);
            this.mWorker.put(OBJ_GIGS_BACKEND, this.mGigsApi);
        }
        EmbedVideoActivity embedVideoActivity2 = this;
        embedVideoActivity2.mNoticeResponse = NoticeApi.getNoticeResponse(embedVideoActivity2.getApplicationContext());
        if (embedVideoActivity2.mNoticeApi == null) {
            this.mNoticeApi = new NoticeApi(this.getApplicationContext());
            this.mWorker.put(OBJ_NOTICE_API, this.mNoticeApi);
        }
        EmbedVideoActivity embedVideoActivity3 = this;
        embedVideoActivity3.mQuery = embedVideoActivity3.getIntent().getStringExtra("video_params");
        object = embedVideoActivity3.mQuery;
        if (object != null && !((String)object).isEmpty()) {
            EmbedVideoActivity embedVideoActivity4 = this;
            embedVideoActivity4.mQueryBundle = new Bundle();
            embedVideoActivity4.mQueryBundle.putString(QUERY_PARAMS, this.mQuery);
            embedVideoActivity4.mWorker.executeTask(TASK_REQUEST_NOTICE, this.mQueryBundle, this);
        }
    }

    public void onPictureInPictureModeChanged(final boolean bl, Configuration configuration) {
        super.onPictureInPictureModeChanged(bl, configuration);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (EmbedVideoActivity.this.mCustomPlayerUIController != null) {
                    EmbedVideoActivity.this.mCustomPlayerUIController.setPipMode(bl);
                }
                if (!bl) {
                    EmbedVideoActivity.access$102(EmbedVideoActivity.this, true);
                }
                EmbedVideoActivity.access$202(EmbedVideoActivity.this, bl);
            }
        }, 300L);
    }

    protected void onResume() {
        EmbedVideoActivity embedVideoActivity = customVideoUIController;
        super.onResume();
        if (embedVideoActivity.mPiPClosed) {
            customVideoUIController.recreate();
            ((EmbedVideoActivity)((Object)customVideoUIController)).mPiPClosed = false;
            return;
        }
        CustomVideoUIController customVideoUIController = ((EmbedVideoActivity)((Object)customVideoUIController)).mCustomPlayerUIController;
        if (customVideoUIController != null) {
            customVideoUIController.onResume();
        }
        sIsOpened = true;
    }

    protected void onPause() {
        EmbedVideoActivity embedVideoActivity = customVideoUIController;
        super.onPause();
        CustomVideoUIController customVideoUIController = embedVideoActivity.mCustomPlayerUIController;
        if (customVideoUIController != null) {
            customVideoUIController.onPause();
        }
    }

    protected void onStop() {
        EmbedVideoActivity embedVideoActivity = this;
        super.onStop();
        sIsOpened = false;
        if (embedVideoActivity.mIsInPictureMode) {
            EmbedVideoActivity embedVideoActivity2 = this;
            embedVideoActivity2.finish();
            embedVideoActivity2.overridePendingTransition(0, 0);
            embedVideoActivity2.mPiPClosed = true;
        }
    }

    protected void onDestroy() {
        EmbedVideoActivity embedVideoActivity = customVideoUIController;
        super.onDestroy();
        CustomVideoUIController customVideoUIController = embedVideoActivity.mCustomPlayerUIController;
        if (customVideoUIController != null) {
            customVideoUIController.onDestroy();
        }
    }

    public void finish() {
        EmbedVideoActivity embedVideoActivity = this;
        super.finish();
        embedVideoActivity.overridePendingTransition(0, 0);
        embedVideoActivity.setRequestedOrientation(1);
    }

    @Override
    public void onInitSuccess(@NonNull VideoPlayer videoPlayer) {
        if (this.mCustomPlayerUIController == null) {
            CustomVideoUIController customVideoUIController;
            EmbedVideoActivity embedVideoActivity = this;
            View view = embedVideoActivity.mCustomPlayerUI;
            VideoPlayerView videoPlayerView = embedVideoActivity.mYouTubePlayerView;
            NoticeResponse noticeResponse = embedVideoActivity.mNoticeResponse;
            int n = noticeResponse != null ? noticeResponse.passive_video_interval * 1000 : 0;
            CustomVideoUIController customVideoUIController2 = customVideoUIController;
            EmbedVideoActivity embedVideoActivity2 = this;
            customVideoUIController2((Activity)embedVideoActivity2, embedVideoActivity2, view, videoPlayer, videoPlayerView, n, this.mIsPolice);
            this.mCustomPlayerUIController = customVideoUIController2;
            videoPlayer.addListener(this.mCustomPlayerUIController);
        }
    }

    @Override
    public Result executeTaskInBackground(String object, Bundle bundle) {
        if (bundle == null) {
            Bundle bundle2;
            bundle = bundle2;
            bundle2 = new Bundle();
        }
        bundle.putBoolean("is_featured", this.getIntent().getBooleanExtra("is_featured", false));
        bundle.putInt("video_category", this.getIntent().getIntExtra("video_category", 0));
        int n = -1;
        switch (((String)object).hashCode()) {
            default: {
                break;
            }
            case 2133978455: {
                if (!((String)object).equals(TASK_VERIFY_YT)) break;
                n = 1;
                break;
            }
            case 2019408402: {
                if (!((String)object).equals(TASK_REPORT_YOUTUBE)) break;
                n = 3;
                break;
            }
            case 449466498: {
                if (!((String)object).equals(TASK_REQUEST_NOTICE)) break;
                n = 5;
                break;
            }
            case 241830917: {
                if (!((String)object).equals(TASK_GET_POLICE)) break;
                n = 2;
                break;
            }
            case -345689196: {
                if (!((String)object).equals("GigsBackend.skipVideo")) break;
                n = 4;
                break;
            }
            case -1133352594: {
                if (!((String)object).equals(TASK_GET_YT)) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return null;
            }
            case 5: {
                object = bundle.getString(QUERY_PARAMS);
                if (object != null && ((HashMap)(object = Utils.queryToHashMap((String)object))).containsKey("app_key") && !((String)((HashMap)object).get("app_key")).isEmpty() && ((HashMap)object).containsKey("sub_pubid") && !((String)((HashMap)object).get("sub_pubid")).isEmpty()) {
                    return this.mNoticeApi.request((HashMap<String, String>)object);
                }
                return new Result(Error.EMPTY);
            }
            case 4: {
                return this.mGigsApi.skipVideo(bundle);
            }
            case 3: {
                return this.mGigsApi.reportYoutube(bundle);
            }
            case 2: {
                return this.mGigsApi.getPoliceVideo();
            }
            case 1: {
                return this.mGigsApi.verifyWatchedYtVideo(bundle);
            }
            case 0: 
        }
        return this.mGigsApi.getYtVideo(bundle);
    }

    @Override
    public void onBackgroundTaskCompleted(String object, Result result) {
        int n = -1;
        switch (object.hashCode()) {
            default: {
                break;
            }
            case 2133978455: {
                if (!object.equals(TASK_VERIFY_YT)) break;
                n = 2;
                break;
            }
            case 2019408402: {
                if (!object.equals(TASK_REPORT_YOUTUBE)) break;
                n = 3;
                break;
            }
            case 449466498: {
                if (!object.equals(TASK_REQUEST_NOTICE)) break;
                n = 0;
                break;
            }
            case 241830917: {
                if (!object.equals(TASK_GET_POLICE)) break;
                n = 5;
                break;
            }
            case -345689196: {
                if (!object.equals("GigsBackend.skipVideo")) break;
                n = 4;
                break;
            }
            case -1133352594: {
                if (!object.equals(TASK_GET_YT)) break;
                n = 1;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                if (!result.isSuccess()) break;
                object = (EmbedGigsResponse[])result.getResult();
                if (((EmbedGigsResponse[])object).length > 0) {
                    EmbedVideoActivity embedVideoActivity = embedVideoActivity2;
                    embedVideoActivity.mPoliceVideoResponse = new ArrayList<EmbedGigsResponse>(Arrays.asList(object));
                    ArrayList<EmbedGigsResponse> arrayList = embedVideoActivity2.mPoliceVideoResponse;
                    embedVideoActivity.mCustomPlayerUIController.initializeYtVideoInfo(arrayList.get(arrayList.size() - 1));
                    ArrayList<EmbedGigsResponse> arrayList2 = embedVideoActivity.mPoliceVideoResponse;
                    arrayList2.remove(arrayList2.size() - 1);
                }
                return;
            }
            case 2: 
            case 3: 
            case 4: {
                Intent intent;
                if (!result.isSuccess()) break;
                EmbedVideoActivity embedVideoActivity = embedVideoActivity2;
                embedVideoActivity.mVideoGigsResponse = (EmbedGigsResponse)result.getResult();
                embedVideoActivity.mCustomPlayerUIController.verifiedYtVideo(embedVideoActivity2.mVideoGigsResponse);
                EmbedVideoActivity embedVideoActivity2 = intent;
                intent = new Intent("gigs_force_refresh_receiver");
                LocalBroadcastManager.getInstance((Context)embedVideoActivity).sendBroadcast((Intent)embedVideoActivity2);
                return;
            }
            case 1: {
                if (!result.isSuccess()) break;
                embedVideoActivity2.mVideoGigsResponse = (EmbedGigsResponse)result.getResult();
                embedVideoActivity2.mCustomPlayerUIController.initializeYtVideoInfo(embedVideoActivity2.mVideoGigsResponse);
                return;
            }
            case 0: {
                if (result != null && result.isSuccess()) {
                    NoticeResponse noticeResponse;
                    embedVideoActivity2.mNoticeResponse = (NoticeResponse)result.getResult();
                    object = embedVideoActivity2.mNoticeResponse;
                    boolean bl = object != null && object.is_police;
                    EmbedVideoActivity embedVideoActivity = embedVideoActivity2;
                    embedVideoActivity.mIsPolice = bl;
                    embedVideoActivity.mYouTubePlayerView.initialize(embedVideoActivity2, true);
                    if (!embedVideoActivity.mIsPolice && (noticeResponse = embedVideoActivity2.mNoticeResponse) != null && noticeResponse.credential.success) {
                        embedVideoActivity2.mWorker.executeTask(TASK_GET_YT, null, embedVideoActivity2);
                        return;
                    }
                }
                embedVideoActivity2.videoNotAvailable();
            }
        }
        embedVideoActivity2.videoNotAvailable();
    }

    @Override
    public void videoReachEndpoint(String string2, int n) {
        if (!this.mIsPolice) {
            Bundle bundle;
            Bundle bundle2 = bundle;
            new Bundle().putString("tid", string2);
            bundle2.putInt("ts", n);
            this.mWorker.executeTask(TASK_VERIFY_YT, bundle2, this);
        } else if (this.mPoliceVideoResponse.size() > 0) {
            EmbedVideoActivity embedVideoActivity = this;
            ArrayList<EmbedGigsResponse> arrayList = this.mPoliceVideoResponse;
            embedVideoActivity.mCustomPlayerUIController.verifiedYtVideo(arrayList.get(arrayList.size() - 1));
            ArrayList<EmbedGigsResponse> arrayList2 = embedVideoActivity.mPoliceVideoResponse;
            arrayList2.remove(arrayList2.size() - 1);
        } else {
            this.videoNotAvailable();
        }
    }

    @Override
    public void videoNotAvailable() {
        Object object;
        if (!(this.isFinishing() || (object = this.mNoVideoDialog) != null && (object.isShowing() || this.isFinishing()))) {
            DialogInterface.OnClickListener onClickListener;
            object = onClickListener;
            onClickListener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    EmbedVideoActivity.this.finish();
                }
            };
            this.mNoVideoDialog = new AlertDialog.Builder((Context)new ContextThemeWrapper((Context)this, R.style.AlertDialog)).setCancelable(false).setMessage(R.string.no_video_retry).setPositiveButton(17039370, (DialogInterface.OnClickListener)object).show();
        }
    }

    @Override
    public void forceStopVideo() {
        if (!this.isFinishing()) {
            this.finish();
        }
    }

    @Override
    public void youtubePlayableError(String string2, String string3) {
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putString("tid", string2);
        bundle2.putString("sid", string3);
        this.mWorker.executeTask(TASK_REPORT_YOUTUBE, bundle2, this);
    }

    @Override
    @TargetApi(value=24)
    public void enablePictureInPicture() {
        this.enterPictureInPictureMode();
    }

    @Override
    public void skipVideo(String string2) {
        NoticeResponse noticeResponse = this.mNoticeResponse;
        if (noticeResponse != null && !noticeResponse.is_police) {
            Bundle bundle;
            noticeResponse = bundle;
            new Bundle().putString("tid", string2);
            this.mWorker.executeTask("GigsBackend.skipVideo", (Bundle)noticeResponse, this);
        } else {
            this.videoNotAvailable();
        }
    }
}

