/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.appzilo.sdk.video.R;
import com.appzilo.sdk.video.backend.GigsApi;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.EmbedGigsResponse;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.App;
import com.appzilo.sdk.video.core.BackgroundWorker;
import com.appzilo.sdk.video.core.Result;
import com.appzilo.sdk.video.utils.SharedPreferencesUtil;
import java.util.HashMap;
import java.util.Map;

public class WebviewFragment
extends Fragment
implements SwipeRefreshLayout.OnRefreshListener,
BackgroundWorker.Callbacks {
    public static final String URL = "url";
    private static final String OBJ_GIGS_BACKEND = "gigs_backend.video";
    private static final String TASK_REQUEST_URL = "task_request_url";
    private WebView mWebView;
    private String mUrl;
    private Toolbar mToolbar;
    private View mView;
    private boolean hideActionBar;
    private SwipeRefreshLayout mRefresh;
    private Handler mainThreadHandler;
    private SharedPreferencesUtil mPref;
    private BackgroundWorker mWorker;
    private GigsApi mGigsBackend;

    public static WebviewFragment newInstance(Bundle bundle) {
        WebviewFragment webviewFragment = new WebviewFragment();
        if (bundle == null) {
            bundle = new Bundle();
        }
        webviewFragment.setArguments(bundle);
        return webviewFragment;
    }

    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        Bundle bundle2 = this.getArguments();
        if (bundle2 != null) {
            this.mUrl = bundle2.getString(URL);
        }
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
        if (this.getActivity() != null) {
            this.mPref = new SharedPreferencesUtil((Context)this.getActivity());
            this.mWorker = new BackgroundWorker(this.getActivity());
            this.mGigsBackend = (GigsApi)this.mWorker.get(OBJ_GIGS_BACKEND);
            if (this.mGigsBackend == null) {
                this.mGigsBackend = new GigsApi(this.getContext());
                this.mWorker.put(OBJ_GIGS_BACKEND, this.mGigsBackend);
            }
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        this.mView = layoutInflater.inflate(R.layout.fragment_webview, viewGroup, false);
        this.mRefresh = (SwipeRefreshLayout)this.mView.findViewById(R.id.swipeContainer);
        this.mRefresh.setEnabled(false);
        this.mRefresh.setColorSchemeResources(new int[]{R.color.primary});
        this.mWebView = (WebView)this.mView.findViewById(R.id.web);
        return this.mView;
    }

    public void onViewCreated(View view, @Nullable Bundle bundle) {
        super.onViewCreated(view, bundle);
        WebSettings webSettings = this.mWebView.getSettings();
        if (Build.VERSION.SDK_INT >= 17) {
            webSettings.setMediaPlaybackRequiresUserGesture(false);
        } else {
            webSettings.setPluginState(WebSettings.PluginState.ON);
        }
        webSettings.setJavaScriptEnabled(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setAllowFileAccess(true);
        String string2 = this.mPref.getStringValue("moo_dbm", null);
        if (string2 != null && !string2.isEmpty()) {
            String string3 = this.mPref.getStringValue("dbm", null);
            this.mUrl = this.mUrl + "&dbm=" + string3 + "&dbm_key=" + string2;
        }
        this.mWorker.executeTask(TASK_REQUEST_URL, null, this);
        this.mWebView.addJavascriptInterface((Object)new OtherWebViewJavascriptInterface(), "PlayerBridge");
        this.mWebView.setWebViewClient((WebViewClient)new OtherWebViewClient());
        this.mWebView.setWebChromeClient(new WebChromeClient());
    }

    public void onResume() {
        super.onResume();
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebviewFragment.this.mWebView.loadUrl("javascript:playVideo()");
            }
        });
    }

    public void onPause() {
        super.onPause();
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebviewFragment.this.mWebView.loadUrl("javascript:pauseVideo()");
            }
        });
    }

    public void onDestroy() {
        this.mainThreadHandler.removeCallbacksAndMessages(null);
        super.onDestroy();
    }

    public void onRefresh() {
        this.mWebView.reload();
    }

    @Override
    public Result executeTaskInBackground(String string2, Bundle bundle) {
        if (TASK_REQUEST_URL.equals(string2)) {
            return this.mGigsBackend.loadUrl(this.mUrl);
        }
        return null;
    }

    @Override
    public void onBackgroundTaskCompleted(String string2, Result result) {
        if (TASK_REQUEST_URL.equals(string2) && result.isSuccess()) {
            String string3 = (String)result.getResult();
            EmbedGigsResponse embedGigsResponse = (EmbedGigsResponse)App.gson().fromJson(string3, EmbedGigsResponse.class);
            this.mWebView.loadDataWithBaseURL(embedGigsResponse.video_info.url, embedGigsResponse.video_html, "text/html", "utf-8", null);
        }
    }

    private Map<String, String> getCustomHeaders() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("X-Requested-With", "com.android.browser");
        NoticeResponse noticeResponse = NoticeApi.getNoticeResponse(this.getContext());
        if (noticeResponse != null && noticeResponse.credential != null && noticeResponse.credential.app_key != null) {
            hashMap.put("App-Key", noticeResponse.credential.app_key);
        }
        return hashMap;
    }

    public class OtherWebViewJavascriptInterface {
        @JavascriptInterface
        public void onFinish() {
            if (WebviewFragment.this.getActivity() != null) {
                WebviewFragment.this.getActivity().finish();
            }
        }
    }

    private class OtherWebViewClient
    extends WebViewClient {
        private OtherWebViewClient() {
        }

        @TargetApi(value=21)
        public boolean shouldOverrideUrlLoading(WebView webView, WebResourceRequest webResourceRequest) {
            webView.loadUrl(webResourceRequest.getUrl().toString(), WebviewFragment.this.getCustomHeaders());
            return true;
        }

        public boolean shouldOverrideUrlLoading(WebView webView, String string2) {
            webView.loadUrl(string2, WebviewFragment.this.getCustomHeaders());
            return true;
        }

        public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
            super.onPageStarted(webView, string2, bitmap);
            WebviewFragment.this.mRefresh.setRefreshing(true);
        }

        public void onPageFinished(WebView webView, String string2) {
            super.onPageFinished(webView, string2);
            WebviewFragment.this.mRefresh.setRefreshing(false);
            webView.setVisibility(0);
        }
    }
}

