/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video;

import android.arch.lifecycle.LifecycleObserver;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.view.ContextThemeWrapper;
import android.widget.LinearLayout;
import com.appzilo.sdk.video.EmbedVideoFragment;
import com.appzilo.sdk.video.R;
import com.appzilo.sdk.video.WebviewFragment;
import com.appzilo.sdk.video.backend.GigsApi;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.EmbedGigsResponse;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.App;
import com.appzilo.sdk.video.core.BackgroundWorker;
import com.appzilo.sdk.video.core.Error;
import com.appzilo.sdk.video.core.Logger;
import com.appzilo.sdk.video.core.Result;
import com.appzilo.sdk.video.player.VideoPlayerView;
import com.appzilo.sdk.video.utils.NetworkUtil;
import com.appzilo.sdk.video.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;

public class EmbedDoubleVideoActivity
extends AppCompatActivity
implements EmbedVideoFragment.EmbedVideoInterface,
BackgroundWorker.Callbacks {
    private static final String OBJ_NOTICE_API = "obj_notice_api";
    private static final String TASK_GET_VIDEO = "video_task_init";
    private static final String TASK_GET_VIDEO_2 = "video_task_init_2";
    private static final String EMBED_FRAGMENT_TAG = "embed_video_";
    private static final String OBJ_GIGS_BACKEND = "gigs_backend.video";
    private static final String TASK_REQUEST_NOTICE = "task_request_notice";
    private static final String QUERY_PARAMS = "query_params";
    private LinearLayout mRootView;
    private BackgroundWorker mWorker;
    private NoticeResponse mNoticeResponse;
    private NoticeApi mNoticeApi;
    private AlertDialog mNoVideoDialog;
    private GigsApi mGigsBackend;
    private EmbedGigsResponse mVideoGigsResponse;
    private int mUnmuteVideoPlayer;
    private ArrayList<String> mPlayingGidList;
    private boolean mIsReady;
    private boolean mFragmentNotAdded;
    private boolean mViewPlaying = false;
    private final Object mSync = new Object();
    private long mLastClickTime = 0L;
    private String mQuery;
    private Bundle mQueryBundle;
    private boolean mIsPolice;
    int page = 1;
    private boolean mIsSkipClicked;

    protected void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        this.setRequestedOrientation(0);
        this.setContentView(R.layout.activity_embed_video_2);
        this.mRootView = (LinearLayout)this.findViewById(R.id.embed_video_root);
        this.mWorker = new BackgroundWorker((FragmentActivity)this);
        this.mNoticeResponse = NoticeApi.getNoticeResponse(this.getApplicationContext());
        if (this.mNoticeApi == null) {
            this.mNoticeApi = new NoticeApi(this.getApplicationContext());
            this.mWorker.put(OBJ_NOTICE_API, this.mNoticeApi);
        }
        this.mGigsBackend = (GigsApi)this.mWorker.get(OBJ_GIGS_BACKEND);
        if (this.mGigsBackend == null) {
            this.mGigsBackend = new GigsApi((Context)this);
            this.mWorker.put(OBJ_GIGS_BACKEND, this.mGigsBackend);
        }
        this.mPlayingGidList = new ArrayList();
        this.mQuery = this.getIntent().getStringExtra("video_params");
        if (this.mQuery != null && !this.mQuery.isEmpty()) {
            this.mQueryBundle = new Bundle();
            this.mQueryBundle.putString(QUERY_PARAMS, this.mQuery);
            this.mWorker.executeTask(TASK_REQUEST_NOTICE, this.mQueryBundle, this);
        }
    }

    protected void onResume() {
        super.onResume();
        this.mIsReady = true;
        if (this.page == 1 && this.mFragmentNotAdded) {
            this.mWorker.executeTask(TASK_GET_VIDEO, null, this);
            this.mFragmentNotAdded = false;
        }
    }

    protected void onPause() {
        super.onPause();
        this.mIsReady = false;
    }

    public void finish() {
        super.finish();
        this.setRequestedOrientation(1);
    }

    @Override
    public Result executeTaskInBackground(String string2, Bundle bundle) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        switch (string2) {
            case "video_task_init": 
            case "video_task_init_2": {
                if (this.mPlayingGidList != null && this.mPlayingGidList.size() > 0) {
                    bundle.putSerializable("exclude_gid", this.mPlayingGidList);
                }
                bundle.putBoolean("is_featured", this.getIntent().getBooleanExtra("is_featured", false));
                bundle.putInt("video_category", this.getIntent().getIntExtra("video_category", 0));
                return this.mGigsBackend.getYtVideo(bundle);
            }
            case "task_request_notice": {
                HashMap<String, String> hashMap;
                String string3 = bundle.getString(QUERY_PARAMS);
                if (string3 != null && (hashMap = Utils.queryToHashMap(string3)).containsKey("app_key") && !hashMap.get("app_key").isEmpty() && hashMap.containsKey("sub_pubid") && !hashMap.get("sub_pubid").isEmpty()) {
                    return this.mNoticeApi.request(hashMap);
                }
                return new Result(Error.EMPTY);
            }
        }
        return null;
    }

    private boolean isEnableDoubleVideo(boolean bl) {
        return bl && Utils.getCurrentWebViewPackageInfo() && NetworkUtil.isConnectedFast(this.getApplicationContext());
    }

    @Override
    public void onBackgroundTaskCompleted(String string2, Result result) {
        switch (string2) {
            case "task_request_notice": {
                if (result != null && result.isSuccess()) {
                    this.mNoticeResponse = (NoticeResponse)result.getResult();
                    boolean bl = this.mIsPolice = this.mNoticeResponse != null && this.mNoticeResponse.is_police;
                    if (!this.mIsPolice && this.mNoticeResponse != null && this.mNoticeResponse.credential.success) {
                        if (this.mNoticeResponse.video_webview_control) {
                            Bundle bundle = new Bundle();
                            if (this.mPlayingGidList != null && this.mPlayingGidList.size() > 0) {
                                bundle.putSerializable("exclude_gid", this.mPlayingGidList);
                            }
                            bundle.putBoolean("is_featured", this.getIntent().getBooleanExtra("is_featured", false));
                            bundle.putInt("video_category", this.getIntent().getIntExtra("video_category", 0));
                            bundle.putBoolean("video_webview_control", true);
                            String string3 = this.mGigsBackend.getDomain() + Utils.hashMapToQuery(this.mGigsBackend.getParams("GigsBackend.getYoutube", bundle));
                            if (this.isEnableDoubleVideo(this.mNoticeResponse.double_video)) {
                                string3 = string3 + "&vc=2";
                            }
                            Bundle bundle2 = new Bundle();
                            bundle2.putString("url", string3);
                            this.getSupportFragmentManager().beginTransaction().add(R.id.embed_video_root, (Fragment)WebviewFragment.newInstance(bundle2), EMBED_FRAGMENT_TAG + this.page).commit();
                        } else {
                            this.mWorker.executeTask(TASK_GET_VIDEO, null, this);
                        }
                        return;
                    }
                }
                this.videoNotAvailable();
                break;
            }
            case "video_task_init": 
            case "video_task_init_2": {
                if (result.isSuccess() && this.mIsReady) {
                    this.mVideoGigsResponse = (EmbedGigsResponse)result.getResult();
                    if (this.mVideoGigsResponse.success) {
                        this.getIntent().putExtra("video_response", App.gson().toJson((Object)this.mVideoGigsResponse));
                        this.getIntent().putExtra("page", this.page);
                        this.addPlayingGid(this.mVideoGigsResponse.gid);
                        EmbedVideoFragment embedVideoFragment = EmbedVideoFragment.newInstance(this.getIntent().getExtras());
                        embedVideoFragment.setListener(this);
                        this.getSupportFragmentManager().beginTransaction().add(R.id.embed_video_root, (Fragment)embedVideoFragment, EMBED_FRAGMENT_TAG + this.page).commit();
                        if (this.isEnableDoubleVideo(this.mNoticeResponse.double_video) && this.page < 2) {
                            Handler handler = new Handler();
                            handler.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    EmbedDoubleVideoActivity.this.mWorker.executeTask(EmbedDoubleVideoActivity.TASK_GET_VIDEO_2, null, EmbedDoubleVideoActivity.this);
                                }
                            }, 1000L);
                        }
                        ++this.page;
                        return;
                    }
                } else if (!this.mIsReady) {
                    this.mFragmentNotAdded = true;
                }
                if (!string2.equalsIgnoreCase(TASK_GET_VIDEO)) break;
                this.videoNotAvailable();
            }
        }
    }

    public void videoNotAvailable() {
        if (!(this.isFinishing() || this.mNoVideoDialog != null && (this.mNoVideoDialog.isShowing() || this.isFinishing()))) {
            this.mNoVideoDialog = new AlertDialog.Builder((Context)new ContextThemeWrapper((Context)this, R.style.AlertDialog)).setCancelable(false).setMessage(R.string.no_video_retry).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    EmbedDoubleVideoActivity.this.finish();
                }
            }).show();
        }
    }

    public void addLifecycleObserver(VideoPlayerView videoPlayerView) {
        this.getLifecycle().addObserver((LifecycleObserver)videoPlayerView);
    }

    public void muteAllHtmlEmbedPlayer(int n) {
        this.mViewPlaying = true;
        for (int i = 1; i <= 2; ++i) {
            Fragment fragment = this.getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG + i);
            if (fragment == null || !(fragment instanceof EmbedVideoFragment)) continue;
            if (i != n) {
                if (this.mUnmuteVideoPlayer <= 0) continue;
                this.mUnmuteVideoPlayer = i;
                ((EmbedVideoFragment)fragment).setMute(false);
                continue;
            }
            ((EmbedVideoFragment)fragment).setVolumeControl(false);
        }
    }

    public void testSkipAd(String string2, int n) {
        for (int i = 1; i <= 2; ++i) {
            Fragment fragment = this.getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG + i);
            if (fragment == null || !(fragment instanceof EmbedVideoFragment)) continue;
            if (i == 1) {
                ((EmbedVideoFragment)fragment).videoReachEndpoint(string2, n);
                continue;
            }
            String string3 = ((EmbedVideoFragment)fragment).getCurrentPlayingVideoId();
            ((EmbedVideoFragment)fragment).videoReachEndpoint(string3, n);
        }
    }

    public void setViewPlaying(boolean bl) {
        this.mViewPlaying = bl;
    }

    public void unmuteSkipVideoPlayer(int n) {
        int n2 = 0;
        if (n == this.mUnmuteVideoPlayer) {
            for (int i = 1; i <= 2; ++i) {
                Fragment fragment = this.getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG + i);
                if (fragment == null || !(fragment instanceof EmbedVideoFragment)) continue;
                ((EmbedVideoFragment)fragment).setMute(true);
                if (n == i) continue;
                n2 = i;
            }
            if (n2 > 0) {
                Fragment fragment = this.getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG + n2);
                if (fragment != null && fragment instanceof EmbedVideoFragment) {
                    ((EmbedVideoFragment)fragment).setMute(false);
                }
                this.mUnmuteVideoPlayer = n2;
            }
        }
    }

    public void unmuteVideoPlayer(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 1; i <= 2; ++i) {
            Fragment fragment = this.getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG + i);
            if (fragment == null || !(fragment instanceof EmbedVideoFragment)) continue;
            ((EmbedVideoFragment)fragment).setMute(true);
            if (n != this.mUnmuteVideoPlayer) {
                n3 = n;
            } else if (n != i) {
                n3 = i;
            }
            ++n4;
        }
        if (n3 != this.mUnmuteVideoPlayer) {
            Fragment fragment;
            Fragment fragment2 = this.getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG + n3);
            if (fragment2 != null && fragment2 instanceof EmbedVideoFragment) {
                ((EmbedVideoFragment)fragment2).setMute(false);
            }
            for (int i = 1; i <= 2; ++i) {
                if (i == n3) continue;
                n2 = i;
            }
            if (n3 > 0 && n4 == 2 && !this.mViewPlaying && (fragment = this.getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG + n2)) != null && fragment instanceof EmbedVideoFragment) {
                ((EmbedVideoFragment)fragment).reload();
            }
        }
        this.mUnmuteVideoPlayer = n3;
    }

    public boolean isUnmuteVideoExist() {
        return this.mUnmuteVideoPlayer > 0;
    }

    public ArrayList<String> getCurrentPlayingGid() {
        if (this.mPlayingGidList.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : this.mPlayingGidList) {
                stringBuilder.append(string2).append(",");
            }
            Logger.e(stringBuilder.toString());
            return this.mPlayingGidList;
        }
        return new ArrayList<String>();
    }

    public boolean isVideoIdExist(String string2) {
        ArrayList<String> arrayList = this.getCurrentPlayingGid();
        return arrayList.size() > 0 && arrayList.contains(string2);
    }

    public void addPlayingGid(String string2) {
        if (string2 != null) {
            this.mPlayingGidList.add(string2);
        }
    }

    public void removePreviousPlayingId(String string2) {
        if (string2 != null) {
            this.mPlayingGidList.remove(string2);
        }
        this.getCurrentPlayingGid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void videoNotAvailable(final int n) {
        Object object = this.mSync;
        synchronized (object) {
            if (SystemClock.elapsedRealtime() - this.mLastClickTime < 1000L) {
                Handler handler = new Handler();
                handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        EmbedDoubleVideoActivity.this.videoNotAvailable(n);
                    }
                }, 500L);
                return;
            }
            this.mLastClickTime = SystemClock.elapsedRealtime();
            Fragment fragment = null;
            int n2 = 0;
            for (int i = 1; i <= 2; ++i) {
                Fragment fragment2 = this.getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG + i);
                if (fragment2 == null || !(fragment2 instanceof EmbedVideoFragment)) continue;
                if (i == n) {
                    fragment = fragment2;
                }
                ++n2;
            }
            if (n2 == 2 && fragment != null) {
                this.getSupportFragmentManager().beginTransaction().remove(fragment).commit();
            } else {
                this.videoNotAvailable();
            }
        }
    }

    public void updateCurrentPlayingGid(String string2) {
        this.removePreviousPlayingId(string2);
    }

    public boolean isClickedSkipButton() {
        return this.mIsSkipClicked;
    }

    public void setIsSkipClicked() {
        if (!this.mIsSkipClicked) {
            Handler handler = new Handler();
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    EmbedDoubleVideoActivity.this.mIsSkipClicked = false;
                }
            }, 2000L);
            this.mIsSkipClicked = true;
        }
    }
}

