/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.appzilo.sdk.video.EmbedDoubleVideoActivity;
import com.appzilo.sdk.video.R;
import com.appzilo.sdk.video.backend.GigsApi;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.EmbedGigsResponse;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.App;
import com.appzilo.sdk.video.core.Logger;
import com.appzilo.sdk.video.core.Result;
import com.appzilo.sdk.video.utils.ResourcesUtil;
import com.appzilo.sdk.video.utils.SharedPreferencesUtil;
import com.appzilo.sdk.video.utils.Utils;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class AppziloVideo {
    public static final String PARAMS = "video_params";
    public static final String SUB_ID = "sb";
    public static final String SUB_ID2 = "sb2";
    public static final String SUB_ID3 = "sb3";
    public static final String SUB_ID4 = "sb4";
    public static final String SUB_ID5 = "sb5";
    public static final String APP_KEY = "app_key";
    public static final String USER_ID = "sub_pubid";
    private static final String APP_ID = "app";
    private static final String APP_VERSION = "ver";
    private static final String MODULE_VERSION = "v";
    private static WeakReference<Activity> mActivity;
    private static HashMap<String, String> mParams;
    private static Class<? extends Activity> sChildClass;
    private static AzRewardedVideoListener mListener;

    public static synchronized void initApp(@NonNull Activity activity, @NonNull String string2, @NonNull String string3) {
        AppziloVideo.initApp(activity, string2, string3, null);
    }

    public static synchronized void initApp(@NonNull Activity activity, @NonNull String string2, @NonNull String string3, HashMap<String, String> hashMap) {
        App.init(activity.getApplicationContext());
        mActivity = new WeakReference<Activity>(activity);
        mParams = new HashMap();
        if (hashMap != null) {
            mParams.putAll(hashMap);
            SharedPreferencesUtil sharedPreferencesUtil = new SharedPreferencesUtil((Context)activity);
            if (hashMap.containsKey("dbm")) {
                sharedPreferencesUtil.putStringValue("dbm", hashMap.get("dbm"));
            }
            if (hashMap.containsKey("az_dbm")) {
                sharedPreferencesUtil.putStringValue("az_dbm", hashMap.get("az_dbm"));
            }
            if (hashMap.containsKey("moo_dbm")) {
                sharedPreferencesUtil.putStringValue("moo_dbm", hashMap.get("moo_dbm"));
            }
        }
        mParams.put(APP_KEY, string2);
        mParams.put(USER_ID, string3);
        mParams.put(APP_ID, activity.getApplicationContext().getPackageName());
        mParams.put(APP_VERSION, Utils.getAppVersion((Context)activity));
        mParams.put(MODULE_VERSION, "1.3.3");
        sChildClass = activity.getClass();
    }

    public static void show() {
        Activity activity = (Activity)mActivity.get();
        if (activity != null && !activity.isFinishing()) {
            Intent intent = new Intent(activity.getApplicationContext(), EmbedDoubleVideoActivity.class);
            intent.putExtra("video_category", mParams.containsKey("video_category") ? Integer.valueOf(mParams.get("video_category")) : 0);
            if (mParams.containsKey("video_category")) {
                mParams.remove("video_category");
            }
            intent.putExtra("is_featured", mParams.containsKey("is_featured") ? Boolean.valueOf(mParams.get("is_featured")) : false);
            if (mParams.containsKey("is_featured")) {
                mParams.remove("is_featured");
            }
            Logger.e("Utils.hashMapToQuery(mParams):" + Utils.hashMapToQuery(mParams));
            intent.putExtra(PARAMS, Utils.hashMapToQuery(mParams));
            intent.setFlags(0x10000000);
            activity.startActivity(intent);
        }
    }

    public static Class<? extends Activity> getChildClass() {
        return sChildClass;
    }

    public static void setVideoListener(AzRewardedVideoListener azRewardedVideoListener) {
        Activity activity = (Activity)mActivity.get();
        mListener = azRewardedVideoListener;
        if (mListener != null) {
            new RequestTask(activity, mParams).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }
    }

    public static interface AzRewardedVideoListener {
        public void onRewardedVideoAvailable();

        public void onRewardedVideoNotAvailable(String var1);
    }

    private static class RequestTask
    extends AsyncTask<Void, Void, String> {
        private NoticeApi mNoticeApi;
        private GigsApi mGigsApi;
        private HashMap<String, String> mParams = new HashMap();

        RequestTask(Activity activity, HashMap<String, String> hashMap) {
            if (this.mGigsApi == null) {
                this.mGigsApi = new GigsApi((Context)activity);
            }
            if (this.mNoticeApi == null) {
                this.mNoticeApi = new NoticeApi((Context)activity);
            }
            this.mParams.putAll(hashMap);
        }

        protected String doInBackground(Void ... voidArray) {
            Result result = this.mNoticeApi.request(this.mParams);
            if (result.isSuccess()) {
                NoticeResponse noticeResponse = (NoticeResponse)result.getResult();
                if (noticeResponse.credential != null && noticeResponse.credential.success) {
                    Bundle bundle = new Bundle();
                    bundle.putInt("check", 1);
                    Result result2 = this.mGigsApi.getYtVideo(bundle);
                    if (result2.isSuccess()) {
                        EmbedGigsResponse embedGigsResponse = (EmbedGigsResponse)result2.getResult();
                        if (embedGigsResponse.success) {
                            mListener.onRewardedVideoAvailable();
                        } else {
                            mListener.onRewardedVideoNotAvailable(ResourcesUtil.getString(R.string.no_video_retry));
                        }
                    }
                }
            }
            return null;
        }

        protected void onPostExecute(String string2) {
            super.onPostExecute((Object)string2);
        }
    }
}

