package com.appzilo.sdk.video;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.content.LocalBroadcastManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.appzilo.sdk.video.backend.GigsApi;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.EmbedGigsResponse;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.App;
import com.appzilo.sdk.video.core.BackgroundWorker;
import com.appzilo.sdk.video.core.Result;
import com.appzilo.sdk.video.player.VideoPlayer;
import com.appzilo.sdk.video.player.VideoPlayerView;
import com.appzilo.sdk.video.player.listeners.VideoPlayerInitListener;

import java.util.ArrayList;


public class EmbedVideoFragment extends Fragment implements BackgroundWorker.Callbacks,
        VideoPlayerInitListener,
        CustomVideoUIController.Listener{
    public final static String EMBED_PAGE = "page";
    private String TASK_GET_VIDEO = "video_task_init";
    private String TASK_GET_SAME_VIDEO = "video_task_same_init";
    private String TASK_VERIFY_VIDEO = "video_task_verify";
    private String TASK_REPORT_VIDEO = "video_task_report";
    private String TASK_SKIP_VIDEO = "video_task_skip";
    private String OBJ_GIGS_BACKEND = "gigs_backend.video";
    private VideoPlayerView mYouTubePlayerView;
    private CustomVideoUIController mCustomPlayerUIController;
    private View mCustomPlayerUI;
    private BackgroundWorker mWorker;
    private GigsApi mGigsBackend;
    private NoticeResponse mNoticeResponse;
    private EmbedGigsResponse mVideoGigsResponse;
    private int mPage;
    private EmbedVideoInterface mListener;

    public static EmbedVideoFragment newInstance(Bundle args) {
        if(args == null) args = new Bundle();
        EmbedVideoFragment fragment = new EmbedVideoFragment();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if(getActivity() != null){
            mWorker = new BackgroundWorker(getActivity());
            mGigsBackend = (GigsApi) mWorker.get(OBJ_GIGS_BACKEND);
            if (mGigsBackend == null) {
                mGigsBackend = new GigsApi(getContext()); // , mType);
                mWorker.put(OBJ_GIGS_BACKEND, mGigsBackend);
            }
            mNoticeResponse = NoticeApi.getNoticeResponse(getContext());
            String videoResponse = null;
            if(getArguments() != null){
                videoResponse = getArguments().getString(GigsApi.VIDEO_RESPOSNE, null);
                mPage = getArguments().getInt(EMBED_PAGE);
                TASK_GET_VIDEO += mPage;
                TASK_VERIFY_VIDEO += mPage;
                TASK_REPORT_VIDEO += mPage;
                TASK_SKIP_VIDEO += mPage;
                TASK_GET_SAME_VIDEO += mPage;
            }

            if(videoResponse != null){
                mVideoGigsResponse = App.gson().fromJson(getArguments().getString(GigsApi.VIDEO_RESPOSNE), EmbedGigsResponse.class);
            }
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_embed_video, container, false);
        mYouTubePlayerView = view.findViewById(R.id.player);
        mCustomPlayerUI = mYouTubePlayerView.inflateCustomPlayerUI(R.layout.custom_video_ui);
        mYouTubePlayerView.initialize(this, true);
        if(getActivity() != null){
            ((EmbedDoubleVideoActivity)getActivity()).addLifecycleObserver(mYouTubePlayerView);
        }
        return view;
    }

    @Override
    public void onResume() {
        super.onResume();
        if(getView() != null){
            getView().clearFocus();
        }
        if (mCustomPlayerUIController != null) {
            mCustomPlayerUIController.onResume();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        if (mCustomPlayerUIController != null) {
            mCustomPlayerUIController.onPause();
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (mCustomPlayerUIController != null) {
            mCustomPlayerUIController.onDestroy();
        }
    }

    @Override
    public Result executeTaskInBackground(String id, Bundle args) {
        if (args == null) {
            args = new Bundle();
        }
        if(getActivity() != null && getActivity() instanceof EmbedDoubleVideoActivity){
            ArrayList<String> exclude_gid = new ArrayList<>(((EmbedDoubleVideoActivity) getActivity()).getCurrentPlayingGid());
            if(exclude_gid.size() > 0) {
                exclude_gid.remove(mVideoGigsResponse.gid);
                args.putSerializable(GigsApi.VIDEO_EXCLUDE, exclude_gid);
            }
        }
        if(getArguments() != null){
            args.putBoolean(GigsApi.IS_FEATURED, (getArguments().getBoolean(GigsApi.IS_FEATURED, false)));
            args.putInt(GigsApi.VIDEO_CATEGORY, (getArguments().getInt(GigsApi.VIDEO_CATEGORY, 0)));
        }

        if(id.equals(TASK_GET_VIDEO) || id.equals(TASK_GET_SAME_VIDEO)){
            return mGigsBackend.getYtVideo(args);
        }
        else if(id.equals(TASK_VERIFY_VIDEO)){
            return mGigsBackend.verifyWatchedYtVideo(args);
        }
        else if(id.equals(TASK_REPORT_VIDEO)){
            return mGigsBackend.reportYoutube(args);
        }
        else if(id.equals(TASK_SKIP_VIDEO)){
            return mGigsBackend.skipVideo(args);
        }
        return null;
    }

    @Override
    public void onBackgroundTaskCompleted(String id, Result result) {
        if(id.equals(TASK_GET_VIDEO)){
            mVideoGigsResponse = (EmbedGigsResponse) result.getResult();
            mCustomPlayerUIController.initializeYtVideoInfo(mVideoGigsResponse);
            return;
        }
        else if(id.equals(TASK_VERIFY_VIDEO) || id.equals(TASK_REPORT_VIDEO) || id.equals(TASK_SKIP_VIDEO) || id.equals(TASK_GET_SAME_VIDEO)){
            if (result.isSuccess()) {
                EmbedGigsResponse new_response = (EmbedGigsResponse) result.getResult();
                if(new_response != null && new_response.gid != null && getActivity() != null){
                    if(getActivity() != null && ((EmbedDoubleVideoActivity)getActivity()).isVideoIdExist(new_response.gid) && !new_response.gid.equals(mCustomPlayerUIController.getPlayingVideoId())){
                        mWorker.executeTask(TASK_GET_SAME_VIDEO, null, this);
                        return;
                    }
                    mVideoGigsResponse = new_response;
                    ((EmbedDoubleVideoActivity)getActivity()).addPlayingGid(new_response.gid);
                }
                mCustomPlayerUIController.verifiedYtVideo(new_response);
                Intent gigsIntent = new Intent("gigs_force_refresh_receiver");
                if(getContext() != null) LocalBroadcastManager.getInstance(getContext()).sendBroadcast(gigsIntent);
                return;
            }
        }
        videoNotAvailable();
    }

    public String getCurrentPlayingVideoId(){
        return mCustomPlayerUIController.getPlayingVideoId();
    }

    @Override
    public void videoReachEndpoint(String id, int ts) {
        if (mNoticeResponse != null && !mNoticeResponse.is_police) {
            Bundle bundle = new Bundle();
            bundle.putString(GigsApi.YOUTUBE_GIGS_ID, id);
            bundle.putInt(GigsApi.YOUTUBE_TIMSTAMP, ts);
            mWorker.executeTask(TASK_VERIFY_VIDEO, bundle, this);
        } else {
            videoNotAvailable();
        }
    }

    @Override
    public void skipVideo(String gid) {
        if (mNoticeResponse != null && !mNoticeResponse.is_police) {
            Bundle bundle = new Bundle();
            bundle.putString(GigsApi.YOUTUBE_GIGS_ID, gid);
            mWorker.executeTask(TASK_SKIP_VIDEO, bundle, this);
        } else {
            videoNotAvailable();
        }
    }

    @Override
    public void videoNotAvailable() {
        if (getActivity() != null && !getActivity().isFinishing() && mListener != null) {
            mListener.videoNotAvailable(mPage);
        }
    }

    @Override
    public void forceStopVideo() {
        if (getActivity() != null && !getActivity().isFinishing()) {
            getActivity().finish();
        }
    }

    @Override
    public void youtubePlayableError(String id, String error) {
        Bundle bundle = new Bundle();
        bundle.putString(GigsApi.YOUTUBE_GIGS_ID, id);
        bundle.putString(GigsApi.YOUTUBE_ERROR, error);
        mWorker.executeTask(TASK_REPORT_VIDEO, bundle, this);
    }

    @Override
    public void enablePictureInPicture() {

    }


    public void setListener(EmbedVideoInterface listener){
        mListener = listener;
    }

    public void setMute(boolean mute){
        if(mCustomPlayerUIController != null){
            mCustomPlayerUIController.setMute(mute);
        }
    }

    public void setVolumeControl(boolean enable){
        if(mCustomPlayerUIController != null){
            mCustomPlayerUIController.setVolumeControl(enable);
        }
    }

    public void reload(){
        if(mCustomPlayerUIController != null){
            mCustomPlayerUIController.reload();
        }
    }

    @Override
    public void onInitSuccess(@NonNull VideoPlayer videoPlayer) {
        if (mCustomPlayerUIController == null) {
            mCustomPlayerUIController = new CustomVideoUIController(getActivity(), this, mPage, mCustomPlayerUI, videoPlayer, mYouTubePlayerView, (mNoticeResponse != null) ? mNoticeResponse.passive_video_interval * 1000 : 0, (mNoticeResponse != null) && mNoticeResponse.is_police);
            videoPlayer.addListener(mCustomPlayerUIController);
            mCustomPlayerUIController.initializeYtVideoInfo(mVideoGigsResponse);
        }
    }


    public interface EmbedVideoInterface{
        void videoNotAvailable(int page);
    }
}
