package com.appzilo.sdk.video;

import android.content.DialogInterface;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.view.ContextThemeWrapper;
import android.widget.LinearLayout;

import com.appzilo.sdk.video.backend.GigsApi;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.EmbedGigsResponse;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.App;
import com.appzilo.sdk.video.core.BackgroundWorker;
import com.appzilo.sdk.video.core.Error;
import com.appzilo.sdk.video.core.Logger;
import com.appzilo.sdk.video.core.Result;
import com.appzilo.sdk.video.player.VideoPlayerView;
import com.appzilo.sdk.video.utils.NetworkUtil;
import com.appzilo.sdk.video.utils.Utils;

import java.util.ArrayList;
import java.util.HashMap;

public class EmbedDoubleVideoActivity extends AppCompatActivity implements
        BackgroundWorker.Callbacks,
        EmbedVideoFragment.EmbedVideoInterface{

    private static final String OBJ_NOTICE_API = "obj_notice_api";
    private static final String TASK_GET_VIDEO = "video_task_init";
    private static final String TASK_GET_VIDEO_2 = "video_task_init_2";
    private static final String EMBED_FRAGMENT_TAG = "embed_video_";
    private static final String OBJ_GIGS_BACKEND = "gigs_backend.video";
    private static final String TASK_REQUEST_NOTICE = "task_request_notice";
    private static final String QUERY_PARAMS = "query_params";
    private LinearLayout mRootView;
    private BackgroundWorker mWorker;
    private NoticeResponse mNoticeResponse;
    private NoticeApi mNoticeApi;
    private AlertDialog mNoVideoDialog;
    private GigsApi mGigsBackend;
    private EmbedGigsResponse mVideoGigsResponse;
    private int mUnmuteVideoPlayer;
    private ArrayList<String> mPlayingGidList;
    private boolean mIsReady;
    private boolean mFragmentNotAdded;
    private boolean mViewPlaying = false;
    private final Object mSync = new Object();
    private long mLastClickTime = 0;
    private String mQuery;
    private Bundle mQueryBundle;
    private boolean mIsPolice;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
        setContentView(R.layout.activity_embed_video_2);
        mRootView = findViewById(R.id.embed_video_root);
        mWorker = new BackgroundWorker(this);
        mNoticeResponse = NoticeApi.getNoticeResponse(getApplicationContext());
        if (mNoticeApi == null) {
            mNoticeApi = new NoticeApi(getApplicationContext());
            mWorker.put(OBJ_NOTICE_API, mNoticeApi);
        }
        mGigsBackend = (GigsApi) mWorker.get(OBJ_GIGS_BACKEND);
        if (mGigsBackend == null) {
            mGigsBackend = new GigsApi(this); // , mType);
            mWorker.put(OBJ_GIGS_BACKEND, mGigsBackend);
        }
        mPlayingGidList = new ArrayList<>();
        mQuery = getIntent().getStringExtra(AppziloVideo.PARAMS);
        if (mQuery != null && !mQuery.isEmpty()) {
            mQueryBundle = new Bundle();
            mQueryBundle.putString(QUERY_PARAMS, mQuery);
            mWorker.executeTask(TASK_REQUEST_NOTICE, mQueryBundle, this);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        mIsReady = true;
        if(page == 1 && mFragmentNotAdded){
            mWorker.executeTask(TASK_GET_VIDEO, null, this);
            mFragmentNotAdded = false;
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        mIsReady = false;
    }

    @Override
    public void finish() {
        super.finish();
        this.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
    }

    @Override
    public Result executeTaskInBackground(String id, Bundle args) {
        if (args == null) {
            args = new Bundle();
        }
        switch (id) {
            case TASK_GET_VIDEO:
            case TASK_GET_VIDEO_2:
                if(mPlayingGidList != null && mPlayingGidList.size() > 0) args.putSerializable(GigsApi.VIDEO_EXCLUDE, mPlayingGidList);
                args.putBoolean(GigsApi.IS_FEATURED, (getIntent().getBooleanExtra(GigsApi.IS_FEATURED, false)));
                args.putInt(GigsApi.VIDEO_CATEGORY, (getIntent().getIntExtra(GigsApi.VIDEO_CATEGORY, 0)));
                return mGigsBackend.getYtVideo(args);
            case TASK_REQUEST_NOTICE:
                String query = args.getString(QUERY_PARAMS);

                if (query != null) {
                    HashMap<String, String> queryParams = Utils.queryToHashMap(query);
                    if ((queryParams.containsKey(AppziloVideo.APP_KEY) && !queryParams.get(AppziloVideo.APP_KEY).isEmpty()) && (queryParams.containsKey(AppziloVideo.USER_ID) && !queryParams.get(AppziloVideo.USER_ID).isEmpty())) {
                        return mNoticeApi.request(queryParams);
                    }
                }
                return new Result(Error.EMPTY);
        }
        return null;
    }

    private boolean isEnableDoubleVideo(boolean isNoticeEnable){
        return isNoticeEnable && Utils.getCurrentWebViewPackageInfo() && NetworkUtil.isConnectedFast(getApplicationContext());
    }

    int page = 1;

    @Override
    public void onBackgroundTaskCompleted(String id, Result result) {
        switch (id) {
            case TASK_REQUEST_NOTICE:
                if (result != null && result.isSuccess()) {
                    mNoticeResponse = (NoticeResponse) result.getResult();
                    mIsPolice = (mNoticeResponse != null) && mNoticeResponse.is_police;
                    if(!mIsPolice && mNoticeResponse != null && mNoticeResponse.credential.success) {
                        if(mNoticeResponse.video_webview_control){
                            Bundle args = new Bundle();
                            if(mPlayingGidList != null && mPlayingGidList.size() > 0) args.putSerializable(GigsApi.VIDEO_EXCLUDE, mPlayingGidList);
                            args.putBoolean(GigsApi.IS_FEATURED, (getIntent().getBooleanExtra(GigsApi.IS_FEATURED, false)));
                            args.putInt(GigsApi.VIDEO_CATEGORY, (getIntent().getIntExtra(GigsApi.VIDEO_CATEGORY, 0)));
                            args.putBoolean(GigsApi.VIDEO_WEBVIEW_CONTROL, true);
                            String url = mGigsBackend.getDomain() + Utils.hashMapToQuery(mGigsBackend.getParams(GigsApi.TASK_GET_YOUTUBE, args));

                            if(isEnableDoubleVideo(mNoticeResponse.double_video)){
                                url = url + "&vc=2";
                            }
                            Bundle webArgs = new Bundle();
                            webArgs.putString(WebviewFragment.URL, url);
                            getSupportFragmentManager().beginTransaction()
                                    .add(R.id.embed_video_root, WebviewFragment.newInstance(webArgs), EMBED_FRAGMENT_TAG+page) // , TAG_SECTION)
                                    .commit();
                        }
                        else{
                            mWorker.executeTask(TASK_GET_VIDEO, null, this);
                        }
                        return;
                    }
                }
                videoNotAvailable();
                break;
            case TASK_GET_VIDEO:
            case TASK_GET_VIDEO_2:
                if (result.isSuccess() && mIsReady) {
                    mVideoGigsResponse = (EmbedGigsResponse) result.getResult();
                    if(mVideoGigsResponse.success){
                        getIntent().putExtra(GigsApi.VIDEO_RESPOSNE, App.gson().toJson(mVideoGigsResponse));
                        getIntent().putExtra(EmbedVideoFragment.EMBED_PAGE, page);
                        addPlayingGid(mVideoGigsResponse.gid);
                        EmbedVideoFragment fragment = EmbedVideoFragment.newInstance(getIntent().getExtras());
                        fragment.setListener(this);
                        getSupportFragmentManager().beginTransaction()
                                .add(R.id.embed_video_root, fragment, EMBED_FRAGMENT_TAG+page) // , TAG_SECTION)
                                .commit();

                        if(isEnableDoubleVideo(mNoticeResponse.double_video)){
                            if(page < 2){
                                final Handler handler = new Handler();
                                handler.postDelayed(new Runnable() {
                                    @Override
                                    public void run() {
                                        mWorker.executeTask(TASK_GET_VIDEO_2, null, EmbedDoubleVideoActivity.this);
                                    }
                                }, 1000);
                            }
                        }
                        page++;
                        return;
                    }
                }
                else if(!mIsReady){
                    mFragmentNotAdded = true;
                }
                if(id.equalsIgnoreCase(TASK_GET_VIDEO)) videoNotAvailable();
                break;
        }
    }

    public void videoNotAvailable() {
        if (!isFinishing()) {
            if ((mNoVideoDialog == null || !mNoVideoDialog.isShowing() && !isFinishing())) {
                mNoVideoDialog = new AlertDialog.Builder(new ContextThemeWrapper(this, R.style.AlertDialog))
                        .setCancelable(false)
                        .setMessage(R.string.no_video_retry)
                        .setPositiveButton(android.R.string.ok, new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                finish();
                            }
                        })
                        .show();
            }
        }
    }

    public void addLifecycleObserver(VideoPlayerView playerView) {
        getLifecycle().addObserver(playerView);
    }

    public void muteAllHtmlEmbedPlayer(int page){
        mViewPlaying = true;
        for(int i =1; i<=2; i++){
            Fragment fragment = getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG+i);
            if(fragment != null && fragment instanceof EmbedVideoFragment){
                if(i != page){
                    if(mUnmuteVideoPlayer > 0){
                        mUnmuteVideoPlayer = i;
                        ((EmbedVideoFragment)fragment).setMute(false);
                    }
                }
                else{
                    ((EmbedVideoFragment)fragment).setVolumeControl(false);
                }
            }
        }
    }

    public void testSkipAd(final String gid, int ts){
        for(int i =1; i<=2; i++){
            final Fragment fragment = getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG+i);
            if(fragment != null && fragment instanceof EmbedVideoFragment){
                if(i == 1){
                    ((EmbedVideoFragment)fragment).videoReachEndpoint(gid, ts);
                }
                else{
                    String current = ((EmbedVideoFragment)fragment).getCurrentPlayingVideoId();
                    ((EmbedVideoFragment)fragment).videoReachEndpoint(current, ts);
                }
            }
        }
    }

    public void setViewPlaying(boolean isPlaying){
        mViewPlaying = isPlaying;
    }

    // mute all video, then unmute
    public void unmuteSkipVideoPlayer(final int page){
        int unmutePage = 0;
        if(page == mUnmuteVideoPlayer){
            for(int i =1; i<=2; i++){
                Fragment fragment = getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG+i);
                if(fragment != null && fragment instanceof EmbedVideoFragment){
                    ((EmbedVideoFragment)fragment).setMute(true);
                    if(page != i ){
                        unmutePage = i;
                    }
                }
            }

            if(unmutePage > 0){
                Fragment fragment = getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG+unmutePage);
                if(fragment != null && fragment instanceof EmbedVideoFragment){
                    ((EmbedVideoFragment)fragment).setMute(false);
                }
                mUnmuteVideoPlayer = unmutePage;
            }
        }
    }

    public void unmuteVideoPlayer(final int page){
        int mutedPage = 0;
        int unmutePage = 0;
        int pageExist = 0;
        // set all to mute and check determine which needed to unmute
        for(int i =1; i<=2; i++){
            Fragment fragment = getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG+i);
            if(fragment != null && fragment instanceof EmbedVideoFragment){
                ((EmbedVideoFragment)fragment).setMute(true);
                if(page != mUnmuteVideoPlayer){
                    unmutePage = page;
                }
                else if(page != i){
                    unmutePage = i;
                }
                pageExist++;
            }
        }

        if(unmutePage != mUnmuteVideoPlayer){
            Fragment fragment = getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG+unmutePage);
            if(fragment != null && fragment instanceof EmbedVideoFragment){
                ((EmbedVideoFragment)fragment).setMute(false);
            }

            // determine mute player, and refresh
            for(int i =1; i<=2; i++){
                if(i != unmutePage){
                    mutedPage = i;
                }
            }

            // when mutedpage more then 0 mean got 2 videos
            if(unmutePage > 0 && pageExist == 2 && !mViewPlaying){
                final Fragment mutedFragment = getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG+mutedPage);
                if(mutedFragment != null && mutedFragment instanceof EmbedVideoFragment){
                    ((EmbedVideoFragment)mutedFragment).reload();
                }
            }
        }

        mUnmuteVideoPlayer = unmutePage;
    }

    public boolean isUnmuteVideoExist(){
        return mUnmuteVideoPlayer > 0;
    }

    public ArrayList<String> getCurrentPlayingGid(){
        if(mPlayingGidList.size() > 0){
            StringBuilder stringBuilder = new StringBuilder();
            for(String gid: mPlayingGidList){
                stringBuilder.append(gid).append(",");
            }
            Logger.e(stringBuilder.toString());

            return mPlayingGidList;
        }

        return new ArrayList<>();
    }

    public boolean isVideoIdExist(String gid){
        ArrayList<String> arr = getCurrentPlayingGid();
        return arr.size() > 0 && arr.contains(gid);
    }

    public void addPlayingGid(String new_gid){
        if(new_gid != null){
            mPlayingGidList.add(new_gid);
        }
    }

    public void removePreviousPlayingId(String old_gid){
        if(old_gid != null){
            mPlayingGidList.remove(old_gid);
        }
        getCurrentPlayingGid();
    }

    @Override
    public void videoNotAvailable(final int page) {
        synchronized(mSync){
            if (SystemClock.elapsedRealtime() - mLastClickTime < 1000) {
                final Handler handler = new Handler();
                handler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        // Do something after 5s = 5000ms
                        videoNotAvailable(page);
                    }
                }, 500);
                return;
            }
            mLastClickTime = SystemClock.elapsedRealtime();
            Fragment removedFragment = null;
            int totalEmbedVideoFragment = 0;
            for(int i =1; i<=2; i++){
                Fragment fragment = getSupportFragmentManager().findFragmentByTag(EMBED_FRAGMENT_TAG+i);
                if(fragment != null && fragment instanceof EmbedVideoFragment){
                    if(i == page){
                        removedFragment = fragment;
                    }
                    totalEmbedVideoFragment++;
                }
            }

            if(totalEmbedVideoFragment == 2 && removedFragment != null){
                getSupportFragmentManager().beginTransaction().remove(removedFragment).commit();
            }
            else{
                videoNotAvailable();
            }
        }
    }

    public void updateCurrentPlayingGid(String old_gid){
        removePreviousPlayingId(old_gid);
    }

    private boolean mIsSkipClicked;

    public boolean isClickedSkipButton(){
        return mIsSkipClicked;
    }

    public void setIsSkipClicked(){
        if(!mIsSkipClicked){
            final Handler handler = new Handler();
            handler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    // Do something after 5s = 5000ms
                    mIsSkipClicked = false;
                }
            }, 2000);
            mIsSkipClicked = true;
        }
    }
}
