/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.webkit.WebView;
import com.appzilo.sdk.video.core.MCrypt;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class Utils {
    @SuppressLint(value={"DefaultLocale"})
    public static String formatTime(float f) {
        int n = (int)(f / 60.0f);
        int n2 = (int)(f % 60.0f);
        return String.format("%d:%02d", n, n2);
    }

    public static void openBrowser(Context context, String string2) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.setFlags(0x10000000);
        intent.setData(Uri.parse((String)string2));
        context.startActivity(intent);
    }

    public static boolean isOnline(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    public static int dpToPx(int n) {
        return (int)((float)n * Resources.getSystem().getDisplayMetrics().density);
    }

    public static String javaEncrypt(String string2) {
        MCrypt mCrypt = new MCrypt();
        String string3 = null;
        try {
            string3 = MCrypt.bytesToHex(mCrypt.encrypt(string2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string3;
    }

    public static boolean isDebug(Context context) {
        return context != null && 0 != (context.getApplicationInfo().flags & 2);
    }

    public static String getAppVersion(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (Exception exception) {
            return "0.0.0";
        }
    }

    public static String hashMapToQuery(HashMap<?, ?> hashMap) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<?, ?> entry : hashMap.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(String.format("%s=%s", entry.getKey().toString(), entry.getValue().toString()));
        }
        return stringBuilder.toString();
    }

    public static HashMap<String, String> queryToHashMap(String string2) {
        String[] stringArray = string2.split("&");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string3 : stringArray) {
            if (string3.split("=").length != 2) continue;
            hashMap.put(string3.split("=")[0], string3.split("=")[1]);
        }
        return hashMap;
    }

    public static String getAppId(Context context) {
        if (context != null) {
            return context.getPackageName();
        }
        return "";
    }

    @SuppressLint(value={"PrivateApi"})
    public static boolean getCurrentWebViewPackageInfo() {
        PackageInfo packageInfo = null;
        if (Build.VERSION.SDK_INT >= 26) {
            packageInfo = WebView.getCurrentWebViewPackage();
        } else if (Build.VERSION.SDK_INT >= 21) {
            try {
                Class<?> clazz = Class.forName("android.webkit.WebViewFactory");
                Method method = clazz.getMethod("getLoadedPackageInfo", new Class[0]);
                packageInfo = (PackageInfo)method.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            return true;
        }
        return packageInfo != null && (packageInfo.packageName.equalsIgnoreCase("com.google.android.webview") || packageInfo.packageName.equalsIgnoreCase("com.android.chrome"));
    }
}

