/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.utils;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import java.lang.reflect.InvocationTargetException;

public class ScreenSizeUtil {
    private static int sWidth;
    private static int sHeight;

    public static void init(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        int n = displayMetrics.widthPixels;
        int n2 = displayMetrics.heightPixels;
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                Point point = new Point();
                Display.class.getMethod("getRealSize", Point.class).invoke((Object)display, point);
                n = point.x;
                n2 = point.y;
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        } else if (Build.VERSION.SDK_INT >= 14) {
            try {
                n = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
                n2 = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        sWidth = n;
        sHeight = n2;
    }

    public static int width() {
        return sWidth;
    }

    public static int height() {
        return sHeight;
    }
}

