/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.player;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.appzilo.sdk.video.player.IFramePlayerOptions;
import com.appzilo.sdk.video.player.PlayerConstants;
import com.appzilo.sdk.video.player.VideoPlayer;
import com.appzilo.sdk.video.player.VideoPlayerBridge;
import com.appzilo.sdk.video.player.listeners.VideoPlayerInitListener;
import com.appzilo.sdk.video.player.listeners.VideoPlayerListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WebViewVideoPlayer
extends WebView
implements VideoPlayer,
VideoPlayerBridge.YouTubePlayerBridgeCallbacks {
    private AudioManager mAudioManager;
    private VideoPlayerInitListener videoPlayerInitListener;
    @NonNull
    private final Set<VideoPlayerListener> videoPlayerListeners;
    @NonNull
    private final Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    private String baseUrl;
    private String playerHtml;
    protected boolean backgroundPlaybackEnabled = false;
    private String mTag;

    public WebViewVideoPlayer(Context context) {
        this(context, null);
    }

    public WebViewVideoPlayer(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public WebViewVideoPlayer(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.videoPlayerListeners = new HashSet<VideoPlayerListener>();
    }

    public void initialize(@NonNull VideoPlayerInitListener videoPlayerInitListener, @Nullable IFramePlayerOptions iFramePlayerOptions) {
        this.videoPlayerInitListener = videoPlayerInitListener;
        this.initWebView(iFramePlayerOptions == null ? IFramePlayerOptions.getDefault() : iFramePlayerOptions);
    }

    public void setTag(String string2) {
        this.mTag = string2;
    }

    @Override
    public void onYouTubeIframeAPIReady() {
        if (this.videoPlayerInitListener != null) {
            this.videoPlayerInitListener.onInitSuccess(this);
        }
    }

    @Override
    public void loadVideo(final @NonNull String string2, final float f) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:loadVideo('" + string2 + "', " + f + ")");
            }
        });
    }

    @Override
    public void loadChannel(final @NonNull String string2) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:setChannel('" + string2 + "')");
            }
        });
    }

    @Override
    public void cueVideo(final @NonNull String string2, final float f) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:cueVideo('" + string2 + "', " + f + ")");
            }
        });
    }

    @Override
    public void play() {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:playVideo()");
            }
        });
    }

    @Override
    public void pause() {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:pauseVideo()");
            }
        });
    }

    @Override
    public void setVolume(final int n) {
        if (n < 0 || n > 100) {
            throw new IllegalArgumentException("Volume must be between 0 and 100");
        }
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:setVolume(" + n + ")");
            }
        });
    }

    @Override
    public void setMute(final boolean bl) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:setMute(" + bl + ")");
            }
        });
    }

    @Override
    public void seekTo(final float f) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:seekTo(" + f + ")");
            }
        });
    }

    public void destroy() {
        this.videoPlayerListeners.clear();
        this.mainThreadHandler.removeCallbacksAndMessages(null);
        super.destroy();
    }

    @Override
    @NonNull
    public Collection<VideoPlayerListener> getListeners() {
        return Collections.unmodifiableCollection(new HashSet<VideoPlayerListener>(this.videoPlayerListeners));
    }

    @Override
    public boolean addListener(@NonNull VideoPlayerListener videoPlayerListener) {
        if (videoPlayerListener == null) {
            Log.e((String)"YouTubePlayer", (String)"null YouTubePlayerListener not allowed.");
            return false;
        }
        return this.videoPlayerListeners.add(videoPlayerListener);
    }

    @Override
    public boolean removeListener(@NonNull VideoPlayerListener videoPlayerListener) {
        return this.videoPlayerListeners.remove(videoPlayerListener);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initWebView(IFramePlayerOptions iFramePlayerOptions) {
        WebSettings webSettings = this.getSettings();
        if (Build.VERSION.SDK_INT >= 17) {
            webSettings.setMediaPlaybackRequiresUserGesture(false);
        } else {
            webSettings.setPluginState(WebSettings.PluginState.ON);
        }
        webSettings.setJavaScriptEnabled(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setAppCacheEnabled(true);
        webSettings.setAllowFileAccess(true);
        this.setWebViewClient(new CustomWebViewClient());
        this.addJavascriptInterface(new VideoPlayerBridge(this), "PlayerBridge");
        this.setWebChromeClient(new WebChromeClient(){

            public Bitmap getDefaultVideoPoster() {
                Bitmap bitmap = super.getDefaultVideoPoster();
                if (bitmap == null) {
                    return Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.RGB_565);
                }
                return bitmap;
            }
        });
        String string2 = this.getSettings().getUserAgentString();
        if (Build.VERSION.SDK_INT > 19) {
            string2 = string2.replace("; wv", "").replaceAll("Chrome\\/(\\d+\\.?)+", "Chrome/70.0.3538.80");
        } else {
            String string3 = "(Version\\/\\S+)";
            string2 = string2.replaceAll(string3, "");
        }
        this.getSettings().setUserAgentString(string2);
        if (this.playerHtml != null && !this.playerHtml.isEmpty()) {
            this.loadDataWithBaseURL(this.baseUrl, this.playerHtml, "text/html", "utf-8", null);
            return;
        }
        if (this.baseUrl != null) {
            this.loadUrl(this.baseUrl, this.getCustomHeaders());
        }
        if (this.videoPlayerInitListener != null) {
            this.videoPlayerInitListener.onInitSuccess(this);
        }
    }

    public void initWebView(String string2, String string3) {
        this.playerHtml = string3;
        this.baseUrl = string2;
        this.initWebView(IFramePlayerOptions.getDefault());
    }

    public void refresh() {
        this.loadUrl("about:blank");
        this.clearView();
    }

    private Map<String, String> getCustomHeaders() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("X-Requested-With", "com.android.browser");
        return hashMap;
    }

    private String readYouTubePlayerHTMLFromFile() {
        try {
            String string2;
            int n = 0;
            InputStream inputStream = this.getResources().openRawResource(n);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append("\n");
            }
            inputStream.close();
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            throw new RuntimeException("Can't parse HTML file containing the player.");
        }
    }

    protected void onWindowVisibilityChanged(int n) {
        if (this.backgroundPlaybackEnabled && (n == 8 || n == 4)) {
            return;
        }
        super.onWindowVisibilityChanged(n);
    }

    public class CustomWebViewClient
    extends WebViewClient {
        boolean isError = false;

        @TargetApi(value=21)
        public boolean shouldOverrideUrlLoading(WebView webView, WebResourceRequest webResourceRequest) {
            webView.loadUrl(webResourceRequest.getUrl().toString(), WebViewVideoPlayer.this.getCustomHeaders());
            return true;
        }

        public boolean shouldOverrideUrlLoading(WebView webView, String string2) {
            webView.loadUrl(string2, WebViewVideoPlayer.this.getCustomHeaders());
            return true;
        }

        public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
            super.onPageStarted(webView, string2, bitmap);
            if (!string2.equals("about:blank") && (WebViewVideoPlayer.this.playerHtml == null || WebViewVideoPlayer.this.playerHtml.isEmpty())) {
                this.isError = false;
            }
        }

        public void onPageFinished(WebView webView, String string2) {
            super.onPageFinished(webView, string2);
            if (!(string2.equals("about:blank") || WebViewVideoPlayer.this.playerHtml != null && !WebViewVideoPlayer.this.playerHtml.isEmpty() || this.isError)) {
                if (webView.getProgress() == 100) {
                    for (VideoPlayerListener videoPlayerListener : WebViewVideoPlayer.this.videoPlayerListeners) {
                        videoPlayerListener.onStateChange(PlayerConstants.PlayerState.PLAYING);
                    }
                }
                if (webView.getProgress() == 100) {
                    WebViewVideoPlayer.this.playerHtml = null;
                    WebViewVideoPlayer.this.baseUrl = null;
                }
            }
        }
    }
}

