/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.player;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.OnLifecycleEvent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.appzilo.sdk.video.R;
import com.appzilo.sdk.video.player.IFramePlayerOptions;
import com.appzilo.sdk.video.player.VideoPlayer;
import com.appzilo.sdk.video.player.WebViewVideoPlayer;
import com.appzilo.sdk.video.player.listeners.AbstractVideoPlayerListener;
import com.appzilo.sdk.video.player.listeners.VideoPlayerFullScreenListener;
import com.appzilo.sdk.video.player.listeners.VideoPlayerInitListener;
import com.appzilo.sdk.video.player.playerUtils.FullScreenHelper;
import com.appzilo.sdk.video.player.playerUtils.PlaybackResumer;
import com.appzilo.sdk.video.ui.DefaultPlayerUIController;
import com.appzilo.sdk.video.ui.PlayerUIController;
import com.appzilo.sdk.video.utils.Callable;
import com.appzilo.sdk.video.utils.NetworkReceiver;
import com.appzilo.sdk.video.utils.ResourcesUtil;
import com.appzilo.sdk.video.utils.ScreenSizeUtil;
import com.appzilo.sdk.video.utils.Utils;

public class VideoPlayerView
extends FrameLayout
implements LifecycleObserver,
NetworkReceiver.NetworkListener {
    public static final String PLAYER_TYPE = "player_type";
    public static final int TYPE_YOUTUBE = 0;
    public static final int TYPE_TWITCH = 1;
    public static final int TYPE_MIXER = 2;
    @NonNull
    private final WebViewVideoPlayer youTubePlayer;
    @Nullable
    private DefaultPlayerUIController defaultPlayerUIController;
    @NonNull
    private final NetworkReceiver networkReceiver;
    @NonNull
    private final PlaybackResumer playbackResumer;
    @NonNull
    private final FullScreenHelper fullScreenHelper;
    @Nullable
    private Callable asyncInitialization;
    private String mTag;

    public VideoPlayerView(Context context) {
        this(context, null);
    }

    public VideoPlayerView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public VideoPlayerView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        ScreenSizeUtil.init(context);
        ResourcesUtil.init(context);
        this.youTubePlayer = new WebViewVideoPlayer(context);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        this.youTubePlayer.setBackgroundColor(ResourcesUtil.getColor(R.color.black));
        this.addView((View)this.youTubePlayer, (ViewGroup.LayoutParams)layoutParams);
        this.defaultPlayerUIController = new DefaultPlayerUIController(this, this.youTubePlayer);
        this.playbackResumer = new PlaybackResumer();
        this.networkReceiver = new NetworkReceiver(this);
        this.fullScreenHelper = new FullScreenHelper();
        this.fullScreenHelper.addFullScreenListener(this.defaultPlayerUIController);
        this.addYouTubePlayerListeners(this.youTubePlayer);
    }

    public void initPlayer(String string2, String string3) {
        this.youTubePlayer.initWebView(string2, string3);
    }

    public void refreshPlayer() {
        this.youTubePlayer.refresh();
    }

    public void setTag(String string2) {
        this.youTubePlayer.setTag(string2);
    }

    protected void onMeasure(int n, int n2) {
        if (this.getLayoutParams().height == -2) {
            int n3 = View.MeasureSpec.makeMeasureSpec((int)(View.MeasureSpec.getSize((int)n) * 9 / 16), (int)0x40000000);
            super.onMeasure(n, n3);
        } else {
            super.onMeasure(n, n2);
        }
    }

    public void initialize(@NonNull VideoPlayerInitListener videoPlayerInitListener, boolean bl) {
        this.initialize(videoPlayerInitListener, bl, null);
    }

    public void initialize(final @NonNull VideoPlayerInitListener videoPlayerInitListener, boolean bl, final @Nullable IFramePlayerOptions iFramePlayerOptions) {
        if (bl) {
            this.getContext().registerReceiver((BroadcastReceiver)this.networkReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        this.asyncInitialization = new Callable(){

            @Override
            public void call() {
                VideoPlayerView.this.youTubePlayer.initialize(new VideoPlayerInitListener(){

                    @Override
                    public void onInitSuccess(@NonNull VideoPlayer videoPlayer) {
                        videoPlayerInitListener.onInitSuccess(videoPlayer);
                    }
                }, iFramePlayerOptions);
            }
        };
        if (Utils.isOnline(this.getContext())) {
            this.asyncInitialization.call();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void release() {
        this.removeView((View)this.youTubePlayer);
        this.youTubePlayer.removeAllViews();
        this.youTubePlayer.destroy();
        try {
            this.getContext().unregisterReceiver((BroadcastReceiver)this.networkReceiver);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    void onStop() {
        this.youTubePlayer.pause();
    }

    @Override
    public void onNetworkAvailable() {
        if (this.asyncInitialization != null) {
            this.asyncInitialization.call();
        } else {
            this.playbackResumer.resume(this.youTubePlayer);
        }
    }

    @Override
    public void onNetworkUnavailable() {
    }

    public void enableBackgroundPlayback(boolean bl) {
        this.youTubePlayer.backgroundPlaybackEnabled = bl;
    }

    @NonNull
    public PlayerUIController getPlayerUIController() {
        if (this.defaultPlayerUIController == null) {
            throw new RuntimeException("You have inflated a custom player UI. You must manage it with your own controller.");
        }
        return this.defaultPlayerUIController;
    }

    public View inflateCustomPlayerUI(@LayoutRes int n) {
        this.removeViews(1, this.getChildCount() - 1);
        if (this.defaultPlayerUIController != null) {
            this.youTubePlayer.removeListener(this.defaultPlayerUIController);
            this.fullScreenHelper.removeFullScreenListener(this.defaultPlayerUIController);
        }
        this.defaultPlayerUIController = null;
        return View.inflate((Context)this.getContext(), (int)n, (ViewGroup)this);
    }

    public void enterFullScreen() {
        this.fullScreenHelper.enterFullScreen((View)this);
    }

    public void exitFullScreen() {
        this.fullScreenHelper.exitFullScreen((View)this);
    }

    public boolean isFullScreen() {
        return this.fullScreenHelper.isFullScreen();
    }

    public void toggleFullScreen() {
        this.fullScreenHelper.toggleFullScreen((View)this);
    }

    public boolean addFullScreenListener(@NonNull VideoPlayerFullScreenListener videoPlayerFullScreenListener) {
        return this.fullScreenHelper.addFullScreenListener(videoPlayerFullScreenListener);
    }

    public boolean removeFullScreenListener(@NonNull VideoPlayerFullScreenListener videoPlayerFullScreenListener) {
        return this.fullScreenHelper.removeFullScreenListener(videoPlayerFullScreenListener);
    }

    private void addYouTubePlayerListeners(VideoPlayer videoPlayer) {
        if (this.defaultPlayerUIController != null) {
            videoPlayer.addListener(this.defaultPlayerUIController);
        }
        videoPlayer.addListener(this.playbackResumer);
        videoPlayer.addListener(new AbstractVideoPlayerListener(){

            @Override
            public void onReady() {
                VideoPlayerView.this.asyncInitialization = null;
            }
        });
    }
}

