/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.player;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.webkit.JavascriptInterface;
import com.appzilo.sdk.video.player.PlayerConstants;
import com.appzilo.sdk.video.player.listeners.VideoPlayerListener;
import java.util.Collection;

public class VideoPlayerBridge {
    private static final String STATE_UNSTARTED = "UNSTARTED";
    private static final String STATE_ENDED = "ENDED";
    private static final String STATE_PLAYING = "PLAYING";
    private static final String STATE_PAUSED = "PAUSED";
    private static final String STATE_BUFFERING = "BUFFERING";
    private static final String STATE_CUED = "CUED";
    private static final String STATE_ONLINE = "ONLINE";
    private static final String STATE_OFFLINE = "OFFLINE";
    private static final String STATE_VIDEOSTART = "VIDEOSTART";
    private static final String QUALITY_SMALL = "small";
    private static final String QUALITY_MEDIUM = "medium";
    private static final String QUALITY_LARGE = "large";
    private static final String QUALITY_HD720 = "hd720";
    private static final String QUALITY_HD1080 = "hd1080";
    private static final String QUALITY_HIGH_RES = "highres";
    private static final String QUALITY_DEFAULT = "default";
    private static final String RATE_0_25 = "0.25";
    private static final String RATE_0_5 = "0.5";
    private static final String RATE_1 = "1";
    private static final String RATE_1_5 = "1.5";
    private static final String RATE_2 = "2";
    private static final String ERROR_INVALID_PARAMETER_IN_REQUEST = "2";
    private static final String ERROR_HTML_5_PLAYER = "5";
    private static final String ERROR_VIDEO_NOT_FOUND = "100";
    private static final String ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER1 = "101";
    private static final String ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER2 = "150";
    @NonNull
    private final YouTubePlayerBridgeCallbacks youTubePlayer;
    @NonNull
    private final Handler mainThreadHandler;

    public VideoPlayerBridge(@NonNull YouTubePlayerBridgeCallbacks youTubePlayerBridgeCallbacks) {
        this.youTubePlayer = youTubePlayerBridgeCallbacks;
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
    }

    @JavascriptInterface
    public void sendYouTubeIframeAPIReady() {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                VideoPlayerBridge.this.youTubePlayer.onYouTubeIframeAPIReady();
            }
        });
    }

    @JavascriptInterface
    public void isMute(final boolean bl) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (VideoPlayerListener videoPlayerListener : VideoPlayerBridge.this.youTubePlayer.getListeners()) {
                    videoPlayerListener.isMute(bl);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendReady() {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (VideoPlayerListener videoPlayerListener : VideoPlayerBridge.this.youTubePlayer.getListeners()) {
                    videoPlayerListener.onReady();
                }
            }
        });
    }

    @JavascriptInterface
    public void sendStateChange(String string2) {
        final PlayerConstants.PlayerState playerState = this.parsePlayerState(string2);
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (VideoPlayerListener videoPlayerListener : VideoPlayerBridge.this.youTubePlayer.getListeners()) {
                    videoPlayerListener.onStateChange(playerState);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendPlaybackQualityChange(String string2) {
        final PlayerConstants.PlaybackQuality playbackQuality = this.parsePlaybackQuality(string2);
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (VideoPlayerListener videoPlayerListener : VideoPlayerBridge.this.youTubePlayer.getListeners()) {
                    videoPlayerListener.onPlaybackQualityChange(playbackQuality);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendPlaybackRateChange(String string2) {
        final PlayerConstants.PlaybackRate playbackRate = this.parsePlaybackRate(string2);
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (VideoPlayerListener videoPlayerListener : VideoPlayerBridge.this.youTubePlayer.getListeners()) {
                    videoPlayerListener.onPlaybackRateChange(playbackRate);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendError(String string2) {
        final PlayerConstants.PlayerError playerError = this.parsePlayerError(string2);
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (VideoPlayerListener videoPlayerListener : VideoPlayerBridge.this.youTubePlayer.getListeners()) {
                    videoPlayerListener.onError(playerError);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendApiChange() {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (VideoPlayerListener videoPlayerListener : VideoPlayerBridge.this.youTubePlayer.getListeners()) {
                    videoPlayerListener.onApiChange();
                }
            }
        });
    }

    @JavascriptInterface
    public void sendVideoCurrentTime(String string2) {
        float f;
        try {
            f = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return;
        }
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (VideoPlayerListener videoPlayerListener : VideoPlayerBridge.this.youTubePlayer.getListeners()) {
                    videoPlayerListener.onCurrentSecond(f);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendVideoDuration(String string2) {
        float f;
        try {
            String string3 = TextUtils.isEmpty((CharSequence)string2) ? "0" : string2;
            f = Float.parseFloat(string3);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return;
        }
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (VideoPlayerListener videoPlayerListener : VideoPlayerBridge.this.youTubePlayer.getListeners()) {
                    videoPlayerListener.onVideoDuration(f);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendVideoLoadedFraction(String string2) {
        float f;
        try {
            f = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return;
        }
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (VideoPlayerListener videoPlayerListener : VideoPlayerBridge.this.youTubePlayer.getListeners()) {
                    videoPlayerListener.onVideoLoadedFraction(f);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendVideoId(final String string2) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (VideoPlayerListener videoPlayerListener : VideoPlayerBridge.this.youTubePlayer.getListeners()) {
                    videoPlayerListener.onVideoId(string2);
                }
            }
        });
    }

    @NonNull
    private PlayerConstants.PlayerState parsePlayerState(String string2) {
        PlayerConstants.PlayerState playerState = string2.equalsIgnoreCase(STATE_UNSTARTED) ? PlayerConstants.PlayerState.UNSTARTED : (string2.equalsIgnoreCase(STATE_VIDEOSTART) ? PlayerConstants.PlayerState.VIDEOSTART : (string2.equalsIgnoreCase(STATE_ENDED) ? PlayerConstants.PlayerState.ENDED : (string2.equalsIgnoreCase(STATE_PLAYING) ? PlayerConstants.PlayerState.PLAYING : (string2.equalsIgnoreCase(STATE_PAUSED) ? PlayerConstants.PlayerState.PAUSED : (string2.equalsIgnoreCase(STATE_BUFFERING) ? PlayerConstants.PlayerState.BUFFERING : (string2.equalsIgnoreCase(STATE_CUED) ? PlayerConstants.PlayerState.VIDEO_CUED : (string2.equals(STATE_OFFLINE) ? PlayerConstants.PlayerState.OFFLINE : (string2.equals(STATE_ONLINE) ? PlayerConstants.PlayerState.ONLINE : PlayerConstants.PlayerState.UNKNOWN))))))));
        return playerState;
    }

    @NonNull
    private PlayerConstants.PlaybackQuality parsePlaybackQuality(String string2) {
        PlayerConstants.PlaybackQuality playbackQuality = string2.equalsIgnoreCase(QUALITY_SMALL) ? PlayerConstants.PlaybackQuality.SMALL : (string2.equalsIgnoreCase(QUALITY_MEDIUM) ? PlayerConstants.PlaybackQuality.MEDIUM : (string2.equalsIgnoreCase(QUALITY_LARGE) ? PlayerConstants.PlaybackQuality.LARGE : (string2.equalsIgnoreCase(QUALITY_HD720) ? PlayerConstants.PlaybackQuality.HD720 : (string2.equalsIgnoreCase(QUALITY_HD1080) ? PlayerConstants.PlaybackQuality.HD1080 : (string2.equalsIgnoreCase(QUALITY_HIGH_RES) ? PlayerConstants.PlaybackQuality.HIGH_RES : (string2.equalsIgnoreCase(QUALITY_DEFAULT) ? PlayerConstants.PlaybackQuality.DEFAULT : PlayerConstants.PlaybackQuality.UNKNOWN))))));
        return playbackQuality;
    }

    @NonNull
    private PlayerConstants.PlaybackRate parsePlaybackRate(String string2) {
        PlayerConstants.PlaybackRate playbackRate = string2.equalsIgnoreCase(RATE_0_25) ? PlayerConstants.PlaybackRate.RATE_0_25 : (string2.equalsIgnoreCase(RATE_0_5) ? PlayerConstants.PlaybackRate.RATE_0_5 : (string2.equalsIgnoreCase(RATE_1) ? PlayerConstants.PlaybackRate.RATE_1 : (string2.equalsIgnoreCase(RATE_1_5) ? PlayerConstants.PlaybackRate.RATE_1_5 : (string2.equalsIgnoreCase("2") ? PlayerConstants.PlaybackRate.RATE_2 : PlayerConstants.PlaybackRate.UNKNOWN))));
        return playbackRate;
    }

    @NonNull
    private PlayerConstants.PlayerError parsePlayerError(String string2) {
        PlayerConstants.PlayerError playerError = string2.equalsIgnoreCase("2") ? PlayerConstants.PlayerError.INVALID_PARAMETER_IN_REQUEST : (string2.equalsIgnoreCase(ERROR_HTML_5_PLAYER) ? PlayerConstants.PlayerError.HTML_5_PLAYER : (string2.equalsIgnoreCase(ERROR_VIDEO_NOT_FOUND) ? PlayerConstants.PlayerError.VIDEO_NOT_FOUND : (string2.equalsIgnoreCase(ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER1) ? PlayerConstants.PlayerError.VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER : (string2.equalsIgnoreCase(ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER2) ? PlayerConstants.PlayerError.VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER : PlayerConstants.PlayerError.UNKNOWN))));
        return playerError;
    }

    public static interface YouTubePlayerBridgeCallbacks {
        public void onYouTubeIframeAPIReady();

        public Collection<VideoPlayerListener> getListeners();
    }
}

