/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.player;

import android.support.annotation.NonNull;
import org.json.JSONException;
import org.json.JSONObject;

public class IFramePlayerOptions {
    private final JSONObject playerOptions;

    private IFramePlayerOptions(JSONObject jSONObject) {
        this.playerOptions = jSONObject;
    }

    public String toString() {
        return this.playerOptions.toString();
    }

    public static IFramePlayerOptions getDefault() {
        return new Builder().build();
    }

    public static class Builder {
        private final JSONObject builderOptions = new JSONObject();
        private static final String AUTOPLAY = "autoplay";
        private static final String CONTROLS = "controls";
        private static final String ENABLE_JS_API = "enablejsapi";
        private static final String FS = "fs";
        private static final String ORIGIN = "origin";
        private static final String REL = "rel";
        private static final String SHOW_INFO = "showinfo";
        private static final String IV_LOAD_POLICY = "iv_load_policy";
        private static final String MODEST_BRANDING = "modestbranding";

        public Builder() {
            this.addInt(AUTOPLAY, 0);
            this.addInt(CONTROLS, 0);
            this.addInt(ENABLE_JS_API, 1);
            this.addInt(FS, 0);
            this.addString(ORIGIN, "https://www.youtube.com");
            this.addInt(REL, 0);
            this.addInt(SHOW_INFO, 0);
            this.addInt(IV_LOAD_POLICY, 3);
            this.addInt(MODEST_BRANDING, 1);
        }

        public Builder autoplay(int n) {
            this.addInt(AUTOPLAY, n);
            return this;
        }

        public Builder controls(int n) {
            this.addInt(CONTROLS, n);
            return this;
        }

        public Builder origin(@NonNull String string2) {
            this.addString(ORIGIN, string2);
            return this;
        }

        public Builder rel(int n) {
            this.addInt(REL, n);
            return this;
        }

        public Builder showInfo(int n) {
            this.addInt(SHOW_INFO, n);
            return this;
        }

        public Builder ivLoadPolicy(int n) {
            this.addInt(IV_LOAD_POLICY, n);
            return this;
        }

        public Builder modestBranding(int n) {
            this.addInt(MODEST_BRANDING, n);
            return this;
        }

        private void addString(@NonNull String string2, @NonNull String string3) {
            try {
                this.builderOptions.put(string2, (Object)string3);
            }
            catch (JSONException jSONException) {
                throw new RuntimeException("Illegal JSON value " + string2 + ": " + string3);
            }
        }

        private void addInt(@NonNull String string2, int n) {
            try {
                this.builderOptions.put(string2, n);
            }
            catch (JSONException jSONException) {
                throw new RuntimeException("Illegal JSON value " + string2 + ": " + n);
            }
        }

        public IFramePlayerOptions build() {
            return new IFramePlayerOptions(this.builderOptions);
        }
    }
}

