/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.backend;

import android.content.Context;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.App;
import com.appzilo.sdk.video.core.Error;
import com.appzilo.sdk.video.core.Http;
import com.appzilo.sdk.video.core.Result;
import com.appzilo.sdk.video.utils.SharedPreferencesUtil;
import com.appzilo.sdk.video.utils.Utils;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;

public class NoticeApi {
    public static final String NOTICE_RESPONSE = "notice_response";
    public static final String APP_KEY = "app_key";
    public static final String TYPE = "ty";
    private final String NOTICE_TAG = "notice_tag";
    private Context mContext;
    private String baseUrl = App.getIsLive() ? "https://www.appzilo.com/sdk_notice/?" : "https://www.uploadhub.com/appzilo/sdk_notice/?";

    public NoticeApi(Context context) {
        this.mContext = context;
    }

    public static NoticeResponse getNoticeResponse(Context context) {
        SharedPreferencesUtil sharedPreferencesUtil = new SharedPreferencesUtil(context);
        NoticeResponse noticeResponse = null;
        String string = sharedPreferencesUtil.getStringValue(NOTICE_RESPONSE, null);
        try {
            noticeResponse = (NoticeResponse)App.gson().fromJson(string, NoticeResponse.class);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        if (noticeResponse != null) {
            return NoticeApi.processResponse(noticeResponse);
        }
        return null;
    }

    private static NoticeResponse processResponse(NoticeResponse noticeResponse) {
        return noticeResponse;
    }

    public Result request(HashMap<String, String> hashMap) {
        NoticeResponse noticeResponse = null;
        if (!Utils.isOnline(this.mContext)) {
            return new Result(Error.OFFLINE);
        }
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        String string = hashMap.get(APP_KEY);
        hashMap.remove(APP_KEY);
        if (!hashMap2.containsKey(TYPE)) {
            hashMap2.put(TYPE, "video");
        }
        hashMap2.putAll(this.getParams("notice_tag"));
        hashMap2.putAll(hashMap);
        Http.Request request = Http.request(this.mContext, string).url(this.baseUrl).post(hashMap2).tag("notice_tag");
        Result result = request.send();
        if (result.isSuccess()) {
            SharedPreferencesUtil sharedPreferencesUtil = new SharedPreferencesUtil(this.mContext);
            String string2 = (String)result.getResult();
            try {
                noticeResponse = (NoticeResponse)App.gson().fromJson(string2, NoticeResponse.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                jsonSyntaxException.printStackTrace();
            }
            if (noticeResponse != null) {
                if (noticeResponse.credential.success) {
                    sharedPreferencesUtil.putStringValue(NOTICE_RESPONSE, string2);
                }
                return new Result(null, NoticeApi.processResponse(noticeResponse));
            }
            return new Result(Error.DATA);
        }
        return new Result(Error.NETWORK);
    }

    private Map<String, String> getParams(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (Utils.isDebug(this.mContext) && !App.getIsDebug()) {
            hashMap.put("dbg", "1");
        }
        switch (string) {
            case "notice_tag": {
                hashMap.put("view", "json");
                return hashMap;
            }
        }
        return hashMap;
    }
}

