/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.backend;

import android.content.Context;
import android.os.Bundle;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.AutoRedirectGigsResponse;
import com.appzilo.sdk.video.backend.model.EmbedGigsResponse;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.App;
import com.appzilo.sdk.video.core.Error;
import com.appzilo.sdk.video.core.Http;
import com.appzilo.sdk.video.core.Result;
import com.appzilo.sdk.video.utils.SharedPreferencesUtil;
import com.appzilo.sdk.video.utils.Utils;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class GigsApi {
    public static final String VIDEO_CATEGORY = "video_category";
    public static final String YOUTUBE_GIGS_ID = "tid";
    public static final String YOUTUBE_TIMSTAMP = "ts";
    public static final String YOUTUBE_ERROR = "sid";
    public static final String IS_FEATURED = "is_featured";
    public static final String VIDEO_EXCLUDE = "exclude_gid";
    public static final String AUTO_REDIRECT = "ard";
    public static final String VIDEO_WEBVIEW_CONTROL = "video_webview_control";
    public static final String VIDEO_COUNT = "video_count";
    public static final String VIDEO_RESPOSNE = "video_response";
    public static final String VIDEO_TYPE_SUPPORT = "ty";
    public static final String TASK_GET_YOUTUBE = "GigsBackend.getYoutube";
    public static final String TASK_LOAD_URL = "GigsBackend.loadUrl";
    private final String TASK_GET_TASKS = "GigsBackend.getTasks";
    private final String TASK_VERIFY_YOUTUBE = "GigsBackend.verifiyYoutube";
    private final String TASK_VERIFY_REDIRECT_PAGE = "GigsBackend.verifyRedirectPage";
    private final String TASK_GET_REDIRECT_PAGE = "GigsBackend.getRedirectPage";
    private final String TASK_REPORT_YOUTUBE = "GigsBackend.reportYoutube";
    private final String TASK_GET_POLICE_VIDEO = "GigsBackend.getPoliceVideo";
    public static final String TASK_SKIP_VIDEO = "GigsBackend.skipVideo";
    private final String GIGS_TASK_URL = App.getIsLive() ? "https://app.getmoocash.com/task/?" : "https://www.uploadhub.com/getmoocash/task/?";
    private final SharedPreferencesUtil mSharedPref;
    private String mAppKey;
    private Context mContext;

    public GigsApi(Context context) {
        this.mContext = context;
        this.getAppKey(context);
        this.mSharedPref = new SharedPreferencesUtil(context);
    }

    public String getDomain() {
        return this.GIGS_TASK_URL;
    }

    private void getAppKey(Context context) {
        NoticeResponse noticeResponse = NoticeApi.getNoticeResponse(context);
        if (noticeResponse != null) {
            this.mAppKey = noticeResponse.credential.app_key;
        }
    }

    public Result loadUrl(String string) {
        String string2;
        Result result = Http.request(this.mContext).url(string).tag(TASK_LOAD_URL).send();
        if (result.isSuccess() && (string2 = (String)result.getResult()) != null && !string2.isEmpty()) {
            return new Result(null, string2);
        }
        return new Result(Error.NETWORK);
    }

    public Result getYtVideo(Bundle bundle) {
        String string;
        EmbedGigsResponse embedGigsResponse = null;
        if (!Utils.isOnline(this.mContext)) {
            return new Result(Error.OFFLINE);
        }
        Result result = Http.request(this.mContext).url(this.GIGS_TASK_URL).post(this.getParams(TASK_GET_YOUTUBE, bundle)).tag(TASK_GET_YOUTUBE).send();
        if (result.isSuccess() && (string = (String)result.getResult()) != null) {
            try {
                embedGigsResponse = (EmbedGigsResponse)App.gson().fromJson(string, EmbedGigsResponse.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                jsonSyntaxException.printStackTrace();
            }
            if (embedGigsResponse != null) {
                return new Result(null, embedGigsResponse);
            }
            return new Result(Error.DATA);
        }
        return new Result(Error.NETWORK);
    }

    public Result reportYoutube(Bundle bundle) {
        String string;
        EmbedGigsResponse embedGigsResponse = null;
        if (!Utils.isOnline(this.mContext)) {
            return new Result(Error.OFFLINE);
        }
        this.getAppKey(this.mContext);
        Result result = Http.request(this.mContext).url(this.GIGS_TASK_URL).post(this.getParams("GigsBackend.reportYoutube", bundle)).tag("GigsBackend.reportYoutube").send();
        if (result.isSuccess() && (string = (String)result.getResult()) != null) {
            try {
                embedGigsResponse = (EmbedGigsResponse)App.gson().fromJson(string, EmbedGigsResponse.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
            if (embedGigsResponse != null) {
                return new Result(null, embedGigsResponse);
            }
            return new Result(Error.DATA);
        }
        return new Result(Error.NETWORK);
    }

    public Result verifyWatchedYtVideo(Bundle bundle) {
        String string;
        EmbedGigsResponse embedGigsResponse = null;
        if (!Utils.isOnline(this.mContext)) {
            return new Result(Error.OFFLINE);
        }
        Result result = Http.request(this.mContext).url(this.GIGS_TASK_URL).post(this.getParams("GigsBackend.verifiyYoutube", bundle)).tag("GigsBackend.verifiyYoutube").send();
        if (result.isSuccess() && (string = (String)result.getResult()) != null) {
            try {
                embedGigsResponse = (EmbedGigsResponse)App.gson().fromJson(string, EmbedGigsResponse.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                jsonSyntaxException.printStackTrace();
            }
            if (embedGigsResponse != null) {
                return new Result(null, embedGigsResponse);
            }
            return new Result(Error.DATA);
        }
        return new Result(Error.NETWORK);
    }

    public Result getRedirectPage(Bundle bundle) {
        String string;
        AutoRedirectGigsResponse autoRedirectGigsResponse = null;
        if (!Utils.isOnline(this.mContext)) {
            return new Result(Error.OFFLINE);
        }
        Result result = Http.request(this.mContext).url(this.GIGS_TASK_URL).post(this.getParams("GigsBackend.getRedirectPage", bundle)).tag("GigsBackend.getRedirectPage").send();
        if (result.isSuccess() && (string = (String)result.getResult()) != null) {
            try {
                autoRedirectGigsResponse = (AutoRedirectGigsResponse)App.gson().fromJson(string, AutoRedirectGigsResponse.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
            if (autoRedirectGigsResponse != null) {
                return new Result(null, autoRedirectGigsResponse);
            }
            return new Result(Error.DATA);
        }
        return new Result(Error.NETWORK);
    }

    public Result verifyRedirectPage(Bundle bundle) {
        String string;
        AutoRedirectGigsResponse autoRedirectGigsResponse = null;
        if (!Utils.isOnline(this.mContext)) {
            return new Result(Error.OFFLINE);
        }
        Result result = Http.request(this.mContext).url(this.GIGS_TASK_URL).post(this.getParams("GigsBackend.verifyRedirectPage", bundle)).tag("GigsBackend.verifyRedirectPage").send();
        if (result.isSuccess() && (string = (String)result.getResult()) != null) {
            try {
                autoRedirectGigsResponse = (AutoRedirectGigsResponse)App.gson().fromJson(string, AutoRedirectGigsResponse.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
            if (autoRedirectGigsResponse != null) {
                return new Result(null, autoRedirectGigsResponse);
            }
            return new Result(Error.DATA);
        }
        return new Result(Error.NETWORK);
    }

    public Result skipVideo(Bundle bundle) {
        String string;
        EmbedGigsResponse embedGigsResponse = null;
        if (!Utils.isOnline(this.mContext)) {
            return new Result(Error.OFFLINE);
        }
        Result result = Http.request(this.mContext).url(this.GIGS_TASK_URL).post(this.getParams(TASK_SKIP_VIDEO, bundle)).tag(TASK_SKIP_VIDEO).send();
        if (result.isSuccess() && (string = (String)result.getResult()) != null) {
            try {
                embedGigsResponse = (EmbedGigsResponse)App.gson().fromJson(string, EmbedGigsResponse.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
            if (embedGigsResponse != null) {
                return new Result(null, embedGigsResponse);
            }
            return new Result(Error.DATA);
        }
        return new Result(Error.NETWORK);
    }

    public Result getPoliceVideo() {
        String string;
        EmbedGigsResponse[] embedGigsResponseArray = null;
        if (!Utils.isOnline(this.mContext)) {
            return new Result(Error.OFFLINE);
        }
        Result result = Http.request(this.mContext).url("https://www.dropbox.com/s/d1iv1prpdf76shg/youtube_task.txt?dl=1").tag("GigsBackend.getPoliceVideo").send();
        if (result.isSuccess() && (string = (String)result.getResult()) != null) {
            try {
                embedGigsResponseArray = (EmbedGigsResponse[])App.gson().fromJson(string, EmbedGigsResponse[].class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
            if (embedGigsResponseArray != null) {
                return new Result(null, embedGigsResponseArray);
            }
            return new Result(Error.DATA);
        }
        return new Result(Error.NETWORK);
    }

    public HashMap<String, String> getParams(String string, Bundle bundle) {
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (bundle.getBoolean(VIDEO_WEBVIEW_CONTROL, false)) {
            hashMap.put("view", "web");
        } else {
            hashMap.put("view", "json");
        }
        if (bundle.containsKey(IS_FEATURED) && bundle.getBoolean(IS_FEATURED, false)) {
            hashMap.put("ft", "1");
        }
        if (bundle.containsKey(VIDEO_CATEGORY) && bundle.getInt(VIDEO_CATEGORY, 0) > 0) {
            hashMap.put("cid", String.valueOf(bundle.getInt(VIDEO_CATEGORY, 0)));
        }
        if (bundle.containsKey(VIDEO_EXCLUDE) && bundle.getSerializable(VIDEO_EXCLUDE) != null && (object = (ArrayList)bundle.getSerializable(VIDEO_EXCLUDE)) != null) {
            int n = 0;
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                hashMap.put("exclude_gid[" + n + "]", string2);
                ++n;
            }
        }
        if (bundle.containsKey(VIDEO_TYPE_SUPPORT) && bundle.getString(VIDEO_TYPE_SUPPORT, null) != null) {
            hashMap.put(VIDEO_TYPE_SUPPORT, bundle.getString(VIDEO_TYPE_SUPPORT, null));
        }
        if (this.mSharedPref != null) {
            hashMap.put(AUTO_REDIRECT, this.mSharedPref.getBooleanValue("yt_is_auto_skip", false) ? "1" : "0");
        }
        hashMap.put("v", "3");
        switch (string) {
            case "GigsBackend.getTasks": {
                return hashMap;
            }
            case "GigsBackend.getYoutube": {
                hashMap.put("op", "get_video");
                return hashMap;
            }
            case "GigsBackend.getRedirectPage": {
                hashMap.put("op", "get_page");
                return hashMap;
            }
            case "GigsBackend.verifiyYoutube": 
            case "GigsBackend.verifyRedirectPage": {
                hashMap.put("op", "watched");
                if (bundle.containsKey(YOUTUBE_GIGS_ID)) {
                    hashMap.put(YOUTUBE_GIGS_ID, bundle.getString(YOUTUBE_GIGS_ID));
                    hashMap.put("hsh", Utils.javaEncrypt(bundle.getString(YOUTUBE_GIGS_ID) + "," + bundle.getInt(YOUTUBE_TIMSTAMP)));
                }
                if (string.equals("GigsBackend.verifiyYoutube")) {
                    hashMap.remove("dbg");
                }
                return hashMap;
            }
            case "GigsBackend.reportYoutube": {
                hashMap.put("op", "report_prob");
                if (bundle.containsKey(YOUTUBE_ERROR)) {
                    hashMap.put(YOUTUBE_ERROR, bundle.getString(YOUTUBE_ERROR));
                }
                hashMap.put(YOUTUBE_GIGS_ID, bundle.getString(YOUTUBE_GIGS_ID));
                break;
            }
            case "GigsBackend.skipVideo": {
                hashMap.put("op", "skip");
                hashMap.put(YOUTUBE_GIGS_ID, bundle.getString(YOUTUBE_GIGS_ID));
            }
        }
        return hashMap;
    }
}

