package com.appzilo.sdk.video.player;

import android.support.annotation.NonNull;

import com.appzilo.sdk.video.player.listeners.VideoPlayerListener;

public interface VideoPlayer {
    /**
     * Loads and automatically plays the specified video.
     * @param videoId id of the video
     * @param startSeconds the time from which the video should start playing
     */
    void loadVideo(@NonNull final String videoId, final float startSeconds);

    void loadChannel(@NonNull final String channelId);

    /**
     * Loads the specified video's thumbnail and prepares the player to play the video. Does not automatically play the video.
     * @param videoId id of the video
     * @param startSeconds the time from which the video should start playing
     */
    void cueVideo(@NonNull final String videoId, final float startSeconds);

    void play();
    void pause();

    /**
     * @param volumePercent Integer between 0 and 100
     */
    void setVolume(final int volumePercent);

    void setMute(final boolean mute);

    /**
     *
     * @param time The absolute time in seconds to seek to
     */
    void seekTo(final float time);

    boolean addListener(@NonNull VideoPlayerListener listener);
    boolean removeListener(@NonNull VideoPlayerListener listener);
}
