/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video;

import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.appzilo.sdk.video.R;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.Logger;
import com.appzilo.sdk.video.utils.SharedPreferencesUtil;
import java.util.HashMap;

public class WebviewFragment
extends Fragment
implements SwipeRefreshLayout.OnRefreshListener {
    public static final String TITLE = "webview.title";
    public static final String IS_HOME = "webview.isHome";
    public static final String HIDE_ACTION_BAR = "webview.hide_actionbar";
    public static final String FORCE_REFRESH = "webview.profile.refresh";
    public static final String URL = "url";
    private static final String TASK_INIT = "webview_fragment.init";
    private WebView mWebView;
    private String mUrl;
    private Toolbar mToolbar;
    private View mView;
    private boolean hideActionBar;
    private SwipeRefreshLayout mRefresh;
    private Handler mainThreadHandler;
    private SharedPreferencesUtil mPref;

    public static WebviewFragment newInstance(Bundle bundle) {
        WebviewFragment webviewFragment = new WebviewFragment();
        if (bundle == null) {
            bundle = new Bundle();
        }
        webviewFragment.setArguments(bundle);
        return webviewFragment;
    }

    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        Bundle bundle2 = this.getArguments();
        if (bundle2 != null) {
            this.mUrl = bundle2.getString(URL);
        }
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
        this.mPref = new SharedPreferencesUtil(this.getContext());
    }

    @Nullable
    public View onCreateView(LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        this.mView = layoutInflater.inflate(R.layout.fragment_webview, viewGroup, false);
        this.mRefresh = (SwipeRefreshLayout)this.mView.findViewById(R.id.swipeContainer);
        this.mRefresh.setEnabled(false);
        this.mRefresh.setColorSchemeResources(new int[]{R.color.primary});
        this.mWebView = (WebView)this.mView.findViewById(R.id.web);
        return this.mView;
    }

    public void onViewCreated(View view, @Nullable Bundle bundle) {
        super.onViewCreated(view, bundle);
        WebSettings webSettings = this.mWebView.getSettings();
        if (Build.VERSION.SDK_INT >= 17) {
            webSettings.setMediaPlaybackRequiresUserGesture(false);
        } else {
            webSettings.setPluginState(WebSettings.PluginState.ON);
        }
        webSettings.setJavaScriptEnabled(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setAllowFileAccess(true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NoticeResponse noticeResponse = NoticeApi.getNoticeResponse(this.getContext());
        if (noticeResponse != null && noticeResponse.credential != null && noticeResponse.credential.app_key != null) {
            hashMap.put("App-Key", noticeResponse.credential.app_key);
        }
        if (this.mPref.getStringValue("moo_dbm", null) != null) {
            String string2 = this.mPref.getStringValue("dbm", null);
            String string3 = this.mPref.getStringValue("moo_dbm", null);
            this.mUrl = this.mUrl + "&dbm=" + string2 + "&dbm+key=" + string3;
        }
        Logger.e("mUrl:" + this.mUrl);
        this.mWebView.loadUrl(this.mUrl, hashMap);
        this.mWebView.addJavascriptInterface((Object)new OtherWebViewJavascriptInterface(), "PlayerBridge");
        this.mWebView.setWebViewClient((WebViewClient)new OtherWebViewClient());
        this.mWebView.setWebChromeClient(new WebChromeClient());
    }

    public void onResume() {
        super.onResume();
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebviewFragment.this.mWebView.loadUrl("javascript:playVideo()");
            }
        });
    }

    public void onPause() {
        super.onPause();
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebviewFragment.this.mWebView.loadUrl("javascript:pauseVideo()");
            }
        });
    }

    public void onDestroy() {
        this.mainThreadHandler.removeCallbacksAndMessages(null);
        super.onDestroy();
    }

    public void onRefresh() {
        this.mWebView.reload();
    }

    public class OtherWebViewJavascriptInterface {
        @JavascriptInterface
        public void onFinish() {
            if (WebviewFragment.this.getActivity() != null) {
                WebviewFragment.this.getActivity().finish();
            }
        }
    }

    private class OtherWebViewClient
    extends WebViewClient {
        private OtherWebViewClient() {
        }

        public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
            super.onPageStarted(webView, string2, bitmap);
            WebviewFragment.this.mRefresh.setRefreshing(true);
        }

        public void onPageFinished(WebView webView, String string2) {
            super.onPageFinished(webView, string2);
            WebviewFragment.this.mRefresh.setRefreshing(false);
            webView.setVisibility(0);
        }
    }
}

