/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.content.LocalBroadcastManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.appzilo.sdk.video.CustomVideoUIController;
import com.appzilo.sdk.video.EmbedDoubleVideoActivity;
import com.appzilo.sdk.video.R;
import com.appzilo.sdk.video.backend.GigsApi;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.EmbedGigsResponse;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.App;
import com.appzilo.sdk.video.core.BackgroundWorker;
import com.appzilo.sdk.video.core.Result;
import com.appzilo.sdk.video.player.VideoPlayer;
import com.appzilo.sdk.video.player.VideoPlayerView;
import com.appzilo.sdk.video.player.listeners.VideoPlayerInitListener;
import java.util.ArrayList;

public class EmbedVideoFragment
extends Fragment
implements CustomVideoUIController.Listener,
BackgroundWorker.Callbacks,
VideoPlayerInitListener {
    public static final String EMBED_PAGE = "page";
    private String TASK_GET_VIDEO = "video_task_init";
    private String TASK_GET_SAME_VIDEO = "video_task_same_init";
    private String TASK_VERIFY_VIDEO = "video_task_verify";
    private String TASK_REPORT_VIDEO = "video_task_report";
    private String TASK_SKIP_VIDEO = "video_task_skip";
    private String OBJ_GIGS_BACKEND = "gigs_backend.video";
    private VideoPlayerView mYouTubePlayerView;
    private CustomVideoUIController mCustomPlayerUIController;
    private View mCustomPlayerUI;
    private BackgroundWorker mWorker;
    private GigsApi mGigsBackend;
    private NoticeResponse mNoticeResponse;
    private EmbedGigsResponse mVideoGigsResponse;
    private int mPage;
    private EmbedVideoInterface mListener;

    public static EmbedVideoFragment newInstance(Bundle bundle) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        EmbedVideoFragment embedVideoFragment = new EmbedVideoFragment();
        embedVideoFragment.setArguments(bundle);
        return embedVideoFragment;
    }

    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        if (this.getActivity() != null) {
            this.mWorker = new BackgroundWorker(this.getActivity());
            this.mGigsBackend = (GigsApi)this.mWorker.get(this.OBJ_GIGS_BACKEND);
            if (this.mGigsBackend == null) {
                this.mGigsBackend = new GigsApi(this.getContext());
                this.mWorker.put(this.OBJ_GIGS_BACKEND, this.mGigsBackend);
            }
            this.mNoticeResponse = NoticeApi.getNoticeResponse(this.getContext());
            String string2 = null;
            if (this.getArguments() != null) {
                string2 = this.getArguments().getString("video_response", null);
                this.mPage = this.getArguments().getInt(EMBED_PAGE);
                this.TASK_GET_VIDEO = this.TASK_GET_VIDEO + this.mPage;
                this.TASK_VERIFY_VIDEO = this.TASK_VERIFY_VIDEO + this.mPage;
                this.TASK_REPORT_VIDEO = this.TASK_REPORT_VIDEO + this.mPage;
                this.TASK_SKIP_VIDEO = this.TASK_SKIP_VIDEO + this.mPage;
                this.TASK_GET_SAME_VIDEO = this.TASK_GET_SAME_VIDEO + this.mPage;
            }
            if (string2 != null) {
                this.mVideoGigsResponse = (EmbedGigsResponse)App.gson().fromJson(this.getArguments().getString("video_response"), EmbedGigsResponse.class);
            }
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.fragment_embed_video, viewGroup, false);
        this.mYouTubePlayerView = (VideoPlayerView)view.findViewById(R.id.player);
        this.mCustomPlayerUI = this.mYouTubePlayerView.inflateCustomPlayerUI(R.layout.custom_video_ui);
        this.mYouTubePlayerView.initialize(this, true);
        if (this.getActivity() != null) {
            ((EmbedDoubleVideoActivity)this.getActivity()).addLifecycleObserver(this.mYouTubePlayerView);
        }
        return view;
    }

    public void onResume() {
        super.onResume();
        if (this.getView() != null) {
            this.getView().clearFocus();
        }
        if (this.mCustomPlayerUIController != null) {
            this.mCustomPlayerUIController.onResume();
        }
    }

    public void onPause() {
        super.onPause();
        if (this.mCustomPlayerUIController != null) {
            this.mCustomPlayerUIController.onPause();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mCustomPlayerUIController != null) {
            this.mCustomPlayerUIController.onDestroy();
        }
    }

    @Override
    public Result executeTaskInBackground(String string2, Bundle bundle) {
        ArrayList<String> arrayList;
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (this.getActivity() != null && this.getActivity() instanceof EmbedDoubleVideoActivity && (arrayList = new ArrayList<String>(((EmbedDoubleVideoActivity)this.getActivity()).getCurrentPlayingGid())).size() > 0) {
            arrayList.remove(this.mVideoGigsResponse.gid);
            bundle.putSerializable("exclude_gid", arrayList);
        }
        if (this.getArguments() != null) {
            bundle.putBoolean("is_featured", this.getArguments().getBoolean("is_featured", false));
            bundle.putInt("video_category", this.getArguments().getInt("video_category", 0));
        }
        if (string2.equals(this.TASK_GET_VIDEO) || string2.equals(this.TASK_GET_SAME_VIDEO)) {
            return this.mGigsBackend.getYtVideo(bundle);
        }
        if (string2.equals(this.TASK_VERIFY_VIDEO)) {
            return this.mGigsBackend.verifyWatchedYtVideo(bundle);
        }
        if (string2.equals(this.TASK_REPORT_VIDEO)) {
            return this.mGigsBackend.reportYoutube(bundle);
        }
        if (string2.equals(this.TASK_SKIP_VIDEO)) {
            return this.mGigsBackend.skipVideo(bundle);
        }
        return null;
    }

    @Override
    public void onBackgroundTaskCompleted(String string2, Result result) {
        if (string2.equals(this.TASK_GET_VIDEO)) {
            this.mVideoGigsResponse = (EmbedGigsResponse)result.getResult();
            this.mCustomPlayerUIController.initializeYtVideoInfo(this.mVideoGigsResponse);
            return;
        }
        if ((string2.equals(this.TASK_VERIFY_VIDEO) || string2.equals(this.TASK_REPORT_VIDEO) || string2.equals(this.TASK_SKIP_VIDEO) || string2.equals(this.TASK_GET_SAME_VIDEO)) && result.isSuccess()) {
            EmbedGigsResponse embedGigsResponse = (EmbedGigsResponse)result.getResult();
            if (embedGigsResponse != null && embedGigsResponse.gid != null && this.getActivity() != null) {
                if (this.getActivity() != null && ((EmbedDoubleVideoActivity)this.getActivity()).isVideoIdExist(embedGigsResponse.gid) && !embedGigsResponse.gid.equals(this.mCustomPlayerUIController.getPlayingVideoId())) {
                    this.mWorker.executeTask(this.TASK_GET_SAME_VIDEO, null, this);
                    return;
                }
                this.mVideoGigsResponse = embedGigsResponse;
                ((EmbedDoubleVideoActivity)this.getActivity()).addPlayingGid(embedGigsResponse.gid);
            }
            this.mCustomPlayerUIController.verifiedYtVideo(embedGigsResponse);
            Intent intent = new Intent("gigs_force_refresh_receiver");
            if (this.getContext() != null) {
                LocalBroadcastManager.getInstance((Context)this.getContext()).sendBroadcast(intent);
            }
            return;
        }
        this.videoNotAvailable();
    }

    public String getCurrentPlayingVideoId() {
        return this.mCustomPlayerUIController.getPlayingVideoId();
    }

    @Override
    public void videoReachEndpoint(String string2, int n) {
        if (this.mNoticeResponse != null && !this.mNoticeResponse.is_police) {
            Bundle bundle = new Bundle();
            bundle.putString("tid", string2);
            bundle.putInt("ts", n);
            this.mWorker.executeTask(this.TASK_VERIFY_VIDEO, bundle, this);
        } else {
            this.videoNotAvailable();
        }
    }

    @Override
    public void skipVideo(String string2) {
        if (this.mNoticeResponse != null && !this.mNoticeResponse.is_police) {
            Bundle bundle = new Bundle();
            bundle.putString("tid", string2);
            this.mWorker.executeTask(this.TASK_SKIP_VIDEO, bundle, this);
        } else {
            this.videoNotAvailable();
        }
    }

    @Override
    public void videoNotAvailable() {
        if (this.getActivity() != null && !this.getActivity().isFinishing() && this.mListener != null) {
            this.mListener.videoNotAvailable(this.mPage);
        }
    }

    @Override
    public void forceStopVideo() {
        if (this.getActivity() != null && !this.getActivity().isFinishing()) {
            this.getActivity().finish();
        }
    }

    @Override
    public void youtubePlayableError(String string2, String string3) {
        Bundle bundle = new Bundle();
        bundle.putString("tid", string2);
        bundle.putString("sid", string3);
        this.mWorker.executeTask(this.TASK_REPORT_VIDEO, bundle, this);
    }

    @Override
    public void enablePictureInPicture() {
    }

    public void setListener(EmbedVideoInterface embedVideoInterface) {
        this.mListener = embedVideoInterface;
    }

    public void setMute(boolean bl) {
        if (this.mCustomPlayerUIController != null) {
            this.mCustomPlayerUIController.setMute(bl);
        }
    }

    public void setVolumeControl(boolean bl) {
        if (this.mCustomPlayerUIController != null) {
            this.mCustomPlayerUIController.setVolumeControl(bl);
        }
    }

    public void reload() {
        if (this.mCustomPlayerUIController != null) {
            this.mCustomPlayerUIController.reload();
        }
    }

    @Override
    public void onInitSuccess(@NonNull VideoPlayer videoPlayer) {
        if (this.mCustomPlayerUIController == null) {
            this.mCustomPlayerUIController = new CustomVideoUIController((Activity)this.getActivity(), this, this.mPage, this.mCustomPlayerUI, videoPlayer, this.mYouTubePlayerView, this.mNoticeResponse != null ? this.mNoticeResponse.passive_video_interval * 1000 : 0, this.mNoticeResponse != null && this.mNoticeResponse.is_police);
            videoPlayer.addListener(this.mCustomPlayerUIController);
            this.mCustomPlayerUIController.initializeYtVideoInfo(this.mVideoGigsResponse);
        }
    }

    public static interface EmbedVideoInterface {
        public void videoNotAvailable(int var1);
    }
}

