package com.appzilo.sdk.video.backend;

import android.content.Context;
import android.os.Bundle;

import com.appzilo.sdk.video.CustomVideoUIController;
import com.appzilo.sdk.video.backend.model.AutoRedirectGigsResponse;
import com.appzilo.sdk.video.backend.model.EmbedGigsResponse;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.App;
import com.appzilo.sdk.video.core.Error;
import com.appzilo.sdk.video.core.Http;
import com.appzilo.sdk.video.core.Result;
import com.appzilo.sdk.video.utils.SharedPreferencesUtil;
import com.appzilo.sdk.video.utils.Utils;
import com.google.gson.JsonSyntaxException;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class GigsApi {


    //params variable name
    public static final String VIDEO_CATEGORY = "video_category";
    public static final String YOUTUBE_GIGS_ID = "tid";
    public static final String YOUTUBE_TIMSTAMP = "ts";
    public static final String YOUTUBE_ERROR = "sid";
    public static final String IS_FEATURED = "is_featured";
    public static final String VIDEO_EXCLUDE = "exclude_gid";
    public static final String AUTO_REDIRECT = "ard";
    public static final String VIDEO_WEBVIEW_CONTROL = "video_webview_control";
    public static final String VIDEO_COUNT = "video_count";

    public static final String VIDEO_RESPOSNE = "video_response";
    public static final String VIDEO_TYPE_SUPPORT = "ty";
    public static final String TASK_GET_YOUTUBE = "GigsBackend.getYoutube";
    private final String TASK_GET_TASKS = "GigsBackend.getTasks";
    private final String TASK_VERIFY_YOUTUBE = "GigsBackend.verifiyYoutube";
    private final String TASK_VERIFY_REDIRECT_PAGE = "GigsBackend.verifyRedirectPage";
    private final String TASK_GET_REDIRECT_PAGE = "GigsBackend.getRedirectPage";
    private final String TASK_REPORT_YOUTUBE = "GigsBackend.reportYoutube";
    private final String TASK_GET_POLICE_VIDEO = "GigsBackend.getPoliceVideo";
    public static final String TASK_SKIP_VIDEO = "GigsBackend.skipVideo";
    private final String GIGS_TASK_URL = App.getIsLive() ? "https://app.getmoocash.com/task/?" : "https://www.uploadhub.com/getmoocash/task/?";
    private final SharedPreferencesUtil mSharedPref;

    private String mAppKey;
    private Context mContext;

    public GigsApi(Context context) {
        mContext = context;
        getAppKey(context);
        mSharedPref = new SharedPreferencesUtil(context);
    }

    public String getDomain(){
        return GIGS_TASK_URL;
    }

    private void getAppKey(Context context){
        NoticeResponse response = NoticeApi.getNoticeResponse(context);
        if (response != null) {
            mAppKey = response.credential.app_key;
        }
    }

    public Result getYtVideo(Bundle args) {
        EmbedGigsResponse response = null;
        if (!Utils.isOnline(mContext)) {
            return new Result(Error.OFFLINE);
        }
        Result result = Http.request(mContext)
                .url(GIGS_TASK_URL)
                .post(getParams(TASK_GET_YOUTUBE, args))
                .tag(TASK_GET_YOUTUBE)
                .send();

        if (result.isSuccess()) {
            String responseText = (String) result.getResult();
            if (responseText != null) {
                try {
                    response = App.gson().fromJson(responseText, EmbedGigsResponse.class);
                } catch (JsonSyntaxException ex) {
                    ex.printStackTrace();
                }
                if (response != null) {
                    return new Result(null, response);
                }
                return new Result(Error.DATA);
            }
        }
        return new Result(Error.NETWORK);
    }

    public Result reportYoutube(Bundle args) {
        EmbedGigsResponse response = null;
        if (!Utils.isOnline(mContext)) {
            return new Result(Error.OFFLINE);
        }
        getAppKey(mContext);
        Result result = Http.request(mContext)
                .url(GIGS_TASK_URL)
                .post(getParams(TASK_REPORT_YOUTUBE, args))
                .tag(TASK_REPORT_YOUTUBE)
                .send();
        if (result.isSuccess()) {
            String responseText = (String) result.getResult();
            if (responseText != null) {
                try {
                    response = App.gson().fromJson(responseText, EmbedGigsResponse.class);
                } catch (JsonSyntaxException ignored) {
                }
                if (response != null) {
                    return new Result(null, response);
                }
                return new Result(Error.DATA);
            }
        }
        return new Result(Error.NETWORK);
    }

    public Result verifyWatchedYtVideo(Bundle args) {
        EmbedGigsResponse response = null;
        if (!Utils.isOnline(mContext)) {
            return new Result(Error.OFFLINE);
        }
        Result result = Http.request(mContext)
                .url(GIGS_TASK_URL)
                .post(getParams(TASK_VERIFY_YOUTUBE, args))
                .tag(TASK_VERIFY_YOUTUBE)
                .send();

        if (result.isSuccess()) {
            String responseText = (String) result.getResult();
            if (responseText != null) {
                try {
                    response = App.gson().fromJson(responseText, EmbedGigsResponse.class);
                } catch (JsonSyntaxException ex) {
                    ex.printStackTrace();
                }
                if (response != null) {
                    return new Result(null, response);
                }
                return new Result(Error.DATA);
            }
        }
        return new Result(Error.NETWORK);
    }

    public Result getRedirectPage(Bundle args) {
        AutoRedirectGigsResponse response = null;
        if (!Utils.isOnline(mContext)) {
            return new Result(Error.OFFLINE);
        }
        Result result = Http.request(mContext)
                .url(GIGS_TASK_URL)
                .post(getParams(TASK_GET_REDIRECT_PAGE, args))
                .tag(TASK_GET_REDIRECT_PAGE)
                .send();

        if (result.isSuccess()) {
            String responseText = (String) result.getResult();
            if (responseText != null) {
                try {
                    response = App.gson().fromJson(responseText, AutoRedirectGigsResponse.class);
                } catch (JsonSyntaxException ignored) {
                }
                if (response != null) {
                    return new Result(null, response);
                }
                return new Result(Error.DATA);
            }
        }
        return new Result(Error.NETWORK);
    }

    public Result verifyRedirectPage(Bundle args) {
        AutoRedirectGigsResponse response = null;
        if (!Utils.isOnline(mContext)) {
            return new Result(Error.OFFLINE);
        }

        Result result = Http.request(mContext)
                .url(GIGS_TASK_URL)
                .post(getParams(TASK_VERIFY_REDIRECT_PAGE, args))
                .tag(TASK_VERIFY_REDIRECT_PAGE)
                .send();

        if (result.isSuccess()) {
            String responseText = (String) result.getResult();
            if (responseText != null) {
                try {
                    response = App.gson().fromJson(responseText, AutoRedirectGigsResponse.class);
                } catch (JsonSyntaxException ignored) {
                }
                if (response != null) {
                    return new Result(null, response);
                }
                return new Result(Error.DATA);
            }
        }
        return new Result(Error.NETWORK);
    }

    public Result skipVideo(Bundle args) {
        EmbedGigsResponse response = null;
        if (!Utils.isOnline(mContext)) {
            return new Result(Error.OFFLINE);
        }

        Result result = Http.request(mContext)
                .url(GIGS_TASK_URL)
                .post(getParams(TASK_SKIP_VIDEO, args))
                .tag(TASK_SKIP_VIDEO)
                .send();
        if (result.isSuccess()) {
            String responseText = (String) result.getResult();
            if (responseText != null) {
                try {
                    response = App.gson().fromJson(responseText, EmbedGigsResponse.class);
                } catch (JsonSyntaxException ignored) {
                }
                if (response != null) {
                    return new Result(null, response);
                }
                return new Result(Error.DATA);
            }
        }
        return new Result(Error.NETWORK);
    }

    public Result getPoliceVideo() {
        EmbedGigsResponse[] response = null;
        if (!Utils.isOnline(mContext)) {
            return new Result(Error.OFFLINE);
        }
        Result result = Http.request(mContext)
                .url("https://www.dropbox.com/s/d1iv1prpdf76shg/youtube_task.txt?dl=1")
                .tag(TASK_GET_POLICE_VIDEO)
                .send();
        if (result.isSuccess()) {
            String responseText = (String) result.getResult();
            if (responseText != null) {
                try {
                    response = App.gson().fromJson(responseText, EmbedGigsResponse[].class);
                } catch (JsonSyntaxException ignored) {
                }
                if (response != null) {
                    return new Result(null, response);
                }
                return new Result(Error.DATA);
            }
        }
        return new Result(Error.NETWORK);
    }

    public HashMap<String, String> getParams(String tag, Bundle args) {
        HashMap<String, String> params = new HashMap<>();
        if(args.getBoolean(VIDEO_WEBVIEW_CONTROL, false)){
            params.put("view", "web");
        }
        else{
            params.put("view", "json");
        }

//        params.put("dbg", "1");
        if (args.containsKey(IS_FEATURED) && args.getBoolean(IS_FEATURED, false)) {
            params.put("ft", "1");
        }
        if (args.containsKey(VIDEO_CATEGORY) && args.getInt(VIDEO_CATEGORY, 0) > 0) {
            params.put("cid", String.valueOf(args.getInt(VIDEO_CATEGORY, 0)));
        }
        if(args.containsKey(VIDEO_EXCLUDE) && args.getSerializable(VIDEO_EXCLUDE) != null){
            ArrayList<String> gidList = (ArrayList<String>) args.getSerializable(VIDEO_EXCLUDE);
            if(gidList != null){
                int i = 0;
                for(String gid: gidList){
                    params.put(VIDEO_EXCLUDE+"["+i+"]", gid);
                    i++;
                }
            }
        }

        if(args.containsKey(VIDEO_TYPE_SUPPORT) && args.getString(VIDEO_TYPE_SUPPORT, null) != null){
            params.put(VIDEO_TYPE_SUPPORT, args.getString(VIDEO_TYPE_SUPPORT, null));
        }

        if(mSharedPref != null){
            params.put(AUTO_REDIRECT,  mSharedPref.getBooleanValue(CustomVideoUIController.YT_IS_AUTO_SKIP, false)?"1":"0");
        }

        params.put("v", "3");
        switch (tag) {
            case TASK_GET_TASKS:
                return params;
            case TASK_GET_YOUTUBE:
                params.put("op", "get_video");
                return params;
            case TASK_GET_REDIRECT_PAGE:
                params.put("op", "get_page");
                return params;
            case TASK_VERIFY_YOUTUBE:
            case TASK_VERIFY_REDIRECT_PAGE:
                params.put("op", "watched");
                if (args.containsKey(YOUTUBE_GIGS_ID)) {
                    params.put(YOUTUBE_GIGS_ID, args.getString(YOUTUBE_GIGS_ID));
                    params.put("hsh", Utils.javaEncrypt(args.getString(YOUTUBE_GIGS_ID) + "," + args.getInt(YOUTUBE_TIMSTAMP)));
                }
                if (tag.equals(TASK_VERIFY_YOUTUBE)) {
                    params.remove("dbg");
                }
                return params;
            case TASK_REPORT_YOUTUBE:
                params.put("op", "report_prob");
                if (args.containsKey(YOUTUBE_ERROR))
                    params.put(YOUTUBE_ERROR, args.getString(YOUTUBE_ERROR));
                params.put(YOUTUBE_GIGS_ID, args.getString(YOUTUBE_GIGS_ID));
                break;
            case TASK_SKIP_VIDEO:
                params.put("op", "skip");
                params.put(YOUTUBE_GIGS_ID, args.getString(YOUTUBE_GIGS_ID));
                break;
        }
        return params;
    }


}
