package com.appzilo.sdk.video;

import android.graphics.Bitmap;
import android.graphics.drawable.ColorDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.BackgroundWorker;
import com.appzilo.sdk.video.core.Logger;
import com.appzilo.sdk.video.utils.SharedPreferencesUtil;

import java.util.HashMap;

public class WebviewFragment extends Fragment implements
        SwipeRefreshLayout.OnRefreshListener {

    public static final String TITLE = "webview.title";
    public static final String IS_HOME = "webview.isHome";
    public static final String HIDE_ACTION_BAR = "webview.hide_actionbar";

    public static final String FORCE_REFRESH = "webview.profile.refresh";
    public static final String URL = "url";
    private static final String TASK_INIT = "webview_fragment.init";

    private WebView mWebView;
    private String mUrl;
    private Toolbar mToolbar;
    private View mView;
    private boolean hideActionBar;
    private SwipeRefreshLayout mRefresh;
    private Handler mainThreadHandler;
    private SharedPreferencesUtil mPref;

    public static WebviewFragment newInstance(Bundle args) {
        WebviewFragment fragment = new WebviewFragment();
        if (args == null) {
            args = new Bundle();
        }
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = getArguments();
        if (args != null) {
            mUrl = args.getString(URL);
        }
        mainThreadHandler = new Handler(Looper.getMainLooper());
        mPref = new SharedPreferencesUtil(getContext());
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        mView = inflater.inflate(R.layout.fragment_webview, container, false);
//        mToolbar = mView.findViewById(R.id.toolbar);
        mRefresh = mView.findViewById(R.id.swipeContainer);
        mRefresh.setEnabled(false);
        mRefresh.setColorSchemeResources(R.color.primary);
        mWebView = mView.findViewById(R.id.web);
        return mView;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        WebSettings settings = mWebView.getSettings();
        if (Build.VERSION.SDK_INT >= 17) {
            settings.setMediaPlaybackRequiresUserGesture(false);
        }else {
            settings.setPluginState(WebSettings.PluginState.ON);
        }
        settings.setJavaScriptEnabled(true);
        settings.setDomStorageEnabled(true);
        settings.setAllowFileAccess(true);

        HashMap<String, String> extraHeaders = new HashMap<>();
        NoticeResponse noticeResponse = NoticeApi.getNoticeResponse(getContext());
        if (noticeResponse != null && noticeResponse.credential != null && noticeResponse.credential.app_key != null) {
            extraHeaders.put("App-Key", noticeResponse.credential.app_key);
        }

        if(mPref.getStringValue("moo_dbm", null) != null){
            String dbm = mPref.getStringValue("dbm", null);
            String dbm_key = mPref.getStringValue("moo_dbm", null);
            mUrl = mUrl + "&dbm="+dbm+"&dbm+key="+dbm_key;
        }

        Logger.e("mUrl:"+mUrl);

        mWebView.loadUrl(mUrl, extraHeaders);

        mWebView.addJavascriptInterface(new OtherWebViewJavascriptInterface(), "PlayerBridge");
        mWebView.setWebViewClient(new OtherWebViewClient());
        mWebView.setWebChromeClient(new WebChromeClient());

    }

    @Override
    public void onResume() {
        super.onResume();
        mainThreadHandler.post(new Runnable() {
            @Override
            public void run() {
                mWebView.loadUrl("javascript:playVideo()");
            }
        });
    }

    @Override
    public void onPause() {
        super.onPause();
        mainThreadHandler.post(new Runnable() {
            @Override
            public void run() {
                mWebView.loadUrl("javascript:pauseVideo()");
            }
        });
    }

    @Override
    public void onDestroy() {
        mainThreadHandler.removeCallbacksAndMessages(null);
        super.onDestroy();
    }

    @Override
    public void onRefresh() {
        mWebView.reload();
    }

    private class OtherWebViewClient extends WebViewClient{
        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            mRefresh.setRefreshing(true);
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            mRefresh.setRefreshing(false);
            view.setVisibility(View.VISIBLE);
        }
    }

     public class OtherWebViewJavascriptInterface {

        @JavascriptInterface
        public void onFinish() {
            if(getActivity() != null){
                getActivity().finish();
            }
        }
    }
}
