package com.appzilo.sdk.video;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.SwitchCompat;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewTreeObserver;
import android.view.animation.DecelerateInterpolator;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.akexorcist.roundcornerprogressbar.RoundCornerProgressBar;
import com.andexert.library.RippleView;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.EmbedGigsResponse;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.Logger;
import com.appzilo.sdk.video.player.PlayerConstants;
import com.appzilo.sdk.video.player.VideoPlayer;
import com.appzilo.sdk.video.player.VideoPlayerView;
import com.appzilo.sdk.video.player.listeners.AbstractVideoPlayerListener;
import com.appzilo.sdk.video.utils.ResourcesUtil;
import com.appzilo.sdk.video.utils.SharedPreferencesUtil;
import com.appzilo.sdk.video.utils.Utils;
import com.squareup.picasso.Picasso;

import java.util.Locale;

import static android.view.View.VISIBLE;

public class CustomVideoUIController extends AbstractVideoPlayerListener implements
        View.OnClickListener,
        CompoundButton.OnCheckedChangeListener {

    public static final String YT_IS_AUTO_SKIP = "yt_is_auto_skip";
    private static final String SKIP_DIALOG_VISIBILITY = "skip_dialog_visiblity";
    private SharedPreferencesUtil mPref;
    private int mDefaultInterval = 0;
    private int mDelayInterval = 10000;
    private Activity mActivity;
    private VideoPlayer youTubePlayerCallback;
    private Button mSkipButton;
    private View mLoadingBar;
    private View mPanel;
    private Listener mListener;
    private int mMinWatchTime;
    private String mIdVideoPlaying;
    private boolean mPlayerIsPlaying;
    private EmbedGigsResponse mNextYtInfo;
    private int mTimestamp;
    private boolean mFirstTime;
    private Handler mHandler;
    private SwitchCompat mAutoSkipToggle;
    private View mAutoSkipContainer;
    private Button mStopButton;
    private boolean mIsYtEnded;
    private boolean mIsPolice;
    private static final String ERROR_INVALID_PARAMETER_IN_REQUEST = "2";
    private static final String ERROR_HTML_5_PLAYER = "5";
    private static final String ERROR_VIDEO_NOT_FOUND = "100";
    private static final String ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER1 = "101";
    private static final String ERROR_VIDEO_LIVE_OFFLINE = "102";
    private static final String ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER2 = "150";
    private final int countdownInterval = 1000;
    private CountDownRunnable mCountDownRunnable;
    private boolean mIsOnPause;
    private float mCurrentSeconds;
    private VideoPlayerView mPlayerView;
    private String mVideoUniqueId;
    private View mLiveIndicator;
    private TextView mLiveStatus;
    private boolean mIsInitialize;
    private ErrorCountDownRunnable mErrorCountdown;
    private int mErrorReportMaxTime;
    private boolean mIsVideoHtmlExist;
    private Button mOpenButton;
    private String mVideoUrl;
    private String mVideoType;
    private EmbedGigsResponse mResponse;
    private int mPage;
    private ImageButton mVolume;
    private RippleView mOpenContainer, mSkipContainer, mVolumeContainer, mPipContainer;
    private boolean mFirstOnReady, mIsVideoStart = true;
    private boolean mIsMute;
    private TextView mSkipCoin;
    private RoundCornerProgressBar mSkipProgress;
    private View mSkipRevealView;
    private ImageButton mPipButton;
    private boolean mIsPipMode;
    private ProgressBar mSkipLoading;
    private int mTotalCoinEarned;
    private int mTotalTimeWatched;
    private View mSkipCoinContainer;
    private ImageView mSkipCoinImage;
    private boolean mIsVideoError;
    private ViewDelayRunnable mViewDelayRunnable;
    private DelayRunnable mDelayRunnable;
    private String mCoinImageUrl;
    private String mVirtualCoin;

    public CustomVideoUIController(Activity activity, Listener listener, View customPlayerUI, VideoPlayer youTubePlayerCallback, VideoPlayerView playerView, int videoInterval, boolean isPolice) {
        init(activity, listener, 0, customPlayerUI, youTubePlayerCallback, playerView, videoInterval, isPolice);
    }

    public CustomVideoUIController(Activity activity, Listener listener, int page, View customPlayerUI, VideoPlayer youTubePlayerCallback, VideoPlayerView playerView, int videoInterval, boolean isPolice) {
        init(activity, listener, page, customPlayerUI, youTubePlayerCallback, playerView, videoInterval, isPolice);
    }

    private void init(Activity activity, Listener listener, int page, View customPlayerUI, VideoPlayer youTubePlayerCallback, VideoPlayerView playerView, int videoInterval, boolean isPolice){
        mActivity = activity;
        mListener = listener;
        NoticeResponse noticeResponse = NoticeApi.getNoticeResponse(mActivity.getApplicationContext());
        if(noticeResponse != null){
            mCoinImageUrl = noticeResponse.coin;
            mVirtualCoin = noticeResponse.vc;
        }
        ResourcesUtil.init(activity);
        this.youTubePlayerCallback = youTubePlayerCallback;
        if (videoInterval > 0) mDelayInterval = videoInterval;
        initViews(customPlayerUI);
        mIsPolice = isPolice;
        mPref = new SharedPreferencesUtil(activity);
        mPlayerView = playerView;
        mHandler = new Handler(Looper.getMainLooper());
        mPage = page;
    }

    private void initViews(View view) {
        mPanel = view.findViewById(R.id.panel);
        mLoadingBar = view.findViewById(R.id.progress_bar);
        mAutoSkipContainer = view.findViewById(R.id.yt_auto_skip_container);
        mAutoSkipToggle = view.findViewById(R.id.yt_auto_skip);
        mStopButton = view.findViewById(R.id.stop_button);
        mAutoSkipToggle.setOnCheckedChangeListener(this);
        mLiveIndicator = view.findViewById(R.id.live_container);
        mLiveStatus = view.findViewById(R.id.live_status);
        mOpenButton = view.findViewById(R.id.open_button);
        mOpenContainer = view.findViewById(R.id.open_container);
        mSkipButton = view.findViewById(R.id.skip_button);
        mSkipContainer = view.findViewById(R.id.skip_container);
        mVolume = view.findViewById(R.id.volume_button);
        mVolumeContainer = view.findViewById(R.id.volume_container);
        mPipButton = view.findViewById(R.id.pip_button);
        mPipContainer = view.findViewById(R.id.pip_container);
        mSkipCoinImage = view.findViewById(R.id.skip_coin_image);
        mSkipCoin = view.findViewById(R.id.skip_coin);
        mSkipProgress = view.findViewById(R.id.skip_progress);
        mSkipLoading = view.findViewById(R.id.skip_loading);
        mSkipCoinContainer = view.findViewById(R.id.skip_coin_container);
        mSkipRevealView = view.findViewById(R.id.skip_reveal_view);

        if(mIsPolice) {
            mSkipContainer.setVisibility(View.GONE);
        }

        mSkipContainer.setOnRippleCompleteListener(new RippleView.OnRippleCompleteListener() {
            @Override
            public void onComplete(RippleView rippleView) {
                if(mSkipButton != null){
                    onClick(mSkipButton);
                }
            }
        });
        mOpenContainer.setOnRippleCompleteListener(new RippleView.OnRippleCompleteListener() {
            @Override
            public void onComplete(RippleView rippleView) {
                if(mOpenButton != null){
                    onClick(mOpenButton);
                }
            }
        });
        mVolumeContainer.setOnRippleCompleteListener(new RippleView.OnRippleCompleteListener() {
            @Override
            public void onComplete(RippleView rippleView) {
                if(mVolume != null){
                    onClick(mVolume);
                }
            }
        });
        mPipContainer.setOnRippleCompleteListener(new RippleView.OnRippleCompleteListener() {
            @Override
            public void onComplete(RippleView rippleView) {
                if(mPipButton != null){
                    onClick(mPipButton);
                }
            }
        });



    }

    public void setPipMode(boolean enable){
        mIsPipMode = enable;
        mPipButton.setVisibility(mIsPipMode?View.GONE:View.VISIBLE);
        if(mNextYtInfo != null){
            initSkipAd();
        }
    }


    @Override
    public void onReady() {
        removeRunnableHandler();
        if(mDefaultInterval > 0 && !mFirstOnReady){
            mDefaultInterval = 0;
        }
//        Logger.e(mDefaultInterval+":onReady:"+mPage);
        mDelayRunnable = new DelayRunnable(mVideoUniqueId);
        mHandler.postDelayed(mDelayRunnable, mDefaultInterval);
        mDefaultInterval = mDelayInterval;
        mFirstOnReady = false;
    }

    @Override
    public void onStateChange(@NonNull PlayerConstants.PlayerState state) {
        if(state == PlayerConstants.PlayerState.PLAYING ){
//            Logger.e("PLAYING:"+mPage);
            stopErrorReportCountDown();
            mIsOnPause = false;
            if(mIsInitialize){
                mIsInitialize = false;
                mPanel.setBackgroundColor(ContextCompat.getColor(mActivity, android.R.color.transparent));
                setMute(mIsMute);
                if(mCountDownRunnable == null){
                    mCountDownRunnable = new CountDownRunnable();
                    mPlayerIsPlaying = true;
                    mHandler.postDelayed(mCountDownRunnable, 0);
                }
                else{
                    mHandler.postDelayed(mCountDownRunnable, 0);
                }
            }
        }
        else if (state == PlayerConstants.PlayerState.BUFFERING || state == PlayerConstants.PlayerState.VIDEO_CUED) {
//            Logger.e("BUFFERING:"+mPage);
            mPanel.setBackgroundColor(ContextCompat.getColor(mActivity, android.R.color.transparent));
            setMute(mIsMute);
        } else if (state == PlayerConstants.PlayerState.ENDED) {
//            Logger.e("ENDED:"+mPage);
            mPlayerIsPlaying = false;
            if(mVideoType.contains("youtube_live")){
                onError(PlayerConstants.PlayerError.ERROR_VIDEO_LIVE_OFFLINE);
            }
            else if (mNextYtInfo != null) {
                initYtVideoInfo(mNextYtInfo);
            }
            mIsYtEnded = true;
        }
        else if(state == PlayerConstants.PlayerState.PAUSED){
//            Logger.e("PAUSED:"+mPage);
            mIsOnPause = true;
            mIsInitialize = true;
            mFirstTime = true;
        }
        else if(state == PlayerConstants.PlayerState.OFFLINE){
//            Logger.e("OFFLINE:"+mPage);
            mIsInitialize = false;
            onError(PlayerConstants.PlayerError.ERROR_VIDEO_LIVE_OFFLINE);
        }
        else if(state  == PlayerConstants.PlayerState.VIDEOSTART){
            if(mIsVideoStart && mVideoType.contains("mixer")){
//                Logger.e("VIDEOSTART:"+mPage);
                setInitialMute();
                mIsVideoStart = false;
            }
            else{
                setMute(mIsMute);
            }
        }
    }

    @Override
    public void onCurrentSecond(float second) {
//        int roundedSecond = Math.round(second);
//        onCurrentSecond(roundedSecond);
    }

    @Override
    public void onError(@NonNull PlayerConstants.PlayerError error) {
        super.onError(error);
        skipEmbedVideo();
        mDefaultInterval = 0;
        mPanel.setBackgroundColor(ResourcesUtil.getColor(R.color.black));
        if(!mIsPolice){
            mIsVideoError = true;
            mListener.youtubePlayableError(mIdVideoPlaying, parsePlayerError(error));
            initUI();
            return;
        }
        mListener.videoNotAvailable();
    }

    @Override
    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.skip_button) {
            if(mActivity != null && mActivity instanceof EmbedDoubleVideoActivity){
                if(((EmbedDoubleVideoActivity)mActivity).isClickedSkipButton()){
                    return;
                }
                ((EmbedDoubleVideoActivity)mActivity).setIsSkipClicked();
            }
            mPlayerIsPlaying = false;
            skipEmbedVideo();
            if (mNextYtInfo != null) initYtVideoInfo(mNextYtInfo);
        } else if (i == R.id.stop_button) {
            mListener.forceStopVideo();
        } else if (i == R.id.open_button) {
            if (v instanceof Button) {
                if (((Button) v).getText().equals(ResourcesUtil.getString(R.string.skip_video_now))) {
                    openSkipDialog();
                } else {
                    Utils.openBrowser(mActivity, mVideoUrl);
                }

            }
        } else if (i == R.id.volume_button) {
            setMute();
        } else if (i == R.id.pip_button) {
            if(isSupportPip()){
                if (enabledPictureInPicture()){
                    mListener.enablePictureInPicture();
                    mPipButton.setVisibility(View.GONE);
                }
                else{
                    Intent intent = new Intent("android.settings.PICTURE_IN_PICTURE_SETTINGS", Uri.parse("package" + Utils.getAppId(mActivity.getApplicationContext())));
                    mActivity.startActivity(intent);
                }
            }
        }
    }

    @Override
    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        int i = buttonView.getId();
        if (i == R.id.yt_auto_skip) {
            mAutoSkipToggle.setChecked(isChecked);
            mPref.putBooleanValue(YT_IS_AUTO_SKIP, isChecked);

        }
    }

    public void initYtVideoInfo(EmbedGigsResponse response){
        if (mActivity instanceof EmbedDoubleVideoActivity) {
            ((EmbedDoubleVideoActivity) mActivity).updateCurrentPlayingGid(mIdVideoPlaying);
        }
        initializeYtVideoInfo(response);
    }

    public void initializeYtVideoInfo(EmbedGigsResponse response) {
        if (!mPlayerIsPlaying) {
            youTubePlayerCallback.pause();
            mPlayerView.refreshPlayer();
            mPanel.setBackgroundColor(ResourcesUtil.getColor(R.color.black));
            initUI();
            if (response.success && response.video_info != null) {
                mCurrentSeconds = 0;
                mResponse = response;
                mPanel.setClickable(!mIsPolice && !response.enable_touch);
                mPanel.setFocusable(!mIsPolice && !response.enable_touch);
                mCountDownRunnable = null;
                mFirstOnReady = true;
                mIsVideoStart = true;
                mNextYtInfo = null;
                mIsVideoError = false;
                mMinWatchTime = response.video_info.min_watch_time;
                mVideoUrl = response.video_info.ourl;
                mVideoType = response.video_type;
                mVideoUniqueId = response.video_info.id;
                mIdVideoPlaying = response.gid;
                mTimestamp = response.ts;
                mErrorReportMaxTime = response.video_info.max_error_time;
                mIsVideoHtmlExist = response.video_html != null && !response.video_html.isEmpty();
                mSkipRevealView.setVisibility(View.GONE);
                mTotalCoinEarned = 0;
                mTotalTimeWatched = 0;
                redrawsCountdownBar();
                mSkipProgress.setProgress(0);
                mSkipProgress.setMax(response.video_info.min_watch_time);
                mSkipProgress.setProgressColor(ResourcesUtil.getColor(R.color.primary));
                if(response.video_html != null && !response.video_html.isEmpty()){
                    mPlayerView.initPlayer(response.video_info.url, response.video_html);
                }
                else{
                    if(mActivity instanceof EmbedDoubleVideoActivity){
                        ((EmbedDoubleVideoActivity)mActivity).muteAllHtmlEmbedPlayer(mPage);
                    }
                    mViewDelayRunnable = new ViewDelayRunnable(response);
                    mHandler.postDelayed(mViewDelayRunnable, mDefaultInterval);
                }
            } else {
                mListener.videoNotAvailable();
            }
        }
    }

    private void createErrorReportCountdown() {
        if(mErrorReportMaxTime > 0 && mIsVideoHtmlExist){
            if(mErrorCountdown != null) mHandler.removeCallbacks(mErrorCountdown);
            mErrorCountdown = new ErrorCountDownRunnable();

            mHandler.postDelayed(mErrorCountdown, mErrorReportMaxTime * 1000);
        }
    }

    private void stopErrorReportCountDown(){
        if(mErrorCountdown != null){
            mHandler.removeCallbacks(mErrorCountdown);
            mErrorCountdown = null;
        }
    }

    public void onResume(){
        if(!mIsYtEnded && !mPlayerIsPlaying) createErrorReportCountdown();
        if (mPlayerIsPlaying && this.youTubePlayerCallback != null) {
            if(mVideoType.contains("youtube_live")){
                reload();
            }
            else{
                this.youTubePlayerCallback.play();
            }
        }

        if(!mIsVideoHtmlExist && mIsOnPause && mHandler != null && mCountDownRunnable != null){
            mHandler.postDelayed(mCountDownRunnable, countdownInterval);
        }

        mIsOnPause = false;

        if(mStopButton != null){
            mStopButton.setOnClickListener(this);
        }

        mSkipContainer.setOnRippleCompleteListener(new RippleView.OnRippleCompleteListener() {
            @Override
            public void onComplete(RippleView rippleView) {
                if(mSkipButton != null){
                    onClick(mSkipButton);
                }
            }
        });
        mOpenContainer.setOnRippleCompleteListener(new RippleView.OnRippleCompleteListener() {
            @Override
            public void onComplete(RippleView rippleView) {
                if(mOpenButton != null){
                    onClick(mOpenButton);
                }
            }
        });
        mVolumeContainer.setOnRippleCompleteListener(new RippleView.OnRippleCompleteListener() {
            @Override
            public void onComplete(RippleView rippleView) {
                if(mVolume != null){
                    onClick(mVolume);
                }
            }
        });
        mPipContainer.setOnRippleCompleteListener(new RippleView.OnRippleCompleteListener() {
            @Override
            public void onComplete(RippleView rippleView) {
                if(mPipButton != null){
                    onClick(mPipButton);
                }
            }
        });
    }

    public void onPause(){
        if(mActivity != null){
            if (!(Build.VERSION.SDK_INT > Build.VERSION_CODES.N && mActivity.isInPictureInPictureMode())) {
                if(mStopButton != null){
                    mStopButton.setOnClickListener(null);
                }
                if (this.youTubePlayerCallback != null) {
                    this.youTubePlayerCallback.pause();
                }
                stopErrorReportCountDown();
                mSkipContainer.setOnRippleCompleteListener(null);
                mOpenContainer.setOnRippleCompleteListener(null);
                mVolumeContainer.setOnRippleCompleteListener(null);
                mPipContainer.setOnRippleCompleteListener(null);
            }
        }
    }

    public void onDestroy() {
        removeRunnableHandler();
        mAutoSkipToggle.setOnCheckedChangeListener(null);
    }

    public void verifiedYtVideo(EmbedGigsResponse response) {
        if(mResponse != null) {
            mTotalCoinEarned += mResponse.coin;
        }
        mNextYtInfo = response;
        initSkipAd();
        if(!mIsVideoError && mResponse != null && mResponse.continuous && response != null && response.success && response.video_info == null){
            measureSkipContainerWidth();
            mFirstTime = true;
            mCurrentSeconds = 0;
            mSkipRevealView.setVisibility(View.GONE);
            mSkipLoading.setVisibility(View.VISIBLE);
            mSkipProgress.setProgress(0);
            mIsInitialize = true;
            mCountDownRunnable = null;
            onStateChange(PlayerConstants.PlayerState.PLAYING);
        }
        else if(response != null && mResponse != null){
            if (mPref.getBooleanValue(YT_IS_AUTO_SKIP, false) || mIsYtEnded) {
                mPlayerIsPlaying = false;
                initYtVideoInfo(response);
            }
        }
    }

    private void initUI(){
        if(!mIsPipMode){
            mLoadingBar.setVisibility(View.VISIBLE);
            mAutoSkipContainer.setVisibility(View.VISIBLE);
            mStopButton.setVisibility(View.VISIBLE);
            mAutoSkipToggle.setChecked(mPref.getBooleanValue(YT_IS_AUTO_SKIP, false));
            if(!mIsPolice){
                mSkipContainer.setVisibility(View.GONE);
                mSkipProgress.setProgressColor(ResourcesUtil.getColor(R.color.primary));
            }
        }
        mOpenButton.setVisibility(View.GONE);
        mVolume.setVisibility(View.GONE);
        mPipButton.setVisibility(View.GONE);
    }

    private boolean onCurrentSecond(int second){
        int roundedSecond = Math.round(second);
        mTotalTimeWatched++;
        if ((roundedSecond == mMinWatchTime || roundedSecond == 0) && mFirstTime) {
            mFirstTime = false;
            mListener.videoReachEndpoint(mIdVideoPlaying, mTimestamp);
            mSkipButton.setVisibility(View.GONE);
            mSkipLoading.setVisibility(VISIBLE);
            //if(mResponse != null && !mResponse.continuous && !mIsPolice) mSkipContainer.setVisibility(View.GONE);
            return false;
        } else if (mFirstTime && roundedSecond < mMinWatchTime) {
            if(!mIsPolice){
                mSkipContainer.setVisibility(VISIBLE);
                mSkipContainer.setEnabled(false);
                mSkipButton.setVisibility(VISIBLE);

                mSkipLoading.setVisibility(View.GONE);
            }
            int timeRemaining = mMinWatchTime - roundedSecond;
            int minutes = (timeRemaining % 3600) / 60;
            int seconds =  timeRemaining % 60;
            String time;
            if(minutes > 0){
                time = String.format(Locale.US, "%02d:%02d", minutes, seconds);
            }
            else{
                time = String.format(Locale.US, "%ds", seconds);
            }
            initSkipAdCountDown(String.format(ResourcesUtil.getString(R.string.yt_skip_video_count_down), (time)));
            return true;
        }

        return false;
    }

    private void initSkipAdCountDown(String content) {
        removeLoadingUI();
        if(mSkipButton != null){
            if(!mIsPipMode){
                mSkipButton.setText(content);
                mSkipButton.setTextSize(12);
                int paddingInPx = Utils.dpToPx(8);
                mSkipButton.setPadding(paddingInPx, paddingInPx, paddingInPx, paddingInPx);
                mSkipContainer.setEnabled(false);
            }

            mSkipCoinImage.getLayoutParams().width = mIsPipMode? Utils.dpToPx(16):Utils.dpToPx(28);
            mSkipCoinImage.getLayoutParams().height = mIsPipMode? Utils.dpToPx(16):Utils.dpToPx(28);
            mSkipContainer.getLayoutParams().height = mIsPipMode? Utils.dpToPx(40):Utils.dpToPx(60);
            mSkipButton.setVisibility(mIsPipMode? View.GONE:VISIBLE);

            redrawsCountdownBar();
        }

        if(!mIsPipMode && mOpenButton != null && !mIsPolice){
            if(mMinWatchTime > 300 || mTotalTimeWatched > 300){
                mOpenButton.setEnabled(true);
                mOpenButton.setText(R.string.skip_video_now);
                mOpenButton.setVisibility(VISIBLE);
            }
            else{
                mOpenButton.setEnabled(false);
                mOpenButton.setVisibility(View.GONE);
            }
        }
    }

    private void initSkipAd() {
        removeLoadingUI();
        if(mNextYtInfo != null && ((mNextYtInfo.success && mNextYtInfo.video_info != null) || (!mNextYtInfo.success && mNextYtInfo.video_info == null))){
            if(mSkipButton != null){
                if(!mIsPipMode){
                    mSkipButton.setVisibility(VISIBLE);
                    mSkipButton.setText(R.string.yt_skip_video);
                    int paddingInPx = Utils.dpToPx(8);
                    mSkipButton.setPadding(paddingInPx, paddingInPx, paddingInPx, paddingInPx);
                    mSkipContainer.setEnabled(true);
                    if(!mIsPolice){
                        mSkipContainer.setVisibility(VISIBLE);
                    }
                }

                mSkipLoading.setVisibility(View.GONE);
                mSkipCoinImage.getLayoutParams().width = mIsPipMode? Utils.dpToPx(16):Utils.dpToPx(28);
                mSkipCoinImage.getLayoutParams().height = mIsPipMode? Utils.dpToPx(16):Utils.dpToPx(28);
                mSkipContainer.getLayoutParams().height = mIsPipMode? Utils.dpToPx(40):Utils.dpToPx(60);
                mSkipButton.setVisibility(mIsPipMode? View.GONE:View.VISIBLE);
                redrawsCountdownBar();
                reveal();
            }

            if(!mIsPipMode && mOpenButton != null && !mIsPolice){
                if( mVideoUrl != null && mVideoType != null){
                    mOpenButton.setEnabled(true);
                    mOpenButton.setText("Watch on "+mVideoType.replace("_live", ""));
                    mOpenButton.setVisibility(VISIBLE);
                }
                else{
                    mOpenButton.setEnabled(false);
                    mOpenButton.setVisibility(View.GONE);
                }
            }
        }
        else{
            redrawsCountdownBar();
        }
    }

    private void showUiVideo(){
        mFirstTime = true;
        mIsYtEnded = false;
//        mNextYtInfo = null;
        removeLoadingUI();
        mPipButton.setVisibility(isSupportPip()?View.VISIBLE:View.GONE);
    }

    private void removeLoadingUI(){
        mLoadingBar.setVisibility(View.GONE);
        mAutoSkipContainer.setVisibility(View.GONE);
        mStopButton.setVisibility(View.GONE);
    }

    private boolean isSupportPip(){
        return (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O && mActivity instanceof EmbedVideoActivity);
    }

    public interface Listener {
        void videoReachEndpoint(String id, int ts);
        void videoNotAvailable();
        void forceStopVideo();
        void youtubePlayableError(String id, String error);
        void enablePictureInPicture();
        void skipVideo(String gid);
    }

    class ViewDelayRunnable implements Runnable {

        private EmbedGigsResponse response;

        ViewDelayRunnable(EmbedGigsResponse response) {
            this.response = response;
        }

        @Override
        public void run() {
            showUiVideo();
            mIsInitialize = true;
            mPlayerView.initPlayer(response.video_info.url, response.video_html);
            mDefaultInterval = mDelayInterval;
        }
    }

    class DelayRunnable implements Runnable {

        private String mVideoId;

        DelayRunnable(String videoId) {
            mVideoId = videoId;
        }

        @Override
        public void run() {
            showUiVideo();
            createErrorReportCountdown();
            mIsInitialize = true;
            // need display matured enabled page before the video is loaded
            mPanel.setBackgroundColor(ContextCompat.getColor(mActivity, android.R.color.transparent));
            float currentVideoTime = mCurrentSeconds;
            // if live not set to 0 will not play the latest video
            if(mVideoType.contains("live")){
                currentVideoTime  = 0;
            }
            if(mIsVideoStart){
                setInitialMute();
                mIsVideoStart = false;
            }
            youTubePlayerCallback.loadVideo(mVideoId, currentVideoTime);
            mDefaultInterval = mDelayInterval;
        }
    }

    class ErrorCountDownRunnable implements Runnable {

        @Override
        public void run() {
            onError(PlayerConstants.PlayerError.UNKNOWN);
        }
    }

    class CountDownRunnable implements Runnable {

        @Override
        public void run() {
            if(mIsOnPause){
                onPause();
                return;
            }
            mHandler.removeCallbacksAndMessages(null);
            if(mMinWatchTime > 0) {
                mCurrentSeconds++;
            }
            if(mSkipProgress != null) {
                ObjectAnimator animation = ObjectAnimator.ofFloat(mSkipProgress, "progress",  mSkipProgress.getProgress(), mCurrentSeconds);
                animation.setDuration(3000);
                animation.setInterpolator(new DecelerateInterpolator());
                animation.start();
            }

            if(onCurrentSecond(Math.round(mCurrentSeconds))){
                mHandler.postDelayed(mCountDownRunnable, countdownInterval);
            }
            else if(mNextYtInfo != null && mNextYtInfo.video_info != null){
                initSkipAd();
            }
        }
    }

    @NonNull
    private String parsePlayerError(PlayerConstants.PlayerError error) {
        String playerError;
        if (error.equals(PlayerConstants.PlayerError.INVALID_PARAMETER_IN_REQUEST))
            playerError = ERROR_INVALID_PARAMETER_IN_REQUEST;
        else if (error.equals(PlayerConstants.PlayerError.HTML_5_PLAYER))
            playerError = ERROR_HTML_5_PLAYER;
        else if (error.equals(PlayerConstants.PlayerError.VIDEO_NOT_FOUND))
            playerError = ERROR_VIDEO_NOT_FOUND;
        else if (error.equals(PlayerConstants.PlayerError.VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER))
            playerError = ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER1;
        else if (error.equals(PlayerConstants.PlayerError.VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER))
            playerError = ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER2;
        else if (error.equals(PlayerConstants.PlayerError.ERROR_VIDEO_LIVE_OFFLINE))
            playerError = ERROR_VIDEO_LIVE_OFFLINE;
        else
            playerError = "0";
        return playerError;
    }

    private boolean enabledPictureInPicture(){
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O){
            AppOpsManager appOps = (AppOpsManager) mActivity.getSystemService(Context.APP_OPS_SERVICE);
            if(appOps != null)
                return appOps.checkOpNoThrow(AppOpsManager.OPSTR_PICTURE_IN_PICTURE, android.os.Process.myUid(), Utils.getAppId(mActivity.getApplicationContext())) == AppOpsManager.MODE_ALLOWED;
        }
        return false;
    }

    public void setMute(boolean mute){
        mIsMute = mute;
        youTubePlayerCallback.setMute(mute);
        if(mVolume != null && mActivity instanceof EmbedDoubleVideoActivity) {
            mVolume.setVisibility(VISIBLE);
            int volume = mute ? R.drawable.volume_mute : R.drawable.volume_up;
            mVolume.setImageDrawable(ResourcesUtil.getDrawable(volume));
        }
    }

    private void setMute(){
        if(mActivity instanceof EmbedDoubleVideoActivity){
            ((EmbedDoubleVideoActivity) mActivity).unmuteVideoPlayer(mPage);
        }
    }

    private void setInitialMute(){
        if(mActivity instanceof EmbedDoubleVideoActivity){
            if(!((EmbedDoubleVideoActivity) mActivity).isUnmuteVideoExist()){
                ((EmbedDoubleVideoActivity) mActivity).unmuteVideoPlayer(mPage);
            }
            else{
                setMute(true);
            }
        }
    }

    public String getPlayingVideoId(){
        return mIdVideoPlaying;
    }

    public void reload(){
        refreshUI();
        float seconds = mCurrentSeconds;
        int totalWatchTime = mTotalTimeWatched;
        EmbedGigsResponse response = mNextYtInfo;
        int currentCoin = mTotalCoinEarned;
        mPlayerIsPlaying = false;
        mDefaultInterval = 0;
        initializeYtVideoInfo(mResponse);
        mTotalTimeWatched = totalWatchTime;
        mCurrentSeconds = seconds;
        mTotalCoinEarned = currentCoin;
        mNextYtInfo = response;
    }

    private void refreshUI(){
        if (mHandler != null) {
            mHandler.removeCallbacksAndMessages(null);
        }
        initUI();
        mPanel.setBackgroundColor(ContextCompat.getColor(mActivity, android.R.color.black));
    }

    private void openSkipDialog(){
        if(!mPref.getBooleanValue(SKIP_DIALOG_VISIBILITY, false)){
            View checkboxLayout = LayoutInflater.from(mActivity).inflate(R.layout.checkbox, null);
            final CheckBox checkbox = checkboxLayout.findViewById(R.id.skip);
            AlertDialog dialog = new AlertDialog.Builder(new ContextThemeWrapper(mActivity, R.style.AlertDialog))
                    .setCancelable(false)
                    .setView(checkboxLayout)
                    .setTitle(ResourcesUtil.getString(R.string.skip_video_now))
                    .setMessage(ResourcesUtil.getString(R.string.skip_video_no_reward_desc))
                    .setPositiveButton(R.string.skip, new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int which) {
                            mPref.putBooleanValue(SKIP_DIALOG_VISIBILITY, checkbox.isChecked());
                            mListener.skipVideo(mIdVideoPlaying);
                            skipEmbedVideo();
                        }
                    })
                    .setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    }).create();
            dialog.show();
        }
        else {
            mListener.skipVideo(mIdVideoPlaying);
            skipEmbedVideo();
        }
    }

    private void skipEmbedVideo(){
        if(mActivity instanceof EmbedDoubleVideoActivity){
            ((EmbedDoubleVideoActivity)mActivity).unmuteSkipVideoPlayer(mPage);
            if(!mIsVideoHtmlExist){
                setVolumeControl(true);
                ((EmbedDoubleVideoActivity)mActivity).setViewPlaying(false);
            }
        }
        youTubePlayerCallback.pause();
        mIsYtEnded = true;
        mIsOnPause = true;
        mPlayerView.refreshPlayer();
        removeRunnableHandler();
        refreshUI();
    }

    public void setVolumeControl(boolean enable){
        mVolumeContainer.setEnabled(enable);
        mVolumeContainer.setVisibility(enable? VISIBLE:View.GONE);
    }

    private void reveal() {
        mSkipRevealView.setVisibility(VISIBLE);

        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.LOLLIPOP) {
            mSkipRevealView.post(new Runnable() {
                @Override
                public void run() {
                    mSkipRevealView.forceLayout();
                    mSkipRevealView.requestLayout();
                    int cx = mSkipRevealView.getLayoutParams().width;
                    int cy = mSkipRevealView.getLayoutParams().height;
                    final float finalRadius = (float) Math.max(cx, cy) * 1.2f;
                    Animator animation = null;
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                        animation = ViewAnimationUtils.createCircularReveal(mSkipRevealView, 0,0, 0f, finalRadius);
                    }
                    mSkipRevealView.setBackgroundColor(ResourcesUtil.getColor(R.color.green));
                    animation.start();
                }
            });
        }
        else{
            mSkipRevealView.setBackgroundColor(ResourcesUtil.getColor(R.color.green));
        }
    }

    private void measureSkipContainerWidth(){
        mSkipCoinContainer.measure(0, 0);
        mSkipCoin.measure(0,0);
        ViewTreeObserver vto = mSkipCoinContainer.getViewTreeObserver();
        vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
            @Override
            public void onGlobalLayout() {
                mSkipCoinContainer.getViewTreeObserver().removeOnGlobalLayoutListener(this);
                mSkipProgress.getLayoutParams().width =   mSkipCoinContainer.getMeasuredWidth();
                mSkipRevealView.getLayoutParams().width =  mSkipCoinContainer.getMeasuredWidth();
                mSkipRevealView.measure(0, 0);
            }
        });
    }

    private void removeRunnableHandler(){
        if(mHandler != null){
            if(mViewDelayRunnable != null) mHandler.removeCallbacks(mViewDelayRunnable);
            if(mDelayRunnable != null) mHandler.removeCallbacks(mDelayRunnable);
            if(mErrorCountdown != null) mHandler.removeCallbacks(mErrorCountdown);
            if(mCountDownRunnable != null) mHandler.removeCallbacks(mCountDownRunnable);
        }
    }

    private void redrawsCountdownBar(){

        mSkipLoading.setVisibility(View.GONE);
        mSkipCoinImage.setVisibility(View.VISIBLE);
        mSkipCoinImage.setVisibility((mCoinImageUrl==null || mCoinImageUrl.isEmpty())?View.GONE:VISIBLE);
        if((mCoinImageUrl!=null && !mCoinImageUrl.isEmpty())){
            Picasso.with(mActivity.getApplicationContext()).load(mCoinImageUrl).into(mSkipCoinImage);
        }
        String coin = (mCoinImageUrl==null || mCoinImageUrl.isEmpty())?String.format("%s %s", mTotalCoinEarned, mVirtualCoin) :String.valueOf(mTotalCoinEarned);
        mSkipCoin.setText(coin);

        measureSkipContainerWidth();
    }
}
