package com.appzilo.sdk.video;

import android.app.Activity;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.annotation.NonNull;

import com.appzilo.sdk.video.backend.GigsApi;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.EmbedGigsResponse;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.App;
import com.appzilo.sdk.video.core.BackgroundWorker;
import com.appzilo.sdk.video.core.Logger;
import com.appzilo.sdk.video.core.Result;
import com.appzilo.sdk.video.utils.NetworkUtil;
import com.appzilo.sdk.video.utils.ResourcesUtil;
import com.appzilo.sdk.video.utils.SharedPreferencesUtil;
import com.appzilo.sdk.video.utils.Utils;

import java.lang.ref.WeakReference;
import java.util.HashMap;

public class AppziloVideo {

    public final static String PARAMS = "video_params";
    public final static String SUB_ID = "sb";
    public final static String SUB_ID2 = "sb2";
    public final static String SUB_ID3 = "sb3";
    public final static String SUB_ID4 = "sb4";
    public final static String SUB_ID5 = "sb5";
    public final static String APP_KEY = "app_key";
    public final static String USER_ID = "sub_pubid";
    private final static String APP_ID = "app";
    private final static String APP_VERSION = "ver";
    private final static String MODULE_VERSION = "v";
    private static WeakReference<Activity> mActivity;
    private static HashMap<String, String> mParams;
    private static Class<? extends Activity> sChildClass;

    /*
     * initialize the sdk
     *
     * @param activity
     * @param appKey unique key that is created when register in dashboard
     * @param userId unique id for user
     *
     * */
    public static synchronized void initApp(@NonNull Activity activity, @NonNull String appKey, @NonNull String userId) {
        initApp(activity, appKey, userId, null);
    }

    /*
     * initialize the sdk
     *
     * @param activity
     * @param appKey unique key that is created when register in dashboard
     * @param userId unique id for user
     * @param customParams parameters that will pass back to the publisher when postback success
     *
     * */
    public static synchronized void initApp(@NonNull Activity activity, @NonNull String appKey, @NonNull String userId, HashMap<String, String> customParams) {
        App.init(activity.getApplicationContext());
        mActivity = new WeakReference<>(activity);
        mParams = new HashMap<>();
        if (customParams != null) {
            mParams.putAll(customParams);
            SharedPreferencesUtil pref = new SharedPreferencesUtil(activity);

            if (customParams.containsKey("dbm")) {
                pref.putStringValue("dbm", customParams.get("dbm"));
            }

            if (customParams.containsKey("az_dbm")) {
                pref.putStringValue("az_dbm", customParams.get("az_dbm"));
            }

            if (customParams.containsKey("moo_dbm")) {
                pref.putStringValue("moo_dbm", customParams.get("moo_dbm"));
            }
        }
        mParams.put(APP_KEY, appKey);
        mParams.put(USER_ID, userId);
        mParams.put(APP_ID, activity.getApplicationContext().getPackageName());
        mParams.put(APP_VERSION, Utils.getAppVersion(activity));
        mParams.put(MODULE_VERSION, BuildConfig.VERSION_NAME);

        sChildClass = activity.getClass();
    }

    public static void show() {
        Activity activity = mActivity.get();
        if (activity != null && !activity.isFinishing()) {
            Intent intent = new Intent(activity.getApplicationContext(), EmbedDoubleVideoActivity.class);
            intent.putExtra(GigsApi.VIDEO_CATEGORY, mParams.containsKey(GigsApi.VIDEO_CATEGORY) ? Integer.valueOf(mParams.get(GigsApi.VIDEO_CATEGORY)) : 0);
            if (mParams.containsKey(GigsApi.VIDEO_CATEGORY)) {
                mParams.remove(GigsApi.VIDEO_CATEGORY);
            }
            intent.putExtra(GigsApi.IS_FEATURED, mParams.containsKey(GigsApi.IS_FEATURED) ? Boolean.valueOf(mParams.get(GigsApi.IS_FEATURED)) : false);
            if (mParams.containsKey(GigsApi.IS_FEATURED)) {
                mParams.remove(GigsApi.IS_FEATURED);
            }
            intent.putExtra(PARAMS, Utils.hashMapToQuery(mParams));
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            activity.startActivity(intent);
        }
    }

    // Used in after picture in picture
    public static Class<? extends Activity> getChildClass(){
        return sChildClass;
    }

}
