/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.Activity;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.SwitchCompat;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewTreeObserver;
import android.view.animation.DecelerateInterpolator;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.akexorcist.roundcornerprogressbar.RoundCornerProgressBar;
import com.andexert.library.RippleView;
import com.appzilo.sdk.video.EmbedDoubleVideoActivity;
import com.appzilo.sdk.video.EmbedVideoActivity;
import com.appzilo.sdk.video.R;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.EmbedGigsResponse;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.player.PlayerConstants;
import com.appzilo.sdk.video.player.VideoPlayer;
import com.appzilo.sdk.video.player.VideoPlayerView;
import com.appzilo.sdk.video.player.listeners.AbstractVideoPlayerListener;
import com.appzilo.sdk.video.utils.ResourcesUtil;
import com.appzilo.sdk.video.utils.SharedPreferencesUtil;
import com.appzilo.sdk.video.utils.Utils;
import com.squareup.picasso.Picasso;
import java.util.Locale;

public class CustomVideoUIController
extends AbstractVideoPlayerListener
implements View.OnClickListener,
CompoundButton.OnCheckedChangeListener {
    public static final String YT_IS_AUTO_SKIP = "yt_is_auto_skip";
    private static final String SKIP_DIALOG_VISIBILITY = "skip_dialog_visiblity";
    private SharedPreferencesUtil mPref;
    private int mDefaultInterval = 0;
    private int mDelayInterval = 10000;
    private Activity mActivity;
    private VideoPlayer youTubePlayerCallback;
    private Button mSkipButton;
    private View mLoadingBar;
    private View mPanel;
    private Listener mListener;
    private int mMinWatchTime;
    private String mIdVideoPlaying;
    private boolean mPlayerIsPlaying;
    private EmbedGigsResponse mNextYtInfo;
    private int mTimestamp;
    private boolean mFirstTime;
    private Handler mHandler;
    private SwitchCompat mAutoSkipToggle;
    private View mAutoSkipContainer;
    private Button mStopButton;
    private boolean mIsYtEnded;
    private boolean mIsPolice;
    private static final String ERROR_INVALID_PARAMETER_IN_REQUEST = "2";
    private static final String ERROR_HTML_5_PLAYER = "5";
    private static final String ERROR_VIDEO_NOT_FOUND = "100";
    private static final String ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER1 = "101";
    private static final String ERROR_VIDEO_LIVE_OFFLINE = "102";
    private static final String ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER2 = "150";
    private final int countdownInterval = 1000;
    private CountDownRunnable mCountDownRunnable;
    private boolean mIsOnPause;
    private float mCurrentSeconds;
    private VideoPlayerView mPlayerView;
    private String mVideoUniqueId;
    private View mLiveIndicator;
    private TextView mLiveStatus;
    private boolean mIsInitialize;
    private ErrorCountDownRunnable mErrorCountdown;
    private int mErrorReportMaxTime;
    private boolean mIsVideoHtmlExist;
    private Button mOpenButton;
    private String mVideoUrl;
    private String mVideoType;
    private EmbedGigsResponse mResponse;
    private int mPage;
    private ImageButton mVolume;
    private RippleView mOpenContainer;
    private RippleView mSkipContainer;
    private RippleView mVolumeContainer;
    private RippleView mPipContainer;
    private boolean mFirstOnReady;
    private boolean mIsVideoStart = true;
    private boolean mIsMute;
    private TextView mSkipCoin;
    private RoundCornerProgressBar mSkipProgress;
    private View mSkipRevealView;
    private ImageButton mPipButton;
    private boolean mIsPipMode;
    private ProgressBar mSkipLoading;
    private int mTotalCoinEarned;
    private int mTotalTimeWatched;
    private View mSkipCoinContainer;
    private ImageView mSkipCoinImage;
    private boolean mIsVideoError;
    private ViewDelayRunnable mViewDelayRunnable;
    private DelayRunnable mDelayRunnable;
    private String mCoinImageUrl;
    private String mVirtualCoin;

    public CustomVideoUIController(Activity activity, Listener listener, View view, VideoPlayer videoPlayer, VideoPlayerView videoPlayerView, int n, boolean bl) {
        this.init(activity, listener, 0, view, videoPlayer, videoPlayerView, n, bl);
    }

    public CustomVideoUIController(Activity activity, Listener listener, int n, View view, VideoPlayer videoPlayer, VideoPlayerView videoPlayerView, int n2, boolean bl) {
        this.init(activity, listener, n, view, videoPlayer, videoPlayerView, n2, bl);
    }

    private void init(Activity activity, Listener listener, int n, View view, VideoPlayer videoPlayer, VideoPlayerView videoPlayerView, int n2, boolean bl) {
        this.mActivity = activity;
        this.mListener = listener;
        NoticeResponse noticeResponse = NoticeApi.getNoticeResponse(this.mActivity.getApplicationContext());
        if (noticeResponse != null) {
            this.mCoinImageUrl = noticeResponse.coin;
            this.mVirtualCoin = noticeResponse.vc;
        }
        ResourcesUtil.init((Context)activity);
        this.youTubePlayerCallback = videoPlayer;
        if (n2 > 0) {
            this.mDelayInterval = n2;
        }
        this.initViews(view);
        this.mIsPolice = bl;
        this.mPref = new SharedPreferencesUtil((Context)activity);
        this.mPlayerView = videoPlayerView;
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mPage = n;
    }

    private void initViews(View view) {
        this.mPanel = view.findViewById(R.id.panel);
        this.mLoadingBar = view.findViewById(R.id.progress_bar);
        this.mAutoSkipContainer = view.findViewById(R.id.yt_auto_skip_container);
        this.mAutoSkipToggle = (SwitchCompat)view.findViewById(R.id.yt_auto_skip);
        this.mStopButton = (Button)view.findViewById(R.id.stop_button);
        this.mAutoSkipToggle.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.mLiveIndicator = view.findViewById(R.id.live_container);
        this.mLiveStatus = (TextView)view.findViewById(R.id.live_status);
        this.mOpenButton = (Button)view.findViewById(R.id.open_button);
        this.mOpenContainer = (RippleView)view.findViewById(R.id.open_container);
        this.mSkipButton = (Button)view.findViewById(R.id.skip_button);
        this.mSkipContainer = (RippleView)view.findViewById(R.id.skip_container);
        this.mVolume = (ImageButton)view.findViewById(R.id.volume_button);
        this.mVolumeContainer = (RippleView)view.findViewById(R.id.volume_container);
        this.mPipButton = (ImageButton)view.findViewById(R.id.pip_button);
        this.mPipContainer = (RippleView)view.findViewById(R.id.pip_container);
        this.mSkipCoinImage = (ImageView)view.findViewById(R.id.skip_coin_image);
        this.mSkipCoin = (TextView)view.findViewById(R.id.skip_coin);
        this.mSkipProgress = (RoundCornerProgressBar)view.findViewById(R.id.skip_progress);
        this.mSkipLoading = (ProgressBar)view.findViewById(R.id.skip_loading);
        this.mSkipCoinContainer = view.findViewById(R.id.skip_coin_container);
        this.mSkipRevealView = view.findViewById(R.id.skip_reveal_view);
        if (this.mIsPolice) {
            this.mSkipContainer.setVisibility(8);
        }
        this.mSkipContainer.setOnRippleCompleteListener(new RippleView.a(){

            @Override
            public void onComplete(RippleView rippleView) {
                if (CustomVideoUIController.this.mSkipButton != null) {
                    CustomVideoUIController.this.onClick((View)CustomVideoUIController.this.mSkipButton);
                }
            }
        });
        this.mOpenContainer.setOnRippleCompleteListener(new RippleView.a(){

            @Override
            public void onComplete(RippleView rippleView) {
                if (CustomVideoUIController.this.mOpenButton != null) {
                    CustomVideoUIController.this.onClick((View)CustomVideoUIController.this.mOpenButton);
                }
            }
        });
        this.mVolumeContainer.setOnRippleCompleteListener(new RippleView.a(){

            @Override
            public void onComplete(RippleView rippleView) {
                if (CustomVideoUIController.this.mVolume != null) {
                    CustomVideoUIController.this.onClick((View)CustomVideoUIController.this.mVolume);
                }
            }
        });
        this.mPipContainer.setOnRippleCompleteListener(new RippleView.a(){

            @Override
            public void onComplete(RippleView rippleView) {
                if (CustomVideoUIController.this.mPipButton != null) {
                    CustomVideoUIController.this.onClick((View)CustomVideoUIController.this.mPipButton);
                }
            }
        });
    }

    public void setPipMode(boolean bl) {
        this.mIsPipMode = bl;
        this.mPipButton.setVisibility(this.mIsPipMode ? 8 : 0);
        if (this.mNextYtInfo != null) {
            this.initSkipAd();
        }
    }

    @Override
    public void onReady() {
        this.removeRunnableHandler();
        if (this.mDefaultInterval > 0 && !this.mFirstOnReady) {
            this.mDefaultInterval = 0;
        }
        this.mDelayRunnable = new DelayRunnable(this.mVideoUniqueId);
        this.mHandler.postDelayed((Runnable)this.mDelayRunnable, (long)this.mDefaultInterval);
        this.mDefaultInterval = this.mDelayInterval;
        this.mFirstOnReady = false;
    }

    @Override
    public void onStateChange(@NonNull PlayerConstants.PlayerState playerState) {
        if (playerState == PlayerConstants.PlayerState.PLAYING) {
            this.stopErrorReportCountDown();
            if (this.mIsInitialize) {
                this.mIsOnPause = false;
                this.mIsInitialize = false;
                this.mPanel.setBackgroundColor(ContextCompat.getColor((Context)this.mActivity, (int)17170445));
                this.setMute(this.mIsMute);
                if (this.mCountDownRunnable == null) {
                    this.mCountDownRunnable = new CountDownRunnable();
                    this.mPlayerIsPlaying = true;
                    this.mHandler.postDelayed((Runnable)this.mCountDownRunnable, 0L);
                } else {
                    this.mHandler.postDelayed((Runnable)this.mCountDownRunnable, 0L);
                }
            }
        } else if (playerState == PlayerConstants.PlayerState.BUFFERING || playerState == PlayerConstants.PlayerState.VIDEO_CUED) {
            this.mPanel.setBackgroundColor(ContextCompat.getColor((Context)this.mActivity, (int)17170445));
            this.setMute(this.mIsMute);
        } else if (playerState == PlayerConstants.PlayerState.ENDED) {
            this.mPlayerIsPlaying = false;
            if (this.mVideoType.contains("youtube_live")) {
                this.onError(PlayerConstants.PlayerError.ERROR_VIDEO_LIVE_OFFLINE);
            } else if (this.mNextYtInfo != null) {
                this.initYtVideoInfo(this.mNextYtInfo);
            }
            this.mIsYtEnded = true;
        } else if (playerState == PlayerConstants.PlayerState.PAUSED) {
            this.mIsOnPause = true;
            this.mIsInitialize = true;
            this.mFirstTime = true;
        } else if (playerState == PlayerConstants.PlayerState.OFFLINE) {
            this.mIsInitialize = false;
            this.onError(PlayerConstants.PlayerError.ERROR_VIDEO_LIVE_OFFLINE);
        } else if (playerState == PlayerConstants.PlayerState.VIDEOSTART) {
            if (this.mIsVideoStart && this.mVideoType.contains("mixer")) {
                this.setInitialMute();
                this.mIsVideoStart = false;
            } else {
                this.setMute(this.mIsMute);
            }
        }
    }

    @Override
    public void onCurrentSecond(float f) {
    }

    @Override
    public void onError(@NonNull PlayerConstants.PlayerError playerError) {
        super.onError(playerError);
        this.skipEmbedVideo();
        this.mDefaultInterval = 0;
        this.mPanel.setBackgroundColor(ResourcesUtil.getColor(R.color.black));
        if (!this.mIsPolice) {
            this.mIsVideoError = true;
            this.mListener.youtubePlayableError(this.mIdVideoPlaying, this.parsePlayerError(playerError));
            this.initUI();
            return;
        }
        this.mListener.videoNotAvailable();
    }

    public void onClick(View view) {
        int n = view.getId();
        if (n == R.id.skip_button) {
            if (this.mActivity != null && this.mActivity instanceof EmbedDoubleVideoActivity) {
                if (((EmbedDoubleVideoActivity)this.mActivity).isClickedSkipButton()) {
                    return;
                }
                ((EmbedDoubleVideoActivity)this.mActivity).setIsSkipClicked();
            }
            this.mPlayerIsPlaying = false;
            this.skipEmbedVideo();
            if (this.mNextYtInfo != null) {
                this.initYtVideoInfo(this.mNextYtInfo);
            }
        } else if (n == R.id.stop_button) {
            this.mListener.forceStopVideo();
        } else if (n == R.id.open_button) {
            if (view instanceof Button) {
                if (((Button)view).getText().equals(ResourcesUtil.getString(R.string.skip_video_now))) {
                    this.openSkipDialog();
                } else {
                    Utils.openBrowser((Context)this.mActivity, this.mVideoUrl);
                }
            }
        } else if (n == R.id.volume_button) {
            this.setMute();
        } else if (n == R.id.pip_button && this.isSupportPip()) {
            if (this.enabledPictureInPicture()) {
                this.mListener.enablePictureInPicture();
                this.mPipButton.setVisibility(8);
            } else {
                Intent intent = new Intent("android.settings.PICTURE_IN_PICTURE_SETTINGS", Uri.parse((String)("package" + Utils.getAppId(this.mActivity.getApplicationContext()))));
                this.mActivity.startActivity(intent);
            }
        }
    }

    public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
        int n = compoundButton.getId();
        if (n == R.id.yt_auto_skip) {
            this.mAutoSkipToggle.setChecked(bl);
            this.mPref.putBooleanValue(YT_IS_AUTO_SKIP, bl);
        }
    }

    public void initYtVideoInfo(EmbedGigsResponse embedGigsResponse) {
        if (this.mActivity instanceof EmbedDoubleVideoActivity) {
            ((EmbedDoubleVideoActivity)this.mActivity).updateCurrentPlayingGid(this.mIdVideoPlaying);
        }
        this.initializeYtVideoInfo(embedGigsResponse);
    }

    public void initializeYtVideoInfo(EmbedGigsResponse embedGigsResponse) {
        if (!this.mPlayerIsPlaying) {
            this.youTubePlayerCallback.pause();
            this.mPlayerView.refreshPlayer();
            this.mPanel.setBackgroundColor(ResourcesUtil.getColor(R.color.black));
            this.initUI();
            if (embedGigsResponse.success && embedGigsResponse.video_info != null) {
                this.mCurrentSeconds = 0.0f;
                this.mResponse = embedGigsResponse;
                this.mPanel.setClickable(!this.mIsPolice && !embedGigsResponse.enable_touch);
                this.mPanel.setFocusable(!this.mIsPolice && !embedGigsResponse.enable_touch);
                this.mCountDownRunnable = null;
                this.mFirstOnReady = true;
                this.mIsVideoStart = true;
                this.mNextYtInfo = null;
                this.mIsVideoError = false;
                this.mMinWatchTime = embedGigsResponse.video_info.min_watch_time;
                this.mVideoUrl = embedGigsResponse.video_info.ourl;
                this.mVideoType = embedGigsResponse.video_type;
                this.mVideoUniqueId = embedGigsResponse.video_info.id;
                this.mIdVideoPlaying = embedGigsResponse.gid;
                this.mTimestamp = embedGigsResponse.ts;
                this.mErrorReportMaxTime = embedGigsResponse.video_info.max_error_time;
                this.mIsVideoHtmlExist = embedGigsResponse.video_html != null && !embedGigsResponse.video_html.isEmpty();
                this.mSkipRevealView.setVisibility(8);
                this.mTotalCoinEarned = 0;
                this.mTotalTimeWatched = 0;
                this.redrawsCountdownBar();
                this.mSkipProgress.setProgress(0.0f);
                this.mSkipProgress.setMax((float)embedGigsResponse.video_info.min_watch_time);
                this.mSkipProgress.setProgressColor(ResourcesUtil.getColor(R.color.primary));
                if (embedGigsResponse.video_html != null && !embedGigsResponse.video_html.isEmpty()) {
                    this.mPlayerView.initPlayer(embedGigsResponse.video_info.url, embedGigsResponse.video_html);
                } else {
                    if (this.mActivity instanceof EmbedDoubleVideoActivity) {
                        ((EmbedDoubleVideoActivity)this.mActivity).muteAllHtmlEmbedPlayer(this.mPage);
                    }
                    this.mViewDelayRunnable = new ViewDelayRunnable(embedGigsResponse);
                    this.mHandler.postDelayed((Runnable)this.mViewDelayRunnable, (long)this.mDefaultInterval);
                }
            } else {
                this.mListener.videoNotAvailable();
            }
        }
    }

    private void createErrorReportCountdown() {
        if (this.mErrorReportMaxTime > 0 && this.mIsVideoHtmlExist) {
            if (this.mErrorCountdown != null) {
                this.mHandler.removeCallbacks((Runnable)this.mErrorCountdown);
            }
            this.mErrorCountdown = new ErrorCountDownRunnable();
            this.mHandler.postDelayed((Runnable)this.mErrorCountdown, (long)(this.mErrorReportMaxTime * 1000));
        }
    }

    private void stopErrorReportCountDown() {
        if (this.mErrorCountdown != null) {
            this.mHandler.removeCallbacks((Runnable)this.mErrorCountdown);
            this.mErrorCountdown = null;
        }
    }

    public void onResume() {
        if (!this.mIsYtEnded && !this.mPlayerIsPlaying) {
            this.createErrorReportCountdown();
        }
        if (this.mPlayerIsPlaying && this.youTubePlayerCallback != null) {
            if (this.mVideoType.contains("youtube_live")) {
                this.reload();
            } else {
                this.youTubePlayerCallback.play();
            }
        }
        if (!this.mIsVideoHtmlExist && this.mIsOnPause && this.mHandler != null && this.mCountDownRunnable != null) {
            this.mHandler.postDelayed((Runnable)this.mCountDownRunnable, 1000L);
        }
        this.mIsOnPause = false;
        if (this.mStopButton != null) {
            this.mStopButton.setOnClickListener((View.OnClickListener)this);
        }
        this.mSkipContainer.setOnRippleCompleteListener(new RippleView.a(){

            @Override
            public void onComplete(RippleView rippleView) {
                if (CustomVideoUIController.this.mSkipButton != null) {
                    CustomVideoUIController.this.onClick((View)CustomVideoUIController.this.mSkipButton);
                }
            }
        });
        this.mOpenContainer.setOnRippleCompleteListener(new RippleView.a(){

            @Override
            public void onComplete(RippleView rippleView) {
                if (CustomVideoUIController.this.mOpenButton != null) {
                    CustomVideoUIController.this.onClick((View)CustomVideoUIController.this.mOpenButton);
                }
            }
        });
        this.mVolumeContainer.setOnRippleCompleteListener(new RippleView.a(){

            @Override
            public void onComplete(RippleView rippleView) {
                if (CustomVideoUIController.this.mVolume != null) {
                    CustomVideoUIController.this.onClick((View)CustomVideoUIController.this.mVolume);
                }
            }
        });
        this.mPipContainer.setOnRippleCompleteListener(new RippleView.a(){

            @Override
            public void onComplete(RippleView rippleView) {
                if (CustomVideoUIController.this.mPipButton != null) {
                    CustomVideoUIController.this.onClick((View)CustomVideoUIController.this.mPipButton);
                }
            }
        });
    }

    public void onPause() {
        if (!(this.mActivity == null || Build.VERSION.SDK_INT > 24 && this.mActivity.isInPictureInPictureMode())) {
            if (this.mStopButton != null) {
                this.mStopButton.setOnClickListener(null);
            }
            if (this.youTubePlayerCallback != null) {
                this.youTubePlayerCallback.pause();
            }
            this.stopErrorReportCountDown();
            this.mSkipContainer.setOnRippleCompleteListener(null);
            this.mOpenContainer.setOnRippleCompleteListener(null);
            this.mVolumeContainer.setOnRippleCompleteListener(null);
            this.mPipContainer.setOnRippleCompleteListener(null);
        }
    }

    public void onDestroy() {
        this.removeRunnableHandler();
        this.mAutoSkipToggle.setOnCheckedChangeListener(null);
    }

    public void verifiedYtVideo(EmbedGigsResponse embedGigsResponse) {
        if (this.mResponse != null) {
            this.mTotalCoinEarned += this.mResponse.coin;
        }
        this.mNextYtInfo = embedGigsResponse;
        this.initSkipAd();
        if (!this.mIsVideoError && this.mResponse != null && this.mResponse.continuous && embedGigsResponse != null && embedGigsResponse.success && embedGigsResponse.video_info == null) {
            this.measureSkipContainerWidth();
            this.mFirstTime = true;
            this.mCurrentSeconds = 0.0f;
            this.mSkipRevealView.setVisibility(8);
            this.mSkipLoading.setVisibility(0);
            this.mSkipProgress.setProgress(0.0f);
            this.mIsInitialize = true;
            this.mCountDownRunnable = null;
            this.onStateChange(PlayerConstants.PlayerState.PLAYING);
        } else if (embedGigsResponse != null && this.mResponse != null && (this.mPref.getBooleanValue(YT_IS_AUTO_SKIP, false) || this.mIsYtEnded)) {
            this.mPlayerIsPlaying = false;
            this.initYtVideoInfo(embedGigsResponse);
        }
    }

    private void initUI() {
        if (!this.mIsPipMode) {
            this.mLoadingBar.setVisibility(0);
            this.mAutoSkipContainer.setVisibility(0);
            this.mStopButton.setVisibility(0);
            this.mAutoSkipToggle.setChecked(this.mPref.getBooleanValue(YT_IS_AUTO_SKIP, false));
            if (!this.mIsPolice) {
                this.mSkipContainer.setVisibility(8);
                this.mSkipProgress.setProgressColor(ResourcesUtil.getColor(R.color.primary));
            }
        }
        this.mOpenButton.setVisibility(8);
        this.mVolume.setVisibility(8);
        this.mPipButton.setVisibility(8);
    }

    private boolean onCurrentSecond(int n) {
        int n2 = Math.round(n);
        ++this.mTotalTimeWatched;
        if ((n2 == this.mMinWatchTime || n2 == 0) && this.mFirstTime) {
            this.mFirstTime = false;
            this.mListener.videoReachEndpoint(this.mIdVideoPlaying, this.mTimestamp);
            this.mSkipButton.setVisibility(8);
            this.mSkipLoading.setVisibility(0);
            return false;
        }
        if (this.mFirstTime && n2 < this.mMinWatchTime) {
            if (!this.mIsPolice) {
                this.mSkipContainer.setVisibility(0);
                this.mSkipContainer.setEnabled(false);
                this.mSkipButton.setVisibility(0);
                this.mSkipLoading.setVisibility(8);
            }
            int n3 = this.mMinWatchTime - n2;
            int n4 = n3 % 3600 / 60;
            int n5 = n3 % 60;
            String string2 = n4 > 0 ? String.format(Locale.US, "%02d:%02d", n4, n5) : String.format(Locale.US, "%ds", n5);
            this.initSkipAdCountDown(String.format(ResourcesUtil.getString(R.string.yt_skip_video_count_down), string2));
            return true;
        }
        return false;
    }

    private void initSkipAdCountDown(String string2) {
        this.removeLoadingUI();
        if (this.mSkipButton != null) {
            if (!this.mIsPipMode) {
                this.mSkipButton.setText((CharSequence)string2);
                this.mSkipButton.setTextSize(12.0f);
                int n = Utils.dpToPx(8);
                this.mSkipButton.setPadding(n, n, n, n);
                this.mSkipContainer.setEnabled(false);
            }
            this.mSkipCoinImage.getLayoutParams().width = this.mIsPipMode ? Utils.dpToPx(16) : Utils.dpToPx(28);
            this.mSkipCoinImage.getLayoutParams().height = this.mIsPipMode ? Utils.dpToPx(16) : Utils.dpToPx(28);
            this.mSkipContainer.getLayoutParams().height = this.mIsPipMode ? Utils.dpToPx(40) : Utils.dpToPx(60);
            this.mSkipButton.setVisibility(this.mIsPipMode ? 8 : 0);
            this.redrawsCountdownBar();
        }
        if (!this.mIsPipMode && this.mOpenButton != null && !this.mIsPolice) {
            if (this.mMinWatchTime > 300 || this.mTotalTimeWatched > 300) {
                this.mOpenButton.setEnabled(true);
                this.mOpenButton.setText(R.string.skip_video_now);
                this.mOpenButton.setVisibility(0);
            } else {
                this.mOpenButton.setEnabled(false);
                this.mOpenButton.setVisibility(8);
            }
        }
    }

    private void initSkipAd() {
        this.removeLoadingUI();
        if (this.mNextYtInfo != null && (this.mNextYtInfo.success && this.mNextYtInfo.video_info != null || !this.mNextYtInfo.success && this.mNextYtInfo.video_info == null)) {
            if (this.mSkipButton != null) {
                if (!this.mIsPipMode) {
                    this.mSkipButton.setVisibility(0);
                    this.mSkipButton.setText(R.string.yt_skip_video);
                    int n = Utils.dpToPx(8);
                    this.mSkipButton.setPadding(n, n, n, n);
                    this.mSkipContainer.setEnabled(true);
                    if (!this.mIsPolice) {
                        this.mSkipContainer.setVisibility(0);
                    }
                }
                this.mSkipLoading.setVisibility(8);
                this.mSkipCoinImage.getLayoutParams().width = this.mIsPipMode ? Utils.dpToPx(16) : Utils.dpToPx(28);
                this.mSkipCoinImage.getLayoutParams().height = this.mIsPipMode ? Utils.dpToPx(16) : Utils.dpToPx(28);
                this.mSkipContainer.getLayoutParams().height = this.mIsPipMode ? Utils.dpToPx(40) : Utils.dpToPx(60);
                this.mSkipButton.setVisibility(this.mIsPipMode ? 8 : 0);
                this.redrawsCountdownBar();
                this.reveal();
            }
            if (!this.mIsPipMode && this.mOpenButton != null && !this.mIsPolice) {
                if (this.mVideoUrl != null && this.mVideoType != null) {
                    this.mOpenButton.setEnabled(true);
                    this.mOpenButton.setText((CharSequence)("Watch on " + this.mVideoType.replace("_live", "")));
                    this.mOpenButton.setVisibility(0);
                } else {
                    this.mOpenButton.setEnabled(false);
                    this.mOpenButton.setVisibility(8);
                }
            }
        } else {
            this.redrawsCountdownBar();
        }
    }

    private void showUiVideo() {
        this.mFirstTime = true;
        this.mIsYtEnded = false;
        this.removeLoadingUI();
        this.mPipButton.setVisibility(this.isSupportPip() ? 0 : 8);
    }

    private void removeLoadingUI() {
        this.mLoadingBar.setVisibility(8);
        this.mAutoSkipContainer.setVisibility(8);
        this.mStopButton.setVisibility(8);
    }

    private boolean isSupportPip() {
        return Build.VERSION.SDK_INT >= 26 && this.mActivity instanceof EmbedVideoActivity;
    }

    @NonNull
    private String parsePlayerError(PlayerConstants.PlayerError playerError) {
        String string2 = playerError.equals((Object)PlayerConstants.PlayerError.INVALID_PARAMETER_IN_REQUEST) ? ERROR_INVALID_PARAMETER_IN_REQUEST : (playerError.equals((Object)PlayerConstants.PlayerError.HTML_5_PLAYER) ? ERROR_HTML_5_PLAYER : (playerError.equals((Object)PlayerConstants.PlayerError.VIDEO_NOT_FOUND) ? ERROR_VIDEO_NOT_FOUND : (playerError.equals((Object)PlayerConstants.PlayerError.VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER) ? ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER1 : (playerError.equals((Object)PlayerConstants.PlayerError.VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER) ? ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER2 : (playerError.equals((Object)PlayerConstants.PlayerError.ERROR_VIDEO_LIVE_OFFLINE) ? ERROR_VIDEO_LIVE_OFFLINE : "0")))));
        return string2;
    }

    private boolean enabledPictureInPicture() {
        AppOpsManager appOpsManager;
        if (Build.VERSION.SDK_INT >= 26 && (appOpsManager = (AppOpsManager)this.mActivity.getSystemService("appops")) != null) {
            return appOpsManager.checkOpNoThrow("android:picture_in_picture", Process.myUid(), Utils.getAppId(this.mActivity.getApplicationContext())) == 0;
        }
        return false;
    }

    public void setMute(boolean bl) {
        this.mIsMute = bl;
        this.youTubePlayerCallback.setMute(bl);
        if (this.mVolume != null && this.mActivity instanceof EmbedDoubleVideoActivity) {
            this.mVolume.setVisibility(0);
            int n = bl ? R.drawable.volume_mute : R.drawable.volume_up;
            this.mVolume.setImageDrawable(ResourcesUtil.getDrawable(n));
        }
    }

    private void setMute() {
        if (this.mActivity instanceof EmbedDoubleVideoActivity) {
            ((EmbedDoubleVideoActivity)this.mActivity).unmuteVideoPlayer(this.mPage);
        }
    }

    private void setInitialMute() {
        if (this.mActivity instanceof EmbedDoubleVideoActivity) {
            if (!((EmbedDoubleVideoActivity)this.mActivity).isUnmuteVideoExist()) {
                ((EmbedDoubleVideoActivity)this.mActivity).unmuteVideoPlayer(this.mPage);
            } else {
                this.setMute(true);
            }
        }
    }

    public String getPlayingVideoId() {
        return this.mIdVideoPlaying;
    }

    public void reload() {
        this.refreshUI();
        float f = this.mCurrentSeconds;
        int n = this.mTotalTimeWatched;
        EmbedGigsResponse embedGigsResponse = this.mNextYtInfo;
        int n2 = this.mTotalCoinEarned;
        this.mPlayerIsPlaying = false;
        this.mDefaultInterval = 0;
        this.initializeYtVideoInfo(this.mResponse);
        this.mTotalTimeWatched = n;
        this.mCurrentSeconds = f;
        this.mTotalCoinEarned = n2;
        this.mNextYtInfo = embedGigsResponse;
    }

    private void refreshUI() {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.initUI();
        this.mPanel.setBackgroundColor(ContextCompat.getColor((Context)this.mActivity, (int)17170444));
    }

    private void openSkipDialog() {
        if (!this.mPref.getBooleanValue(SKIP_DIALOG_VISIBILITY, false)) {
            View view = LayoutInflater.from((Context)this.mActivity).inflate(R.layout.checkbox, null);
            final CheckBox checkBox = (CheckBox)view.findViewById(R.id.skip);
            AlertDialog alertDialog = new AlertDialog.Builder((Context)new ContextThemeWrapper((Context)this.mActivity, R.style.AlertDialog)).setCancelable(false).setView(view).setTitle((CharSequence)ResourcesUtil.getString(R.string.skip_video_now)).setMessage((CharSequence)ResourcesUtil.getString(R.string.skip_video_no_reward_desc)).setPositiveButton(R.string.skip, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    CustomVideoUIController.this.mPref.putBooleanValue(CustomVideoUIController.SKIP_DIALOG_VISIBILITY, checkBox.isChecked());
                    CustomVideoUIController.this.mListener.skipVideo(CustomVideoUIController.this.mIdVideoPlaying);
                    CustomVideoUIController.this.skipEmbedVideo();
                }
            }).setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    dialogInterface.dismiss();
                }
            }).create();
            alertDialog.show();
        } else {
            this.mListener.skipVideo(this.mIdVideoPlaying);
            this.skipEmbedVideo();
        }
    }

    private void skipEmbedVideo() {
        if (this.mActivity instanceof EmbedDoubleVideoActivity) {
            ((EmbedDoubleVideoActivity)this.mActivity).unmuteSkipVideoPlayer(this.mPage);
            if (!this.mIsVideoHtmlExist) {
                this.setVolumeControl(true);
                ((EmbedDoubleVideoActivity)this.mActivity).setViewPlaying(false);
            }
        }
        this.youTubePlayerCallback.pause();
        this.mIsYtEnded = true;
        this.mIsOnPause = true;
        this.mPlayerView.refreshPlayer();
        this.removeRunnableHandler();
        this.refreshUI();
    }

    public void setVolumeControl(boolean bl) {
        this.mVolumeContainer.setEnabled(bl);
        this.mVolumeContainer.setVisibility(bl ? 0 : 8);
    }

    private void reveal() {
        this.mSkipRevealView.setVisibility(0);
        if (Build.VERSION.SDK_INT >= 21) {
            this.mSkipRevealView.post(new Runnable(){

                @Override
                public void run() {
                    CustomVideoUIController.this.mSkipRevealView.forceLayout();
                    CustomVideoUIController.this.mSkipRevealView.requestLayout();
                    int n = ((CustomVideoUIController)CustomVideoUIController.this).mSkipRevealView.getLayoutParams().width;
                    int n2 = ((CustomVideoUIController)CustomVideoUIController.this).mSkipRevealView.getLayoutParams().height;
                    float f = (float)Math.max(n, n2) * 1.2f;
                    Animator animator = null;
                    if (Build.VERSION.SDK_INT >= 21) {
                        animator = ViewAnimationUtils.createCircularReveal((View)CustomVideoUIController.this.mSkipRevealView, (int)0, (int)0, (float)0.0f, (float)f);
                    }
                    CustomVideoUIController.this.mSkipRevealView.setBackgroundColor(ResourcesUtil.getColor(R.color.green));
                    animator.start();
                }
            });
        } else {
            this.mSkipRevealView.setBackgroundColor(ResourcesUtil.getColor(R.color.green));
        }
    }

    private void measureSkipContainerWidth() {
        this.mSkipCoinContainer.measure(0, 0);
        this.mSkipCoin.measure(0, 0);
        ViewTreeObserver viewTreeObserver = this.mSkipCoinContainer.getViewTreeObserver();
        viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                CustomVideoUIController.this.mSkipCoinContainer.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                ((CustomVideoUIController)CustomVideoUIController.this).mSkipProgress.getLayoutParams().width = CustomVideoUIController.this.mSkipCoinContainer.getMeasuredWidth();
                ((CustomVideoUIController)CustomVideoUIController.this).mSkipRevealView.getLayoutParams().width = CustomVideoUIController.this.mSkipCoinContainer.getMeasuredWidth();
                CustomVideoUIController.this.mSkipRevealView.measure(0, 0);
            }
        });
    }

    private void removeRunnableHandler() {
        if (this.mHandler != null) {
            if (this.mViewDelayRunnable != null) {
                this.mHandler.removeCallbacks((Runnable)this.mViewDelayRunnable);
            }
            if (this.mDelayRunnable != null) {
                this.mHandler.removeCallbacks((Runnable)this.mDelayRunnable);
            }
            if (this.mErrorCountdown != null) {
                this.mHandler.removeCallbacks((Runnable)this.mErrorCountdown);
            }
            if (this.mCountDownRunnable != null) {
                this.mHandler.removeCallbacks((Runnable)this.mCountDownRunnable);
            }
        }
    }

    private void redrawsCountdownBar() {
        this.mSkipLoading.setVisibility(8);
        this.mSkipCoinImage.setVisibility(0);
        this.mSkipCoinImage.setVisibility(this.mCoinImageUrl == null || this.mCoinImageUrl.isEmpty() ? 8 : 0);
        if (this.mCoinImageUrl != null && !this.mCoinImageUrl.isEmpty()) {
            Picasso.with((Context)this.mActivity.getApplicationContext()).load(this.mCoinImageUrl).into(this.mSkipCoinImage);
        }
        String string2 = this.mCoinImageUrl == null || this.mCoinImageUrl.isEmpty() ? String.format("%s %s", this.mTotalCoinEarned, this.mVirtualCoin) : String.valueOf(this.mTotalCoinEarned);
        this.mSkipCoin.setText((CharSequence)string2);
        this.measureSkipContainerWidth();
    }

    static /* synthetic */ float access$1208(CustomVideoUIController customVideoUIController) {
        float f = customVideoUIController.mCurrentSeconds;
        customVideoUIController.mCurrentSeconds = f + 1.0f;
        return f;
    }

    class CountDownRunnable
    implements Runnable {
        CountDownRunnable() {
        }

        @Override
        public void run() {
            if (CustomVideoUIController.this.mIsOnPause) {
                return;
            }
            CustomVideoUIController.this.mHandler.removeCallbacksAndMessages(null);
            if (CustomVideoUIController.this.mMinWatchTime > 0) {
                CustomVideoUIController.access$1208(CustomVideoUIController.this);
            }
            if (CustomVideoUIController.this.mSkipProgress != null) {
                ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)CustomVideoUIController.this.mSkipProgress, (String)"progress", (float[])new float[]{CustomVideoUIController.this.mSkipProgress.getProgress(), CustomVideoUIController.this.mCurrentSeconds});
                objectAnimator.setDuration(3000L);
                objectAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                objectAnimator.start();
            }
            if (CustomVideoUIController.this.onCurrentSecond(Math.round(CustomVideoUIController.this.mCurrentSeconds))) {
                CustomVideoUIController.this.mHandler.postDelayed((Runnable)CustomVideoUIController.this.mCountDownRunnable, 1000L);
            } else if (CustomVideoUIController.this.mNextYtInfo != null && ((CustomVideoUIController)CustomVideoUIController.this).mNextYtInfo.video_info != null) {
                CustomVideoUIController.this.initSkipAd();
            }
        }
    }

    class ErrorCountDownRunnable
    implements Runnable {
        ErrorCountDownRunnable() {
        }

        @Override
        public void run() {
            CustomVideoUIController.this.onError(PlayerConstants.PlayerError.UNKNOWN);
        }
    }

    class DelayRunnable
    implements Runnable {
        private String mVideoId;

        DelayRunnable(String string2) {
            this.mVideoId = string2;
        }

        @Override
        public void run() {
            CustomVideoUIController.this.showUiVideo();
            CustomVideoUIController.this.createErrorReportCountdown();
            CustomVideoUIController.this.mIsInitialize = true;
            CustomVideoUIController.this.mPanel.setBackgroundColor(ContextCompat.getColor((Context)CustomVideoUIController.this.mActivity, (int)17170445));
            float f = CustomVideoUIController.this.mCurrentSeconds;
            if (CustomVideoUIController.this.mVideoType.contains("live")) {
                f = 0.0f;
            }
            if (CustomVideoUIController.this.mIsVideoStart) {
                CustomVideoUIController.this.setInitialMute();
                CustomVideoUIController.this.mIsVideoStart = false;
            }
            CustomVideoUIController.this.youTubePlayerCallback.loadVideo(this.mVideoId, f);
            CustomVideoUIController.this.mDefaultInterval = CustomVideoUIController.this.mDelayInterval;
        }
    }

    class ViewDelayRunnable
    implements Runnable {
        private EmbedGigsResponse response;

        ViewDelayRunnable(EmbedGigsResponse embedGigsResponse) {
            this.response = embedGigsResponse;
        }

        @Override
        public void run() {
            CustomVideoUIController.this.showUiVideo();
            CustomVideoUIController.this.mIsInitialize = true;
            CustomVideoUIController.this.mPlayerView.initPlayer(this.response.video_info.url, this.response.video_html);
            CustomVideoUIController.this.mDefaultInterval = CustomVideoUIController.this.mDelayInterval;
        }
    }

    public static interface Listener {
        public void videoReachEndpoint(String var1, int var2);

        public void videoNotAvailable();

        public void forceStopVideo();

        public void youtubePlayableError(String var1, String var2);

        public void enablePictureInPicture();

        public void skipVideo(String var1);
    }
}

