/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.ui;

import android.animation.Animator;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.appzilo.sdk.video.R;
import com.appzilo.sdk.video.player.PlayerConstants;
import com.appzilo.sdk.video.player.VideoPlayer;
import com.appzilo.sdk.video.player.VideoPlayerView;
import com.appzilo.sdk.video.player.listeners.VideoPlayerFullScreenListener;
import com.appzilo.sdk.video.player.listeners.VideoPlayerListener;
import com.appzilo.sdk.video.ui.PlayerUIController;
import com.appzilo.sdk.video.ui.menu.YouTubePlayerMenu;
import com.appzilo.sdk.video.ui.menu.defaultMenu.DefaultYouTubePlayerMenu;
import com.appzilo.sdk.video.utils.Utils;

public class DefaultPlayerUIController
implements View.OnClickListener,
SeekBar.OnSeekBarChangeListener,
VideoPlayerFullScreenListener,
VideoPlayerListener,
PlayerUIController {
    @NonNull
    private final VideoPlayerView videoPlayerView;
    @NonNull
    private final VideoPlayer videoPlayer;
    private final Handler handler = new Handler(Looper.getMainLooper());
    @NonNull
    private YouTubePlayerMenu youTubePlayerMenu;
    private View panel;
    private View controlsRoot;
    private LinearLayout extraViewsContainer;
    private TextView videoTitle;
    private TextView videoCurrentTime;
    private TextView videoDuration;
    private TextView liveVideoIndicator;
    private ProgressBar progressBar;
    private ImageView menuButton;
    private ImageView playPauseButton;
    private ImageView youTubeButton;
    private ImageView fullScreenButton;
    private ImageView customActionLeft;
    private ImageView customActionRight;
    private SeekBar seekBar;
    @Nullable
    private View.OnClickListener onFullScreenButtonListener;
    @Nullable
    private View.OnClickListener onMenuButtonClickListener;
    private boolean isPlaying = false;
    private boolean isVisible = true;
    private boolean canFadeControls = false;
    private boolean showUI = true;
    private final Runnable fadeOutRunnable = new Runnable(){

        @Override
        public void run() {
            DefaultPlayerUIController.this.fadeControls(0.0f);
        }
    };
    private boolean showPlayPauseButton = true;
    private boolean showBufferingProgress = true;
    private boolean showCustomActionLeft = false;
    private boolean showCustomActionRight = false;
    private boolean seekBarTouchStarted = false;
    private int newSeekBarProgress = -1;

    public DefaultPlayerUIController(@NonNull VideoPlayerView videoPlayerView, @NonNull VideoPlayer videoPlayer) {
        this.videoPlayerView = videoPlayerView;
        this.videoPlayer = videoPlayer;
        View view = View.inflate((Context)videoPlayerView.getContext(), (int)R.layout.default_player_ui, (ViewGroup)videoPlayerView);
        this.initViews(view);
        this.youTubePlayerMenu = new DefaultYouTubePlayerMenu(videoPlayerView.getContext());
    }

    private void initViews(View view) {
        this.panel = view.findViewById(R.id.panel);
        this.controlsRoot = view.findViewById(R.id.controls_root);
        this.extraViewsContainer = (LinearLayout)view.findViewById(R.id.extra_views_container);
        this.videoTitle = (TextView)view.findViewById(R.id.video_title);
        this.videoCurrentTime = (TextView)view.findViewById(R.id.video_current_time);
        this.videoDuration = (TextView)view.findViewById(R.id.video_duration);
        this.liveVideoIndicator = (TextView)view.findViewById(R.id.live_video_indicator);
        this.progressBar = (ProgressBar)view.findViewById(R.id.progress);
        this.menuButton = (ImageView)view.findViewById(R.id.menu_button);
        this.playPauseButton = (ImageView)view.findViewById(R.id.play_pause_button);
        this.youTubeButton = (ImageView)view.findViewById(R.id.youtube_button);
        this.fullScreenButton = (ImageView)view.findViewById(R.id.fullscreen_button);
        this.customActionLeft = (ImageView)view.findViewById(R.id.custom_action_left_button);
        this.customActionRight = (ImageView)view.findViewById(R.id.custom_action_right_button);
        this.seekBar = (SeekBar)view.findViewById(R.id.seek_bar);
        this.seekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.panel.setOnClickListener((View.OnClickListener)this);
        this.playPauseButton.setOnClickListener((View.OnClickListener)this);
        this.menuButton.setOnClickListener((View.OnClickListener)this);
        this.fullScreenButton.setOnClickListener((View.OnClickListener)this);
    }

    @Override
    public void showVideoTitle(boolean bl) {
        int n = bl ? 0 : 8;
        this.videoTitle.setVisibility(n);
    }

    @Override
    public void setVideoTitle(@NonNull String string2) {
        this.videoTitle.setText((CharSequence)string2);
    }

    @Override
    public void showUI(boolean bl) {
        int n = bl ? 0 : 4;
        this.controlsRoot.setVisibility(n);
        this.showUI = bl;
    }

    @Override
    public void showPlayPauseButton(boolean bl) {
        int n = bl ? 0 : 8;
        this.playPauseButton.setVisibility(n);
        this.showPlayPauseButton = bl;
    }

    @Override
    public void enableLiveVideoUI(boolean bl) {
        if (bl) {
            this.videoDuration.setVisibility(4);
            this.seekBar.setVisibility(4);
            this.videoCurrentTime.setVisibility(4);
            this.liveVideoIndicator.setVisibility(0);
        } else {
            this.videoDuration.setVisibility(0);
            this.seekBar.setVisibility(0);
            this.videoCurrentTime.setVisibility(0);
            this.liveVideoIndicator.setVisibility(8);
        }
    }

    @Override
    public void setCustomAction1(@NonNull Drawable drawable2, View.OnClickListener onClickListener) {
        this.customActionLeft.setImageDrawable(drawable2);
        this.customActionLeft.setOnClickListener(onClickListener);
        this.showCustomAction1(true);
    }

    @Override
    public void setCustomAction2(@NonNull Drawable drawable2, View.OnClickListener onClickListener) {
        this.customActionRight.setImageDrawable(drawable2);
        this.customActionRight.setOnClickListener(onClickListener);
        this.showCustomAction2(true);
    }

    @Override
    public void showCustomAction1(boolean bl) {
        this.showCustomActionLeft = bl;
        int n = bl ? 0 : 8;
        this.customActionLeft.setVisibility(n);
    }

    @Override
    public void showCustomAction2(boolean bl) {
        this.showCustomActionRight = bl;
        int n = bl ? 0 : 8;
        this.customActionRight.setVisibility(n);
    }

    @Override
    public void showMenuButton(boolean bl) {
        int n = bl ? 0 : 8;
        this.menuButton.setVisibility(n);
    }

    @Override
    public void setMenuButtonClickListener(@NonNull View.OnClickListener onClickListener) {
        this.onMenuButtonClickListener = onClickListener;
    }

    @Override
    public void showCurrentTime(boolean bl) {
        int n = bl ? 0 : 8;
        this.videoCurrentTime.setVisibility(n);
    }

    @Override
    public void showDuration(boolean bl) {
        int n = bl ? 0 : 8;
        this.videoDuration.setVisibility(n);
    }

    @Override
    public void showSeekBar(boolean bl) {
        int n = bl ? 0 : 4;
        this.seekBar.setVisibility(n);
    }

    @Override
    public void showBufferingProgress(boolean bl) {
        this.showBufferingProgress = bl;
    }

    @Override
    public void showYouTubeButton(boolean bl) {
        int n = bl ? 0 : 8;
        this.youTubeButton.setVisibility(n);
    }

    @Override
    public void addView(@NonNull View view) {
        this.extraViewsContainer.addView(view, 0);
    }

    @Override
    public void removeView(@NonNull View view) {
        this.extraViewsContainer.removeView(view);
    }

    @Override
    @NonNull
    public YouTubePlayerMenu getMenu() {
        return this.youTubePlayerMenu;
    }

    @Override
    public void setMenu(@NonNull YouTubePlayerMenu youTubePlayerMenu) {
        this.youTubePlayerMenu = youTubePlayerMenu;
    }

    @Override
    public void showFullscreenButton(boolean bl) {
        int n = bl ? 0 : 8;
        this.fullScreenButton.setVisibility(n);
    }

    @Override
    public void setFullScreenButtonClickListener(@NonNull View.OnClickListener onClickListener) {
        this.onFullScreenButtonListener = onClickListener;
    }

    public void onClick(View view) {
        if (view == this.panel) {
            this.toggleControlsVisibility();
        } else if (view == this.playPauseButton) {
            this.onPlayButtonPressed();
        } else if (view == this.fullScreenButton) {
            this.onFullScreenButtonPressed();
        } else if (view == this.menuButton) {
            this.onMenuButtonPressed();
        }
    }

    private void onMenuButtonPressed() {
        if (this.onMenuButtonClickListener == null) {
            this.youTubePlayerMenu.show((View)this.menuButton);
        } else {
            this.onMenuButtonClickListener.onClick((View)this.menuButton);
        }
    }

    private void onFullScreenButtonPressed() {
        if (this.onFullScreenButtonListener == null) {
            this.videoPlayerView.toggleFullScreen();
        } else {
            this.onFullScreenButtonListener.onClick((View)this.fullScreenButton);
        }
    }

    private void onPlayButtonPressed() {
        if (this.isPlaying) {
            this.videoPlayer.pause();
        } else {
            this.videoPlayer.play();
        }
    }

    private void updatePlayPauseButtonIcon(boolean bl) {
        int n = bl ? R.drawable.ic_pause_36dp : R.drawable.ic_play_36dp;
        this.playPauseButton.setImageResource(n);
    }

    private void toggleControlsVisibility() {
        float f = this.isVisible ? 0.0f : 1.0f;
        this.fadeControls(f);
    }

    private void fadeControls(final float f) {
        if (!this.canFadeControls || !this.showUI) {
            return;
        }
        boolean bl = this.isVisible = f != 0.0f;
        if (f == 1.0f && this.isPlaying) {
            this.startFadeOutViewTimer();
        } else {
            this.handler.removeCallbacks(this.fadeOutRunnable);
        }
        this.controlsRoot.animate().alpha(f).setDuration(300L).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                if (f == 1.0f) {
                    DefaultPlayerUIController.this.controlsRoot.setVisibility(0);
                }
            }

            public void onAnimationEnd(Animator animator) {
                if (f == 0.0f) {
                    DefaultPlayerUIController.this.controlsRoot.setVisibility(8);
                }
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        }).start();
    }

    private void startFadeOutViewTimer() {
        this.handler.postDelayed(this.fadeOutRunnable, 3000L);
    }

    @Override
    public void onYouTubePlayerEnterFullScreen() {
        this.fullScreenButton.setImageResource(R.drawable.ic_fullscreen_exit_24dp);
    }

    @Override
    public void onYouTubePlayerExitFullScreen() {
        this.fullScreenButton.setImageResource(R.drawable.ic_fullscreen_24dp);
    }

    @Override
    public void onStateChange(@NonNull PlayerConstants.PlayerState playerState) {
        this.newSeekBarProgress = -1;
        this.updateControlsState(playerState);
        if (playerState == PlayerConstants.PlayerState.PLAYING || playerState == PlayerConstants.PlayerState.PAUSED || playerState == PlayerConstants.PlayerState.VIDEO_CUED) {
            this.panel.setBackgroundColor(ContextCompat.getColor((Context)this.videoPlayerView.getContext(), (int)17170445));
            this.progressBar.setVisibility(8);
            if (this.showPlayPauseButton) {
                this.playPauseButton.setVisibility(0);
            }
            if (this.showCustomActionLeft) {
                this.customActionLeft.setVisibility(0);
            }
            if (this.showCustomActionRight) {
                this.customActionRight.setVisibility(0);
            }
            this.canFadeControls = true;
            boolean bl = playerState == PlayerConstants.PlayerState.PLAYING;
            this.updatePlayPauseButtonIcon(bl);
            if (bl) {
                this.startFadeOutViewTimer();
            } else {
                this.handler.removeCallbacks(this.fadeOutRunnable);
            }
        } else {
            this.updatePlayPauseButtonIcon(false);
            this.fadeControls(1.0f);
            if (playerState == PlayerConstants.PlayerState.BUFFERING) {
                this.panel.setBackgroundColor(ContextCompat.getColor((Context)this.videoPlayerView.getContext(), (int)17170445));
                if (this.showPlayPauseButton) {
                    this.playPauseButton.setVisibility(4);
                }
                this.customActionLeft.setVisibility(8);
                this.customActionRight.setVisibility(8);
                this.canFadeControls = false;
            }
            if (playerState == PlayerConstants.PlayerState.UNSTARTED) {
                this.canFadeControls = false;
                this.progressBar.setVisibility(8);
                if (this.showPlayPauseButton) {
                    this.playPauseButton.setVisibility(0);
                }
            }
        }
    }

    private void updateControlsState(PlayerConstants.PlayerState playerState) {
        switch (playerState) {
            case ENDED: {
                this.isPlaying = false;
                break;
            }
            case PAUSED: {
                this.isPlaying = false;
                break;
            }
            case PLAYING: {
                this.isPlaying = true;
                break;
            }
            case UNSTARTED: {
                this.resetUI();
                break;
            }
        }
        this.updatePlayPauseButtonIcon(!this.isPlaying);
    }

    @Override
    public void onCurrentSecond(float f) {
        if (this.seekBarTouchStarted) {
            return;
        }
        if (this.newSeekBarProgress > 0 && !Utils.formatTime(f).equals(Utils.formatTime(this.newSeekBarProgress))) {
            return;
        }
        this.newSeekBarProgress = -1;
        this.seekBar.setProgress((int)f);
    }

    @Override
    public void onVideoDuration(float f) {
        this.videoDuration.setText((CharSequence)Utils.formatTime(f));
        this.seekBar.setMax((int)f);
    }

    @Override
    public void onVideoLoadedFraction(float f) {
        if (this.showBufferingProgress) {
            this.seekBar.setSecondaryProgress((int)(f * (float)this.seekBar.getMax()));
        } else {
            this.seekBar.setSecondaryProgress(0);
        }
    }

    @Override
    public void onVideoId(final @NonNull String string2) {
        this.youTubeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("http://www.youtube.com/watch?v=" + string2 + "#t=" + DefaultPlayerUIController.this.seekBar.getProgress())));
                DefaultPlayerUIController.this.controlsRoot.getContext().startActivity(intent);
            }
        });
    }

    @Override
    public void onReady() {
    }

    @Override
    public void onPlaybackQualityChange(@NonNull PlayerConstants.PlaybackQuality playbackQuality) {
    }

    @Override
    public void onPlaybackRateChange(@NonNull PlayerConstants.PlaybackRate playbackRate) {
    }

    @Override
    public void onError(@NonNull PlayerConstants.PlayerError playerError) {
    }

    @Override
    public void onApiChange() {
    }

    public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
        this.videoCurrentTime.setText((CharSequence)Utils.formatTime(n));
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        this.seekBarTouchStarted = true;
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        if (this.isPlaying) {
            this.newSeekBarProgress = seekBar.getProgress();
        }
        this.videoPlayer.seekTo(seekBar.getProgress());
        this.seekBarTouchStarted = false;
    }

    private void resetUI() {
        this.seekBar.setProgress(0);
        this.seekBar.setMax(0);
        this.videoDuration.post(new Runnable(){

            @Override
            public void run() {
                DefaultPlayerUIController.this.videoDuration.setText((CharSequence)"");
            }
        });
    }
}

