/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.core;

import android.content.Context;
import android.os.Build;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.Error;
import com.appzilo.sdk.video.core.Logger;
import com.appzilo.sdk.video.core.Result;
import com.appzilo.sdk.video.core.SyncCookieHandler;
import com.appzilo.sdk.video.utils.SharedPreferencesUtil;
import com.appzilo.sdk.video.utils.Utils;
import com.franmontiel.persistentcookiejar.PersistentCookieJar;
import com.franmontiel.persistentcookiejar.cache.CookieCache;
import com.franmontiel.persistentcookiejar.cache.SetCookieCache;
import com.franmontiel.persistentcookiejar.persistence.CookiePersistor;
import com.franmontiel.persistentcookiejar.persistence.SharedPrefsCookiePersistor;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.CookieJar;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Http {
    private static final String COOKIES = "set-cookie";
    private static OkHttpClient sClient;
    private static PersistentCookieJar mCookieJar;
    private static String mAppKey;
    private static String sUserAgent;
    private static SharedPreferencesUtil mPrefUtil;

    public static void init(Context context) {
        mPrefUtil = new SharedPreferencesUtil(context);
    }

    public static Request request(Context context, String string) {
        mAppKey = string;
        return Http.request(context);
    }

    public static Request request(Context context) {
        if (sClient == null) {
            mCookieJar = new PersistentCookieJar((CookieCache)new SetCookieCache(), (CookiePersistor)new SharedPrefsCookiePersistor(context));
            sClient = new OkHttpClient.Builder().connectTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).cookieJar((CookieJar)new SyncCookieHandler()).build();
        }
        return new Request(context);
    }

    public static void destroy() {
        sClient = null;
    }

    public static String getDefaultAgent(Context context) {
        if (sUserAgent == null || sUserAgent.isEmpty()) {
            if (Build.VERSION.SDK_INT >= 17) {
                sUserAgent = WebSettings.getDefaultUserAgent((Context)context);
            } else {
                try {
                    Constructor constructor = WebSettings.class.getDeclaredConstructor(Context.class, WebView.class);
                    constructor.setAccessible(true);
                    try {
                        WebSettings webSettings = (WebSettings)constructor.newInstance(context, null);
                        sUserAgent = webSettings.getUserAgentString();
                    }
                    finally {
                        constructor.setAccessible(false);
                    }
                }
                catch (Exception exception) {
                    sUserAgent = System.getProperty("http.agent");
                }
            }
        }
        return sUserAgent;
    }

    public static class Request {
        private Request.Builder mBuilder;
        private List<String> mLog = new ArrayList<String>();
        private Context mContext;
        private SharedPreferencesUtil mPrefUtil;
        private String mUrl;

        Request(Context context) {
            this.mBuilder = new Request.Builder();
            this.mPrefUtil = new SharedPreferencesUtil(context);
            NoticeResponse noticeResponse = NoticeApi.getNoticeResponse(context);
            if (noticeResponse != null && noticeResponse.credential.app_key != null) {
                mAppKey = noticeResponse.credential.app_key;
            }
            this.mBuilder.addHeader("App-Key", mAppKey);
            this.mLog.add("App-Key: " + mAppKey);
            String string = Http.getDefaultAgent(context);
            if (string != null) {
                this.mBuilder.addHeader("User-Agent", string);
                this.mLog.add("User Agent: " + string);
            }
            this.mContext = context;
        }

        public Request url(String string) {
            this.mUrl = string;
            this.mBuilder.url(string);
            this.mLog.add(0, "URL: " + string);
            return this;
        }

        public Request tag(String string) {
            this.mBuilder.tag((Object)string);
            return this;
        }

        public Request post(Map<String, String> map) {
            if (map != null) {
                FormBody.Builder builder = new FormBody.Builder();
                if (!this.mPrefUtil.getStringValue("dbm", "").isEmpty()) {
                    map.put("dbm", this.mPrefUtil.getStringValue("dbm", ""));
                }
                if (this.mUrl.contains("appzilo.com") && !this.mPrefUtil.getStringValue("az_dbm", "").isEmpty()) {
                    map.put("dbm_key", this.mPrefUtil.getStringValue("az_dbm", ""));
                }
                if (this.mUrl.contains("getmoocash.com") && !this.mPrefUtil.getStringValue("moo_dbm", "").isEmpty()) {
                    map.put("dbm_key", this.mPrefUtil.getStringValue("moo_dbm", ""));
                }
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string = entry.getValue();
                    if (string == null) {
                        string = "";
                    }
                    builder.add(entry.getKey(), string);
                }
                this.mLog.add("PARAM: " + map.toString());
                this.mBuilder.post((RequestBody)builder.build());
            }
            return this;
        }

        public Result send() {
            Result result;
            if (!Utils.isOnline(this.mContext) || sClient == null) {
                result = new Result(Error.OFFLINE);
            } else {
                Object object = null;
                try {
                    Response object2 = sClient.newCall(this.mBuilder.build()).execute();
                    this.mLog.add("Code: " + object2.code() + " " + object2.message());
                    if (object2.isSuccessful()) {
                        object = object2.body().string();
                    }
                }
                catch (IOException iOException) {
                    this.mLog.add("Error: " + iOException.getMessage());
                }
                if (object != null) {
                    this.mLog.add("Response: " + object);
                    result = new Result(null, object);
                } else {
                    result = new Result(Error.NETWORK);
                }
            }
            for (String string : this.mLog) {
                Logger.d("HTTP[" + Integer.toHexString(this.hashCode()) + "] " + string);
            }
            return result;
        }

        public Call call() {
            return sClient.newCall(this.mBuilder.build());
        }
    }
}

