/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.backend;

import android.content.Context;
import android.os.Bundle;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.AutoRedirectGigsResponse;
import com.appzilo.sdk.video.backend.model.EmbedGigsResponse;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.App;
import com.appzilo.sdk.video.core.Error;
import com.appzilo.sdk.video.core.Http;
import com.appzilo.sdk.video.core.Result;
import com.appzilo.sdk.video.utils.Utils;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;

public class GigsApi {
    public static final String VIDEO_CATEGORY = "video_category";
    public static final String YOUTUBE_GIGS_ID = "tid";
    public static final String YOUTUBE_TIMSTAMP = "ts";
    public static final String YOUTUBE_ERROR = "sid";
    public static final String IS_FEATURED = "is_featured";
    private final String TASK_GET_TASKS = "GigsBackend.getTasks";
    private final String TASK_GET_YOUTUBE = "GigsBackend.getYoutube";
    private final String TASK_VERIFY_YOUTUBE = "GigsBackend.verifiyYoutube";
    private final String TASK_VERIFY_REDIRECT_PAGE = "GigsBackend.verifyRedirectPage";
    private final String TASK_GET_REDIRECT_PAGE = "GigsBackend.getRedirectPage";
    private final String TASK_REPORT_YOUTUBE = "GigsBackend.reportYoutube";
    private final String TASK_GET_POLICE_VIDEO = "GigsBackend.getPoliceVideo";
    private final String GIGS_TASK_URL = App.getIsLive() ? "http://app.getmoocash.com/task/?" : "http://www.uploadhub.com/getmoocash/task/?";
    private String mAppKey;
    private Context mContext;

    public GigsApi(Context context) {
        this.mContext = context;
        this.getAppKey(context);
    }

    private void getAppKey(Context context) {
        NoticeResponse noticeResponse = NoticeApi.getNoticeResponse(context);
        if (noticeResponse != null) {
            this.mAppKey = noticeResponse.credential.app_key;
        }
    }

    public Result getYtVideo(Bundle bundle) {
        String string;
        EmbedGigsResponse embedGigsResponse = null;
        if (!Utils.isOnline(this.mContext)) {
            return new Result(Error.OFFLINE);
        }
        Result result = Http.request(this.mContext).url(this.GIGS_TASK_URL).post(this.getParams("GigsBackend.getYoutube", bundle)).tag("GigsBackend.getYoutube").send();
        if (result.isSuccess() && (string = (String)result.getResult()) != null) {
            try {
                embedGigsResponse = (EmbedGigsResponse)App.gson().fromJson(string, EmbedGigsResponse.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
            if (embedGigsResponse != null) {
                return new Result(null, embedGigsResponse);
            }
            return new Result(Error.DATA);
        }
        return new Result(Error.NETWORK);
    }

    public Result reportYoutube(Bundle bundle) {
        String string;
        EmbedGigsResponse embedGigsResponse = null;
        if (!Utils.isOnline(this.mContext)) {
            return new Result(Error.OFFLINE);
        }
        this.getAppKey(this.mContext);
        Result result = Http.request(this.mContext).url(this.GIGS_TASK_URL).post(this.getParams("GigsBackend.reportYoutube", bundle)).tag("GigsBackend.reportYoutube").send();
        if (result.isSuccess() && (string = (String)result.getResult()) != null) {
            try {
                embedGigsResponse = (EmbedGigsResponse)App.gson().fromJson(string, EmbedGigsResponse.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
            if (embedGigsResponse != null) {
                return new Result(null, embedGigsResponse);
            }
            return new Result(Error.DATA);
        }
        return new Result(Error.NETWORK);
    }

    public Result verifyWatchedYtVideo(Bundle bundle) {
        String string;
        EmbedGigsResponse embedGigsResponse = null;
        if (!Utils.isOnline(this.mContext)) {
            return new Result(Error.OFFLINE);
        }
        Result result = Http.request(this.mContext).url(this.GIGS_TASK_URL).post(this.getParams("GigsBackend.verifiyYoutube", bundle)).tag("GigsBackend.verifiyYoutube").send();
        if (result.isSuccess() && (string = (String)result.getResult()) != null) {
            try {
                embedGigsResponse = (EmbedGigsResponse)App.gson().fromJson(string, EmbedGigsResponse.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
            if (embedGigsResponse != null) {
                return new Result(null, embedGigsResponse);
            }
            return new Result(Error.DATA);
        }
        return new Result(Error.NETWORK);
    }

    public Result getRedirectPage(Bundle bundle) {
        String string;
        AutoRedirectGigsResponse autoRedirectGigsResponse = null;
        if (!Utils.isOnline(this.mContext)) {
            return new Result(Error.OFFLINE);
        }
        Result result = Http.request(this.mContext).url(this.GIGS_TASK_URL).post(this.getParams("GigsBackend.getRedirectPage", bundle)).tag("GigsBackend.getRedirectPage").send();
        if (result.isSuccess() && (string = (String)result.getResult()) != null) {
            try {
                autoRedirectGigsResponse = (AutoRedirectGigsResponse)App.gson().fromJson(string, AutoRedirectGigsResponse.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
            if (autoRedirectGigsResponse != null) {
                return new Result(null, autoRedirectGigsResponse);
            }
            return new Result(Error.DATA);
        }
        return new Result(Error.NETWORK);
    }

    public Result verifyRedirectPage(Bundle bundle) {
        String string;
        AutoRedirectGigsResponse autoRedirectGigsResponse = null;
        if (!Utils.isOnline(this.mContext)) {
            return new Result(Error.OFFLINE);
        }
        Result result = Http.request(this.mContext).url(this.GIGS_TASK_URL).post(this.getParams("GigsBackend.verifyRedirectPage", bundle)).tag("GigsBackend.verifyRedirectPage").send();
        if (result.isSuccess() && (string = (String)result.getResult()) != null) {
            try {
                autoRedirectGigsResponse = (AutoRedirectGigsResponse)App.gson().fromJson(string, AutoRedirectGigsResponse.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
            if (autoRedirectGigsResponse != null) {
                return new Result(null, autoRedirectGigsResponse);
            }
            return new Result(Error.DATA);
        }
        return new Result(Error.NETWORK);
    }

    public Result getPoliceVideo() {
        String string;
        EmbedGigsResponse[] embedGigsResponseArray = null;
        if (!Utils.isOnline(this.mContext)) {
            return new Result(Error.OFFLINE);
        }
        Result result = Http.request(this.mContext).url("https://www.dropbox.com/s/d1iv1prpdf76shg/youtube_task.txt?dl=1").tag("GigsBackend.getPoliceVideo").send();
        if (result.isSuccess() && (string = (String)result.getResult()) != null) {
            try {
                embedGigsResponseArray = (EmbedGigsResponse[])App.gson().fromJson(string, EmbedGigsResponse[].class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
            if (embedGigsResponseArray != null) {
                return new Result(null, embedGigsResponseArray);
            }
            return new Result(Error.DATA);
        }
        return new Result(Error.NETWORK);
    }

    private Map<String, String> getParams(String string, Bundle bundle) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("view", "json");
        if (bundle.containsKey(IS_FEATURED) && bundle.getBoolean(IS_FEATURED, false)) {
            hashMap.put("ft", "1");
        }
        if (bundle.containsKey(VIDEO_CATEGORY) && bundle.getInt(VIDEO_CATEGORY, 0) > 0) {
            hashMap.put("cid", String.valueOf(bundle.getInt(VIDEO_CATEGORY, 0)));
        }
        switch (string) {
            case "GigsBackend.getTasks": {
                return hashMap;
            }
            case "GigsBackend.getYoutube": {
                hashMap.put("op", "get_video");
                hashMap.put("v", "3");
                return hashMap;
            }
            case "GigsBackend.getRedirectPage": {
                hashMap.put("op", "get_page");
                return hashMap;
            }
            case "GigsBackend.verifiyYoutube": 
            case "GigsBackend.verifyRedirectPage": {
                hashMap.put("op", "watched");
                hashMap.put("v", "3");
                if (bundle.containsKey(YOUTUBE_GIGS_ID)) {
                    hashMap.put(YOUTUBE_GIGS_ID, bundle.getString(YOUTUBE_GIGS_ID));
                    hashMap.put("hsh", Utils.javaEncrypt(bundle.getString(YOUTUBE_GIGS_ID) + "," + bundle.getInt(YOUTUBE_TIMSTAMP)));
                }
                if (string.equals("GigsBackend.verifiyYoutube")) {
                    hashMap.remove("dbg");
                }
                return hashMap;
            }
            case "GigsBackend.reportYoutube": {
                hashMap.put("op", "report_prob");
                hashMap.put("v", "3");
                if (bundle.containsKey(YOUTUBE_ERROR)) {
                    hashMap.put(YOUTUBE_ERROR, bundle.getString(YOUTUBE_ERROR));
                }
                hashMap.put(YOUTUBE_GIGS_ID, bundle.getString(YOUTUBE_GIGS_ID));
            }
        }
        return hashMap;
    }
}

