/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.SwitchCompat;
import android.view.View;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.TextView;
import com.appzilo.sdk.video.R;
import com.appzilo.sdk.video.backend.model.EmbedGigsResponse;
import com.appzilo.sdk.video.core.Logger;
import com.appzilo.sdk.video.player.PlayerConstants;
import com.appzilo.sdk.video.player.VideoPlayer;
import com.appzilo.sdk.video.player.VideoPlayerView;
import com.appzilo.sdk.video.player.listeners.AbstractVideoPlayerListener;
import com.appzilo.sdk.video.utils.ResourcesUtil;
import com.appzilo.sdk.video.utils.SharedPreferencesUtil;
import com.appzilo.sdk.video.utils.Utils;

public class CustomVideoUIController
extends AbstractVideoPlayerListener
implements View.OnClickListener,
CompoundButton.OnCheckedChangeListener {
    private static final String YT_IS_AUTO_SKIP = "yt_is_auto_skip";
    private static final String ERROR_INVALID_PARAMETER_IN_REQUEST = "2";
    private static final String ERROR_HTML_5_PLAYER = "5";
    private static final String ERROR_VIDEO_NOT_FOUND = "100";
    private static final String ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER1 = "101";
    private static final String ERROR_VIDEO_LIVE_OFFLINE = "102";
    private static final String ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER2 = "150";
    private final int countdownInterval = 1000;
    private View mPanel;
    private View mLoadingBar;
    private SwitchCompat mAutoSkipToggle;
    private View mAutoSkipContainer;
    private Button mStopButton;
    private View mLiveIndicator;
    private TextView mLiveStatus;
    private Button mSkipButton;
    private SharedPreferencesUtil mPref;
    private int mDefaultInterval = 0;
    private int mDelayInterval = 10000;
    private Context context;
    private VideoPlayer youTubePlayerCallback;
    private Listener mListener;
    private int mMinWatchTime;
    private String mIdVideoPlaying;
    private boolean mPlayerIsPlaying;
    private EmbedGigsResponse mNextYtInfo;
    private int mTimestamp;
    private boolean mFirstTime;
    private Handler mHandler;
    private boolean mIsYtEnded;
    private boolean mIsPolice;
    private CountDownRunnable mCountDownRunnable;
    private boolean mIsOnPause;
    private int mCurrentSeconds;
    private VideoPlayerView mPlayerView;
    private String mVideoUniqueId;
    private boolean mIsInitialize;
    private ErrorCountDownRunnable mErrorCountdown;
    private int mErrorReportMaxTime;
    private boolean mIsVideoHtmlExist;
    private Button mOpenButton;
    private String mVideoUrl;
    private String mVideoType;

    public CustomVideoUIController(Context context, View view, VideoPlayer videoPlayer, VideoPlayerView videoPlayerView, int n, boolean bl) {
        this.context = context;
        if (context instanceof Listener) {
            this.mListener = (Listener)context;
        }
        ResourcesUtil.init(context);
        this.youTubePlayerCallback = videoPlayer;
        if (n > 0) {
            this.mDelayInterval = n;
        }
        this.initViews(view);
        this.mIsPolice = bl;
        this.mPref = new SharedPreferencesUtil(context);
        this.mPlayerView = videoPlayerView;
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    private void initViews(View view) {
        this.mPanel = view.findViewById(R.id.panel);
        this.mLoadingBar = view.findViewById(R.id.progress_bar);
        this.mOpenButton = (Button)view.findViewById(R.id.open_button);
        this.mAutoSkipContainer = view.findViewById(R.id.yt_auto_skip_container);
        this.mAutoSkipToggle = (SwitchCompat)view.findViewById(R.id.yt_auto_skip);
        this.mStopButton = (Button)view.findViewById(R.id.stop_button);
        this.mAutoSkipToggle.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.mSkipButton = (Button)view.findViewById(R.id.skip_button);
        this.mLiveIndicator = view.findViewById(R.id.live_container);
        this.mLiveStatus = (TextView)view.findViewById(R.id.live_status);
        if (this.mIsPolice) {
            this.mSkipButton.setVisibility(8);
        }
        if (this.mSkipButton != null) {
            this.mSkipButton.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mOpenButton != null) {
            this.mOpenButton.setOnClickListener((View.OnClickListener)this);
        }
        this.mStopButton.setOnClickListener((View.OnClickListener)this);
    }

    @Override
    public void onReady() {
        this.mHandler.postDelayed((Runnable)new DelayRunnable(this.mVideoUniqueId), (long)this.mDefaultInterval);
        this.mDefaultInterval = this.mDelayInterval;
    }

    @Override
    public void onStateChange(@NonNull PlayerConstants.PlayerState playerState) {
        if (playerState == PlayerConstants.PlayerState.PLAYING && this.mIsInitialize) {
            this.stopErrorReportCountDown();
            if (this.mIsInitialize) {
                this.mIsOnPause = false;
                this.mIsInitialize = false;
                if (this.mCountDownRunnable == null) {
                    this.mCountDownRunnable = new CountDownRunnable();
                    this.mPlayerIsPlaying = true;
                    this.mHandler.postDelayed((Runnable)this.mCountDownRunnable, 1000L);
                    this.mPanel.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)17170445));
                } else {
                    this.mHandler.postDelayed((Runnable)this.mCountDownRunnable, 1000L);
                }
            }
        }
        if (playerState == PlayerConstants.PlayerState.BUFFERING || playerState == PlayerConstants.PlayerState.VIDEO_CUED) {
            this.mPanel.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)17170445));
        } else if (playerState == PlayerConstants.PlayerState.ENDED) {
            this.mPlayerIsPlaying = false;
            if (this.mNextYtInfo != null) {
                this.initializeYtVideoInfo(this.mNextYtInfo);
            }
            this.mIsYtEnded = true;
        } else if (playerState == PlayerConstants.PlayerState.PAUSED) {
            this.mIsOnPause = true;
            this.mIsInitialize = true;
        } else if (playerState == PlayerConstants.PlayerState.OFFLINE) {
            this.onError(PlayerConstants.PlayerError.ERROR_VIDEO_LIVE_OFFLINE);
        }
    }

    @Override
    public void onCurrentSecond(float f) {
        int n = Math.round(f);
        this.onCurrentSecond(n);
    }

    private boolean onCurrentSecond(int n) {
        int n2 = Math.round(n);
        if ((n2 == this.mMinWatchTime || n2 == 0) && this.mFirstTime) {
            this.mFirstTime = false;
            this.mListener.videoReachEndpoint(this.mIdVideoPlaying, this.mTimestamp);
            if (!this.mIsPolice) {
                this.mSkipButton.setVisibility(8);
            }
            return false;
        }
        if (this.mFirstTime && n2 < this.mMinWatchTime) {
            if (!this.mIsPolice) {
                this.mSkipButton.setVisibility(0);
            }
            this.initSkipAdCountDown(String.format(ResourcesUtil.getString(R.string.yt_skip_video_count_down), this.mMinWatchTime - n2));
            return true;
        }
        return false;
    }

    @Override
    public void onError(@NonNull PlayerConstants.PlayerError playerError) {
        super.onError(playerError);
        this.mPlayerIsPlaying = false;
        this.mDefaultInterval = 0;
        this.mPanel.setBackgroundColor(ResourcesUtil.getColor(R.color.black));
        this.mIsYtEnded = true;
        if (!this.mIsPolice) {
            this.mListener.youtubePlayableError(this.mIdVideoPlaying, this.parsePlayerError(playerError));
            this.intiUI();
            return;
        }
        this.mListener.videoNotAvailable();
    }

    public void onClick(View view) {
        int n = view.getId();
        if (n == R.id.skip_button) {
            this.mPlayerIsPlaying = false;
            if (this.mNextYtInfo != null) {
                this.initializeYtVideoInfo(this.mNextYtInfo);
            }
        } else if (n == R.id.stop_button) {
            this.mListener.forceStopVideo();
        } else if (n == R.id.open_button) {
            Utils.openBrowser(this.context, this.mVideoUrl);
        }
    }

    public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
        int n = compoundButton.getId();
        if (n == R.id.yt_auto_skip) {
            this.mAutoSkipToggle.setChecked(bl);
            this.mPref.putBooleanValue(YT_IS_AUTO_SKIP, bl);
        }
    }

    public void initializeYtVideoInfo(EmbedGigsResponse embedGigsResponse) {
        if (!this.mPlayerIsPlaying) {
            this.youTubePlayerCallback.pause();
            this.mPlayerView.refreshPlayer();
            this.mPanel.setBackgroundColor(ResourcesUtil.getColor(R.color.black));
            if (embedGigsResponse.success) {
                this.intiUI();
                this.mPanel.setClickable(!this.mIsPolice && !embedGigsResponse.enable_touch);
                this.mPanel.setFocusable(!this.mIsPolice && !embedGigsResponse.enable_touch);
                this.mCountDownRunnable = null;
                this.mNextYtInfo = null;
                this.mCurrentSeconds = 0;
                this.mMinWatchTime = embedGigsResponse.video_info.min_watch_time;
                this.mVideoUniqueId = embedGigsResponse.video_info.id;
                this.mVideoUrl = embedGigsResponse.video_info.ourl;
                this.mVideoType = embedGigsResponse.video_type;
                this.mIdVideoPlaying = embedGigsResponse.gid;
                this.mTimestamp = embedGigsResponse.ts;
                this.mErrorReportMaxTime = embedGigsResponse.video_info.max_error_time;
                boolean bl = this.mIsVideoHtmlExist = embedGigsResponse.video_html != null && !embedGigsResponse.video_html.isEmpty();
                if (embedGigsResponse.video_html != null && !embedGigsResponse.video_html.isEmpty()) {
                    this.mPlayerView.initPlayer(embedGigsResponse.video_info.url, embedGigsResponse.video_html);
                } else {
                    this.mHandler.postDelayed((Runnable)new ViewDelayRunnable(embedGigsResponse), (long)this.mDefaultInterval);
                }
            } else {
                this.mListener.videoNotAvailable();
            }
        }
    }

    private void createErrorReportCountdown() {
        if (this.mErrorReportMaxTime > 0 && this.mIsVideoHtmlExist) {
            Logger.e("createErrorReportCountdown:");
            if (this.mErrorCountdown != null) {
                this.mHandler.removeCallbacks((Runnable)this.mErrorCountdown);
            }
            this.mErrorCountdown = new ErrorCountDownRunnable();
            this.mHandler.postDelayed((Runnable)this.mErrorCountdown, (long)(this.mErrorReportMaxTime * 1000));
        }
    }

    private void stopErrorReportCountDown() {
        if (this.mErrorCountdown != null) {
            Logger.e("stopErrorReportCountDown:");
            this.mHandler.removeCallbacks((Runnable)this.mErrorCountdown);
            this.mErrorCountdown = null;
        }
    }

    private void intiUI() {
        this.mLoadingBar.setVisibility(0);
        this.mAutoSkipContainer.setVisibility(0);
        this.mStopButton.setVisibility(0);
        this.mAutoSkipToggle.setChecked(this.mPref.getBooleanValue(YT_IS_AUTO_SKIP, false));
        if (!this.mIsPolice) {
            this.mSkipButton.setVisibility(8);
        }
        this.mOpenButton.setVisibility(8);
    }

    public void onResume() {
        if (!this.mIsYtEnded && !this.mPlayerIsPlaying) {
            this.createErrorReportCountdown();
        }
        if (this.mPlayerIsPlaying && this.youTubePlayerCallback != null) {
            this.youTubePlayerCallback.play();
        }
        if (!this.mIsVideoHtmlExist && this.mIsOnPause && this.mHandler != null && this.mCountDownRunnable != null) {
            this.mHandler.postDelayed((Runnable)this.mCountDownRunnable, 1000L);
        }
        this.mIsOnPause = false;
        if (this.mStopButton != null) {
            this.mStopButton.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mSkipButton != null) {
            this.mSkipButton.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mOpenButton != null) {
            this.mOpenButton.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void onPause() {
        this.mIsOnPause = true;
        if (this.mStopButton != null) {
            this.mStopButton.setOnClickListener(null);
        }
        if (this.mSkipButton != null) {
            this.mSkipButton.setOnClickListener(null);
        }
        if (this.mOpenButton != null) {
            this.mOpenButton.setOnClickListener(null);
        }
        if (this.youTubePlayerCallback != null) {
            this.youTubePlayerCallback.pause();
        }
        this.stopErrorReportCountDown();
    }

    public void onDestroy() {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.mAutoSkipToggle.setOnCheckedChangeListener(null);
    }

    public void verifiedYtVideo(EmbedGigsResponse embedGigsResponse) {
        this.mNextYtInfo = embedGigsResponse;
        this.initSkipAd();
        if (this.mPref.getBooleanValue(YT_IS_AUTO_SKIP, false) || this.mIsYtEnded) {
            this.mPlayerIsPlaying = false;
            this.initializeYtVideoInfo(embedGigsResponse);
        }
    }

    private void initSkipAdCountDown(String string2) {
        if (this.mSkipButton != null) {
            this.mSkipButton.setText((CharSequence)string2);
            this.mSkipButton.setTextSize(12.0f);
            int n = Utils.dpToPx(8);
            this.mSkipButton.setPadding(n, n, n, n);
            this.mSkipButton.setEnabled(false);
        }
        if (this.mOpenButton != null) {
            this.mOpenButton.setEnabled(false);
            this.mOpenButton.setVisibility(8);
        }
    }

    private void initSkipAd() {
        if (this.mSkipButton != null) {
            this.mSkipButton.setText(R.string.yt_skip_video);
            int n = Utils.dpToPx(8);
            this.mSkipButton.setPadding(n, n, n, n);
            this.mSkipButton.setEnabled(true);
            if (!this.mIsPolice) {
                this.mSkipButton.setVisibility(0);
            }
        }
        if (this.mOpenButton != null && this.mVideoUrl != null && this.mVideoType != null) {
            this.mOpenButton.setEnabled(true);
            this.mOpenButton.setText((CharSequence)String.format(ResourcesUtil.getString(R.string.open_video), this.mVideoType.replace("_live", "")));
            this.mOpenButton.setVisibility(0);
        }
    }

    private void showUiVideo() {
        this.mFirstTime = true;
        this.mIsYtEnded = false;
        this.mNextYtInfo = null;
        this.mLoadingBar.setVisibility(8);
        this.mAutoSkipContainer.setVisibility(8);
        this.mStopButton.setVisibility(8);
    }

    @NonNull
    private String parsePlayerError(PlayerConstants.PlayerError playerError) {
        String string2 = playerError.equals((Object)PlayerConstants.PlayerError.INVALID_PARAMETER_IN_REQUEST) ? ERROR_INVALID_PARAMETER_IN_REQUEST : (playerError.equals((Object)PlayerConstants.PlayerError.HTML_5_PLAYER) ? ERROR_HTML_5_PLAYER : (playerError.equals((Object)PlayerConstants.PlayerError.VIDEO_NOT_FOUND) ? ERROR_VIDEO_NOT_FOUND : (playerError.equals((Object)PlayerConstants.PlayerError.VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER) ? ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER1 : (playerError.equals((Object)PlayerConstants.PlayerError.VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER) ? ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER2 : (playerError.equals((Object)PlayerConstants.PlayerError.ERROR_VIDEO_LIVE_OFFLINE) ? ERROR_VIDEO_LIVE_OFFLINE : "0")))));
        return string2;
    }

    class DelayRunnable
    implements Runnable {
        private String mVideoId;

        DelayRunnable(String string2) {
            this.mVideoId = string2;
        }

        @Override
        public void run() {
            CustomVideoUIController.this.showUiVideo();
            CustomVideoUIController.this.createErrorReportCountdown();
            CustomVideoUIController.this.mIsInitialize = true;
            CustomVideoUIController.this.youTubePlayerCallback.loadVideo(this.mVideoId, 0.0f);
            CustomVideoUIController.this.mDefaultInterval = CustomVideoUIController.this.mDelayInterval;
        }
    }

    class ViewDelayRunnable
    implements Runnable {
        private EmbedGigsResponse response;

        ViewDelayRunnable(EmbedGigsResponse embedGigsResponse) {
            this.response = embedGigsResponse;
        }

        @Override
        public void run() {
            CustomVideoUIController.this.showUiVideo();
            CustomVideoUIController.this.mIsInitialize = true;
            CustomVideoUIController.this.mPlayerView.initPlayer(this.response.video_info.url, this.response.video_html);
            CustomVideoUIController.this.mDefaultInterval = CustomVideoUIController.this.mDelayInterval;
        }
    }

    class CountDownRunnable
    implements Runnable {
        CountDownRunnable() {
        }

        @Override
        public void run() {
            if (CustomVideoUIController.this.mIsOnPause) {
                return;
            }
            if (CustomVideoUIController.this.mMinWatchTime > 0) {
                CustomVideoUIController.this.mCurrentSeconds++;
            }
            if (CustomVideoUIController.this.onCurrentSecond(CustomVideoUIController.this.mCurrentSeconds)) {
                CustomVideoUIController.this.mHandler.postDelayed((Runnable)CustomVideoUIController.this.mCountDownRunnable, 1000L);
            }
        }
    }

    class ErrorCountDownRunnable
    implements Runnable {
        ErrorCountDownRunnable() {
        }

        @Override
        public void run() {
            CustomVideoUIController.this.onError(PlayerConstants.PlayerError.UNKNOWN);
        }
    }

    public static interface Listener {
        public void videoReachEndpoint(String var1, int var2);

        public void videoNotAvailable();

        public void forceStopVideo();

        public void youtubePlayableError(String var1, String var2);
    }
}

