package com.appzilo.sdk.video.player.playerUtils;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;

import com.appzilo.sdk.video.player.PlayerConstants;
import com.appzilo.sdk.video.player.VideoPlayer;
import com.appzilo.sdk.video.player.listeners.AbstractVideoPlayerListener;

/**
 * Class responsible for resuming the playback state in case of network problems.
 */
public class PlaybackResumer extends AbstractVideoPlayerListener {

    private boolean isPlaying = false;
    private PlayerConstants.PlayerError error = null;

    private String currentVideoId;
    private float currentSecond;

    public void resume(VideoPlayer videoPlayer) {
        if (isPlaying && error == PlayerConstants.PlayerError.HTML_5_PLAYER)
            videoPlayer.loadVideo(currentVideoId, currentSecond);
        else if (!isPlaying && error == PlayerConstants.PlayerError.HTML_5_PLAYER)
            videoPlayer.cueVideo(currentVideoId, currentSecond);

        error = null;
    }

    @SuppressLint("SwitchIntDef")
    @Override
    public void onStateChange(@NonNull PlayerConstants.PlayerState state) {
        switch (state) {
            case ENDED:
                isPlaying = false;
                return;
            case PAUSED:
                isPlaying = false;
                return;
            case PLAYING:
                isPlaying = true;
                return;
            default:
                return;
        }
    }

    @Override
    public void onError(@NonNull PlayerConstants.PlayerError error) {
        if (error == PlayerConstants.PlayerError.HTML_5_PLAYER)
            this.error = error;
    }

    @Override
    public void onCurrentSecond(float second) {
        this.currentSecond = second;
    }

    @Override
    public void onVideoId(@NonNull String videoId) {
        this.currentVideoId = videoId;
    }
}
