package com.appzilo.sdk.video.player.playerUtils;

import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;

import com.appzilo.sdk.video.player.listeners.VideoPlayerFullScreenListener;

import java.util.HashSet;
import java.util.Set;


public class FullScreenHelper {

    private final Set<VideoPlayerFullScreenListener> fullScreenListeners;
    private boolean isFullScreen;

    public FullScreenHelper() {
        isFullScreen = false;
        fullScreenListeners = new HashSet<>();
    }

    public void enterFullScreen(@NonNull View view) {
        if (isFullScreen)
            return;

        ViewGroup.LayoutParams viewParams = view.getLayoutParams();
        viewParams.height = ViewGroup.LayoutParams.MATCH_PARENT;
        viewParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        view.setLayoutParams(viewParams);

        isFullScreen = true;

        for (VideoPlayerFullScreenListener fullScreenListener : fullScreenListeners)
            fullScreenListener.onYouTubePlayerEnterFullScreen();
    }

    public void exitFullScreen(@NonNull View view) {
        if (!isFullScreen)
            return;

        ViewGroup.LayoutParams viewParams = view.getLayoutParams();
        viewParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        viewParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
        view.setLayoutParams(viewParams);

        isFullScreen = false;

        for (VideoPlayerFullScreenListener fullScreenListener : fullScreenListeners)
            fullScreenListener.onYouTubePlayerExitFullScreen();
    }

    public void toggleFullScreen(@NonNull View view) {
        if (isFullScreen)
            exitFullScreen(view);
        else
            enterFullScreen(view);
    }

    public boolean isFullScreen() {
        return isFullScreen;
    }

    public boolean addFullScreenListener(@NonNull VideoPlayerFullScreenListener fullScreenListener) {
        return fullScreenListeners.add(fullScreenListener);
    }

    public boolean removeFullScreenListener(@NonNull VideoPlayerFullScreenListener fullScreenListener) {
        return fullScreenListeners.remove(fullScreenListener);
    }
}
