package com.appzilo.sdk.video.utils;

import android.content.Context;
import android.content.SharedPreferences;

import java.util.Set;

public class SharedPreferencesUtil {

    private static final String NAME = "APPZILO";

    private static SharedPreferences mSharedPreferences;

    public SharedPreferencesUtil(Context context) {
        mSharedPreferences = context.getSharedPreferences(NAME, Context.MODE_PRIVATE);
    }

//    public SharedPreferences getSP() {
//        return mSharedPreferences;
//    }

//    public SharedPreferences.Editor getEditor() {
//        return mSharedPreferences.edit();
//    }

    public void putLongValue(String key, long value) {
        mSharedPreferences.edit().putLong(key, value).apply();
    }

    public void putIntValue(String key, int value) {
        mSharedPreferences.edit().putInt(key, value).apply();
    }

    public void putStringValue(String key, String value) {
        mSharedPreferences.edit().putString(key, value).apply();
    }

    public void putStringSet(String key, Set<String> value) {
        mSharedPreferences.edit().putStringSet(key, value).apply();
    }

    public void putBooleanValue(String key, boolean value) {
        mSharedPreferences.edit().putBoolean(key, value).apply();
    }

    public long getLongValue(String key, long defValue) {
        return mSharedPreferences.getLong(key, defValue);
    }


    public int getIntValue(String key, int defValue) {
        return mSharedPreferences.getInt(key, defValue);
    }

    public boolean getBooleanValue(String key, boolean defValue) {
        return mSharedPreferences.getBoolean(key, defValue);
    }

    public String getStringValue(String key, String defValue) {
        return mSharedPreferences.getString(key, defValue);
    }

    public Set<String> getStringSet(String key, Set<String> set) {
        return mSharedPreferences.getStringSet(key, set);
    }

    public void clear() {
        mSharedPreferences.edit().clear().apply();
    }

    public void remove(String key) {
        mSharedPreferences.edit().remove(key).apply();
    }
}
