/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.player.playerUtils;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import com.appzilo.sdk.video.player.PlayerConstants;
import com.appzilo.sdk.video.player.VideoPlayer;
import com.appzilo.sdk.video.player.listeners.AbstractVideoPlayerListener;

public class PlaybackResumer
extends AbstractVideoPlayerListener {
    private boolean isPlaying = false;
    private PlayerConstants.PlayerError error = null;
    private String currentVideoId;
    private float currentSecond;

    public void resume(VideoPlayer videoPlayer) {
        if (this.isPlaying && this.error == PlayerConstants.PlayerError.HTML_5_PLAYER) {
            videoPlayer.loadVideo(this.currentVideoId, this.currentSecond);
        } else if (!this.isPlaying && this.error == PlayerConstants.PlayerError.HTML_5_PLAYER) {
            videoPlayer.cueVideo(this.currentVideoId, this.currentSecond);
        }
        this.error = null;
    }

    @Override
    @SuppressLint(value={"SwitchIntDef"})
    public void onStateChange(@NonNull PlayerConstants.PlayerState playerState) {
        switch (playerState) {
            case ENDED: {
                this.isPlaying = false;
                return;
            }
            case PAUSED: {
                this.isPlaying = false;
                return;
            }
            case PLAYING: {
                this.isPlaying = true;
                return;
            }
        }
    }

    @Override
    public void onError(@NonNull PlayerConstants.PlayerError playerError) {
        if (playerError == PlayerConstants.PlayerError.HTML_5_PLAYER) {
            this.error = playerError;
        }
    }

    @Override
    public void onCurrentSecond(float f) {
        this.currentSecond = f;
    }

    @Override
    public void onVideoId(@NonNull String string2) {
        this.currentVideoId = string2;
    }
}

