/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.player.playerUtils;

import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.appzilo.sdk.video.player.listeners.VideoPlayerFullScreenListener;
import java.util.HashSet;
import java.util.Set;

public class FullScreenHelper {
    private final Set<VideoPlayerFullScreenListener> fullScreenListeners = new HashSet<VideoPlayerFullScreenListener>();
    private boolean isFullScreen = false;

    public void enterFullScreen(@NonNull View view) {
        if (this.isFullScreen) {
            return;
        }
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        layoutParams.height = -1;
        layoutParams.width = -1;
        view.setLayoutParams(layoutParams);
        this.isFullScreen = true;
        for (VideoPlayerFullScreenListener videoPlayerFullScreenListener : this.fullScreenListeners) {
            videoPlayerFullScreenListener.onYouTubePlayerEnterFullScreen();
        }
    }

    public void exitFullScreen(@NonNull View view) {
        if (!this.isFullScreen) {
            return;
        }
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        layoutParams.height = -2;
        layoutParams.width = -1;
        view.setLayoutParams(layoutParams);
        this.isFullScreen = false;
        for (VideoPlayerFullScreenListener videoPlayerFullScreenListener : this.fullScreenListeners) {
            videoPlayerFullScreenListener.onYouTubePlayerExitFullScreen();
        }
    }

    public void toggleFullScreen(@NonNull View view) {
        if (this.isFullScreen) {
            this.exitFullScreen(view);
        } else {
            this.enterFullScreen(view);
        }
    }

    public boolean isFullScreen() {
        return this.isFullScreen;
    }

    public boolean addFullScreenListener(@NonNull VideoPlayerFullScreenListener videoPlayerFullScreenListener) {
        return this.fullScreenListeners.add(videoPlayerFullScreenListener);
    }

    public boolean removeFullScreenListener(@NonNull VideoPlayerFullScreenListener videoPlayerFullScreenListener) {
        return this.fullScreenListeners.remove(videoPlayerFullScreenListener);
    }
}

