package com.appzilo.sdk.video.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import com.appzilo.sdk.video.core.MCrypt;

import java.util.HashMap;
import java.util.Map;

public class Utils {
    @SuppressLint("DefaultLocale")
    public static String formatTime(float sec) {
        int minutes = (int) (sec / 60);
        int seconds = (int) (sec % 60);
        return String.format("%d:%02d", minutes, seconds);
    }

    public static boolean isOnline(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return (networkInfo != null && networkInfo.isConnected());
    }

    public static int dpToPx(int value) {
        return (int) (value * Resources.getSystem().getDisplayMetrics().density);
    }

    public static String javaEncrypt(String value) {
        MCrypt crypt = new MCrypt();
        String encrypted = null;
        try {
            encrypted = MCrypt.bytesToHex(crypt.encrypt(value));
        } catch (Exception e) {
            e.printStackTrace();
        }

        return encrypted;
    }

    public static boolean isDebug(Context context) {
        return (context != null && (0 != (context.getApplicationInfo().flags & ApplicationInfo.FLAG_DEBUGGABLE)));
    }

    public static String getAppVersion(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        } catch (Exception ignored) {
        }
        return "0.0.0";
    }

    public static String hashMapToQuery(HashMap<?, ?> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(String.format("%s=%s",
                    entry.getKey().toString(),
                    entry.getValue().toString()));
        }
        return sb.toString();
    }

    public static HashMap<String, String> queryToHashMap(String query) {
        String[] paramsString = query.split("&");
        HashMap<String, String> paramsMap = new HashMap<>();
        for (String param : paramsString) {
            if (param.split("=").length == 2) {
                paramsMap.put(param.split("=")[0], param.split("=")[1]);
            }
        }

        return paramsMap;
    }
}
