/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.appzilo.sdk.video.core.MCrypt;
import java.util.HashMap;
import java.util.Map;

public class Utils {
    @SuppressLint(value={"DefaultLocale"})
    public static String formatTime(float f) {
        int n = (int)(f / 60.0f);
        int n2 = (int)(f % 60.0f);
        return String.format("%d:%02d", n, n2);
    }

    public static boolean isOnline(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    public static int dpToPx(int n) {
        return (int)((float)n * Resources.getSystem().getDisplayMetrics().density);
    }

    public static String javaEncrypt(String string2) {
        MCrypt mCrypt = new MCrypt();
        String string3 = null;
        try {
            string3 = MCrypt.bytesToHex(mCrypt.encrypt(string2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string3;
    }

    public static boolean isDebug(Context context) {
        return context != null && 0 != (context.getApplicationInfo().flags & 2);
    }

    public static String getAppVersion(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (Exception exception) {
            return "0.0.0";
        }
    }

    public static String hashMapToQuery(HashMap<?, ?> hashMap) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<?, ?> entry : hashMap.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(String.format("%s=%s", entry.getKey().toString(), entry.getValue().toString()));
        }
        return stringBuilder.toString();
    }

    public static HashMap<String, String> queryToHashMap(String string2) {
        String[] stringArray = string2.split("&");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string3 : stringArray) {
            if (string3.split("=").length != 2) continue;
            hashMap.put(string3.split("=")[0], string3.split("=")[1]);
        }
        return hashMap;
    }
}

