/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.player;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.appzilo.sdk.video.player.IFramePlayerOptions;
import com.appzilo.sdk.video.player.PlayerConstants;
import com.appzilo.sdk.video.player.VideoPlayer;
import com.appzilo.sdk.video.player.VideoPlayerBridge;
import com.appzilo.sdk.video.player.listeners.VideoPlayerInitListener;
import com.appzilo.sdk.video.player.listeners.VideoPlayerListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class WebViewVideoPlayer
extends WebView
implements VideoPlayer,
VideoPlayerBridge.YouTubePlayerBridgeCallbacks {
    @NonNull
    private final Set<VideoPlayerListener> videoPlayerListeners;
    @NonNull
    private final Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    protected boolean backgroundPlaybackEnabled = false;
    private VideoPlayerInitListener videoPlayerInitListener;
    private String baseUrl;
    private String playerHtml;

    protected WebViewVideoPlayer(Context context) {
        this(context, null);
    }

    protected WebViewVideoPlayer(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    protected WebViewVideoPlayer(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.videoPlayerListeners = new HashSet<VideoPlayerListener>();
    }

    protected void initialize(@NonNull VideoPlayerInitListener videoPlayerInitListener, @Nullable IFramePlayerOptions iFramePlayerOptions) {
        this.videoPlayerInitListener = videoPlayerInitListener;
        this.initWebView(iFramePlayerOptions == null ? IFramePlayerOptions.getDefault() : iFramePlayerOptions);
    }

    @Override
    public void onYouTubeIframeAPIReady() {
        this.videoPlayerInitListener.onInitSuccess(this);
    }

    @Override
    public void loadVideo(final @NonNull String string2, final float f) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:loadVideo('" + string2 + "', " + f + ")");
            }
        });
    }

    @Override
    public void loadChannel(final @NonNull String string2) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:setChannel('" + string2 + "')");
            }
        });
    }

    @Override
    public void cueVideo(final @NonNull String string2, final float f) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:cueVideo('" + string2 + "', " + f + ")");
            }
        });
    }

    @Override
    public void play() {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:playVideo()");
            }
        });
    }

    @Override
    public void pause() {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:pauseVideo()");
            }
        });
    }

    @Override
    public void setVolume(final int n) {
        if (n < 0 || n > 100) {
            throw new IllegalArgumentException("Volume must be between 0 and 100");
        }
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:setVolume(" + n + ")");
            }
        });
    }

    @Override
    public void seekTo(final float f) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewVideoPlayer.this.loadUrl("javascript:seekTo(" + f + ")");
            }
        });
    }

    public void destroy() {
        this.videoPlayerListeners.clear();
        this.mainThreadHandler.removeCallbacksAndMessages(null);
        super.destroy();
    }

    @Override
    @NonNull
    public Collection<VideoPlayerListener> getListeners() {
        return Collections.unmodifiableCollection(new HashSet<VideoPlayerListener>(this.videoPlayerListeners));
    }

    @Override
    public boolean addListener(@NonNull VideoPlayerListener videoPlayerListener) {
        if (videoPlayerListener == null) {
            Log.e((String)"YouTubePlayer", (String)"null YouTubePlayerListener not allowed.");
            return false;
        }
        return this.videoPlayerListeners.add(videoPlayerListener);
    }

    @Override
    public boolean removeListener(@NonNull VideoPlayerListener videoPlayerListener) {
        return this.videoPlayerListeners.remove(videoPlayerListener);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initWebView(IFramePlayerOptions iFramePlayerOptions) {
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setDomStorageEnabled(true);
        this.getSettings().setCacheMode(2);
        this.getSettings().setMediaPlaybackRequiresUserGesture(false);
        this.setWebViewClient(new CustomWebViewClient());
        this.addJavascriptInterface(new VideoPlayerBridge(this), "PlayerBridge");
        this.setWebChromeClient(new WebChromeClient(){

            public Bitmap getDefaultVideoPoster() {
                Bitmap bitmap = super.getDefaultVideoPoster();
                if (bitmap == null) {
                    return Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.RGB_565);
                }
                return bitmap;
            }
        });
        if (this.playerHtml != null && !this.playerHtml.isEmpty()) {
            String string2 = this.playerHtml;
            String string3 = string2.replace("<<injectedPlayerVars>>", iFramePlayerOptions.toString());
            this.loadDataWithBaseURL(this.baseUrl, string3, "text/html", "utf-8", null);
            return;
        }
        if (this.baseUrl != null) {
            this.loadUrl(this.baseUrl);
        }
        if (this.videoPlayerInitListener != null) {
            this.videoPlayerInitListener.onInitSuccess(this);
        }
    }

    public void initWebView(String string2, String string3) {
        this.playerHtml = string3;
        this.baseUrl = string2;
        this.initWebView(IFramePlayerOptions.getDefault());
    }

    public void refresh() {
        this.playerHtml = null;
        this.baseUrl = null;
        this.loadUrl("about:blank");
    }

    private String readYouTubePlayerHTMLFromFile() {
        try {
            String string2;
            int n = 0;
            InputStream inputStream = this.getResources().openRawResource(n);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append("\n");
            }
            inputStream.close();
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            throw new RuntimeException("Can't parse HTML file containing the player.");
        }
    }

    protected void onWindowVisibilityChanged(int n) {
        if (this.backgroundPlaybackEnabled && (n == 8 || n == 4)) {
            return;
        }
        super.onWindowVisibilityChanged(n);
    }

    public class CustomWebViewClient
    extends WebViewClient {
        boolean isError = false;

        public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
            super.onPageStarted(webView, string2, bitmap);
            if (!string2.equals("about:blank") && (WebViewVideoPlayer.this.playerHtml == null || WebViewVideoPlayer.this.playerHtml.isEmpty())) {
                for (VideoPlayerListener videoPlayerListener : WebViewVideoPlayer.this.videoPlayerListeners) {
                    videoPlayerListener.onReady();
                }
                this.isError = false;
            }
        }

        public void onPageFinished(WebView webView, String string2) {
            super.onPageFinished(webView, string2);
            if (!string2.equals("about:blank")) {
                if ((WebViewVideoPlayer.this.playerHtml == null || WebViewVideoPlayer.this.playerHtml.isEmpty()) && !this.isError && webView.getProgress() == 100) {
                    for (VideoPlayerListener videoPlayerListener : WebViewVideoPlayer.this.videoPlayerListeners) {
                        videoPlayerListener.onStateChange(PlayerConstants.PlayerState.PLAYING);
                    }
                }
                if (webView.getProgress() == 100) {
                    WebViewVideoPlayer.this.playerHtml = null;
                    WebViewVideoPlayer.this.baseUrl = null;
                }
            }
        }

        public void onReceivedError(WebView webView, WebResourceRequest webResourceRequest, WebResourceError webResourceError) {
            super.onReceivedError(webView, webResourceRequest, webResourceError);
            this.isError = true;
            for (VideoPlayerListener videoPlayerListener : WebViewVideoPlayer.this.videoPlayerListeners) {
                videoPlayerListener.onError(PlayerConstants.PlayerError.VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER);
            }
        }
    }
}

